/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchEvent;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportsHelper;
import com.gridnine.xtrip.common.Environment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

class RecentReportsTracker {
    private static final int LIMIT = 6;
    private static final Consumer<ReportLaunchEvent> EVENT_HANDLER = evt -> RecentReportsTracker.onExecute(evt.getHandler());

    static List<ReportLaunchHandler> getRecent() throws Exception {
        Set<String> uids = RecentReportsTracker.loadUids();
        if (uids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap handlers = new HashMap();
        ReportsHelper.enumerateAvailableHandlers(handler -> handlers.put(handler.getUid(), handler), false);
        ArrayList<ReportLaunchHandler> result = new ArrayList<ReportLaunchHandler>(uids.size());
        for (String uid : uids) {
            ReportLaunchHandler handler2 = (ReportLaunchHandler)handlers.get(uid);
            if (handler2 == null) continue;
            result.add(handler2);
        }
        Collections.reverse(result);
        return result;
    }

    private static void onExecute(ReportLaunchHandler handler) {
        Set<String> uids = RecentReportsTracker.loadUids();
        String handlerUid = handler.getUid();
        uids.remove(handlerUid);
        uids.add(handlerUid);
        while (uids.size() > 6) {
            Iterator<String> it = uids.iterator();
            it.next();
            it.remove();
        }
        File file = RecentReportsTracker.getDataFile();
        Properties props = new Properties();
        int idx = 0;
        for (String uid : uids) {
            props.setProperty(idx + ".uid", uid);
            ++idx;
        }
        try (BufferedWriter out = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            props.store(out, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Set<String> loadUids() {
        String uid;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        File file = RecentReportsTracker.getDataFile();
        if (!file.isFile()) {
            return result;
        }
        Properties props = new Properties();
        try (BufferedReader in2 = Files.newBufferedReader(file.toPath());){
            props.load(in2);
        }
        catch (Exception in2) {
            // empty catch block
        }
        int idx = 0;
        while ((uid = props.getProperty(idx + ".uid")) != null) {
            result.add(uid);
            ++idx;
        }
        return result;
    }

    private static File getDataFile() {
        File file = new File(Environment.getDataFolder(), "settings/report-launchers-recent.dat");
        return file;
    }

    private RecentReportsTracker() {
    }

    static {
        EventBus.get().subscribe(ReportLaunchEvent.TYPE, EVENT_HANDLER);
    }
}

