/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.reports.manager.DocumentsTile;
import com.gridnine.xtrip.client.fx.reports.manager.LaunchersTile;
import com.gridnine.xtrip.client.fx.reports.manager.QueueTile;
import com.gridnine.xtrip.client.fx.reports.manager.ReportsManagerSettings;
import com.gridnine.xtrip.client.fx.reports.manager.TemplatesTile;
import java.util.ArrayList;
import javafx.scene.Node;

public class ReportsManagerPane
extends BaseContentPane {
    private final QueueTile queueTile;
    private final LaunchersTile launchersTile;
    private final DocumentsTile documentsTile;
    private TemplatesTile templatesTile;

    public ReportsManagerPane(ObservableMutex mutex, ReportsManagerSettings settings) {
        this.getStyleClass().add((Object)"xtrip-reports-pane");
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        this.launchersTile = new LaunchersTile();
        tiles.add(this.launchersTile);
        this.queueTile = new QueueTile();
        tiles.add(this.queueTile);
        this.documentsTile = new DocumentsTile(mutex);
        tiles.add(this.documentsTile);
        if (settings.isShowTemplatesTile()) {
            this.templatesTile = new TemplatesTile(mutex);
            tiles.add(this.templatesTile);
        }
        TilesSpace space = new TilesSpace(2);
        space.addTiles(tiles);
        this.composePane((Node)space, null, null, null);
        Notifications.get().submitTask(this::init, mutex);
    }

    public void dispose() {
        super.dispose();
        this.launchersTile.dispose();
        this.queueTile.dispose();
    }

    private void init() {
        this.launchersTile.init();
        this.queueTile.init();
        this.documentsTile.init();
        if (this.templatesTile != null) {
            this.templatesTile.init();
        }
    }
}

