/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.EntityIndexDataViewHandler;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.reports.model.TemplateReportDescriptionIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.StackPane;

class TemplatesCompactPane
extends StackPane {
    final DataViewWidget<TemplateReportDescriptionIndex> dataView = new DataViewWidget(true);

    TemplatesCompactPane() {
        TableColumnSettings columnSettings = new TableColumnSettings();
        columnSettings.setId("name");
        columnSettings.setDisplayName(Messages.Name);
        columnSettings.setSortable(false);
        this.dataView.getTableView().getColumns().add((Object)columnSettings.createColumn(item -> item.getName()));
        columnSettings = new TableColumnSettings();
        columnSettings.setId("active");
        columnSettings.setType("boolean");
        columnSettings.setSortable(false);
        columnSettings.setPrefWidth(Double.valueOf(50.0));
        TableColumn column = columnSettings.createColumn(item -> !item.isDisabled());
        TableColumnSettings.setHelp((TableColumn)column, () -> new QuickHelp(Messages.Template_available_for_forming));
        this.dataView.getTableView().getColumns().add((Object)column);
        TableColumn column2 = TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource()));
        column2.setId("link");
        this.dataView.getTableView().getColumns().add((Object)column2);
        this.dataView.setDefaultActionHandler(() -> {
            TemplateReportDescriptionIndex selected = (TemplateReportDescriptionIndex)this.dataView.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                RootEntityEditingService.navigateTo((EntityReference)selected.getSource());
            }
        });
        EntityIndexDataViewHandler handler = new EntityIndexDataViewHandler(TemplateReportDescriptionIndex.class, idx -> idx);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getOrders().put(TemplateReportDescriptionIndex.Property.name.name(), SortOrder.ASC);
        query.setLimit(10000);
        handler.setQuery(query);
        this.dataView.setHandler((DataViewHandler)handler);
        this.dataView.getTableView().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.getChildren().add(this.dataView);
    }
}

