/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.navtool;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.reports.manager.ReportsManagerPane;
import com.gridnine.xtrip.client.fx.reports.navtool.ReportsActivityHandler;
import com.gridnine.xtrip.client.fx.reports.navtool.ReportsNavToolData;
import com.gridnine.xtrip.client.fx.reports.navtool.ReportsNavToolEditors;
import com.gridnine.xtrip.client.fx.reports.navtool.ReportsNavToolParameters;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.reports.restriction.resource.ReportsRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.List;

public class ReportsNavTool
implements NavTool<ReportsNavToolData> {
    private static final AclQuery ACL_QUERY = AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), ReportsRestrictionGroupResources.GROUP_REPORT.getId()).build();
    public static final String ID = "reports-nav-tool";

    public String getId() {
        return ID;
    }

    public IconShape getShape(boolean leaf) {
        return StandardIconShapes.NAVIGATION_REPORT_14X14;
    }

    public Serializer<ReportsNavToolData> getSerializer() {
        return ReportsNavToolData.SERIALIZER;
    }

    public void execute(String token, String name, String description, ReportsNavToolData data, boolean stateful, boolean update, boolean background) {
        NavigationParameters parameters = new NavigationParameters();
        parameters.setTitle(name);
        parameters.setDescription(description);
        parameters.setParameters((Object)data);
        ActivityManager.get().navigate(token, (ActivityHandler)ReportsActivityHandler.get(), parameters, stateful, update ? view -> {
            ActivityState state = ActivityManager.get().findState(token);
            if (state != null) {
                ReportsActivityHandler.get().update((ActivityState<ReportsManagerPane, ReportsNavToolData>)state, (NavigationParameters<ReportsNavToolData>)parameters);
            }
        } : null, background);
    }

    public AclQuery toolACLQuery() {
        return ACL_QUERY;
    }

    public AclQuery itemACLQuery(ReportsNavToolData data) {
        return ACL_QUERY;
    }

    public boolean isExecutable() {
        return true;
    }

    public ReportsNavToolData createParameters() {
        return ReportsNavToolParameters.create();
    }

    public ReportsNavToolData cloneParameters(ReportsNavToolData data) throws Exception {
        return ReportsNavToolParameters.clone(data);
    }

    public ReportsNavToolData cleanParameters(ReportsNavToolData data) {
        return ReportsNavToolParameters.clean(data);
    }

    public List<NavToolEditor> createEditors() {
        return ReportsNavToolEditors.create();
    }
}

