/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.navtool;

import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.navtool.ReportsNavToolData;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import javafx.scene.Node;
import javafx.util.StringConverter;

class ReportsNavToolEditor
implements NavToolEditor {
    private final Card<Node> content;
    private BooleanValueWidget showTemplatesTileWidget = new BooleanValueWidget(false, false);
    private boolean dataChanged;

    ReportsNavToolEditor() {
        this.showTemplatesTileWidget.setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean object) {
                return object != false ? Messages.Show : Messages.Dont_show;
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        this.showTemplatesTileWidget.valueProperty().addListener(obj -> {
            this.dataChanged = true;
        });
        GridContainer ctr = new GridContainer(4);
        ctr.setAdaptive(true);
        ctr.getCells().add((Object)new GridCell(Messages.Template_workbranch, (Node)this.showTemplatesTileWidget));
        this.content = new Card("displayParameters", UiCardsContainer.Style.STATIC, Messages.View_parameters, (Node)ctr);
    }

    public Card<Node> getContent() {
        return this.content;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public void readData(FxWorkspaceItem item) {
        ReportsNavToolData data;
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            data = (ReportsNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            data = null;
        }
        if (data != null) {
            this.showTemplatesTileWidget.setValue(data.isShowTemplatesTile());
        } else {
            this.showTemplatesTileWidget.setValue(false);
        }
        this.dataChanged = false;
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            ReportsNavToolData data = (ReportsNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data == null) {
                data = (ReportsNavToolData)tool.createParameters();
            }
            data.setShowTemplatesTile(this.showTemplatesTileWidget.getValue());
            item.setParameters(tool.getSerializer().serialize((Object)data));
            this.dataChanged = false;
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }
}

