/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.settings;

import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;

class ReportTypesSettingsFullPane
extends CardsContainer {
    private final Set<String> disabledUids = new HashSet<String>();

    ReportTypesSettingsFullPane() {
    }

    int getTotal() {
        int result = 0;
        for (Card card : this.getCards()) {
            result += ((GridContainer)card.getContent()).getCells().size();
        }
        return result;
    }

    int getEnabled() {
        int result = 0;
        for (Card card : this.getCards()) {
            for (GridCell cell : ((GridContainer)card.getContent()).getCells()) {
                if (!((CheckBoxWidget)cell.getPayload()).isSelected()) continue;
                ++result;
            }
        }
        return result;
    }

    void readData(List<MiscUtil.Pair<ReportLaunchHandler, Boolean>> data) {
        this.disabledUids.clear();
        HashMap<FactoryToolCategory, ArrayList<MiscUtil.Pair<ReportLaunchHandler, Boolean>>> category2handlers = new HashMap<FactoryToolCategory, ArrayList<MiscUtil.Pair<ReportLaunchHandler, Boolean>>>();
        for (MiscUtil.Pair<ReportLaunchHandler, Boolean> pair : data) {
            ArrayList<MiscUtil.Pair<ReportLaunchHandler, Boolean>> list = (ArrayList<MiscUtil.Pair<ReportLaunchHandler, Boolean>>)category2handlers.get(((ReportLaunchHandler)pair.getFirst()).getCategory());
            if (list == null) {
                list = new ArrayList<MiscUtil.Pair<ReportLaunchHandler, Boolean>>();
                category2handlers.put(((ReportLaunchHandler)pair.getFirst()).getCategory(), list);
            }
            list.add(pair);
        }
        ArrayList cards = new ArrayList();
        category2handlers.entrySet().stream().sorted((entry1, entry2) -> FactoryToolCategory.COMPARATOR.compare(entry1.getKey(), entry2.getKey())).forEach(entry -> {
            Collections.sort((List)entry.getValue(), (pair1, pair2) -> ReportLaunchHandler.COMPARATOR.compare((ReportLaunchHandler)pair1.getFirst(), (ReportLaunchHandler)pair2.getFirst()));
            cards.add(new Card(((FactoryToolCategory)entry.getKey()).getId(), UiCardsContainer.Style.EXPANDED, ((FactoryToolCategory)entry.getKey()).getName(), (Node)this.buildGridContainer((List)entry.getValue())));
        });
        this.getCards().setAll(cards);
    }

    private GridContainer buildGridContainer(List<MiscUtil.Pair<ReportLaunchHandler, Boolean>> handlers) {
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        for (MiscUtil.Pair<ReportLaunchHandler, Boolean> pair : handlers) {
            CheckBoxWidget widget = new CheckBoxWidget(false);
            widget.setText(((ReportLaunchHandler)pair.getFirst()).getName());
            if (((Boolean)pair.getSecond()).booleanValue()) {
                widget.setSelected(true);
            } else {
                this.disabledUids.add(((ReportLaunchHandler)pair.getFirst()).getUid());
            }
            widget.getProperties().put((Object)"handler", pair.getFirst());
            cells.add(new GridCell((Node)widget));
        }
        GridContainer result = new GridContainer(4);
        result.getCells().addAll(cells);
        return result;
    }

    void writeData(List<MiscUtil.Pair<ReportLaunchHandler, Boolean>> data) {
        data.clear();
        this.disabledUids.clear();
        for (Card card : this.getCards()) {
            for (GridCell cell : ((GridContainer)card.getContent()).getCells()) {
                CheckBoxWidget widget = (CheckBoxWidget)cell.getPayload();
                ReportLaunchHandler handler = (ReportLaunchHandler)widget.getProperties().get((Object)"handler");
                data.add((MiscUtil.Pair<ReportLaunchHandler, Boolean>)new MiscUtil.Pair((Object)handler, (Object)widget.isSelected()));
                if (widget.isSelected()) continue;
                this.disabledUids.add(handler.getUid());
            }
        }
    }

    boolean isDataChanged() {
        for (Card card : this.getCards()) {
            for (GridCell cell : ((GridContainer)card.getContent()).getCells()) {
                CheckBoxWidget widget = (CheckBoxWidget)cell.getPayload();
                String uid = ((ReportLaunchHandler)widget.getProperties().get((Object)"handler")).getUid();
                if (!(widget.isSelected() ? this.disabledUids.contains(uid) : !this.disabledUids.contains(uid))) continue;
                return true;
            }
        }
        return false;
    }

    void setNotEditable(boolean value) {
        for (Card card : this.getCards()) {
            for (GridCell cell : ((GridContainer)card.getContent()).getCells()) {
                ((CheckBoxWidget)cell.getPayload()).getViewState().setNotEditable(value);
            }
        }
    }
}

