/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.settings;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.settings.SettingsHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportsHelper;
import com.gridnine.xtrip.client.fx.reports.api.TemplateReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.settings.ReportTypesSettingsFullPane;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.common.fx.reports.restriction.resource.ReportsUiResource;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class ReportTypesSettingsHandler
implements SettingsHandler<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> {
    public String getId() {
        return "settings-reporttypes";
    }

    public double getWeight() {
        return 6.0;
    }

    public Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> createTile(Consumer<List<Message>> validationMessagesConsumer) {
        InfoLabelWidget info = new InfoLabelWidget();
        info.setText(Messages.Report_type_settings_not_loaded);
        Tile result = new Tile(this.getId(), Messages.Available_report_types, (Node)SimpleContainer.create((Node)info), (Node)new ReportTypesSettingsFullPane());
        result.expandedProperty().addListener((s, o, n) -> {
            if (!n.booleanValue()) {
                this.updateInfoLabel((Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane>)result);
            }
        });
        return result;
    }

    public String getAclResourceId() {
        return ReportsUiResource.SETTINGS_AVAILABLE_REPORTS.getId();
    }

    public void loadData(Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> tile) throws Exception {
        HashSet<String> disabledUids = new HashSet<String>();
        String value = RpcDictHelper.findPreferenceValue((PreferenceKey)PreferenceKey.BLANKTYPE_CHOICE_SETTINGS);
        if (!TextUtil.isBlank((String)value)) {
            for (String id : TextUtil.split((String)value, (String)"\\|", (boolean)true, (boolean)true)) {
                if (!id.endsWith("!")) continue;
                disabledUids.add(id.substring(0, id.length() - 1));
            }
        }
        ArrayList handlers = new ArrayList();
        ReportsHelper.enumerateAvailableHandlers(handlers::add, true);
        ArrayList<MiscUtil.Pair> data = new ArrayList<MiscUtil.Pair>();
        for (ReportLaunchHandler reportHandler : handlers) {
            if (reportHandler instanceof TemplateReportLaunchHandler) {
                data.add(new MiscUtil.Pair((Object)reportHandler, (Object)(!((TemplateReportLaunchHandler)reportHandler).isDisabled() ? 1 : 0)));
                continue;
            }
            data.add(new MiscUtil.Pair((Object)reportHandler, (Object)(!disabledUids.contains(reportHandler.getUid()) ? 1 : 0)));
        }
        FxUtil.waitForFxThread(() -> {
            ((ReportTypesSettingsFullPane)tile.getFullNode()).readData(data);
            this.updateInfoLabel(tile);
        });
    }

    public void saveData(Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> tile) throws Exception {
        ArrayList data = new ArrayList();
        FxUtil.waitForFxThread(() -> ((ReportTypesSettingsFullPane)tile.getFullNode()).writeData(data));
        HashSet<String> disabledUids = new HashSet<String>();
        for (MiscUtil.Pair pair : data) {
            if (pair.getFirst() instanceof TemplateReportLaunchHandler) {
                ((TemplateReportLaunchHandler)pair.getFirst()).setDisabled((Boolean)pair.getSecond() == false);
                continue;
            }
            if (((Boolean)pair.getSecond()).booleanValue()) continue;
            disabledUids.add(((ReportLaunchHandler)pair.getFirst()).getUid());
        }
        String value = disabledUids.isEmpty() ? null : disabledUids.stream().map(id -> id + '!').collect(Collectors.joining("|"));
        RpcDictHelper.updatePreference((PreferenceKey)PreferenceKey.BLANKTYPE_CHOICE_SETTINGS, value);
        FxUtil.submitToFxThread(() -> this.updateInfoLabel(tile));
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)tile.getFullNode(), new EntityModification(new EntityReference("fake-uid", BaseTemplateReportDescription.class, "fake-caption"), EntityModification.ModificationType.CHANGE)));
    }

    public boolean isDataChanged(Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> tile) {
        return ((ReportTypesSettingsFullPane)tile.getFullNode()).isDataChanged();
    }

    public void setNotEditable(Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> tile, boolean notEditable) {
        ((ReportTypesSettingsFullPane)tile.getFullNode()).setNotEditable(notEditable);
    }

    private void updateInfoLabel(Tile<SimpleContainer<InfoLabelWidget>, ReportTypesSettingsFullPane> tile) {
        ((InfoLabelWidget)((SimpleContainer)tile.getCompactNode()).getContent()).setText(Messages.getAvailable_report_types_amount(((ReportTypesSettingsFullPane)tile.getFullNode()).getEnabled(), ((ReportTypesSettingsFullPane)tile.getFullNode()).getTotal()));
    }
}

