/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiMessageException
extends RuntimeException {
    private static final long serialVersionUID = 680534646747133639L;
    private volatile transient String message;
    private static final Pattern PATTERN = Pattern.compile("\n-BEGIN OF THE LIST-.*-END OF THE LIST-", 32);
    private final List<Message> messages = new ArrayList<Message>();

    public MultiMessageException() {
    }

    public MultiMessageException(Message t) {
        this.messages.add(Objects.requireNonNull(t));
    }

    public MultiMessageException(Collection<Message> list) {
        this.messages.addAll(Objects.requireNonNull(list));
    }

    public MultiMessageException(Message ... list) {
        this.messages.addAll(Arrays.asList(list));
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuilder sb = new StringBuilder();
        int size = this.messages.size();
        if (this.messages.size() == 0) {
            sb.append("no errors has occurred.");
        } else {
            if (1 == size) {
                sb.append(String.format("an error has occurred %d", size));
            } else {
                sb.append(String.format("%d errors have occurred", size));
            }
            sb.append(":");
            int i = 1;
            sb.append("\n").append("-BEGIN OF THE LIST-");
            for (Message message : this.messages) {
                String str;
                sb.append("\n").append(i++).append(": ");
                if (message.getType() != null) {
                    sb.append('[').append(message.getType().name()).append("] ");
                }
                String string = str = message.getMessage() != null ? message.getMessage().toString() : message.getClass().getName();
                if (message.getDetails() != null) {
                    str = str + "\n" + message.getDetails();
                }
                Matcher matcher = PATTERN.matcher(str);
                int p = 0;
                while (matcher.find()) {
                    sb.append(str.substring(p, matcher.start()));
                    sb.append(matcher.group().replace("\n", "\n\t"));
                    p = matcher.end();
                }
                sb.append(str.substring(p));
            }
            sb.append("\n").append("-END OF THE LIST-");
        }
        this.message = sb.toString();
        return this.message;
    }

    public void addMessage(Message t) {
        this.messages.add(Objects.requireNonNull(t));
        this.message = null;
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void addMessages(Collection<Message> list) {
        this.messages.addAll(Objects.requireNonNull(list));
        this.message = null;
    }

    public void addMessages(Message ... list) {
        this.messages.addAll(Arrays.asList(list));
        this.message = null;
    }
}

