/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class OpeningBalance
extends BaseAsset {
    private static final long serialVersionUID = -1169560520652930735L;
    private String organizationUid;
    private Date operationDate;
    private Date calculationDate;
    private long debit;
    private long credit;
    private String accountUid;
    private String dimension1;
    private String dimension2;
    private String dimension3;
    private boolean auxiliary;

    public OpeningBalance() {
    }

    public OpeningBalance(String uid) {
        super(uid);
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.organizationUid = XHelper.readString((Element)elm, (String)Property.organizationUid.name());
        this.operationDate = XHelper.readDate((Element)elm, (String)Property.operationDate.name());
        this.calculationDate = XHelper.readDate((Element)elm, (String)Property.calculationDate.name());
        this.debit = XHelper.readLong((Element)elm, (String)Property.debit.name(), (long)0L);
        this.credit = XHelper.readLong((Element)elm, (String)Property.credit.name(), (long)0L);
        this.accountUid = XHelper.readString((Element)elm, (String)Property.accountUid.name());
        this.dimension1 = XHelper.readString((Element)elm, (String)Property.dimension1.name());
        this.dimension2 = XHelper.readString((Element)elm, (String)Property.dimension2.name());
        this.dimension3 = XHelper.readString((Element)elm, (String)Property.dimension3.name());
        this.auxiliary = XHelper.readBoolean((Element)elm, (String)Property.auxiliary.name());
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if (Property.organizationUid.name().equals(tagName)) {
            this.organizationUid = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.operationDate.name().equals(tagName)) {
            this.operationDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if (Property.calculationDate.name().equals(tagName)) {
            this.calculationDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if (Property.debit.name().equals(tagName)) {
            this.debit = XSHelper.readLong((XMLStreamReader)reader, (long)0L);
            return true;
        }
        if (Property.credit.name().equals(tagName)) {
            this.credit = XSHelper.readLong((XMLStreamReader)reader, (long)0L);
            return true;
        }
        if (Property.accountUid.name().equals(tagName)) {
            this.accountUid = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.dimension1.name().equals(tagName)) {
            this.dimension1 = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.dimension2.name().equals(tagName)) {
            this.dimension2 = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.dimension3.name().equals(tagName)) {
            this.dimension3 = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.auxiliary.name().equals(tagName)) {
            this.auxiliary = XSHelper.readBoolean((XMLStreamReader)reader);
            return true;
        }
        return false;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString((Element)elm, (String)Property.organizationUid.name(), (String)this.organizationUid);
        XHelper.writeDate((Element)elm, (String)Property.operationDate.name(), (Date)this.operationDate);
        XHelper.writeDate((Element)elm, (String)Property.calculationDate.name(), (Date)this.calculationDate);
        XHelper.writeLong((Element)elm, (String)Property.debit.name(), (long)this.debit);
        XHelper.writeLong((Element)elm, (String)Property.credit.name(), (long)this.credit);
        XHelper.writeString((Element)elm, (String)Property.accountUid.name(), (String)this.accountUid);
        XHelper.writeString((Element)elm, (String)Property.dimension1.name(), (String)this.dimension1);
        XHelper.writeString((Element)elm, (String)Property.dimension2.name(), (String)this.dimension2);
        XHelper.writeString((Element)elm, (String)Property.dimension3.name(), (String)this.dimension3);
        XHelper.writeBoolean((Element)elm, (String)Property.auxiliary.name(), (boolean)this.auxiliary);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.organizationUid.name(), (String)this.organizationUid);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)Property.operationDate.name(), (Date)this.operationDate);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)Property.calculationDate.name(), (Date)this.calculationDate);
        XSHelper.writeLong((XMLStreamWriter)writer, (String)Property.debit.name(), (long)this.debit);
        XSHelper.writeLong((XMLStreamWriter)writer, (String)Property.credit.name(), (long)this.credit);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.accountUid.name(), (String)this.accountUid);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.dimension1.name(), (String)this.dimension1);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.dimension2.name(), (String)this.dimension2);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.dimension3.name(), (String)this.dimension3);
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)Property.auxiliary.name(), (boolean)this.auxiliary);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) {
        OpeningBalance source = (OpeningBalance)sourceAsset;
        this.organizationUid = source.organizationUid;
        this.operationDate = XCloneHelper.cloneDate((Date)source.operationDate);
        this.calculationDate = XCloneHelper.cloneDate((Date)source.calculationDate);
        this.debit = source.debit;
        this.credit = source.credit;
        this.accountUid = source.accountUid;
        this.dimension1 = source.dimension1;
        this.dimension2 = source.dimension2;
        this.dimension3 = source.dimension3;
        this.auxiliary = source.auxiliary;
    }

    public String getOrganizationUid() {
        return this.organizationUid;
    }

    public void setOrganizationUid(String value) {
        this.organizationUid = value;
    }

    public long getDebit() {
        return this.debit;
    }

    public long getCredit() {
        return this.credit;
    }

    public String getAccountUid() {
        return this.accountUid;
    }

    public void setAccountUid(String value) {
        this.accountUid = value;
    }

    public String getDimension1() {
        return this.dimension1;
    }

    public void setDimension1(String value) {
        this.dimension1 = value;
    }

    public String getDimension2() {
        return this.dimension2;
    }

    public void setDimension2(String value) {
        this.dimension2 = value;
    }

    public String getDimension3() {
        return this.dimension3;
    }

    public void setDimension3(String value) {
        this.dimension3 = value;
    }

    public Date getOperationDate() {
        return this.operationDate;
    }

    public void setOperationDate(Date value) {
        this.operationDate = value;
    }

    public Date getCalculationDate() {
        return this.calculationDate;
    }

    public void setCalculationDate(Date value) {
        this.calculationDate = value;
    }

    public void setDebit(long value) {
        this.debit = value;
    }

    public void setCredit(long value) {
        this.credit = value;
    }

    public boolean isAuxiliary() {
        return this.auxiliary;
    }

    public void setAuxiliary(boolean value) {
        this.auxiliary = value;
    }

    public static enum Property {
        organizationUid,
        operationDate,
        calculationDate,
        debit,
        credit,
        accountUid,
        dimension1,
        dimension2,
        dimension3,
        auxiliary;

    }
}

