/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.model.assets.SmartFolder;
import com.gridnine.xtrip.common.model.assets.WorkspaceElement;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class Repository
extends WorkspaceElement {
    private static final long serialVersionUID = -1586504892662580531L;
    private final List<SmartFolder> folders = new ArrayList<SmartFolder>();

    public List<SmartFolder> getFolders() {
        return this.folders;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.folders.clear();
        for (Element folderElm : XmlUtil.getElements((Element)elm, (String)"folders/item")) {
            SmartFolder folder = new SmartFolder();
            folder.fromXML(folderElm);
            this.folders.add(folder);
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("folders".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    SmartFolder folder = new SmartFolder();
                    folder.fromXML(reader);
                    this.folders.add(folder);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        for (SmartFolder folder : this.folders) {
            folder.toXML(XmlUtil.addElement((Element)elm, (String)"folders/item"));
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        if (!this.folders.isEmpty()) {
            writer.writeStartElement("folders");
            for (SmartFolder folder : this.folders) {
                writer.writeStartElement("item");
                folder.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public void copyFrom(WorkspaceElement sourceWorkspaceElement, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceWorkspaceElement, newUids, uids);
        Repository sourceRepository = (Repository)sourceWorkspaceElement;
        this.folders.clear();
        this.folders.addAll(XCloneHelper.cloneCollection(sourceRepository.folders, (boolean)newUids, uids));
    }
}

