/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.model.assets.Command;
import com.gridnine.xtrip.common.model.assets.WorkspaceElement;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class SmartFolder
extends WorkspaceElement {
    private static final long serialVersionUID = 7605386797311454593L;
    private final List<SmartFolder> subFolders = new ArrayList<SmartFolder>();
    private Command defaultCommand;
    private final List<Command> commands = new ArrayList<Command>();

    public List<SmartFolder> getSubFolders() {
        for (SmartFolder folder : this.subFolders) {
            folder.getCustomData().get("index-class");
        }
        return this.subFolders;
    }

    public Command getDefaultCommand() {
        return this.defaultCommand;
    }

    public void setDefaultCommand(Command value) {
        this.defaultCommand = value;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.subFolders.clear();
        for (Element folderElm : XmlUtil.getElements((Element)elm, (String)"subFolders/item")) {
            SmartFolder folder = new SmartFolder();
            folder.fromXML(folderElm);
            this.subFolders.add(folder);
        }
        Element cmdElm = XmlUtil.getElement((Element)elm, (String)"defaultCommand");
        if (cmdElm != null) {
            this.defaultCommand = new Command();
            this.defaultCommand.fromXML(cmdElm);
        } else {
            this.defaultCommand = null;
        }
        this.commands.clear();
        for (Element cmdElm2 : XmlUtil.getElements((Element)elm, (String)"commands/item")) {
            Command cmd = new Command();
            cmd.fromXML(cmdElm2);
            this.commands.add(cmd);
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("subFolders".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    SmartFolder folder = new SmartFolder();
                    folder.fromXML(reader);
                    this.subFolders.add(folder);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("defaultCommand".equals(tagName)) {
            this.defaultCommand = new Command();
            this.defaultCommand.fromXML(reader);
            return true;
        }
        if ("commands".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    Command cmd = new Command();
                    cmd.fromXML(reader);
                    this.commands.add(cmd);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        for (SmartFolder folder : this.subFolders) {
            folder.toXML(XmlUtil.addElement((Element)elm, (String)"subFolders/item"));
        }
        if (this.defaultCommand != null) {
            this.defaultCommand.toXML(XmlUtil.addElement((Element)elm, (String)"defaultCommand"));
        }
        for (Command cmd : this.commands) {
            cmd.toXML(XmlUtil.addElement((Element)elm, (String)"commands/item"));
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        if (!this.subFolders.isEmpty()) {
            writer.writeStartElement("subFolders");
            for (SmartFolder folder : this.subFolders) {
                writer.writeStartElement("item");
                folder.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.defaultCommand != null) {
            writer.writeStartElement("defaultCommand");
            this.defaultCommand.toXML(writer);
        }
        if (!this.commands.isEmpty()) {
            writer.writeStartElement("commands");
            for (Command cmd : this.commands) {
                writer.writeStartElement("item");
                cmd.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public void copyFrom(WorkspaceElement sourceWorkspaceElement, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceWorkspaceElement, newUids, uids);
        SmartFolder sourceSmartFolder = (SmartFolder)sourceWorkspaceElement;
        this.subFolders.clear();
        this.subFolders.addAll(XCloneHelper.cloneCollection(sourceSmartFolder.subFolders, (boolean)newUids, uids));
        this.defaultCommand = (Command)XCloneHelper.cloneObject((Object)sourceSmartFolder.defaultCommand, (boolean)newUids, uids);
        this.commands.clear();
        this.commands.addAll(XCloneHelper.cloneCollection(sourceSmartFolder.commands, (boolean)newUids, uids));
    }
}

