/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class WorkspaceElement
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -4666676457738186827L;
    private String type;
    private String id;
    private String name;
    private String description;
    private byte[] icon;
    private final Map<String, Object> customData = new HashMap<String, Object>();

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public void setIcon(byte[] value) {
        this.icon = value;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    public void fromXML(Element elm) throws Exception {
        this.type = XHelper.readString((Element)elm, (String)"type");
        this.id = XHelper.readString((Element)elm, (String)"id");
        this.name = XHelper.readString((Element)elm, (String)"name");
        this.description = XHelper.readString((Element)elm, (String)"description");
        this.icon = XHelper.readBytes((Element)elm, (String)"icon");
        this.customData.clear();
        for (Element dataElm : XmlUtil.getElements((Element)elm, (String)"customData/item")) {
            this.customData.put(XHelper.readString((Element)dataElm, (String)"@key"), XHelper.readObject((Element)dataElm, (String)"."));
        }
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("type".equals(tag)) {
                this.type = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("id".equals(tag)) {
                this.id = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("name".equals(tag)) {
                this.name = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("description".equals(tag)) {
                this.description = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("icon".equals(tag)) {
                this.icon = XSHelper.readBytes((XMLStreamReader)reader);
                continue;
            }
            if ("customData".equals(tag)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        String key = reader.getAttributeValue(null, "key");
                        this.customData.put(key, XSHelper.readObject((XMLStreamReader)reader));
                        continue;
                    }
                    XSHelper.skipElement((XMLStreamReader)reader);
                }
                continue;
            }
            if (this.readXMLElement(reader)) continue;
            LoggerFactory.getLogger(this.getClass()).debug("fromXML(): skipping " + tag);
            XSHelper.skipElement((XMLStreamReader)reader);
        }
    }

    protected abstract boolean readXMLElement(XMLStreamReader var1) throws Exception;

    public void toXML(Element elm) throws Exception {
        XHelper.writeString((Element)elm, (String)"type", (String)this.type);
        XHelper.writeString((Element)elm, (String)"id", (String)this.id);
        XHelper.writeString((Element)elm, (String)"name", (String)this.name, (boolean)true);
        XHelper.writeString((Element)elm, (String)"description", (String)this.description, (boolean)true);
        XHelper.writeBytes((Element)elm, (String)"icon", (byte[])this.icon);
        Set<Map.Entry<String, Object>> entrySet = this.customData.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (entry.getValue() == null) {
                System.out.println(entry.getKey());
            }
            XHelper.writeObject((Element)elm, (String)"customData/item", (Object)entry.getValue()).setAttribute("key", entry.getKey());
        }
    }

    public final void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"type", (String)this.type);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"id", (String)this.id);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"name", (String)this.name, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"description", (String)this.description, (boolean)true);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"icon", (byte[])this.icon);
        if (!this.customData.isEmpty()) {
            writer.writeStartElement("customData");
            Set<Map.Entry<String, Object>> entrySet = this.customData.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                if (entry.getValue() == null) {
                    System.out.println(entry.getKey());
                }
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)entry.getValue(), Collections.singletonMap("key", entry.getKey()));
            }
            writer.writeEndElement();
        }
        this.writeXMLElements(writer);
    }

    protected abstract void writeXMLElements(XMLStreamWriter var1) throws Exception;

    public final Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        WorkspaceElement clone = (WorkspaceElement)this.getClass().newInstance();
        clone.copyFrom(this, newUids, uids);
        return clone;
    }

    public void copyFrom(WorkspaceElement sourceWorkspaceElement, boolean newUids, Map<String, String> uids) throws Exception {
        this.type = sourceWorkspaceElement.type;
        this.id = sourceWorkspaceElement.id;
        this.name = sourceWorkspaceElement.name;
        this.description = sourceWorkspaceElement.description;
        this.icon = (byte[])XCloneHelper.cloneArray((Object)sourceWorkspaceElement.icon, (boolean)newUids, uids);
        this.customData.clear();
        this.customData.putAll(XCloneHelper.cloneMap(sourceWorkspaceElement.customData, (boolean)newUids, uids));
    }
}

