/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.insurance;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public final class InsuranceTouristicHelper {
    public static String getLocalizedRouteLine(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getRouteLine(product, LocaleManager.get().getCurrentLocale(), false, CodeSystem.IATA);
    }

    public static String getRouteLine(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getRouteLine(product, null, true, CodeSystem.IATA);
    }

    public static String getRouteLine(InsuranceTouristic product, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        return product.getCountryName();
    }

    public static void removeProduct(InsuranceTouristic product, boolean removeEmptyReservations) {
        for (Reservation res : new ArrayList(product.getReservation().getBookingFile().getReservations())) {
            if (res.getProducts().contains(product)) {
                res.getProducts().remove(product);
            }
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof InsuranceTouristic)) continue;
                InsuranceTouristic prod = (InsuranceTouristic)bp;
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            product.getReservation().getBookingFile().getReservations().remove(res);
        }
    }

    public static InsuranceTouristic createRefund(InsuranceTouristic model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        excludedUids.addAll(model.getTravellersUids());
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        InsuranceTouristic refund = (InsuranceTouristic)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
        model.getReservation().getProducts().add(refund);
        model.setNextProduct(refund);
        refund.setPreviousProduct(model);
        refund.setNextProduct(null);
        refund.setContractRulesApplied(false);
        refund.setCancellationDetails(null);
        refund.setStatus(ProductStatus.REFUND);
        refund.setIssueDate(new Date());
        refund.setCompleted(false);
        refund.setChecked(false);
        refund.getShipments().clear();
        refund.getPrepaymentDocuments().clear();
        refund.getFopDetalizations().clear();
        return refund;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InsuranceTouristic source, InsuranceTouristic target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        InsuranceTouristic sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        InsuranceTouristic sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        InsuranceTouristic targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        InsuranceTouristic targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static SalesChain getSalesChain(InsuranceTouristic product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(InsuranceTouristic item) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)item);
    }

    public static GeneralProductContractRelationData getClientContractRelation(InsuranceTouristic prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(InsuranceTouristic product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static EntityReference<Organization> getSupplier(InsuranceTouristic prod) {
        return GeneralProductHelper.getContractor(InsuranceTouristicHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(InsuranceTouristic prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(InsuranceTouristicHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(InsuranceTouristic prod) {
        return GeneralProductHelper.getContractor(InsuranceTouristicHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(InsuranceTouristic prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(InsuranceTouristicHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(InsuranceTouristic prod) {
        return InsuranceTouristicHelper.getSubagency(prod, false);
    }

    public static EntityReference<Organization> getSubagency(InsuranceTouristic prod, boolean strict) {
        return GeneralProductHelper.getContractor(InsuranceTouristicHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, strict);
    }

    public static void setSubagency(InsuranceTouristic prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(InsuranceTouristicHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(InsuranceTouristic prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(InsuranceTouristic prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static List<GeneralProductFop> getVendorFops(InsuranceTouristic prod) {
        return InsuranceTouristicHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(InsuranceTouristic prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = InsuranceTouristicHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(InsuranceTouristic prod) {
        return InsuranceTouristicHelper.getClientContractRelation(prod).getFops();
    }

    public static BigDecimal calculateCommissionsEquivalentValue(Collection<GeneralProductCommission> commissions) {
        BigDecimal value = null;
        for (GeneralProductCommission commission : commissions) {
            if (commission.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(commission.getEquivalentAmount()) : commission.getEquivalentAmount();
        }
        return value;
    }

    public static InsuranceTouristic createRefundProduct(InsuranceTouristic model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        excludedUids.addAll(model.getTravellersUids());
        InsuranceTouristic refund = (InsuranceTouristic)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
        model.getReservation().getProducts().add(refund);
        model.setNextProduct(refund);
        refund.setPreviousProduct(model);
        refund.setNextProduct(null);
        refund.setContractRulesApplied(false);
        refund.setCancellationDetails(null);
        refund.setStatus(ProductStatus.REFUND);
        refund.setIssueDate(new Date());
        refund.setCompleted(false);
        refund.setChecked(false);
        return refund;
    }

    public static boolean removeProduct(InsuranceTouristic product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(InsuranceTouristic product, BaseProduct relatedProduct) {
        if (TextUtil.isSame((String)product.getRelatedProductUid(), (String)relatedProduct.getUid())) {
            product.setRelatedProductUid(null);
        }
        return true;
    }

    public static String getCountries(InsuranceTouristic product, Locale locale) {
        return product.getCountryName() != null ? product.getCountryName() : "?";
    }
}

