/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.taxi;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProductSettings;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaxiHelper {
    private static final EntityReference<TaxiProductSettings> SETTINGS_REF = new EntityReference("TAXI-PRODUCT-SETTINGS", TaxiProductSettings.class, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0442\u0430\u043a\u0441\u0438");

    public static SalesChain getSalesChain(TaxiProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static EntityReference<Organization> getAgency(TaxiProduct prod) {
        return GeneralProductHelper.getContractor(TaxiHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static EntityReference<Organization> getSubagency(TaxiProduct prod) {
        return GeneralProductHelper.getContractor(TaxiHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static EntityReference<Organization> getSupplier(TaxiProduct prod) {
        return GeneralProductHelper.getContractor(TaxiHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setAgency(TaxiProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(TaxiHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static void setSubagency(TaxiProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(TaxiHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static BigDecimal getTotalPrice(TaxiProduct product) {
        Money fare;
        Money money = fare = product.getEquivalentFare() != null ? product.getEquivalentFare() : product.getFare();
        if (fare == null) {
            return null;
        }
        if (product.getStatus() == ProductStatus.REFUND) {
            if (product.getPenalty() == null) {
                product.setPenalty(BigDecimal.ZERO);
            }
            return fare.getValue() != null ? fare.getValue().subtract(product.getPenalty()).negate() : null;
        }
        return fare.getValue();
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(TaxiProduct product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static List<GeneralProductFop> getVendorFops(TaxiProduct prod) {
        return TaxiHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(TaxiProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = TaxiHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(TaxiProduct prod) {
        return TaxiHelper.getClientContractRelation(prod).getFops();
    }

    public static Traveller getTraveller(TaxiProduct product) {
        return BookingHelper.findTraveller(product.getReservation().getBookingFile(), !product.getTravellers().isEmpty() ? ((Traveller)product.getTravellers().get(0)).getUid() : null);
    }

    public static String getRouteLine(TaxiProduct product) {
        Locale locale = LocaleManager.get().getCurrentLocale();
        String departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getCountry())).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String departureCity = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getCity())).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String departureAddress = Optional.ofNullable(product.getSource()).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String departureRoute = Stream.of(departureCountry, departureCity, departureAddress).filter(Objects::nonNull).collect(Collectors.joining(", "));
        String arriveCountry = departureCountry;
        String arriveCity = departureCity;
        String arriveAddress = Optional.ofNullable(product.getDestination()).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String arriveRoute = Stream.of(arriveCountry, arriveCity, arriveAddress).filter(Objects::nonNull).collect(Collectors.joining(", "));
        return Stream.of(departureRoute, arriveRoute).filter(Objects::nonNull).collect(Collectors.joining(" - "));
    }

    private static GeneralProductContractRelationData getVendorContractRelation(TaxiProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(TaxiProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static GeneralProductContractRelationData getClientContractRelation(TaxiProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static void setSupplier(TaxiProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(TaxiHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(TaxiProduct prod) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)prod);
    }

    public static TaxiProduct createRefund(TaxiProduct model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        model.getTravellers().forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        TaxiProduct refund = (TaxiProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
        model.getReservation().getProducts().add(refund);
        model.setNextProduct(refund);
        refund.setPreviousProduct(model);
        refund.setNextProduct(null);
        refund.setContractRulesApplied(false);
        refund.setStatus(ProductStatus.REFUND);
        refund.setIssueDate(new Date());
        refund.setCompleted(false);
        refund.setChecked(false);
        refund.getShipments().clear();
        refund.getPrepaymentDocuments().clear();
        refund.getFopDetalizations().clear();
        return refund;
    }

    public static boolean removeProduct(TaxiProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(TaxiProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static String getCities(TaxiProduct product, Locale locale) {
        return Optional.ofNullable(DictionaryCache.get().resolveReference(product.getCity())).map(item -> item.toString(locale)).orElse("?");
    }

    public static String getCountries(TaxiProduct product, Locale locale) {
        return Optional.ofNullable(DictionaryCache.get().resolveReference(product.getCountry())).map(item -> item.toString(locale)).orElse("?");
    }

    public static String getAddresses(TaxiProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        boolean isEnLocale = MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null));
        String country = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getCountry())).map(item -> item.toString(locale)).orElse(null);
        String city = Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)product.getCity()))).map(item -> item.toString(locale)).orElse(null);
        String departureStreet = Optional.ofNullable(product.getSource()).map(item -> isEnLocale ? TranslitUtil.cyr2lat((String)item, (TranslitUtil.TranslitRules)translitRules) : item).orElse(null);
        String arriveStreet = Optional.ofNullable(product.getDestination()).map(item -> isEnLocale ? TranslitUtil.cyr2lat((String)item, (TranslitUtil.TranslitRules)translitRules) : item).orElse(null);
        RouteHelper.AddressData departureAddressData = RouteHelper.AddressDataBuilder.get().country(country).city(city).street(departureStreet).build();
        RouteHelper.AddressData arriveAddressData = RouteHelper.AddressDataBuilder.get().country(country).city(city).street(arriveStreet).build();
        return RouteHelper.getRoute(Arrays.asList(departureAddressData, arriveAddressData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityContainer<TaxiProductSettings> getSettings() {
        EntityContainer result = EntityStorage.get().resolve(SETTINGS_REF);
        if (result != null) {
            return result;
        }
        EntityReference<TaxiProductSettings> entityReference = SETTINGS_REF;
        synchronized (entityReference) {
            result = EntityStorage.get().resolve(SETTINGS_REF);
            if (result != null) {
                return result;
            }
            result = new EntityContainer(TaxiProductSettings.class, SETTINGS_REF.getUid());
            TaxiProductSettings settings = (TaxiProductSettings)result.getEntity();
            settings.setType(SystemSettingsType.OTHER);
            settings.setName(SETTINGS_REF.getCaption());
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(result, false);
        }
        return result;
    }
}

