/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.transfer;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.transfers.PlaceType;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferBlankOwnerProfile;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProductSettings;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProvider;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProviderProfile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TransferHelper {
    private static final EntityReference<TransferProductSettings> SETTINGS_REF = new EntityReference("TRANSFER-PRODUCT-SETTINGS", TransferProductSettings.class, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0442\u0440\u0430\u043d\u0441\u0444\u0435\u0440");

    public static SalesChain getSalesChain(Transfer product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static EntityReference<Organization> getSupplier(Transfer prod) {
        return GeneralProductHelper.getContractor(TransferHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static EntityReference<Organization> getAgency(Transfer prod) {
        return GeneralProductHelper.getContractor(TransferHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static EntityReference<Organization> getSubagency(Transfer prod) {
        return GeneralProductHelper.getContractor(TransferHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static String getRouteLine(Transfer product) {
        Locale locale = LocaleManager.get().getCurrentLocale();
        String departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getStartCountry())).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String departureCity = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getStartCity())).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String departureType = Optional.ofNullable(product.getStartType()).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        if (departureCity != null && departureType != null) {
            departureCity = String.format("%s (%s)", departureCity, departureType);
        }
        String departureAddress = Optional.ofNullable(product.getStartAddress()).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String departureRoute = Stream.of(departureCountry, departureCity, departureAddress).filter(item -> item != null).collect(Collectors.joining(", "));
        String arriveCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getEndCountry())).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String arriveCity = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getEndCity())).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String arriveType = Optional.ofNullable(product.getEndType()).map(item -> item.toString(locale)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        if (arriveCity != null && arriveType != null) {
            arriveCity = String.format("%s (%s)", arriveCity, arriveType);
        }
        String arriveAddress = Optional.ofNullable(product.getEndAddress()).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).orElse(null);
        String arriveRoute = Stream.of(arriveCountry, arriveCity, arriveAddress).filter(item -> item != null).collect(Collectors.joining(", "));
        return Stream.of(departureRoute, arriveRoute).filter(item -> item != null).collect(Collectors.joining(" - "));
    }

    public static List<GeneralProductContractRelationData> getContractRelations(Transfer prod) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductFop> getVendorFops(Transfer prod) {
        return TransferHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(Transfer prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = TransferHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(Transfer prod) {
        return TransferHelper.getClientContractRelation(prod).getFops();
    }

    public static List<GeneralProductCommission> getCommissions(Transfer prod) {
        return TransferHelper.getClientContractRelation(prod).getCommissions();
    }

    private static GeneralProductContractRelationData getVendorContractRelation(Transfer prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(Transfer prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static GeneralProductContractRelationData getClientContractRelation(Transfer prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(Transfer product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static Traveller getTraveller(Transfer product) {
        return BookingHelper.findTraveller(product.getReservation().getBookingFile(), !product.getTravellers().isEmpty() ? ((Traveller)product.getTravellers().get(0)).getUid() : null);
    }

    public static void setAgency(Transfer prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(TransferHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static void setSubagency(Transfer prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(TransferHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static void setSupplier(Transfer prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(TransferHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityContainer<TransferProductSettings> getSettings() throws Exception {
        EntityContainer result = EntityStorage.get().resolve(SETTINGS_REF);
        if (result != null) {
            return result;
        }
        EntityReference<TransferProductSettings> entityReference = SETTINGS_REF;
        synchronized (entityReference) {
            result = EntityStorage.get().resolve(SETTINGS_REF);
            if (result != null) {
                return result;
            }
            result = new EntityContainer(TransferProductSettings.class, SETTINGS_REF.getUid());
            TransferProductSettings settings = (TransferProductSettings)result.getEntity();
            settings.setType(SystemSettingsType.OTHER);
            settings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0442\u0440\u0430\u043d\u0441\u0444\u0435\u0440");
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(result, false);
        }
        return result;
    }

    public static EntityReference<Organization> getSupplierFor(TransferProvider provider) throws GetSupplierException {
        if (provider == null) {
            return null;
        }
        try {
            for (TransferProviderProfile pp : ((TransferProductSettings)TransferHelper.getSettings().getEntity()).getSuppliersMapping()) {
                if (provider != pp.getProvider()) continue;
                return pp.getProfile();
            }
            return null;
        }
        catch (Exception e) {
            throw new GetSupplierException(provider, e);
        }
    }

    public static EntityReference<Organization> getBlankOwnerFor(String blankOwnerCode) throws GetBlankOwnerException {
        if (TextUtil.isBlank((String)blankOwnerCode)) {
            return null;
        }
        try {
            for (TransferBlankOwnerProfile bop : ((TransferProductSettings)TransferHelper.getSettings().getEntity()).getBlankOwnersMapping()) {
                if (!TextUtil.isLike((String)blankOwnerCode, (String)bop.getCode(), (boolean)true, (boolean)true)) continue;
                return bop.getProfile();
            }
            return TransferHelper.getSupplierFor((TransferProvider)CollectionUtil.findEnumConstant(TransferProvider.class, (String)blankOwnerCode));
        }
        catch (Exception e) {
            throw new GetBlankOwnerException(blankOwnerCode, e);
        }
    }

    public static BigDecimal getTotalPrice(Transfer product) {
        Money fare;
        Money money = fare = product.getEquivalentFare() != null ? product.getEquivalentFare() : product.getFare();
        if (fare == null) {
            return null;
        }
        if (product.getStatus() == ProductStatus.REFUND) {
            if (product.getPenalty() == null) {
                product.setPenalty(BigDecimal.ZERO);
            }
            return fare.getValue() != null ? fare.getValue().subtract(product.getPenalty()).negate() : null;
        }
        return fare.getValue();
    }

    public static Transfer createRefund(Transfer model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        model.getTravellers().forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Transfer refund = (Transfer)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
        model.getReservation().getProducts().add(refund);
        model.setNextProduct(refund);
        refund.setPreviousProduct(model);
        refund.setNextProduct(null);
        refund.setContractRulesApplied(false);
        refund.setStatus(ProductStatus.REFUND);
        refund.setIssueDate(new Date());
        refund.setCompleted(false);
        refund.setChecked(false);
        refund.getShipments().clear();
        refund.getPrepaymentDocuments().clear();
        refund.getFopDetalizations().clear();
        return refund;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Transfer source, Transfer target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        Transfer sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        Transfer sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        Transfer targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        Transfer targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static boolean removeProduct(Transfer product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(Transfer product, BaseProduct relatedProduct) {
        return true;
    }

    public static TransportationType getTransportationType(Transfer product) {
        Country start = (Country)DictionaryCache.get().resolveReference(product.getStartCountry());
        Country end = (Country)DictionaryCache.get().resolveReference(product.getEndCountry());
        if (start == null && end == null) {
            return TransportationType.NONE;
        }
        if (start == null) {
            return end.isDomestic() ? TransportationType.DOMESTIC : TransportationType.INTERNATIONAL;
        }
        if (end == null) {
            return start.isDomestic() ? TransportationType.DOMESTIC : TransportationType.INTERNATIONAL;
        }
        if (start.isDomestic() && end.isDomestic()) {
            return TransportationType.DOMESTIC;
        }
        if (!start.isDomestic() && !end.isDomestic()) {
            return TransportationType.INTERNATIONAL;
        }
        return TransportationType.COMBINED;
    }

    public static String getCities(Transfer product, Locale locale) {
        StringBuilder locations = new StringBuilder();
        locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getStartCity())).map(item -> item.toString(locale)).orElse("?"));
        locations.append(" - ");
        locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getEndCity())).map(item -> item.toString(locale)).orElse("?"));
        return locations.length() > 0 ? locations.toString() : null;
    }

    public static String getCountries(Transfer product, Locale locale) {
        StringBuilder countries = new StringBuilder();
        countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getStartCountry())).map(item -> item.toString(locale)).orElse("?"));
        countries.append(" - ");
        countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getEndCountry())).map(item -> item.toString(locale)).orElse("?"));
        return countries.length() > 0 ? countries.toString() : null;
    }

    public static String getAddresses(Transfer product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        boolean isEnLocale = MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null));
        String departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getStartCountry())).map(item -> item.toString(locale)).orElse(null);
        String departureCity = Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)product.getStartCity()))).map(item -> item.toString(locale)).orElse(null);
        String departureStreet = Optional.ofNullable(product.getStartAddress()).map(item -> {
            if (isEnLocale) {
                item = TranslitUtil.cyr2lat((String)item, (TranslitUtil.TranslitRules)translitRules);
            }
            return product.getStartType() != null && product.getStartType() != PlaceType.OTHER ? String.format("%s %s", product.getStartType().toString(locale), item) : item;
        }).orElse(null);
        String arriveCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getEndCountry())).map(item -> item.toString(locale)).orElse(null);
        String arriveCity = Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)product.getEndCity()))).map(item -> item.toString(locale)).orElse(null);
        String arriveStreet = Optional.ofNullable(product.getEndAddress()).map(item -> {
            if (isEnLocale) {
                item = TranslitUtil.cyr2lat((String)item, (TranslitUtil.TranslitRules)translitRules);
            }
            return product.getEndType() != null && product.getEndType() != PlaceType.OTHER ? String.format("%s %s", product.getEndType().toString(locale), item) : item;
        }).orElse(null);
        RouteHelper.AddressData departureAddressData = RouteHelper.AddressDataBuilder.get().country(departureCountry).city(departureCity).street(departureStreet).build();
        RouteHelper.AddressData arriveAddressData = RouteHelper.AddressDataBuilder.get().country(arriveCountry).city(arriveCity).street(arriveStreet).build();
        return RouteHelper.getRoute(Arrays.asList(departureAddressData, arriveAddressData));
    }

    public static boolean hasSameSystemNumbers(Transfer product) {
        int totalCount;
        ProductHandler<Transfer> handler = ProductHandler.of(product);
        List<String> productNumbers = handler.getProductNumbers(product);
        if (CollectionUtil.isEmpty(productNumbers)) {
            return false;
        }
        SearchQuery query = TransferHelper.getBaseSearchQuery(product, handler, productNumbers);
        List<GdsName> gdsNames = CommonReservationGdsNameInfoHelper.getGdsNames(product.getReservation()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!gdsNames.isEmpty()) {
            ArrayList<SearchCriterion> orCriterions = new ArrayList<SearchCriterion>();
            for (GdsName gdsName : gdsNames) {
                orCriterions.add(SearchCriterion.contains((String)CommonProductIndex.Property.gdsNames.name(), (Object)gdsName));
            }
            orCriterions.add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)CommonProductIndex.Property.gdsNames.name()), SearchCriterion.eq((String)CommonProductIndex.Property.gdsName.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])orCriterions.toArray(new SearchCriterion[0])));
        }
        if ((totalCount = EntityStorage.get().search(CommonProductIndex.class, query).getTotalCount()) > 0) {
            return true;
        }
        query = TransferHelper.getBaseSearchQuery(product, handler, productNumbers);
        if (!gdsNames.isEmpty()) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.in((String)CommonProductIndex.Property.gdsName.name(), (Object[])gdsNames.toArray(new GdsName[0])), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.gdsName.name(), null), SearchCriterion.isEmpty((String)CommonProductIndex.Property.gdsNames.name())})}));
        }
        return EntityStorage.get().search(CommonProductIndex.class, query).getTotalCount() > 0;
    }

    private static SearchQuery getBaseSearchQuery(Transfer product, ProductHandler<BaseProduct> handler, List<String> productNumbers) {
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"navigationKey", (Object)product.getUid()));
        HashSet<String> systemNumbers = new HashSet<String>(productNumbers);
        systemNumbers.addAll(productNumbers.stream().map(String::trim).collect(Collectors.toSet()));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)CommonProductIndex.Property.systemNumbers.name(), systemNumbers));
        ProductStatus status = handler.getStatus((BaseProduct)product);
        if (status == ProductStatus.SELL || status == ProductStatus.VOID) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.status.name(), EnumSet.of(ProductStatus.SELL, ProductStatus.VOID)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.TRANSFER));
        TicketType ticketType = handler.getTicketType((BaseProduct)product);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.ticketType.name(), Arrays.asList(ticketType, null)));
        Date issueDate = product.getIssueDate();
        if (issueDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)TransferHelper.getBeginningOfYear(issueDate)));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)issueDate));
        }
        return query;
    }

    private static Date getBeginningOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static final class GetBlankOwnerException
    extends RuntimeException {
        public final String blankOwnerCode;

        public GetBlankOwnerException(String blankOwnerCode, Exception e) {
            super("Error getting blank owner for code " + blankOwnerCode, e);
            this.blankOwnerCode = blankOwnerCode;
        }
    }

    public static final class GetSupplierException
    extends RuntimeException {
        public final TransferProvider provider;

        public GetSupplierException(TransferProvider provider, Exception e) {
            super("Error getting supplier for provider " + provider, e);
            this.provider = provider;
        }
    }
}

