/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.visa;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public final class VisaProductHelper {
    private VisaProductHelper() {
    }

    public static SalesChain getSalesChain(VisaProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(VisaProduct item) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)item);
    }

    public static GeneralProductContractRelationData getClientContractRelation(VisaProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(VisaProduct product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static EntityReference<Organization> getSupplier(VisaProduct prod) {
        return GeneralProductHelper.getContractor(VisaProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(VisaProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(VisaProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(VisaProduct prod) {
        return GeneralProductHelper.getContractor(VisaProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(VisaProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(VisaProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(VisaProduct prod) {
        return GeneralProductHelper.getContractor(VisaProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(VisaProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(VisaProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(VisaProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(VisaProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static List<GeneralProductFop> getVendorFops(VisaProduct prod) {
        return VisaProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(VisaProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = VisaProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(VisaProduct prod) {
        return VisaProductHelper.getClientContractRelation(prod).getFops();
    }

    public static String getRouteLine(VisaProduct product) {
        return product.getCountry() == null ? null : product.getCountry().toString();
    }

    public static VisaProduct createRefund(VisaProduct model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        excludedUids.addAll(model.getTravellers().stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        VisaProduct refund = (VisaProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
        model.getReservation().getProducts().add(refund);
        model.setNextProduct(refund);
        refund.setPreviousProduct(model);
        refund.setNextProduct(null);
        refund.setContractRulesApplied(false);
        refund.setStatus(ProductStatus.REFUND);
        refund.setIssueDate(new Date());
        refund.setCompleted(false);
        refund.setChecked(false);
        refund.getShipments().clear();
        refund.getPrepaymentDocuments().clear();
        refund.getFopDetalizations().clear();
        return refund;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(VisaProduct source, VisaProduct target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        VisaProduct sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        VisaProduct sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        VisaProduct targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        VisaProduct targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static BigDecimal getTotalPrice(VisaProduct product) {
        Money fare;
        Money money = fare = product.getEquivalentFare() != null ? product.getEquivalentFare() : product.getFare();
        if (fare == null) {
            return null;
        }
        if (product.getStatus() == ProductStatus.REFUND) {
            if (product.getPenalty() == null) {
                product.setPenalty(BigDecimal.ZERO);
            }
            return fare.getValue() != null ? fare.getValue().subtract(product.getPenalty()).negate() : null;
        }
        return fare.getValue();
    }

    public static BigDecimal getEquivalentVat(VisaProduct product) {
        return product.getEquivalentFareVatValue() != null ? product.getEquivalentFareVatValue().getAmount() : null;
    }

    public static void setEquivalentVat(VisaProduct product, BigDecimal value) {
        if (product.getEquivalentFareVatValue() != null) {
            product.getEquivalentFareVatValue().setAmount(value);
        } else if (value != null) {
            VatValue vatValue = new VatValue();
            vatValue.setAmount(value);
            product.setEquivalentFareVatValue(vatValue);
        }
    }

    public static BigDecimal getPenaltyVat(VisaProduct product) {
        return product.getPenaltyVatValue() != null ? product.getPenaltyVatValue().getAmount() : null;
    }

    public static void setPenaltyVat(VisaProduct product, BigDecimal value) {
        if (product.getPenaltyVatValue() != null) {
            product.getPenaltyVatValue().setAmount(value);
        } else if (value != null) {
            VatValue vatValue = new VatValue();
            vatValue.setAmount(value);
            product.setPenaltyVatValue(vatValue);
        }
    }

    public static void removeProduct(VisaProduct product, boolean removeEmptyReservations) {
        Iterator iterator = product.getReservation().getBookingFile().getReservations().iterator();
        while (iterator.hasNext()) {
            Reservation res = (Reservation)iterator.next();
            res.getProducts().remove(product);
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof VisaProduct)) continue;
                VisaProduct prod = (VisaProduct)bp;
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisaProduct createExchange(VisaProduct model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        ArrayList travellers = new ArrayList(model.getTravellers());
        model.getTravellers().clear();
        try {
            VisaProduct exchange = (VisaProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            exchange.setReservation(res);
            res.getProducts().add(exchange);
            exchange.getTravellers().addAll(travellers);
            exchange.setContractRulesApplied(false);
            exchange.setStatus(ProductStatus.EXCHANGE);
            exchange.setIssueDate(new Date());
            VisaProduct sell2 = (VisaProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            sell2.setReservation(res);
            res.getProducts().add(sell2);
            sell2.getTravellers().addAll(travellers);
            model.setNextProduct(exchange);
            exchange.setPreviousProduct(model);
            sell2.setPreviousProduct(exchange);
            exchange.setNextProduct(sell2);
            sell2.setContractRulesApplied(false);
            sell2.setStatus(ProductStatus.SELL);
            sell2.setIssueDate(new Date());
            sell2.setSystemNumber(null);
            exchange.setCompleted(false);
            sell2.setCompleted(false);
            VisaProduct visaProduct = sell2;
            return visaProduct;
        }
        finally {
            model.setReservation(res);
            model.getTravellers().addAll(travellers);
        }
    }

    public static boolean removeProduct(VisaProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(VisaProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static String getCountries(VisaProduct product, Locale locale) {
        return Optional.ofNullable(DictionaryCache.get().resolveReference(product.getCountry())).map(item -> item.toString(locale)).orElse("?");
    }
}

