/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.xtriphotels;

import com.google.common.collect.Iterables;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class XtripHotelProductHelper {
    public static Date startDate(CancellationCharge c) {
        Date result = c == null || c.getStartDate() == null ? null : XtripHotelProductHelper.someDate(c.getStartDate(), c);
        return result;
    }

    public static Date endDate(CancellationCharge c) {
        Date result = c == null || c.getEndDate() == null ? null : XtripHotelProductHelper.someDate(c.getEndDate(), c);
        return result;
    }

    private static Date someDate(Date date, CancellationCharge c) {
        return c.isWithTime() ? date : MiscUtil.clearTime((Date)date, (String)c.getTimeZoneId());
    }

    public static Date guardedStartDate(CancellationCharge c) {
        return XtripHotelProductHelper.guardedStartDate(c, new Date());
    }

    public static Date guardedStartDate(CancellationCharge c, Date now) {
        Date result = c == null || XtripHotelProductHelper.isZero(c) ? null : (c.getStartDate() == null ? XtripHotelProductHelper.someDate(now, c) : XtripHotelProductHelper.startDate(c));
        return result;
    }

    public static boolean isZero(CancellationCharge c) {
        RateMoney penalty = c.getPenalty();
        if (penalty != null) {
            Double rate = penalty.getRate();
            if (rate != null && rate != 0.0) {
                return false;
            }
            Money money = penalty.getMoney();
            if (money != null && money.getValue() != null && !MiscUtil.equals((Object)money.getValue(), (Object)BigDecimal.ZERO)) {
                return false;
            }
        }
        return true;
    }

    public static Date getTimeLimit(List<CancellationCharge> charges, Date defaultDate) {
        Date result = defaultDate;
        for (CancellationCharge cc : charges) {
            result = MiscUtil.minimum((Date[])new Date[]{result, XtripHotelProductHelper.guardedStartDate(cc)});
        }
        return result;
    }

    public static Date calculateTimeLimit(HotelProduct prod) {
        return XtripHotelProductHelper.calculateTimeLimit(prod, null);
    }

    public static Date calculateTimeLimit(HotelProduct prod, Integer shift) {
        Room room = (Room)CollectionUtil.head((Iterable)prod.getRooms());
        Date checkInDate = room == null ? null : room.getCheckInDate();
        Date freeCancellationTerm = prod.getFreeCancellationTerm();
        Date defaultDate = freeCancellationTerm != null ? (checkInDate != null ? MiscUtil.minimum((Date[])new Date[]{checkInDate, freeCancellationTerm}) : null) : checkInDate;
        Date result = XtripHotelProductHelper.getTimeLimit(prod.getCancellationCharges(), defaultDate);
        return result == null || shift == null ? result : MiscUtil.addMinutesToDate((Date)result, (int)(-shift.intValue()));
    }

    public static Date calculateTimeLimit(Iterable<HotelProduct> prods) {
        Date result = null;
        for (HotelProduct hp : prods) {
            result = MiscUtil.minimum((Date[])new Date[]{result, XtripHotelProductHelper.calculateTimeLimit(hp)});
        }
        return result;
    }

    public static Date calculateTimeLimit(BookingFile bf) {
        Date result = null;
        for (Reservation res : bf.getReservations()) {
            result = MiscUtil.minimum((Date[])new Date[]{result, XtripHotelProductHelper.calculateTimeLimit(Iterables.filter((Iterable)res.getProducts(), HotelProduct.class))});
        }
        return result;
    }
}

