/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.excel;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static final int SHIFT_CELLS_RIGHT = 0;
    public static final int SHIFT_CELLS_DOWN = 1;

    public static HSSFSheet findSheet(HSSFWorkbook book, String title) {
        if (book == null || TextUtil.isBlank((String)title)) {
            return null;
        }
        return book.getSheet(title);
    }

    public static void copyRows(HSSFSheet sheet, int startOfRange, int endOfRange) throws Exception {
        if (sheet == null) {
            return;
        }
        int lastRowNum = sheet.getLastRowNum();
        if (startOfRange > endOfRange) {
            throw new Exception("Start row number is greater than end row number");
        }
        if (startOfRange < 0 || endOfRange < 0) {
            throw new Exception("Start row or end row number is out of range");
        }
        for (int n = startOfRange; n <= endOfRange; ++n) {
            if (sheet.getRow(n) != null) continue;
            sheet.createRow(n);
        }
        int startRow = startOfRange;
        int lastRow = endOfRange > lastRowNum ? endOfRange : lastRowNum;
        ArrayList<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
        for (int n = 0; n < sheet.getNumMergedRegions(); ++n) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(n);
            if (mergedRegion.getFirstRow() < startOfRange || mergedRegion.getLastRow() > endOfRange) continue;
            mergedRegions.add(mergedRegion.copy());
        }
        int shift = endOfRange - startOfRange + 1;
        sheet.shiftRows(startRow, lastRow, shift, true, false, true);
        for (int n = startOfRange; n <= endOfRange; ++n) {
            HSSFRow destRow = sheet.getRow(n);
            HSSFRow sourceRow = sheet.getRow(n + shift);
            if (sourceRow == null) continue;
            for (int m = sourceRow.getFirstCellNum(); m < sourceRow.getLastCellNum(); ++m) {
                HSSFCell sourceCell = sourceRow.getCell(m);
                if (sourceCell == null) continue;
                HSSFCell destCell = destRow.getCell(m);
                if (destCell == null) {
                    destCell = destRow.createCell(m);
                }
                ExcelUtils.copyCell(sourceCell, destCell);
            }
        }
        for (CellRangeAddress region : mergedRegions) {
            sheet.addMergedRegion(region);
        }
    }

    public static void copyColumns(HSSFSheet sheet, int startColumn, int endColumn) throws Exception {
        ExcelUtils.copyColumns(sheet, startColumn, endColumn, sheet.getFirstRowNum(), sheet.getLastRowNum());
    }

    public static void copyColumns(HSSFSheet sheet, int startOfRange, int endOfRange, int startRow, int endRow) throws Exception {
        int n;
        if (sheet == null) {
            return;
        }
        if (startOfRange > endOfRange) {
            throw new Exception("Start column number is greater than end column number");
        }
        if (startRow > endRow) {
            throw new Exception("Start row number is greater than end row number");
        }
        int shft = endOfRange - startOfRange + 1;
        ArrayList<CellRangeAddress> regions = new ArrayList<CellRangeAddress>();
        for (int n2 = 0; n2 < sheet.getNumMergedRegions(); ++n2) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(n2);
            if (mergedRegion.getFirstRow() < startRow || mergedRegion.getLastRow() > endRow) continue;
            if (mergedRegion.getFirstColumn() < startOfRange && mergedRegion.getLastColumn() >= endOfRange) {
                mergedRegion.setLastColumn(mergedRegion.getLastColumn() + shft);
                continue;
            }
            if (mergedRegion.getFirstColumn() >= startOfRange && mergedRegion.getFirstColumn() <= endOfRange && mergedRegion.getLastColumn() > endOfRange) {
                mergedRegion.setLastColumn(mergedRegion.getLastColumn() + shft);
                continue;
            }
            if (mergedRegion.getFirstColumn() > endOfRange) {
                mergedRegion.setFirstColumn(mergedRegion.getFirstColumn() + shft);
                mergedRegion.setLastColumn(mergedRegion.getLastColumn() + shft);
                continue;
            }
            if (mergedRegion.getFirstColumn() < startOfRange || mergedRegion.getLastColumn() > endOfRange) continue;
            CellRangeAddress region = mergedRegion.copy();
            region.setFirstColumn(region.getFirstColumn() + shft);
            region.setLastColumn(region.getLastColumn() + shft);
            regions.add(region);
        }
        for (CellRangeAddress region : regions) {
            sheet.addMergedRegion(region);
        }
        int maxLastColumn = 0;
        for (n = startRow; n <= endRow; ++n) {
            short firstCellNum;
            HSSFRow row = sheet.getRow(n);
            if (row == null) continue;
            int lastCellNum = row.getLastCellNum() - 1;
            if (lastCellNum > maxLastColumn) {
                maxLastColumn = lastCellNum;
            }
            if (startOfRange >= (firstCellNum = row.getFirstCellNum())) {
                firstCellNum = (short)startOfRange;
            }
            int lastColumn = lastCellNum < endOfRange ? lastCellNum : endOfRange;
            int shift = lastColumn - firstCellNum + 1;
            for (int m = lastCellNum; m >= firstCellNum; --m) {
                HSSFCell sourceCell = row.getCell(m);
                if (sourceCell == null) continue;
                HSSFCell destCell = row.getCell(m + shift);
                if (destCell == null) {
                    destCell = row.createCell(m + shift);
                }
                ExcelUtils.copyCell(sourceCell, destCell);
            }
        }
        for (n = maxLastColumn; n >= startOfRange; --n) {
            sheet.setColumnWidth(n + shft, sheet.getColumnWidth(n));
        }
    }

    public static void replace(HSSFSheet sheet, String key, String value) {
        ExcelUtils.replace(sheet, key, value, 0, 0, 0, 0);
    }

    public static void replace(XSSFSheet sheet, String key, String value) {
        ExcelUtils.replace(sheet, key, value, 0, 0, 0, 0);
    }

    public static void replace(HSSFSheet sheet, String key, String value, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        if (sheet == null || TextUtil.isBlank((String)key)) {
            return;
        }
        if (value == null) {
            value = "";
        }
        int n1 = firstRow != 0 && firstRow > 0 ? firstRow : 0;
        int n2 = lastRow != 0 && lastRow < sheet.getLastRowNum() ? lastRow : sheet.getLastRowNum();
        for (int n = n1; n <= n2; ++n) {
            HSSFRow row = sheet.getRow(n);
            if (row == null) continue;
            int m1 = firstColumn != 0 && firstColumn > 0 ? firstColumn : 0;
            int m2 = lastColumn != 0 && lastColumn < row.getLastCellNum() - 1 ? lastColumn : row.getLastCellNum() - 1;
            for (int m = m1; m <= m2; ++m) {
                HSSFCell cell = row.getCell(m);
                if (cell == null) continue;
                ExcelUtils.replace(cell, key, value);
            }
        }
    }

    public static void replace(XSSFSheet sheet, String key, String value, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        if (sheet == null || TextUtil.isBlank((String)key)) {
            return;
        }
        if (value == null) {
            value = "";
        }
        int n1 = firstRow != 0 && firstRow > 0 ? firstRow : 0;
        int n2 = lastRow != 0 && lastRow < sheet.getLastRowNum() ? lastRow : sheet.getLastRowNum();
        for (int n = n1; n <= n2; ++n) {
            XSSFRow row = sheet.getRow(n);
            if (row == null) continue;
            int m1 = firstColumn != 0 && firstColumn > 0 ? firstColumn : 0;
            int m2 = lastColumn != 0 && lastColumn < row.getLastCellNum() - 1 ? lastColumn : row.getLastCellNum() - 1;
            for (int m = m1; m <= m2; ++m) {
                XSSFCell cell = row.getCell(m);
                if (cell == null) continue;
                ExcelUtils.replace(cell, key, value);
            }
        }
    }

    public static void removeRow(HSSFSheet sheet, int rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            return;
        }
        sheet.removeRow((Row)row);
        int lastRowNum = sheet.getLastRowNum();
        if (rowIndex >= lastRowNum) {
            return;
        }
        sheet.shiftRows(rowIndex + 1, lastRowNum, -1);
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, BigDecimal value) throws Exception {
        ExcelUtils.setCellValue(sheet, originX, originY, x, y, value, false);
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, Double value) throws Exception {
        if (value == null) {
            return;
        }
        ExcelUtils.setCellValue(sheet, originX, originY, x, y, value, false);
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, BigDecimal value, boolean ignoreZero) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        if (value == null || value.doubleValue() == 0.0 && ignoreZero) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value.doubleValue());
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, double value, boolean ignoreZero) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        if (value == 0.0 && ignoreZero) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value);
    }

    public static void clearCellValue(HSSFSheet sheet, int originX, int originY, int x, int y) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        cell.setCellType(3);
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, String value) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        cell.setCellValue((RichTextString)new HSSFRichTextString(value));
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, int value) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        cell.setCellValue((double)value);
    }

    public static void setCellValue(HSSFSheet sheet, int originX, int originY, int x, int y, Date value) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value);
    }

    public static void setCellFormula(HSSFSheet sheet, int originX, int originY, int x, int y, String formula) throws Exception {
        HSSFCell cell = ExcelUtils.findCell(sheet, originX, originY, x, y);
        if (cell == null) {
            throw new Exception("Cell  is null");
        }
        if (TextUtil.isBlank((String)formula)) {
            cell.setCellType(3);
            return;
        }
        String value = formula.startsWith("=") ? formula.substring(1) : formula;
        cell.setCellFormula(value);
    }

    private static HSSFCell findCell(HSSFSheet sheet, int originX, int originY, int x, int y) throws Exception {
        if (sheet == null) {
            throw new Exception("sheet is null");
        }
        int rowIndex = originX - 1 + (x - 1);
        int colIndex = originY - 1 + (y - 1);
        if (rowIndex > sheet.getLastRowNum() || rowIndex < 0) {
            throw new Exception("Row index " + rowIndex + " is out of range. Max row index " + sheet.getLastRowNum());
        }
        HSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if (colIndex >= row.getLastCellNum() || colIndex < 0) {
            row.createCell(colIndex);
        }
        if (row.getCell(colIndex) == null) {
            return row.createCell(colIndex);
        }
        return row.getCell(colIndex);
    }

    public static HSSFCell getCell(HSSFSheet sheet, int rowIndex, int columnIndex) {
        HSSFRow row = sheet != null ? sheet.getRow(rowIndex) : null;
        return row != null ? row.getCell(columnIndex) : null;
    }

    public static HSSFCell findCell(HSSFSheet sheet, String content) throws Exception {
        if (content == null || sheet == null) {
            return null;
        }
        for (int n = 0; n < sheet.getLastRowNum(); ++n) {
            HSSFRow row = sheet.getRow(n);
            if (row == null) continue;
            for (int m = 0; m < row.getLastCellNum(); ++m) {
                HSSFCell cell = row.getCell(m);
                if (cell == null || cell.getCellType() != 1 || cell.getRichStringCellValue() == null || !content.equals(cell.getRichStringCellValue().toString())) continue;
                return cell;
            }
        }
        return null;
    }

    private static void copyCell(HSSFCell source, HSSFCell dest) {
        if (source == null) {
            return;
        }
        HSSFComment cellComment = source.getCellComment();
        if (cellComment != null) {
            HSSFComment comment = new HSSFComment(cellComment.getParent(), cellComment.getAnchor());
            ExcelUtils.copyCellComment(cellComment, comment);
            dest.setCellComment((Comment)comment);
        } else {
            dest.setCellComment(null);
        }
        dest.setCellType(3);
        dest.setCellType(source.getCellType());
        dest.setCellStyle(source.getCellStyle());
        switch (source.getCellType()) {
            case 3: {
                break;
            }
            case 4: {
                dest.setCellValue(source.getBooleanCellValue());
                break;
            }
            case 5: {
                dest.setCellErrorValue(source.getErrorCellValue());
                break;
            }
            case 2: {
                dest.setCellFormula(source.getCellFormula());
                break;
            }
            case 0: {
                dest.setCellValue(source.getNumericCellValue());
                break;
            }
            case 1: {
                dest.setCellValue((RichTextString)source.getRichStringCellValue());
            }
        }
        HSSFHyperlink hyperlink = source.getHyperlink();
        if (hyperlink != null) {
            dest.setHyperlink((Hyperlink)hyperlink);
        }
    }

    private static void copyCellComment(HSSFComment source, HSSFComment dest) {
        dest.setAnchor(source.getAnchor());
        dest.setAuthor(source.getAuthor());
        dest.setColumn(source.getColumn());
        dest.setFillColor(source.getFillColor());
        dest.setHorizontalAlignment(source.getHorizontalAlignment());
        dest.setLineStyle(source.getLineStyleColor());
        dest.setLineWidth(source.getLineWidth());
        dest.setMarginLeft(source.getMarginLeft());
        dest.setMarginRight(source.getMarginRight());
        dest.setMarginBottom(source.getMarginBottom());
        dest.setMarginTop(source.getMarginTop());
        dest.setNoFill(source.isNoFill());
        dest.setRow(source.getRow());
        dest.setShapeType(source.getShapeType());
        dest.setString((RichTextString)(source.getString() != null ? new HSSFRichTextString(source.getString().getString()) : null));
        dest.setVerticalAlignment(source.getVerticalAlignment());
        dest.setVisible(source.isVisible());
    }

    private static void replace(HSSFCell cell, String key, String value) {
        if (cell == null || TextUtil.isBlank((String)key)) {
            return;
        }
        String oldValue = null;
        switch (cell.getCellType()) {
            case 2: {
                oldValue = cell.getCellFormula();
                break;
            }
            case 1: {
                HSSFRichTextString str = cell.getRichStringCellValue();
                if (str == null) break;
                oldValue = str.getString();
                break;
            }
        }
        if (TextUtil.isBlank(oldValue)) {
            return;
        }
        String newValue = oldValue.replace(key, value == null ? "" : value);
        switch (cell.getCellType()) {
            case 2: {
                cell.setCellFormula(newValue);
                return;
            }
            case 1: {
                cell.setCellValue((RichTextString)new HSSFRichTextString(newValue));
                return;
            }
        }
    }

    private static void replace(XSSFCell cell, String key, String value) {
        if (cell == null || TextUtil.isBlank((String)key)) {
            return;
        }
        String oldValue = null;
        switch (cell.getCellType()) {
            case 2: {
                oldValue = cell.getCellFormula();
                break;
            }
            case 1: {
                XSSFRichTextString str = cell.getRichStringCellValue();
                if (str == null) break;
                oldValue = str.getString();
                break;
            }
        }
        if (TextUtil.isBlank(oldValue)) {
            return;
        }
        String newValue = oldValue.replace(key, value == null ? "" : value);
        switch (cell.getCellType()) {
            case 2: {
                cell.setCellFormula(newValue);
                return;
            }
            case 1: {
                cell.setCellValue((RichTextString)new XSSFRichTextString(newValue));
                return;
            }
        }
    }

    public static void insertRow(HSSFSheet sheet, int row, int cols, int rowsCountToShift) {
        sheet.shiftRows(row, row + rowsCountToShift, 1);
        HSSFRow oldRow = sheet.getRow(row - 1);
        HSSFRow newRow = sheet.getRow(row);
        int fCell = oldRow.getFirstCellNum() < 0 ? 0 : oldRow.getFirstCellNum();
        short lCell = cols < oldRow.getLastCellNum() ? (short)cols : oldRow.getLastCellNum();
        for (int i = fCell; i < lCell; ++i) {
            HSSFCell oldCell = oldRow.getCell(i);
            if (oldCell == null) continue;
            HSSFCellStyle style = oldRow.getCell(i).getCellStyle();
            if (newRow.getCell(i) == null) {
                HSSFCell newCell = newRow.createCell(i);
                newCell.setCellStyle(style);
            }
            ExcelUtils.copyCell(oldRow.getCell(i), newRow.getCell(i));
        }
    }

    public static void insertCells(HSSFSheet sheet, int row1, int row2, int col1, int col2, int shiftDirection, boolean moveMergedRegions) {
        int maxRowIndex = sheet.getLastRowNum();
        switch (shiftDirection) {
            case 1: {
                int shiftHeight = row2 - row1 + 1;
                ArrayList<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
                if (moveMergedRegions) {
                    for (int n = 0; n < sheet.getNumMergedRegions(); ++n) {
                        CellRangeAddress mergedRegion = sheet.getMergedRegion(n);
                        if (mergedRegion.getFirstRow() < row1 - 1 || mergedRegion.getLastRow() > row2 - 1 || mergedRegion.getFirstColumn() < col1 - 1 || mergedRegion.getLastColumn() > col2 - 1) continue;
                        mergedRegions.add(mergedRegion.copy());
                    }
                }
                for (int i = maxRowIndex; i > row1 - 1; --i) {
                    HSSFRow dstRow;
                    HSSFRow srcRow = sheet.getRow(i);
                    if (srcRow == null) {
                        srcRow = sheet.createRow(i);
                    }
                    if ((dstRow = sheet.getRow(i + shiftHeight)) == null) {
                        dstRow = sheet.createRow(i + shiftHeight);
                    }
                    for (int j = col1 - 1; j <= col2 - 1; ++j) {
                        HSSFCell srcCell = srcRow.getCell(j);
                        HSSFCell dstCell = dstRow.getCell(j);
                        if (srcCell == null) {
                            srcCell = srcRow.createCell(j);
                        }
                        if (dstCell == null) {
                            dstCell = dstRow.createCell(j);
                        }
                        ExcelUtils.copyCell(srcCell, dstCell);
                    }
                }
                if (!moveMergedRegions) break;
                for (CellRangeAddress region : mergedRegions) {
                    region.setFirstRow(region.getFirstRow() + shiftHeight);
                    region.setLastRow(region.getLastRow() + shiftHeight);
                    sheet.addMergedRegion(region);
                }
                break;
            }
            case 0: {
                break;
            }
        }
    }

    public static void mergeCells(HSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow - 1, lastRow - 1, firstCol - 1, lastCol - 1));
    }

    public static void setCellStyle(HSSFSheet sheet, int row, int col, HSSFCellStyle style) throws Exception {
        HSSFCell cell;
        if (sheet == null || style == null || col == 0 || row == 0) {
            return;
        }
        HSSFRow r = sheet.getRow(row - 1);
        if (r != null && (cell = r.getCell(col - 1)) != null) {
            cell.setCellStyle(style);
        }
    }

    public static HSSFCellStyle getCellStyle(HSSFSheet sheet, int row, int col) throws Exception {
        HSSFCell cell;
        if (sheet == null || row == 0 || col == 0) {
            return null;
        }
        HSSFRow r = sheet.getRow(row - 1);
        if (r != null && (cell = r.getCell(col - 1)) != null) {
            return cell.getCellStyle();
        }
        return null;
    }

    public static String getTextValue(HSSFWorkbook workbook, HSSFSheet sheet, HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            switch (cell.getCellType()) {
                case 1: {
                    return cell.getRichStringCellValue().getString();
                }
                case 0: {
                    return ExcelUtils.getFormattedValue(cell.getNumericCellValue());
                }
                case 2: {
                    HSSFFormulaEvaluator formulaEvaluator = new HSSFFormulaEvaluator(workbook);
                    CellValue value = formulaEvaluator.evaluate((Cell)cell);
                    return ExcelUtils.getFormattedValue(value.getNumberValue());
                }
            }
            return null;
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)L10n.get((String)"CANNOT_GET_CELL_VALUE"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
        }
    }

    public static String getTextValue(XSSFWorkbook workbook, XSSFSheet sheet, XSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            switch (cell.getCellType()) {
                case 1: {
                    return cell.getRichStringCellValue().getString();
                }
                case 0: {
                    return ExcelUtils.getFormattedValue(cell.getNumericCellValue());
                }
                case 2: {
                    XSSFFormulaEvaluator formulaEvaluator = new XSSFFormulaEvaluator(workbook);
                    CellValue value = formulaEvaluator.evaluate((Cell)cell);
                    return ExcelUtils.getFormattedValue(value.getNumberValue());
                }
            }
            return null;
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)L10n.get((String)"CANNOT_GET_CELL_VALUE"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
        }
    }

    private static String getFormattedValue(double number) {
        return ExcelUtils.removeZeroes(String.format("%1$f", number));
    }

    public static Date getDateValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            return cell.getDateCellValue();
        }
        catch (Exception e) {
            if (cell.getCellType() == 1) {
                throw Xeption.forDeveloper((String)L10n.get((String)"DATE_CELL_TYPE_IS_TEXT"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
            }
            throw Xeption.forDeveloper((String)L10n.get((String)"CANNOT_GET_CELL_VALUE"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
        }
    }

    public static Date getDateValue(XSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            return cell.getDateCellValue();
        }
        catch (Exception e) {
            if (cell.getCellType() == 1) {
                throw Xeption.forDeveloper((String)L10n.get((String)"DATE_CELL_TYPE_IS_TEXT"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
            }
            throw Xeption.forDeveloper((String)L10n.get((String)"CANNOT_GET_CELL_VALUE"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
        }
    }

    public static Integer getIntValue(HSSFWorkbook workbook, HSSFSheet sheet, HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            switch (cell.getCellType()) {
                case 1: {
                    return Integer.valueOf(cell.getRichStringCellValue().getString());
                }
                case 0: {
                    return (int)cell.getNumericCellValue();
                }
                case 2: {
                    HSSFFormulaEvaluator formulaEvaluator = new HSSFFormulaEvaluator(workbook);
                    CellValue value = formulaEvaluator.evaluate((Cell)cell);
                    return Double.valueOf(value.formatAsString()).intValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)L10n.get((String)"CANNOT_GET_CELL_VALUE"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
        }
    }

    public static Double getDoubleValue(HSSFWorkbook workbook, HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            switch (cell.getCellType()) {
                case 1: {
                    return Double.valueOf(cell.getRichStringCellValue().getString());
                }
                case 0: {
                    return cell.getNumericCellValue();
                }
                case 2: {
                    HSSFFormulaEvaluator formulaEvaluator = new HSSFFormulaEvaluator(workbook);
                    CellValue value = formulaEvaluator.evaluate((Cell)cell);
                    return Double.valueOf(value.formatAsString());
                }
            }
            return null;
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)L10n.get((String)"CANNOT_GET_CELL_VALUE"), (Throwable)e, (Object[])new Object[]{cell.getAddress()});
        }
    }

    public static String removeZeroes(String original) {
        if (TextUtil.isBlank((String)original)) {
            return original;
        }
        String result = original;
        int dotPos = original.indexOf(".");
        if (dotPos < 0) {
            dotPos = original.indexOf(",");
        }
        int lastNonZeroDigitPos = -1;
        if (dotPos >= 0) {
            for (int i = dotPos + 1; i < original.length(); ++i) {
                if (original.charAt(i) == '0') continue;
                lastNonZeroDigitPos = i;
            }
            result = lastNonZeroDigitPos > dotPos + 1 && lastNonZeroDigitPos < original.length() ? original.substring(0, lastNonZeroDigitPos + 1) : original.substring(0, dotPos);
        }
        return result;
    }

    public static String indexToLetter(int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index can't be less than 1");
        }
        return String.valueOf(Character.valueOf((char)(64 + index)));
    }

    public static int letterToIndex(char letter) {
        if ((letter = Character.toUpperCase(letter)) < 'A' || letter > 'Z') {
            throw new IllegalArgumentException("Letter index can't be less than 'A' or greater than 'Z'");
        }
        return letter - 65;
    }

    public static int stringToIndex(String strIndex) {
        StringBuilder str = new StringBuilder(strIndex.toUpperCase());
        str = str.reverse();
        int res = 0;
        for (int i = 0; i < str.length(); ++i) {
            res = (int)((double)res + (double)(ExcelUtils.letterToIndex(str.charAt(i)) + 1) * Math.pow(26.0, i));
        }
        return --res;
    }

    public static String indexToString(int index) {
        int num = index + 1;
        StringBuilder str = new StringBuilder();
        while (num > 26) {
            str.append(ExcelUtils.indexToLetter(num % 26 > 0 ? num % 26 : 26));
            num = num % 26 > 0 ? num / 26 : num / 26 - 1;
        }
        str.append(ExcelUtils.indexToLetter(num));
        str = str.reverse();
        return str.toString();
    }

    public static List<String> prepareDataColumns(String excelColNumValueStart, String excelColNumValueFinish) {
        ArrayList<String> res = new ArrayList<String>();
        int finishNum = ExcelUtils.stringToIndex(excelColNumValueFinish);
        for (int curNum = ExcelUtils.stringToIndex(excelColNumValueStart); curNum <= finishNum; ++curNum) {
            res.add(ExcelUtils.indexToString(curNum));
        }
        return res;
    }

    public static List<Integer> prepareDataRows(int excelRowNumValueStart, int excelRowNumValueFinish) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = excelRowNumValueStart; i <= excelRowNumValueFinish; ++i) {
            result.add(i);
        }
        return result;
    }
}

