/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.DictionaryCompressedData;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ExportHelper {
    public static final ObjectResolver standardResolver = new ObjectResolver(){

        @Override
        public <D extends BaseDictionary> D resolve(DictionaryReference<D> ref) {
            return (D)DictionaryCache.get().resolveReference(ref);
        }

        @Override
        public <E extends BaseEntity> E resolve(EntityReference<E> ref) throws Exception {
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            return (E)(ctr == null ? null : ctr.getEntity());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSerializable uncompress(byte[] content) throws Exception {
        if (content == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(content));){
            if (zip.getNextEntry() == null) {
                XSerializable xSerializable = null;
                return xSerializable;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtil.copyStream((InputStream)zip, (OutputStream)baos, (int)256);
            Document document = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            Element root = document.getDocumentElement();
            Class cls = XHelper.getClass((String)root.getAttribute("class"));
            Object obj = null;
            obj = EntityContainer.class.equals((Object)cls) ? new EntityContainer(XHelper.getClass((String)XHelper.readString((Element)root, (String)"entityType")), XHelper.readString((Element)root, (String)"uid")) : (XSerializable)cls.newInstance();
            obj.fromXML(root);
            XSerializable xSerializable = obj;
            return xSerializable;
        }
    }

    private ExportHelper() {
    }

    public static ObjectResolver createExportResolver(final List<EntityCompressedData> referencedEntities, final List<DictionaryCompressedData> referencedDictionaries) {
        return new ObjectResolver(){
            private final Map<DictionaryReference<?>, BaseDictionary> dictCache = new HashMap();
            private final Map<EntityReference<?>, Object> entityCache = new HashMap();

            @Override
            public <D extends BaseDictionary> D resolve(DictionaryReference<D> ref) throws Exception {
                if (ref == null) {
                    return null;
                }
                if (this.dictCache.containsKey(ref)) {
                    return (D)this.dictCache.get(ref);
                }
                for (DictionaryCompressedData data : referencedDictionaries) {
                    if (!ref.getType().getName().equals(data.getDictClassName()) || !ref.getCode().equals(data.getDictCode())) continue;
                    BaseDictionary item = (BaseDictionary)ExportHelper.uncompress(data.getContent());
                    this.dictCache.put(ref, item);
                    return (D)item;
                }
                this.dictCache.put(ref, null);
                return null;
            }

            @Override
            public <E extends BaseEntity> E resolve(EntityReference<E> ref) throws Exception {
                if (ref == null) {
                    return null;
                }
                if (this.entityCache.containsKey(ref)) {
                    return (E)((BaseEntity)this.entityCache.get(ref));
                }
                for (EntityCompressedData data : referencedEntities) {
                    if (!ref.equals((Object)data.getReference())) continue;
                    EntityContainer ctr = (EntityContainer)ExportHelper.uncompress(data.getContent());
                    this.entityCache.put(ref, ctr.getEntity());
                    return (E)ctr.getEntity();
                }
                this.entityCache.put(ref, null);
                return null;
            }
        };
    }

    public static interface ObjectResolver {
        public <E extends BaseEntity> E resolve(EntityReference<E> var1) throws Exception;

        public <D extends BaseDictionary> D resolve(DictionaryReference<D> var1) throws Exception;
    }
}

