/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.v2;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.export.ExportedCustomEntityDescriptor;
import com.gridnine.xtrip.common.meta.export.ExportedElementDataType;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedPropertyType;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ExportUniversalProductCustomEntityDescriptor
implements ExportedCustomEntityDescriptor {
    private String entityId;
    private ExportedEntityType metadata;
    private String entityDisplayName;
    private L10nString entityDocumentation;
    private Map<String, L10nString> propertyDisplayNames = new HashMap<String, L10nString>();
    private Map<String, L10nString> propertyDocumentations = new HashMap<String, L10nString>();

    public ExportUniversalProductCustomEntityDescriptor(EntityContainer<UniversalProductDescription> descrCtr) {
        this.entityId = descrCtr.getUid();
        this.entityDocumentation = new L10nString();
        this.entityDocumentation.setStringValue("\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
        this.metadata = new ExportedEntityType();
        this.entityDisplayName = ((UniversalProductDescription)descrCtr.getEntity()).getName();
        this.metadata.setId(this.entityId);
        ExportedPropertyType systemNumberType = new ExportedPropertyType();
        systemNumberType.setType(ExportedElementDataType.STRING);
        systemNumberType.setId("systemNumber");
        this.metadata.getProperties().put(systemNumberType.getId(), systemNumberType);
        L10nString propertyDoc = new L10nString();
        propertyDoc.setStringValue("\u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440");
        this.propertyDisplayNames.put(systemNumberType.getId(), propertyDoc);
        this.propertyDocumentations.put(systemNumberType.getId(), propertyDoc);
        for (UniversalProductCustomParameterDescription item : ((UniversalProductDescription)descrCtr.getEntity()).getCustomParameters()) {
            switch (item.getType()) {
                case STRING: {
                    ExportedPropertyType customStringParameter = new ExportedPropertyType();
                    customStringParameter.setType(ExportedElementDataType.STRING);
                    customStringParameter.setId(item.getId());
                    this.metadata.getProperties().put(item.getId(), customStringParameter);
                    L10nString propertyDoc2 = new L10nString();
                    propertyDoc2.setStringValue(item.getDisplayName());
                    this.propertyDisplayNames.put(item.getId(), propertyDoc2);
                    this.propertyDocumentations.put(item.getId(), propertyDoc2);
                }
            }
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public ExportedEntityType getMetadata() {
        return this.metadata;
    }

    public String getEntityDisplayName(Locale locale) {
        return this.entityDisplayName;
    }

    public String getPropertyDisplayName(String property, Locale locale) {
        return this.propertyDisplayNames.get(property).toString(locale);
    }

    public String getPropertyDocumentation(String id, Locale currentLocale) {
        return this.propertyDocumentations.get(id).toString(currentLocale);
    }

    public String getEntityDocumentation(Locale currentLocale) {
        return this.entityDocumentation.toString(currentLocale);
    }
}

