/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.xml;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.ExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.StAXRecorder;
import com.gridnine.xtrip.common.xml.XMLObjectWatcher;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StAXExportHelper {
    protected static final Logger log = LoggerFactory.getLogger(StAXExportHelper.class);
    private static final String ROOT_ELEMENT_NAME = "export";
    private static final String ENTITIES_ELEMENT_NAME = "entities";
    private static final String ENTITY_ELEMENT_NAME = "entity";
    private static final String DICTIONARIES_ELEMENT_NAME = "dictionaries";
    private static final String DICTIONARY_ELEMENT_NAME = "dictionary";
    private static final String UID_ATTRIBUTE_NAME = "uid";
    private static final String TYPE_ATTRIBUTE_NAME = "class";
    private static final String CAPTION_ATTRIBUTE_NAME = "caption";
    private static final String CAPTION_ATTRIBUTE_CODE = "code";
    private static final String UID_ELEMENT_NAME = "uid";
    private static final String TYPE_ELEMENT_NAME = "type";
    private static final String CAPTION_ELEMENT_NAME = "caption";
    private static final String NESTED_UID_ELEMENT_NAME = "nestedEntityUid";
    private static final String NESTED_TYPE_ELEMENT_NAME = "nestedEntityType";
    private static final String LINK_UID_ATTRIBUTE_NAME = "uid";
    private static final String LINK_CTR_UID_ATTRIBUTE_NAME = "ctrUid";
    private static final String LINK_TYPE_ATTRIBUTE_NAME = "type";
    private static final String LINK_NESTED_UID_ATTRIBUTE_NAME = "ctrUid";
    private static final String LINK_NESTED_TYPE_ATTRIBUTE_NAME = "ctrType";
    private static final String TARGET_UID_ATTRIBUTE_NAME = "uid";
    private static final String TARGET_TYPE_ATTRIBUTE_NAME = "type";

    public static <T extends BaseEntity> void exportEntityReference(XMLStreamWriter writer, EntityReference<T> entityReference, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        StAXExportHelper.exportEntityReferences(writer, Collections.singletonList(entityReference), filters, messages);
    }

    public static <T extends BaseEntity> void exportEntityReferences(XMLStreamWriter writer, List<EntityReference<T>> entityReferences, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> entities = new ArrayList<T>();
        for (EntityReference<T> entityReference : entityReferences) {
            T entity = ExportHelper.standardResolver.resolve(entityReference);
            if (entity != null) {
                entities.add(entity);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442", String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", entityReference.getCaption(), entityReference.getType().getName()), new Object[0]));
        }
        StAXExportHelper.export(writer, entities, filters, messages);
    }

    public static <T extends BaseDictionary> void exportDictionaryReference(XMLStreamWriter writer, DictionaryReference<T> dictionaryReference, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        StAXExportHelper.exportDictionaryReferences(writer, Collections.singletonList(dictionaryReference), filters, messages);
    }

    public static <T extends BaseDictionary> void exportDictionaryReferences(XMLStreamWriter writer, List<DictionaryReference<T>> dictionaryReferences, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> dictionaries = new ArrayList<T>();
        for (DictionaryReference<T> dictionaryReference : dictionaryReferences) {
            T dictionary = ExportHelper.standardResolver.resolve(dictionaryReference);
            if (dictionary != null) {
                dictionaries.add(dictionary);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430", String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \"%s\" \u0441 \u043a\u043e\u0434\u043e\u043c %s \u0442\u0438\u043f\u0430 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", dictionaryReference.getCaption(), dictionaryReference.getCode(), dictionaryReference.getType().getName()), new Object[0]));
        }
        StAXExportHelper.export(writer, dictionaries, filters, messages);
    }

    public static <T extends BaseEntity> void export(XMLStreamWriter writer, T entity, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        StAXExportHelper.export(writer, Collections.singletonList(entity), filters, messages);
    }

    public static <T extends BaseEntity> void export(XMLStreamWriter writer, List<T> entities, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        StAXExportHelper.export(writer, entities, filters, ExportHelper.standardResolver, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseEntity> void export(XMLStreamWriter writer, List<T> entities, List<XMLFilterHelper.XMLFilter> filters, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        writer.writeStartElement(ROOT_ELEMENT_NAME);
        WriteContext context = new WriteContext(writer, filters, resolver, messages);
        try (Pipe pipe = new Pipe(context);){
            String uid;
            String type;
            List group;
            String entityElementName;
            TreeMap<String, List> groups = new TreeMap<String, List>();
            for (BaseEntity baseEntity : entities) {
                if (baseEntity == null) continue;
                entityElementName = TextUtil.decapitalize((String)MiscUtil.getSimpleClassName(baseEntity.getClass()));
                group = groups.computeIfAbsent(entityElementName, k -> new ArrayList());
                group.add(baseEntity);
            }
            for (Map.Entry entry : groups.entrySet()) {
                entityElementName = (String)entry.getKey();
                group = (List)entry.getValue();
                writer.writeStartElement(entityElementName + "s");
                for (BaseEntity entity : group) {
                    type = entity.getClass().getName();
                    uid = entity.getUid();
                    context.hasEntity(uid, type);
                    writer.writeStartElement(entityElementName);
                    context.push(State.ROOT);
                    context.setCurrentPath(type);
                    pipe.writeAttribute("type", type);
                    pipe.writeAttribute("uid", uid);
                    entity.toXML((XMLStreamWriter)pipe);
                    pipe.flush();
                    context.pop();
                    if (context.getProcessor() != null) {
                        throw new IllegalStateException("internal error: export(), out != null");
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeStartElement(ENTITIES_ELEMENT_NAME);
            StAXRecorder lateEntityWriter = context.getLateEntityWriter();
            if (lateEntityWriter != null) {
                lateEntityWriter.writeTo(writer);
                lateEntityWriter.clear();
            }
            ArrayList<LateEntityData> arrayList = new ArrayList<LateEntityData>();
            Deque<LateEntityData> lateEntities = context.getLateEntities();
            Deque<LateEntityData> lateDictionaries = context.getLateDictionaries();
            while (lateEntities.size() != 0 || lateDictionaries.size() != 0) {
                LateEntityData data;
                BaseEntity entity;
                while (null != (data = lateEntities.pollFirst())) {
                    entity = data.getEntity();
                    String uid2 = data.getUid();
                    String type2 = data.getType();
                    context.push(State.ROOT);
                    context.setCurrentPath(type2);
                    writer.writeStartElement(ENTITY_ELEMENT_NAME);
                    writer.writeAttribute("type", type2);
                    writer.writeAttribute("uid", uid2);
                    entity.toXML((XMLStreamWriter)pipe);
                    context.pop();
                    if (context.getProcessor() != null) {
                        throw new IllegalStateException("internal error: export(), out != null");
                    }
                    writer.writeEndElement();
                    lateEntityWriter = context.getLateEntityWriter();
                    if (lateEntityWriter == null) continue;
                    lateEntityWriter.writeTo(writer);
                    lateEntityWriter.clear();
                }
                while (null != (data = lateDictionaries.pollFirst())) {
                    arrayList.add(data);
                    entity = data.getEntity();
                    type = data.getType();
                    context.push(State.COLLECT_LATE_ENTITY);
                    context.setCurrentPath(type);
                    entity.toXML((XMLStreamWriter)pipe);
                    context.pop();
                    if (context.getProcessor() != null) {
                        throw new IllegalStateException("internal error: export(), out != null");
                    }
                    lateEntityWriter = context.getLateEntityWriter();
                    if (lateEntityWriter == null) continue;
                    lateEntityWriter.writeTo(writer);
                    lateEntityWriter.clear();
                }
            }
            writer.writeEndElement();
            writer.writeStartElement(DICTIONARIES_ELEMENT_NAME);
            for (LateEntityData data : arrayList) {
                BaseEntity dictionary = data.getEntity();
                uid = data.getUid();
                String type3 = data.getType();
                context.push(State.ROOT);
                context.setCurrentPath(type3);
                writer.writeStartElement(DICTIONARY_ELEMENT_NAME);
                writer.writeAttribute("type", type3);
                writer.writeAttribute("uid", uid);
                dictionary.toXML((XMLStreamWriter)pipe);
                context.pop();
                if (context.getProcessor() != null) {
                    throw new IllegalStateException("internal error: export(), out != null");
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private static class CEDictionaryDictionaryReference
    implements StateProcessor {
        protected final WriteContext context;
        private boolean trigger;
        private int ignoreLevel;
        private boolean elements;
        private final StringBuilder sb = new StringBuilder();
        private final Map<String, String> attributes = new HashMap<String, String>();

        public CEDictionaryDictionaryReference(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
            this.trigger = false;
            this.elements = false;
            this.attributes.clear();
            this.ignoreLevel = 0;
        }

        public void finish() throws Exception {
            this.context.pop();
            String type = this.attributes.get(StAXExportHelper.TYPE_ATTRIBUTE_NAME);
            String caption = this.attributes.get("caption");
            String code = this.attributes.get(StAXExportHelper.CAPTION_ATTRIBUTE_CODE);
            String uid = this.sb.toString();
            if (TextUtil.isBlank((String)uid) && code != null) {
                uid = code;
            }
            if (TextUtil.isBlank((String)uid) || TextUtil.isBlank((String)type)) {
                return;
            }
            DictionaryReference dictionaryReference = (DictionaryReference)XSHelper.getClassForName((String)type).newInstance();
            dictionaryReference.setCode(uid);
            dictionaryReference.setCaption(caption);
            Object dictionary = this.context.getResolver().resolve(dictionaryReference);
            if (null == dictionary) {
                this.context.getMessages().add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430", String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \"%s\" \u0441 \u043a\u043e\u0434\u043e\u043c %s \u0442\u0438\u043f\u0430 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", dictionaryReference.getCaption(), dictionaryReference.getCode(), dictionaryReference.getType().getName()), new Object[0]));
                return;
            }
            type = dictionary.getClass().getName();
            uid = dictionary.getUid();
            this.context.late((BaseDictionary)dictionary, uid, type);
        }

        protected void startElement(String element) {
            this.elements = true;
            ++this.ignoreLevel;
        }

        protected void endElement() throws XMLStreamException {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            try {
                this.finish();
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void writeStartElement(String localName) {
            if (this.trigger) {
                this.startElement(localName);
                return;
            }
            this.trigger = true;
            this.sb.setLength(0);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.endElement();
        }

        @Override
        public void writeAttribute(String localName, String value) {
            if (!this.elements) {
                this.attributes.put(localName, value);
            }
        }

        @Override
        public void writeCData(String data) {
            this.elements = true;
            if (0 == this.ignoreLevel) {
                this.sb.append(data);
            }
        }

        @Override
        public void writeEntityRef(String name) {
            this.elements = true;
            if (0 == this.ignoreLevel) {
                this.sb.append(StringEscapeUtils.unescapeXml((String)("&" + name + ";")));
            }
        }

        @Override
        public void writeCharacters(String text) {
            this.elements = true;
            if (0 == this.ignoreLevel) {
                this.sb.append(text);
            }
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            this.elements = true;
            if (0 == this.ignoreLevel) {
                this.sb.append(text, start, len);
            }
        }
    }

    private static class CEDictionaryEmbedded
    implements StateProcessor {
        protected final WriteContext context;
        private final Cache cache = new Cache();
        private boolean trigger;
        private boolean elements;
        private String activeElement;
        private String type;
        private String uid;
        private int ignoreLevel;
        private final StringBuilder sb = new StringBuilder();

        public CEDictionaryEmbedded(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
            this.trigger = false;
            this.elements = false;
            this.activeElement = null;
            this.uid = null;
            this.type = null;
            this.ignoreLevel = 0;
        }

        protected void checkDone() throws XMLStreamException {
            if (TextUtil.isBlank((String)this.uid) || TextUtil.isBlank((String)this.type)) {
                return;
            }
            this.finish(false);
        }

        protected void finish(boolean over) throws XMLStreamException {
            this.context.pop();
            if (over) {
                this.cache.reset();
                return;
            }
            boolean embedded = this.elements;
            if (embedded && !this.context.hasEntity(this.uid, this.type)) {
                this.context.pushLateEntity(this.uid, this.type);
                StAXRecorder lateOut = this.context.getLateEntityWriter();
                lateOut.writeStartElement(StAXExportHelper.ENTITY_ELEMENT_NAME);
                lateOut.writeAttribute("type", this.type);
                lateOut.writeAttribute("uid", this.uid);
                this.cache.writeTo(this.context);
            } else {
                this.context.push(State.IGNORE_WITHOUT_START);
            }
            this.cache.reset();
        }

        protected void startElement(String element) {
            this.elements = true;
            if (this.activeElement != null) {
                ++this.ignoreLevel;
                return;
            }
            this.activeElement = element;
            this.sb.setLength(0);
        }

        protected void endElement() throws XMLStreamException {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            if (this.activeElement != null) {
                if ("uid".equals(this.activeElement)) {
                    if (this.sb.length() != 0) {
                        this.uid = this.sb.toString();
                    }
                    this.sb.setLength(0);
                    this.checkDone();
                }
                this.activeElement = null;
                return;
            }
            this.finish(true);
        }

        @Override
        public void writeStartElement(String localName) {
            if (this.trigger) {
                this.cache.writeStartElement(localName);
                this.startElement(localName);
                return;
            }
            this.trigger = true;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.cache.writeEndElement();
            this.endElement();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.cache.writeAttribute(localName, value);
            if (!this.elements) {
                if (StAXExportHelper.TYPE_ATTRIBUTE_NAME.equals(localName)) {
                    this.type = value;
                } else if ("uid".equals(localName)) {
                    this.uid = value;
                }
                this.checkDone();
            }
        }

        @Override
        public void writeCData(String data) {
            this.cache.writeCData(data);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(data);
            }
        }

        @Override
        public void writeEntityRef(String name) {
            this.cache.writeEntityRef(name);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(StringEscapeUtils.unescapeXml((String)("&" + name + ";")));
            }
        }

        @Override
        public void writeCharacters(String text) {
            this.cache.writeCharacters(text);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text);
            }
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            this.cache.writeCharacters(text, start, len);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text, start, len);
            }
        }
    }

    private static class CEDictionaryEntityReference
    implements StateProcessor {
        protected final WriteContext context;
        private boolean trigger;
        private String activeElement;
        private int ignoreLevel;
        private final StringBuilder sb = new StringBuilder();
        private final Map<String, String> elements = new HashMap<String, String>();

        public CEDictionaryEntityReference(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
            this.trigger = false;
            this.activeElement = null;
            this.elements.clear();
            this.ignoreLevel = 0;
        }

        public void finish() throws Exception {
            Object entity;
            this.context.pop();
            String uid = this.elements.get("uid");
            String type = this.elements.get("type");
            if (TextUtil.isBlank((String)uid) || TextUtil.isBlank((String)type)) {
                return;
            }
            String caption = this.elements.get("caption");
            String nestedUid = this.elements.get(StAXExportHelper.NESTED_UID_ELEMENT_NAME);
            String nestedType = this.elements.get(StAXExportHelper.NESTED_TYPE_ELEMENT_NAME);
            if (TextUtil.isBlank((String)nestedType)) {
                EntityReference entityReference = new EntityReference(uid, XSHelper.getClassForName((String)type), caption);
                entity = this.context.resolve(entityReference);
            } else {
                NestedEntityReference entityReference = new NestedEntityReference(uid, XSHelper.getClassForName((String)type), nestedUid, XSHelper.getClassForName((String)nestedType), caption);
                entity = this.context.resolve(entityReference);
            }
            if (null == entity) {
                this.context.getMessages().add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442", String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", caption, type), new Object[0]));
                return;
            }
            uid = entity.getUid();
            type = entity.getClass().getName();
            this.context.late((BaseEntity)entity, uid, type);
        }

        protected void startElement(String element) {
            if (this.activeElement != null) {
                ++this.ignoreLevel;
                return;
            }
            this.activeElement = element;
            this.sb.setLength(0);
        }

        protected void endElement() throws XMLStreamException {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            if (this.activeElement != null) {
                if (this.sb.length() != 0) {
                    this.elements.put(this.activeElement, this.sb.toString());
                }
                this.activeElement = null;
                this.sb.setLength(0);
                return;
            }
            try {
                this.finish();
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void writeStartElement(String localName) {
            if (this.trigger) {
                this.startElement(localName);
                return;
            }
            this.trigger = true;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.endElement();
        }

        @Override
        public void writeAttribute(String localName, String value) {
        }

        @Override
        public void writeCData(String data) {
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(data);
            }
        }

        @Override
        public void writeEntityRef(String name) {
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(StringEscapeUtils.unescapeXml((String)("&" + name + ";")));
            }
        }

        @Override
        public void writeCharacters(String text) {
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text);
            }
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text, start, len);
            }
        }
    }

    private static class CEDictionarySimpleNode
    implements StateProcessor {
        protected final WriteContext context;

        public CEDictionarySimpleNode(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
        }

        protected void event() {
            this.context.push(State.COLLECT_LATE_ENTITY_FIND_TYPE);
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.event();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeEndElement() {
            this.context.pop();
            this.context.levelDown();
        }

        @Override
        public void writeAttribute(String localName, String value) {
        }

        @Override
        public void writeCData(String data) {
        }

        @Override
        public void writeEntityRef(String name) {
        }

        @Override
        public void writeCharacters(String text) {
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
        }
    }

    private static class CEDictionarySimpleNodeStart
    extends RootSimpleNodeStart {
        public CEDictionarySimpleNodeStart(WriteContext context) {
            super(context);
        }

        @Override
        protected void event() {
            this.context.push(State.COLLECT_LATE_ENTITY_SIMPLE_NODE);
        }

        @Override
        public void writeStartElement(String localName) {
            this.context.levelUp(localName);
            this.context.pop();
            this.event();
        }
    }

    private static class CEDictionaryFindType
    extends RootFindType {
        public CEDictionaryFindType(WriteContext context) {
            super(context);
        }

        @Override
        protected void pushState(State state) {
            switch (state) {
                case ROOT_ENTITY_REFERENCE: {
                    this.context.push(State.COLLECT_LATE_ENTITY_ENTITY_REFERENCE);
                    return;
                }
                case ROOT_EMBEDDED: {
                    this.context.push(State.COLLECT_LATE_ENTITY_EMBEDDED);
                    return;
                }
                case ROOT_DICTIONARY_REFERENCE: {
                    this.context.push(State.COLLECT_LATE_ENTITY_DICTIONARY_REFERENCE);
                    return;
                }
                case ROOT_SIMPLE_NODE_START: {
                    this.context.push(State.COLLECT_LATE_ENTITY_SIMPLE_NODE_START);
                    return;
                }
            }
            throw new IllegalArgumentException("internal error: unknown state " + state.name());
        }
    }

    private static class CEDictionary
    implements StateProcessor {
        protected final WriteContext context;

        public CEDictionary(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
        }

        protected void event() {
            this.context.push(State.COLLECT_LATE_ENTITY_FIND_TYPE);
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.event();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.context.pop();
        }

        @Override
        public void writeAttribute(String localName, String value) {
        }

        @Override
        public void writeCData(String data) {
        }

        @Override
        public void writeEntityRef(String name) {
        }

        @Override
        public void writeCharacters(String text) {
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
        }
    }

    private static class LateEntityDictionaryReference
    extends RootDictionaryReference {
        public LateEntityDictionaryReference(WriteContext context) {
            super(context);
        }

        @Override
        protected XMLStreamWriter getOut() {
            return this.context.getLateEntityWriter();
        }
    }

    private static class LateEntityEmbedded
    extends RootEmbedded {
        public LateEntityEmbedded(WriteContext context) {
            super(context);
        }

        @Override
        protected void initCache() {
        }

        @Override
        public void reset() {
            super.reset();
            this.cache = this.context.acquireCache();
        }

        @Override
        protected XMLStreamWriter getOut() {
            return this.context.getLateEntityWriter();
        }

        @Override
        protected void finish(boolean over) throws XMLStreamException {
            Cache localCache = this.cache;
            this.cache = null;
            this.finish(over, localCache);
            this.context.releaseCache(localCache);
        }
    }

    private static class LateEntityEntityReference
    extends RootEntityReference {
        public LateEntityEntityReference(WriteContext context) {
            super(context);
        }

        @Override
        protected XMLStreamWriter getOut() {
            return this.context.getLateEntityWriter();
        }
    }

    private static class LateEntitySimpleNode
    extends RootSimpleNode {
        public LateEntitySimpleNode(WriteContext context) {
            super(context);
        }

        @Override
        protected void event() {
            this.context.push(State.LATE_ENTITY_FIND_TYPE);
        }

        @Override
        protected XMLStreamWriter getOut() {
            return this.context.getLateEntityWriter();
        }
    }

    private static class LateEntitySimpleNodeStart
    extends RootSimpleNodeStart {
        public LateEntitySimpleNodeStart(WriteContext context) {
            super(context);
        }

        @Override
        protected void event() {
            this.context.push(State.LATE_ENTITY_SIMPLE_NODE);
        }

        @Override
        protected XMLStreamWriter getOut() {
            return this.context.getLateEntityWriter();
        }
    }

    private static class LateEntityFindType
    extends RootFindType {
        public LateEntityFindType(WriteContext context) {
            super(context);
        }

        @Override
        protected void pushState(State state) {
            switch (state) {
                case ROOT_ENTITY_REFERENCE: {
                    this.context.push(State.LATE_ENTITY_ENTITY_REFERENCE);
                    return;
                }
                case ROOT_EMBEDDED: {
                    this.context.push(State.LATE_ENTITY_EMBEDDED);
                    return;
                }
                case ROOT_DICTIONARY_REFERENCE: {
                    this.context.push(State.LATE_ENTITY_DICTIONARY_REFERENCE);
                    return;
                }
                case ROOT_SIMPLE_NODE_START: {
                    this.context.push(State.LATE_ENTITY_SIMPLE_NODE_START);
                    return;
                }
            }
            throw new IllegalArgumentException("internal error: unknown state " + state.name());
        }
    }

    private static class LateEntity
    extends Root {
        public LateEntity(WriteContext context) {
            super(context);
        }

        @Override
        protected void event() {
            this.context.push(State.LATE_ENTITY_FIND_TYPE);
        }

        @Override
        protected XMLStreamWriter getOut() {
            return this.context.getLateEntityWriter();
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.getOut().writeEndElement();
            this.context.pop();
        }

        @Override
        public void writeAttribute(String localName, String value) {
        }
    }

    private static class IgnoreWithoutStart
    implements StateProcessor {
        private final WriteContext context;
        private int level = 1;

        public IgnoreWithoutStart(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
            this.level = 1;
        }

        @Override
        public void writeStartElement(String localName) {
            ++this.level;
        }

        @Override
        public void writeEndElement() {
            if (--this.level != 0) {
                return;
            }
            this.context.pop();
        }

        @Override
        public void writeAttribute(String localName, String value) {
        }

        @Override
        public void writeCData(String data) {
        }

        @Override
        public void writeEntityRef(String name) {
        }

        @Override
        public void writeCharacters(String text) {
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
        }
    }

    private static class RootEmbedded
    implements StateProcessor {
        protected final WriteContext context;
        protected Cache cache;
        private String mainTagName;
        private boolean trigger;
        private boolean elements;
        private String activeElement;
        private String type;
        private String uid;
        private int ignoreLevel;
        private final StringBuilder sb = new StringBuilder();

        public RootEmbedded(WriteContext context) {
            this.context = context;
            this.initCache();
        }

        protected void initCache() {
            this.cache = new Cache();
        }

        protected XMLStreamWriter getOut() {
            return this.context.getOwner();
        }

        @Override
        public void reset() {
            this.mainTagName = null;
            this.trigger = false;
            this.elements = false;
            this.activeElement = null;
            this.uid = null;
            this.type = null;
            this.ignoreLevel = 0;
        }

        protected void checkDone() throws XMLStreamException {
            if (TextUtil.isBlank((String)this.uid) || TextUtil.isBlank((String)this.type)) {
                return;
            }
            this.finish(false);
        }

        protected void finish(boolean over, Cache localCache) throws XMLStreamException {
            this.context.pop();
            if (over) {
                XMLStreamWriter out = this.getOut();
                out.writeStartElement(this.mainTagName);
                localCache.writeTo(out);
                localCache.reset();
                return;
            }
            XMLStreamWriter out = this.getOut();
            out.writeEmptyElement(this.mainTagName);
            out.writeAttribute("type", this.type);
            out.writeAttribute("uid", this.uid);
            boolean embedded = this.elements;
            if (embedded && !this.context.hasEntity(this.uid, this.type)) {
                this.context.pushLateEntity(this.uid, this.type);
                StAXRecorder lateOut = this.context.getLateEntityWriter();
                lateOut.writeStartElement(StAXExportHelper.ENTITY_ELEMENT_NAME);
                lateOut.writeAttribute("type", this.type);
                lateOut.writeAttribute("uid", this.uid);
                localCache.writeTo(this.context);
            } else {
                this.context.push(State.IGNORE_WITHOUT_START);
            }
            localCache.reset();
        }

        protected void finish(boolean over) throws XMLStreamException {
            this.finish(over, this.cache);
        }

        protected void startElement(String element) {
            this.elements = true;
            if (this.activeElement != null) {
                ++this.ignoreLevel;
                return;
            }
            this.activeElement = element;
            this.sb.setLength(0);
        }

        protected void endElement() throws XMLStreamException {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            if (this.activeElement != null) {
                if ("uid".equals(this.activeElement)) {
                    if (this.sb.length() != 0) {
                        this.uid = this.sb.toString();
                    }
                    this.sb.setLength(0);
                    this.checkDone();
                }
                this.activeElement = null;
                return;
            }
            this.finish(true);
        }

        @Override
        public void writeStartElement(String localName) {
            if (this.trigger) {
                this.cache.writeStartElement(localName);
                this.startElement(localName);
                return;
            }
            this.trigger = true;
            this.mainTagName = localName;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.cache.writeEndElement();
            this.endElement();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.cache.writeAttribute(localName, value);
            if (!this.elements) {
                if (StAXExportHelper.TYPE_ATTRIBUTE_NAME.equals(localName)) {
                    this.type = value;
                } else if ("uid".equals(localName)) {
                    this.uid = value;
                }
                this.checkDone();
            }
        }

        @Override
        public void writeCData(String data) {
            this.cache.writeCData(data);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(data);
            }
        }

        @Override
        public void writeEntityRef(String name) {
            this.cache.writeEntityRef(name);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(StringEscapeUtils.unescapeXml((String)("&" + name + ";")));
            }
        }

        @Override
        public void writeCharacters(String text) {
            this.cache.writeCharacters(text);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text);
            }
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            this.cache.writeCharacters(text, start, len);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text, start, len);
            }
        }
    }

    private static class RootDictionaryReference
    implements StateProcessor {
        protected final WriteContext context;
        private final Cache cache = new Cache();
        private String mainTagName;
        private boolean trigger;
        private int ignoreLevel;
        private boolean elements;
        private final StringBuilder sb = new StringBuilder();
        private final Map<String, String> attributes = new HashMap<String, String>();

        public RootDictionaryReference(WriteContext context) {
            this.context = context;
        }

        protected XMLStreamWriter getOut() {
            return this.context.getOwner();
        }

        @Override
        public void reset() {
            this.mainTagName = null;
            this.trigger = false;
            this.elements = false;
            this.attributes.clear();
            this.ignoreLevel = 0;
        }

        public void finish() throws Exception {
            this.context.pop();
            String type = this.attributes.get(StAXExportHelper.TYPE_ATTRIBUTE_NAME);
            String caption = this.attributes.get("caption");
            String code = this.attributes.get(StAXExportHelper.CAPTION_ATTRIBUTE_CODE);
            String uid = this.sb.toString();
            this.sb.setLength(0);
            if (TextUtil.isBlank((String)uid) && code != null) {
                uid = code;
            }
            if (TextUtil.isBlank((String)uid) || TextUtil.isBlank((String)type)) {
                XMLStreamWriter out = this.getOut();
                out.writeStartElement(this.mainTagName);
                this.cache.writeTo(out);
                this.cache.reset();
                return;
            }
            this.cache.reset();
            DictionaryReference dictionaryReference = (DictionaryReference)XSHelper.getClassForName((String)type).newInstance();
            dictionaryReference.setCode(uid);
            dictionaryReference.setCaption(caption);
            Object dictionary = this.context.getResolver().resolve(dictionaryReference);
            if (null == dictionary) {
                this.context.getMessages().add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430", String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \"%s\" \u0441 \u043a\u043e\u0434\u043e\u043c %s \u0442\u0438\u043f\u0430 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", dictionaryReference.getCaption(), dictionaryReference.getCode(), dictionaryReference.getType().getName()), new Object[0]));
                return;
            }
            type = dictionary.getClass().getName();
            uid = dictionary.getUid();
            XMLStreamWriter out = this.getOut();
            out.writeEmptyElement(this.mainTagName);
            out.writeAttribute("type", type);
            out.writeAttribute("uid", uid);
            this.context.late((BaseDictionary)dictionary, uid, type);
        }

        protected void startElement(String element) {
            this.elements = true;
            ++this.ignoreLevel;
        }

        protected void endElement() throws XMLStreamException {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            try {
                this.finish();
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void writeStartElement(String localName) {
            if (this.trigger) {
                this.startElement(localName);
                this.cache.writeStartElement(localName);
                return;
            }
            this.trigger = true;
            this.mainTagName = localName;
            this.sb.setLength(0);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.cache.writeEndElement();
            this.endElement();
        }

        @Override
        public void writeAttribute(String localName, String value) {
            this.cache.writeAttribute(localName, value);
            if (!this.elements) {
                this.attributes.put(localName, value);
            }
        }

        @Override
        public void writeCData(String data) {
            this.elements = true;
            this.cache.writeCData(data);
            if (0 == this.ignoreLevel) {
                this.sb.append(data);
            }
        }

        @Override
        public void writeEntityRef(String name) {
            this.elements = true;
            this.cache.writeEntityRef(name);
            if (0 == this.ignoreLevel) {
                this.sb.append(StringEscapeUtils.unescapeXml((String)("&" + name + ";")));
            }
        }

        @Override
        public void writeCharacters(String text) {
            this.elements = true;
            this.cache.writeCharacters(text);
            if (0 == this.ignoreLevel) {
                this.sb.append(text);
            }
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            this.elements = true;
            this.cache.writeCharacters(text, start, len);
            if (0 == this.ignoreLevel) {
                this.sb.append(text, start, len);
            }
        }
    }

    private static class RootEntityReference
    implements StateProcessor {
        protected final WriteContext context;
        private final Cache cache = new Cache();
        private String mainTagName;
        private boolean trigger;
        private String activeElement;
        private int ignoreLevel;
        private final StringBuilder sb = new StringBuilder();
        private final Map<String, String> elements = new HashMap<String, String>();

        public RootEntityReference(WriteContext context) {
            this.context = context;
        }

        protected XMLStreamWriter getOut() {
            return this.context.getOwner();
        }

        @Override
        public void reset() {
            this.mainTagName = null;
            this.trigger = false;
            this.activeElement = null;
            this.elements.clear();
            this.ignoreLevel = 0;
        }

        public void finish() throws Exception {
            Object entity;
            EntityReference entityReference;
            this.context.pop();
            String uid = this.elements.get("uid");
            String type = this.elements.get("type");
            if (TextUtil.isBlank((String)uid) || TextUtil.isBlank((String)type)) {
                XMLStreamWriter out = this.getOut();
                out.writeStartElement(this.mainTagName);
                this.cache.writeTo(out);
                this.cache.reset();
                return;
            }
            this.cache.reset();
            String caption = this.elements.get("caption");
            String nestedUid = this.elements.get(StAXExportHelper.NESTED_UID_ELEMENT_NAME);
            String nestedType = this.elements.get(StAXExportHelper.NESTED_TYPE_ELEMENT_NAME);
            if (TextUtil.isBlank((String)nestedType)) {
                entityReference = new EntityReference(uid, XSHelper.getClassForName((String)type), caption);
                entity = this.context.resolve(entityReference);
            } else {
                entityReference = new NestedEntityReference(uid, XSHelper.getClassForName((String)type), nestedUid, XSHelper.getClassForName((String)nestedType), caption);
                entity = this.context.resolve(entityReference);
            }
            if (null == entity) {
                this.context.getMessages().add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442", String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", caption, type), new Object[0]));
                return;
            }
            String ctrUid = uid;
            uid = entity.getUid();
            XMLStreamWriter out = this.getOut();
            out.writeEmptyElement(this.mainTagName);
            if (TextUtil.isBlank((String)nestedType)) {
                out.writeAttribute("ctrUid", ctrUid);
                out.writeAttribute("type", type);
                out.writeAttribute("uid", uid);
            } else {
                out.writeAttribute(StAXExportHelper.LINK_NESTED_TYPE_ATTRIBUTE_NAME, type);
                out.writeAttribute("ctrUid", ctrUid);
                out.writeAttribute("type", nestedType);
                out.writeAttribute("uid", nestedUid);
            }
            type = entity.getClass().getName();
            this.context.late((BaseEntity)entity, uid, type);
        }

        protected void startElement(String element) {
            if (this.activeElement != null) {
                ++this.ignoreLevel;
                return;
            }
            this.activeElement = element;
            this.sb.setLength(0);
        }

        protected void endElement() throws XMLStreamException {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            if (this.activeElement != null) {
                if (this.sb.length() != 0) {
                    this.elements.put(this.activeElement, this.sb.toString());
                }
                this.activeElement = null;
                this.sb.setLength(0);
                return;
            }
            try {
                this.finish();
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void writeStartElement(String localName) {
            if (this.trigger) {
                this.cache.writeStartElement(localName);
                this.startElement(localName);
                return;
            }
            this.trigger = true;
            this.mainTagName = localName;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.cache.writeEndElement();
            this.endElement();
        }

        @Override
        public void writeAttribute(String localName, String value) {
            this.cache.writeAttribute(localName, value);
        }

        @Override
        public void writeCData(String data) {
            this.cache.writeCData(data);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(data);
            }
        }

        @Override
        public void writeEntityRef(String name) {
            this.cache.writeEntityRef(name);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(StringEscapeUtils.unescapeXml((String)("&" + name + ";")));
            }
        }

        @Override
        public void writeCharacters(String text) {
            this.cache.writeCharacters(text);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text);
            }
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            this.cache.writeCharacters(text, start, len);
            if (this.activeElement != null && 0 == this.ignoreLevel) {
                this.sb.append(text, start, len);
            }
        }
    }

    private static class RootSimpleNode
    implements StateProcessor {
        protected final WriteContext context;

        public RootSimpleNode(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
        }

        protected void event() {
            this.context.push(State.ROOT_FIND_TYPE);
        }

        protected XMLStreamWriter getOut() {
            return this.context.getOwner();
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.event();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.getOut().writeEndElement();
            this.context.pop();
            this.context.levelDown();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.getOut().writeAttribute(localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.getOut().writeCData(data);
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.getOut().writeEntityRef(name);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.getOut().writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.getOut().writeCharacters(text, start, len);
        }
    }

    private static class RootSimpleNodeStart
    implements StateProcessor {
        protected final WriteContext context;

        public RootSimpleNodeStart(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
        }

        protected void event() {
            this.context.push(State.ROOT_SIMPLE_NODE);
        }

        protected XMLStreamWriter getOut() {
            return this.context.getOwner();
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.getOut().writeStartElement(localName);
            this.context.levelUp(localName);
            this.context.pop();
            this.event();
        }

        @Override
        public void writeEndElement() {
            throw new IllegalStateException("internal error: RootSimpleNodeStart.writeEndElement()");
        }

        @Override
        public void writeAttribute(String localName, String value) {
            throw new IllegalStateException("internal error: RootSimpleNodeStart.writeAttribute()");
        }

        @Override
        public void writeCData(String data) {
            throw new IllegalStateException("internal error: RootSimpleNodeStart.writeCData()");
        }

        @Override
        public void writeEntityRef(String name) {
            throw new IllegalStateException("internal error: RootSimpleNodeStart.writeEntityRef()");
        }

        @Override
        public void writeCharacters(String text) {
            throw new IllegalStateException("internal error: RootSimpleNodeStart.writeCharacters()");
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            throw new IllegalStateException("internal error: RootSimpleNodeStart.writeCharacters()");
        }
    }

    private static class RootFindType
    implements StateProcessor {
        protected final WriteContext context;
        private final Cache cache = new Cache();
        private boolean trigger;

        public RootFindType(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
            this.trigger = false;
        }

        protected void pushState(State state) {
            this.context.push(state);
        }

        protected void event(String type) throws XMLStreamException {
            this.context.pop();
            if (!TextUtil.isBlank((String)type)) {
                Class clazz;
                try {
                    clazz = XSHelper.getClass((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new XMLStreamException(e);
                }
                if (EntityReference.class.isAssignableFrom(clazz)) {
                    this.pushState(State.ROOT_ENTITY_REFERENCE);
                } else if (BaseEntity.class.isAssignableFrom(clazz)) {
                    this.pushState(State.ROOT_EMBEDDED);
                } else if (DictionaryReference.class.isAssignableFrom(clazz)) {
                    this.pushState(State.ROOT_DICTIONARY_REFERENCE);
                } else {
                    this.pushState(State.ROOT_SIMPLE_NODE_START);
                }
            } else {
                this.pushState(State.ROOT_SIMPLE_NODE_START);
            }
            this.cache.writeTo(this.context);
            this.cache.reset();
        }

        protected StateProcessor checkType(String localName, String value) throws XMLStreamException {
            if (StAXExportHelper.TYPE_ATTRIBUTE_NAME.equals(localName)) {
                this.event(value);
                return this.context.getProcessor();
            }
            return this.cache;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            if (this.trigger) {
                this.event(null);
                this.context.getProcessor().writeStartElement(localName);
                return;
            }
            if (!this.context.accept(localName)) {
                this.context.pop();
                this.context.push(State.IGNORE_WITHOUT_START);
                return;
            }
            this.trigger = true;
            this.cache.writeStartElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.event(null);
            this.context.getProcessor().writeEndElement();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.checkType(localName, value).writeAttribute(localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.event(null);
            this.context.getProcessor().writeCData(data);
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.event(null);
            this.context.getProcessor().writeEntityRef(name);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.event(null);
            this.context.getProcessor().writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.event(null);
            this.context.getProcessor().writeCharacters(text, start, len);
        }
    }

    private static class Root
    implements StateProcessor {
        protected final WriteContext context;

        public Root(WriteContext context) {
            this.context = context;
        }

        @Override
        public void reset() {
        }

        protected void event() {
            this.context.push(State.ROOT_FIND_TYPE);
        }

        protected XMLStreamWriter getOut() {
            return this.context.getOwner();
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.event();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            throw new IllegalStateException("internal error: Root.writeEndElement()");
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.getOut().writeAttribute(localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.getOut().writeCData(data);
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.getOut().writeEntityRef(name);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.getOut().writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.getOut().writeCharacters(text, start, len);
        }
    }

    private static interface StateProcessor {
        public void reset();

        public void writeStartElement(String var1) throws XMLStreamException;

        public void writeEndElement() throws XMLStreamException;

        public void writeAttribute(String var1, String var2) throws XMLStreamException;

        public void writeCData(String var1) throws XMLStreamException;

        public void writeEntityRef(String var1) throws XMLStreamException;

        public void writeCharacters(String var1) throws XMLStreamException;

        public void writeCharacters(char[] var1, int var2, int var3) throws XMLStreamException;
    }

    private static class Pipe
    implements XMLStreamWriter,
    XMLObjectWatcher {
        private final WriteContext context;
        private final Cache emptyElementCache = new Cache();

        public Pipe(WriteContext context) {
            this.context = context;
        }

        public void flushEmptyElementCache() throws XMLStreamException {
            if (!this.emptyElementCache.isEmpty()) {
                this.emptyElementCache.writeTo(this.context);
                this.emptyElementCache.reset();
                this.writeEndElement();
            }
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeStartElement(localName);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.emptyElementCache.writeStartElement(localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.emptyElementCache.writeStartElement(localName);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.emptyElementCache.writeStartElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeEndElement();
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.context.getProcessor().writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.context.getProcessor().writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.context.getProcessor().writeAttribute(localName, value);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) {
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) {
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeCData(data);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeEntityRef(name);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.flushEmptyElementCache();
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.flushEmptyElementCache();
            this.context.getProcessor().writeCharacters(text, start, len);
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }

        @Override
        public void setPrefix(String prefix, String uri) {
        }

        @Override
        public void setDefaultNamespace(String uri) {
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return null;
        }

        @Override
        public void setNamespaceContext(NamespaceContext namespaceContext) {
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.context.getOwner().getProperty(name);
        }

        public Object beginObject(String name, Object object) {
            return null;
        }

        public void endObject(Object id) {
        }

        protected static class ID {
            public int level;
            public String name;
            public Object object;

            protected ID() {
            }
        }
    }

    protected static class Cache
    implements StateProcessor {
        private final List<Event> events = new ArrayList<Event>();

        protected Cache() {
        }

        @Override
        public void reset() {
            this.events.clear();
        }

        public boolean isEmpty() {
            return this.events.isEmpty();
        }

        public void write(Cache recorder) {
            this.events.addAll(recorder.events);
        }

        public void writeTo(WriteContext context) throws XMLStreamException {
            block8: for (Event event : this.events) {
                switch (event.type) {
                    case START_ELEMENT: {
                        context.getProcessor().writeStartElement(event.p1);
                        continue block8;
                    }
                    case END_ELEMENT: {
                        context.getProcessor().writeEndElement();
                        continue block8;
                    }
                    case ATTRIBUTE: {
                        context.getProcessor().writeAttribute(event.p1, event.p2);
                        continue block8;
                    }
                    case CDATA: {
                        context.getProcessor().writeCData(event.p1);
                        continue block8;
                    }
                    case ENTITY_REF: {
                        context.getProcessor().writeEntityRef(event.p1);
                        continue block8;
                    }
                    case CHARACTERS: {
                        context.getProcessor().writeCharacters(event.p1);
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException(event.type.name());
            }
        }

        public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
            block8: for (Event event : this.events) {
                switch (event.type) {
                    case START_ELEMENT: {
                        writer.writeStartElement(event.p1);
                        continue block8;
                    }
                    case END_ELEMENT: {
                        writer.writeEndElement();
                        continue block8;
                    }
                    case ATTRIBUTE: {
                        writer.writeAttribute(event.p1, event.p2);
                        continue block8;
                    }
                    case CDATA: {
                        writer.writeCData(event.p1);
                        continue block8;
                    }
                    case ENTITY_REF: {
                        writer.writeEntityRef(event.p1);
                        continue block8;
                    }
                    case CHARACTERS: {
                        writer.writeCharacters(event.p1);
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException(event.type.name());
            }
        }

        @Override
        public void writeStartElement(String localName) {
            Event event = new Event();
            event.type = EventType.START_ELEMENT;
            event.p1 = localName;
            this.events.add(event);
        }

        @Override
        public void writeEndElement() {
            Event event = new Event();
            event.type = EventType.END_ELEMENT;
            this.events.add(event);
        }

        public void close() {
            this.reset();
        }

        @Override
        public void writeAttribute(String localName, String value) {
            Event event = new Event();
            event.type = EventType.ATTRIBUTE;
            event.p1 = localName;
            event.p2 = value;
            this.events.add(event);
        }

        @Override
        public void writeCData(String data) {
            Event event = new Event();
            event.type = EventType.CDATA;
            event.p1 = data;
            this.events.add(event);
        }

        @Override
        public void writeEntityRef(String name) {
            Event event = new Event();
            event.type = EventType.ENTITY_REF;
            event.p1 = name;
            this.events.add(event);
        }

        @Override
        public void writeCharacters(String text) {
            Event event = new Event();
            event.type = EventType.CHARACTERS;
            event.p1 = text;
            this.events.add(event);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) {
            Event event = new Event();
            event.type = EventType.CHARACTERS;
            event.p1 = new String(text, start, len);
            this.events.add(event);
        }

        protected static class Event {
            EventType type;
            String p1;
            String p2;

            protected Event() {
            }
        }

        protected static enum EventType {
            START_ELEMENT,
            END_ELEMENT,
            ATTRIBUTE,
            CDATA,
            ENTITY_REF,
            CHARACTERS;

        }
    }

    private static class EntityKey {
        private final String uid;
        private final String type;

        public EntityKey(String uid, String type) {
            this.uid = uid;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityKey other = (EntityKey)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
        }
    }

    private static class LateEntityData {
        private final BaseEntity entity;
        private final String uid;
        private final String type;

        public LateEntityData(BaseEntity entity, String uid, String type) {
            this.entity = entity;
            this.uid = uid;
            this.type = type;
        }

        public BaseEntity getEntity() {
            return this.entity;
        }

        public String getUid() {
            return this.uid;
        }

        public String getType() {
            return this.type;
        }
    }

    private static class LateEntityState {
        private final StAXRecorder writer;
        private final String path;

        public LateEntityState(StAXRecorder writer, String path) {
            this.writer = writer;
            this.path = path;
        }

        public StAXRecorder getWriter() {
            return this.writer;
        }

        public String getPath() {
            return this.path;
        }
    }

    private static class WriteContext {
        private final XMLStreamWriter owner;
        private final List<XMLFilterHelper.XMLFilter> filters;
        private final ExportHelper.ObjectResolver resolver;
        private final List<Message> messages;
        private StateProcessor current;
        private final Deque<StateProcessor> queue = new ArrayDeque<StateProcessor>();
        private final StateProcessor[] stateLess = new StateProcessor[State.values().length];
        private static final Object NULL_CTR = new Object();
        private final Map<String, Object> containersCache = new HashMap<String, Object>();
        private final StringBuilder currentPath = new StringBuilder();
        private final Deque<LateEntityData> lateEntities = new ArrayDeque<LateEntityData>();
        private final Deque<LateEntityData> lateDictionaries = new ArrayDeque<LateEntityData>();
        private final Deque<LateEntityState> lateEntityWritersQueue = new ArrayDeque<LateEntityState>();
        private StAXRecorder lateEntityWriter;
        private final Deque<StAXRecorder> lateEntityWriterCache = new ArrayDeque<StAXRecorder>();
        private final Set<EntityKey> entities = new HashSet<EntityKey>();
        private final Deque<Cache> caches = new ArrayDeque<Cache>();

        public WriteContext(XMLStreamWriter owner, List<XMLFilterHelper.XMLFilter> filters, ExportHelper.ObjectResolver resolver, List<Message> messages) {
            this.owner = owner;
            this.filters = filters;
            this.resolver = resolver;
            this.messages = messages;
        }

        public StateProcessor getProcessor() {
            return this.current;
        }

        public void push(State state) {
            if (this.current != null) {
                this.queue.addLast(this.current);
            }
            this.current = this.stateToOut(state);
        }

        public void pop() {
            this.onCurrentRemoved();
            this.current = this.queue.pollLast();
        }

        private StateProcessor stateLess(State state) {
            int i = state.ordinal();
            StateProcessor processor = this.stateLess[i];
            if (processor != null) {
                return processor;
            }
            this.stateLess[i] = processor = this.create(state);
            return processor;
        }

        private StateProcessor stateToOut(State state) {
            StateProcessor result;
            switch (state) {
                case ROOT: 
                case ROOT_FIND_TYPE: 
                case ROOT_SIMPLE_NODE_START: 
                case ROOT_SIMPLE_NODE: 
                case ROOT_ENTITY_REFERENCE: 
                case ROOT_EMBEDDED: 
                case ROOT_DICTIONARY_REFERENCE: 
                case LATE_ENTITY: 
                case LATE_ENTITY_FIND_TYPE: 
                case LATE_ENTITY_SIMPLE_NODE_START: 
                case LATE_ENTITY_SIMPLE_NODE: 
                case LATE_ENTITY_ENTITY_REFERENCE: 
                case LATE_ENTITY_EMBEDDED: 
                case LATE_ENTITY_DICTIONARY_REFERENCE: 
                case COLLECT_LATE_ENTITY: 
                case COLLECT_LATE_ENTITY_FIND_TYPE: 
                case COLLECT_LATE_ENTITY_SIMPLE_NODE_START: 
                case COLLECT_LATE_ENTITY_SIMPLE_NODE: 
                case COLLECT_LATE_ENTITY_ENTITY_REFERENCE: 
                case COLLECT_LATE_ENTITY_EMBEDDED: 
                case COLLECT_LATE_ENTITY_DICTIONARY_REFERENCE: 
                case IGNORE_WITHOUT_START: {
                    result = this.stateLess(state);
                    break;
                }
                default: {
                    result = this.create(state);
                }
            }
            result.reset();
            return result;
        }

        private StateProcessor create(State state) {
            switch (state) {
                case ROOT: {
                    return new Root(this);
                }
                case ROOT_FIND_TYPE: {
                    return new RootFindType(this);
                }
                case ROOT_SIMPLE_NODE_START: {
                    return new RootSimpleNodeStart(this);
                }
                case ROOT_SIMPLE_NODE: {
                    return new RootSimpleNode(this);
                }
                case ROOT_ENTITY_REFERENCE: {
                    return new RootEntityReference(this);
                }
                case ROOT_EMBEDDED: {
                    return new RootEmbedded(this);
                }
                case ROOT_DICTIONARY_REFERENCE: {
                    return new RootDictionaryReference(this);
                }
                case LATE_ENTITY: {
                    return new LateEntity(this);
                }
                case LATE_ENTITY_FIND_TYPE: {
                    return new LateEntityFindType(this);
                }
                case LATE_ENTITY_SIMPLE_NODE_START: {
                    return new LateEntitySimpleNodeStart(this);
                }
                case LATE_ENTITY_SIMPLE_NODE: {
                    return new LateEntitySimpleNode(this);
                }
                case LATE_ENTITY_ENTITY_REFERENCE: {
                    return new LateEntityEntityReference(this);
                }
                case LATE_ENTITY_EMBEDDED: {
                    return new LateEntityEmbedded(this);
                }
                case LATE_ENTITY_DICTIONARY_REFERENCE: {
                    return new LateEntityDictionaryReference(this);
                }
                case COLLECT_LATE_ENTITY: {
                    return new CEDictionary(this);
                }
                case COLLECT_LATE_ENTITY_FIND_TYPE: {
                    return new CEDictionaryFindType(this);
                }
                case COLLECT_LATE_ENTITY_SIMPLE_NODE_START: {
                    return new CEDictionarySimpleNodeStart(this);
                }
                case COLLECT_LATE_ENTITY_SIMPLE_NODE: {
                    return new CEDictionarySimpleNode(this);
                }
                case COLLECT_LATE_ENTITY_ENTITY_REFERENCE: {
                    return new CEDictionaryEntityReference(this);
                }
                case COLLECT_LATE_ENTITY_EMBEDDED: {
                    return new CEDictionaryEmbedded(this);
                }
                case COLLECT_LATE_ENTITY_DICTIONARY_REFERENCE: {
                    return new CEDictionaryDictionaryReference(this);
                }
                case IGNORE_WITHOUT_START: {
                    return new IgnoreWithoutStart(this);
                }
            }
            throw new IllegalArgumentException("unknown state " + (Object)((Object)state));
        }

        public XMLStreamWriter getOwner() {
            return this.owner;
        }

        public ExportHelper.ObjectResolver getResolver() {
            return this.resolver;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public <R extends BaseEntity, N extends BaseEntity> N resolve(NestedEntityReference<R, N> ref) throws Exception {
            if (null == ref) {
                return null;
            }
            Object ctr = this.containersCache.get(ref.getUid());
            if (NULL_CTR.equals(ctr)) {
                return null;
            }
            if (ctr == null) {
                ctr = this.resolver.resolve(ref);
                if (ctr == null) {
                    this.containersCache.put(ref.getUid(), NULL_CTR);
                    return null;
                }
                this.containersCache.put(ref.getUid(), ctr);
            }
            return (N)EntityStorageHelper.findNestedEntity((BaseEntity)((BaseEntity)ctr), (String)ref.getNestedEntityUid(), (Class)ref.getNestedEntityType(), new HashSet());
        }

        public <R extends BaseEntity> R resolve(EntityReference<R> ref) throws Exception {
            if (null == ref) {
                return null;
            }
            Object ctr = this.containersCache.get(ref.getUid());
            if (NULL_CTR.equals(ctr)) {
                return null;
            }
            if (ctr != null) {
                return (R)((BaseEntity)ctr);
            }
            ctr = this.resolver.resolve(ref);
            if (ctr == null) {
                this.containersCache.put(ref.getUid(), NULL_CTR);
                return null;
            }
            this.containersCache.put(ref.getUid(), ctr);
            return (R)((BaseEntity)ctr);
        }

        public String getCurrentPath() {
            return this.currentPath.toString();
        }

        public void setCurrentPath(String type) {
            if (this.filters == null) {
                return;
            }
            this.currentPath.setLength(0);
            this.currentPath.append(type);
        }

        public void levelUp(String localName) {
            if (this.filters == null) {
                return;
            }
            this.currentPath.append('/');
            this.currentPath.append(localName);
        }

        public void levelDown() {
            if (this.filters == null) {
                return;
            }
            int p = this.currentPath.lastIndexOf("/");
            this.currentPath.setLength(p != -1 ? p : 0);
        }

        public boolean accept(String localName) {
            if (this.filters == null) {
                return true;
            }
            int len = this.currentPath.length();
            this.levelUp(localName);
            String newPath = this.getCurrentPath();
            this.currentPath.setLength(len);
            for (XMLFilterHelper.XMLFilter filter : this.filters) {
                if (filter.accept(newPath)) continue;
                return false;
            }
            return true;
        }

        public void late(BaseEntity entity, String uid, String type) {
            if (this.hasEntity(uid, type)) {
                return;
            }
            this.lateEntities.add(new LateEntityData(entity, uid, type));
        }

        public void late(BaseDictionary entity, String uid, String type) {
            if (this.hasEntity(uid, type)) {
                return;
            }
            this.lateDictionaries.add(new LateEntityData((BaseEntity)entity, uid, type));
        }

        public Deque<LateEntityData> getLateEntities() {
            return this.lateEntities;
        }

        public Deque<LateEntityData> getLateDictionaries() {
            return this.lateDictionaries;
        }

        public void pushLateEntity(String uid, String type) {
            this.push(State.LATE_ENTITY);
            this.lateEntityWritersQueue.push(new LateEntityState(this.lateEntityWriter, this.currentPath.toString()));
            StAXRecorder recorder = this.lateEntityWriterCache.pollLast();
            if (null == recorder) {
                recorder = new StAXRecorder();
            }
            this.lateEntityWriter = recorder;
            this.setCurrentPath(type);
        }

        private void onCurrentRemoved() {
            if (this.current instanceof LateEntity) {
                LateEntityState restore = this.lateEntityWritersQueue.pop();
                this.setCurrentPath(restore.getPath());
                if (restore.getWriter() != null) {
                    StAXRecorder t = restore.getWriter();
                    this.lateEntityWriter.write(t);
                    t.clear();
                    this.lateEntityWriterCache.addLast(t);
                }
            }
        }

        public StAXRecorder getLateEntityWriter() {
            return this.lateEntityWriter;
        }

        public boolean hasEntity(String uid, String type) {
            EntityKey key = new EntityKey(uid, type);
            if (this.entities.contains(key)) {
                return true;
            }
            this.entities.add(key);
            return false;
        }

        public Cache acquireCache() {
            Cache result = this.caches.pollLast();
            if (result != null) {
                return result;
            }
            return new Cache();
        }

        public void releaseCache(Cache cache) {
            this.caches.addLast(cache);
        }
    }

    private static enum State {
        IGNORE_WITHOUT_START,
        ROOT,
        ROOT_FIND_TYPE,
        ROOT_SIMPLE_NODE_START,
        ROOT_SIMPLE_NODE,
        ROOT_ENTITY_REFERENCE,
        ROOT_EMBEDDED,
        ROOT_DICTIONARY_REFERENCE,
        LATE_ENTITY,
        LATE_ENTITY_FIND_TYPE,
        LATE_ENTITY_SIMPLE_NODE_START,
        LATE_ENTITY_SIMPLE_NODE,
        LATE_ENTITY_ENTITY_REFERENCE,
        LATE_ENTITY_EMBEDDED,
        LATE_ENTITY_DICTIONARY_REFERENCE,
        COLLECT_LATE_ENTITY,
        COLLECT_LATE_ENTITY_FIND_TYPE,
        COLLECT_LATE_ENTITY_SIMPLE_NODE_START,
        COLLECT_LATE_ENTITY_SIMPLE_NODE,
        COLLECT_LATE_ENTITY_ENTITY_REFERENCE,
        COLLECT_LATE_ENTITY_EMBEDDED,
        COLLECT_LATE_ENTITY_DICTIONARY_REFERENCE;

    }
}

