/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.xml;

import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public final class XMLFilterHelper {
    public static final XMLFilter EMPTY_FILTER = new XMLFilter(){

        @Override
        public boolean accept(String path) {
            return true;
        }
    };
    public static final XMLFilter DOCUMENT_FILTER = new XMLFilter(){
        final List<String> paths = new ArrayList<String>();
        {
            this.paths.add(XMLFilterHelper.buildPath("com.gridnine.xtrip.common.model.system.Document", "content"));
        }

        @Override
        public boolean accept(String path) {
            return !this.paths.contains(path);
        }
    };
    public static final XMLFilter CONTRACT_FILTER = new XMLFilter(){
        final List<String> paths = new ArrayList<String>();
        {
            this.paths.add(XMLFilterHelper.buildPath("com.gridnine.xtrip.common.model.profile.Contract", "ruleSet"));
        }

        @Override
        public boolean accept(String path) {
            return !this.paths.contains(path);
        }
    };
    public static final XMLFilter MODEL_CONTRACT_FILTER = new XMLFilter(){
        final List<String> paths = new ArrayList<String>();
        {
            this.paths.add(XMLFilterHelper.buildPath("com.gridnine.xtrip.common.model.profile.ModelContract", "ruleSet"));
        }

        @Override
        public boolean accept(String path) {
            return !this.paths.contains(path);
        }
    };
    public static final XMLFilter TRIPARTITE_CONTRACT_FILTER = new XMLFilter(){
        final List<String> paths = new ArrayList<String>();
        {
            this.paths.add(XMLFilterHelper.buildPath("com.gridnine.xtrip.common.model.profile.TripartiteContract", "ruleSet"));
        }

        @Override
        public boolean accept(String path) {
            return !this.paths.contains(path);
        }
    };
    public static final XMLFilter TEMPLATE_DOCUMENT_FILTER = new XMLFilter(){
        final List<String> paths = new ArrayList<String>();
        {
            this.paths.add(XMLFilterHelper.buildPath("com.gridnine.xtrip.common.model.system.TemplateDocument", "content"));
            this.paths.add(XMLFilterHelper.buildPath("com.gridnine.xtrip.common.model.system.TemplateDocument", "icon"));
        }

        @Override
        public boolean accept(String path) {
            return !this.paths.contains(path);
        }
    };

    public static List<XMLFilter> getFilters() {
        ArrayList<XMLFilter> filters = new ArrayList<XMLFilter>();
        filters.add(DOCUMENT_FILTER);
        filters.add(TEMPLATE_DOCUMENT_FILTER);
        filters.add(CONTRACT_FILTER);
        filters.add(MODEL_CONTRACT_FILTER);
        filters.add(TRIPARTITE_CONTRACT_FILTER);
        return filters;
    }

    public static XMLFilter createExclusiveFilter(final List<String> paths) {
        return new XMLFilter(){

            @Override
            public boolean accept(String path) {
                return !paths.contains(path);
            }
        };
    }

    public static XMLFilter createInclusiveFilter(final List<String> paths) {
        return new XMLFilter(){

            @Override
            public boolean accept(String path) {
                return paths.contains(path);
            }
        };
    }

    public static XMLFilter createExclusiveFilter(String filterFileName) throws IOException {
        return XMLFilterHelper.createExclusiveFilter(new File(filterFileName));
    }

    public static XMLFilter createInclusiveFilter(String filterFileName) throws IOException {
        return XMLFilterHelper.createInclusiveFilter(new File(filterFileName));
    }

    public static XMLFilter createExclusiveFilter(File filterFile) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(XMLFilterHelper.readPaths(filterFile));
        return XMLFilterHelper.createExclusiveFilter(paths);
    }

    public static XMLFilter createInclusiveFilter(File filterFile) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(XMLFilterHelper.readPaths(filterFile));
        return XMLFilterHelper.createInclusiveFilter(paths);
    }

    public static List<String> readPaths(File filterFile) throws IOException {
        Scanner scanner;
        ArrayList<String> paths = new ArrayList<String>();
        if (filterFile.exists()) {
            scanner = new Scanner(filterFile, "utf-8");
            while (scanner.hasNextLine()) {
                String path = scanner.nextLine();
                if (TextUtil.isBlank((String)path)) continue;
                paths.add(path);
            }
        } else {
            throw new IOException(String.format("file %s does not exists", filterFile));
        }
        scanner.close();
        return paths;
    }

    public static String buildPath(String ... pathElements) {
        StringBuilder path = new StringBuilder();
        for (String pathElement : pathElements) {
            if (path.length() > 0) {
                path.append("/");
            }
            path.append(pathElement);
        }
        return path.toString();
    }

    public static interface XMLFilter {
        public static final String PATH_SEPARATOR = "/";

        public boolean accept(String var1);
    }
}

