/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.finance;

import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import java.util.Arrays;
import java.util.List;

public enum StandardTransactionActions implements TransactionAction
{
    INCOME{

        @Override
        public List<ChartOfAccountsElementType> getSupplierCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CUSTOMER, ChartOfAccountsElementType.INCOME);
        }

        @Override
        public List<ChartOfAccountsElementType> getSupplierDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.BANK);
        }

        @Override
        public List<ChartOfAccountsElementType> getCustomerCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.BANK);
        }

        @Override
        public List<ChartOfAccountsElementType> getCustomerDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.SUPPLIER, ChartOfAccountsElementType.EXPENSE);
        }
    }
    ,
    EXPENSE{

        @Override
        public List<ChartOfAccountsElementType> getSupplierCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.INCOME);
        }

        @Override
        public List<ChartOfAccountsElementType> getSupplierDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CUSTOMER);
        }

        @Override
        public List<ChartOfAccountsElementType> getCustomerCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.SUPPLIER);
        }

        @Override
        public List<ChartOfAccountsElementType> getCustomerDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.EXPENSE);
        }
    }
    ,
    CORRECTION{

        @Override
        public List<ChartOfAccountsElementType> getSupplierCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CUSTOMER, ChartOfAccountsElementType.INCOME);
        }

        @Override
        public List<ChartOfAccountsElementType> getSupplierDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.BANK);
        }

        @Override
        public List<ChartOfAccountsElementType> getCustomerCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.BANK);
        }

        @Override
        public List<ChartOfAccountsElementType> getCustomerDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.SUPPLIER, ChartOfAccountsElementType.EXPENSE);
        }
    }
    ,
    AGENT_CASH_REGISTER{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.AGENT);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REGISTER);
        }
    }
    ,
    AGENT_AGENT_CORRECTION{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.AGENT);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.AGENT_CORRECTION);
        }
    }
    ,
    CASH_REGISTER_CASH{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REGISTER);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH);
        }
    }
    ,
    CASH_CASH_STASH{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_STASH);
        }
    }
    ,
    CASH_CASH_CORRECTION{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_CORRECTION);
        }
    }
    ,
    CASH_CORRECTION_CASH_STASH{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_CORRECTION);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_STASH);
        }
    }
    ,
    CASH_REMAINS_AGENT_STASH{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_AGENT);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_STASH);
        }
    }
    ,
    CASH_REMAINS_AGENT_CORRECTION{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_AGENT);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_CORRECTION);
        }
    }
    ,
    CASH_REMAINS_AGENT_CASH{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_AGENT);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_CASH);
        }
    }
    ,
    CASH_REMAINS_CORRECTION_STASH{

        @Override
        public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_CORRECTION);
        }

        @Override
        public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
            return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_STASH);
        }
    };

}

