/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.finance;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TransactionDataHolder
extends BaseIdentity {
    private static final long serialVersionUID = 6198468201728236115L;
    private final EntityReference<BookingFile> bookingFile;
    private final String productUid;
    private final String documentUid;
    private final String transactionUid;
    private final Date date;
    private final Money amount;
    private final EntityReference<Organization> organization;
    private final EntityReference<Organization> supplier;
    private final EntityReference<Organization> customer;
    private final String description;
    private final DimensionDataHolder creditDimensionData;
    private final DimensionDataHolder debitDimensionData;
    private final List<ChartOfAccountsElementType> organizationCreditChartOfAccountElementTypes = new ArrayList<ChartOfAccountsElementType>();
    private final List<ChartOfAccountsElementType> organizationDebitChartOfAccountElementTypes = new ArrayList<ChartOfAccountsElementType>();
    private final List<ChartOfAccountsElementType> supplierCreditChartOfAccountElementTypes = new ArrayList<ChartOfAccountsElementType>();
    private final List<ChartOfAccountsElementType> supplierDebitChartOfAccountElementTypes = new ArrayList<ChartOfAccountsElementType>();
    private final List<ChartOfAccountsElementType> customerCreditChartOfAccountElementTypes = new ArrayList<ChartOfAccountsElementType>();
    private final List<ChartOfAccountsElementType> customerDebitChartOfAccountElementTypes = new ArrayList<ChartOfAccountsElementType>();

    private TransactionDataHolder(TransactionDataHolderBuilder builder) {
        this.bookingFile = builder.bookingFile;
        this.productUid = builder.productUid;
        this.documentUid = builder.documentUid;
        this.transactionUid = builder.transactionUid;
        this.date = builder.date;
        this.amount = builder.amount;
        this.organization = builder.organization;
        this.supplier = builder.supplier;
        this.customer = builder.customer;
        this.description = builder.description;
        this.creditDimensionData = builder.creditDimensionDataHolderBuilder.build();
        this.debitDimensionData = builder.debitDimensionDataHolderBuilder.build();
        this.organizationCreditChartOfAccountElementTypes.clear();
        this.organizationCreditChartOfAccountElementTypes.addAll(builder.action.getOrganizationCreditChartOfAccounts());
        this.organizationDebitChartOfAccountElementTypes.clear();
        this.organizationDebitChartOfAccountElementTypes.addAll(builder.action.getOrganizationDebitChartOfAccounts());
        this.supplierCreditChartOfAccountElementTypes.clear();
        this.supplierCreditChartOfAccountElementTypes.addAll(builder.action.getSupplierCreditChartOfAccounts());
        this.supplierDebitChartOfAccountElementTypes.clear();
        this.supplierDebitChartOfAccountElementTypes.addAll(builder.action.getSupplierDebitChartOfAccounts());
        this.customerCreditChartOfAccountElementTypes.clear();
        this.customerCreditChartOfAccountElementTypes.addAll(builder.action.getCustomerCreditChartOfAccounts());
        this.customerDebitChartOfAccountElementTypes.clear();
        this.customerDebitChartOfAccountElementTypes.addAll(builder.action.getCustomerDebitChartOfAccounts());
    }

    public EntityReference<BookingFile> getBookingFile() {
        return this.bookingFile;
    }

    public String getProductUid() {
        return this.productUid;
    }

    public String getDocumentUid() {
        return this.documentUid;
    }

    public String getTransactionUid() {
        return this.transactionUid;
    }

    public Date getDate() {
        return this.date;
    }

    public Money getAmount() {
        return this.amount;
    }

    public EntityReference<Organization> getOrganization() {
        return this.organization;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Organization> getCustomer() {
        return this.customer;
    }

    public String getDescription() {
        return this.description;
    }

    public DimensionDataHolder getCreditDimensionData() {
        return this.creditDimensionData;
    }

    public DimensionDataHolder getDebitDimensionData() {
        return this.debitDimensionData;
    }

    public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccountElementTypes() {
        return this.organizationCreditChartOfAccountElementTypes;
    }

    public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccountElementTypes() {
        return this.organizationDebitChartOfAccountElementTypes;
    }

    public List<ChartOfAccountsElementType> getSupplierCreditChartOfAccountElementTypes() {
        return this.supplierCreditChartOfAccountElementTypes;
    }

    public List<ChartOfAccountsElementType> getSupplierDebitChartOfAccountElementTypes() {
        return this.supplierDebitChartOfAccountElementTypes;
    }

    public List<ChartOfAccountsElementType> getCustomerCreditChartOfAccountElementTypes() {
        return this.customerCreditChartOfAccountElementTypes;
    }

    public List<ChartOfAccountsElementType> getCustomerDebitChartOfAccountElementTypes() {
        return this.customerDebitChartOfAccountElementTypes;
    }

    public static final class DimensionDataHolderBuilder {
        private final TransactionDataHolderBuilder parent;
        private PaymentType paymentType;
        private ContractType contractType;
        private final EntityReference<Organization> organization;
        private final EntityReference<Organization> supplier;
        private final EntityReference<Organization> customer;
        private EntityReference<SalesPoint> salesPoint;
        private EntityReference<Person> agent;
        private EntityReference<Cash> cash;
        private EntityReference<CashRegister> cashRegister;
        private EntityReference<CashRegisterWorkplace> cashRegisterWorkplace;

        private DimensionDataHolderBuilder(TransactionDataHolderBuilder parent, EntityReference<Organization> organization, EntityReference<Organization> supplier, EntityReference<Organization> customer) {
            this.parent = parent;
            this.organization = organization;
            this.supplier = supplier;
            this.customer = customer;
        }

        public DimensionDataHolderBuilder paymentType(PaymentType paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public DimensionDataHolderBuilder contractType(ContractType contractType) {
            this.contractType = contractType;
            return this;
        }

        public DimensionDataHolderBuilder salesPoint(EntityReference<SalesPoint> salesPoint) {
            this.salesPoint = salesPoint;
            return this;
        }

        public DimensionDataHolderBuilder agent(EntityReference<Person> agent) {
            this.agent = agent;
            return this;
        }

        public DimensionDataHolderBuilder cash(EntityReference<Cash> cash) {
            this.cash = cash;
            return this;
        }

        public DimensionDataHolderBuilder cashRegister(EntityReference<CashRegister> cashRegister) {
            this.cashRegister = cashRegister;
            return this;
        }

        public DimensionDataHolderBuilder cashRegisterWorkplace(EntityReference<CashRegisterWorkplace> cashRegisterWorkplace) {
            this.cashRegisterWorkplace = cashRegisterWorkplace;
            return this;
        }

        public TransactionDataHolderBuilder end() {
            return this.parent;
        }

        public DimensionDataHolder build() {
            return new DimensionDataHolder(this);
        }
    }

    public static final class TransactionDataHolderBuilder {
        private final TransactionAction action;
        private EntityReference<BookingFile> bookingFile;
        private String productUid;
        private String documentUid;
        private String transactionUid;
        private Date date;
        private Money amount;
        private final EntityReference<Organization> organization;
        private final EntityReference<Organization> supplier;
        private final EntityReference<Organization> customer;
        private String description;
        private final DimensionDataHolderBuilder creditDimensionDataHolderBuilder;
        private final DimensionDataHolderBuilder debitDimensionDataHolderBuilder;

        public static TransactionDataHolderBuilder of(TransactionAction action, EntityReference<Organization> organization) {
            Objects.requireNonNull(action);
            Objects.requireNonNull(organization);
            return new TransactionDataHolderBuilder(action, organization, null, null);
        }

        public static TransactionDataHolderBuilder of(TransactionAction action, EntityReference<Organization> supplier, EntityReference<Organization> customer) {
            Objects.requireNonNull(action);
            Objects.requireNonNull(supplier);
            Objects.requireNonNull(customer);
            return new TransactionDataHolderBuilder(action, null, supplier, customer);
        }

        private TransactionDataHolderBuilder(TransactionAction action, EntityReference<Organization> organization, EntityReference<Organization> supplier, EntityReference<Organization> customer) {
            this.action = action;
            this.organization = organization;
            this.supplier = supplier;
            this.customer = customer;
            this.creditDimensionDataHolderBuilder = new DimensionDataHolderBuilder(this, organization, supplier, customer);
            this.debitDimensionDataHolderBuilder = new DimensionDataHolderBuilder(this, organization, supplier, customer);
        }

        public TransactionDataHolderBuilder bookingFile(EntityReference<BookingFile> bookingFile) {
            this.bookingFile = bookingFile;
            return this;
        }

        public TransactionDataHolderBuilder productUid(String productUid) {
            this.productUid = productUid;
            return this;
        }

        public TransactionDataHolderBuilder documentUid(String documentUid) {
            this.documentUid = documentUid;
            return this;
        }

        public TransactionDataHolderBuilder transactionUid(String transactionUid) {
            this.transactionUid = transactionUid;
            return this;
        }

        public TransactionDataHolderBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public TransactionDataHolderBuilder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public TransactionDataHolderBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DimensionDataHolderBuilder creditDimensionData() {
            return this.creditDimensionDataHolderBuilder;
        }

        public DimensionDataHolderBuilder debitDimensionData() {
            return this.debitDimensionDataHolderBuilder;
        }

        public TransactionDataHolder build() {
            return new TransactionDataHolder(this);
        }
    }

    public static class DimensionDataHolder
    extends BaseIdentity {
        private static final long serialVersionUID = 7789690411640085024L;
        private final PaymentType paymentType;
        private final ContractType contractType;
        private final EntityReference<Organization> organization;
        private final EntityReference<Organization> supplier;
        private final EntityReference<Organization> customer;
        private final EntityReference<SalesPoint> salesPoint;
        private final EntityReference<Person> agent;
        private final EntityReference<Cash> cash;
        private final EntityReference<CashRegister> cashRegister;
        private final EntityReference<CashRegisterWorkplace> cashRegisterWorkplace;

        private DimensionDataHolder(DimensionDataHolderBuilder builder) {
            this.paymentType = builder.paymentType;
            this.contractType = builder.contractType;
            this.organization = builder.organization;
            this.supplier = builder.supplier;
            this.customer = builder.customer;
            this.salesPoint = builder.salesPoint;
            this.agent = builder.agent;
            this.cash = builder.cash;
            this.cashRegister = builder.cashRegister;
            this.cashRegisterWorkplace = builder.cashRegisterWorkplace;
        }

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public ContractType getContractType() {
            return this.contractType;
        }

        public EntityReference<Organization> getOrganization() {
            return this.organization;
        }

        public EntityReference<Organization> getSupplier() {
            return this.supplier;
        }

        public EntityReference<Organization> getCustomer() {
            return this.customer;
        }

        public EntityReference<SalesPoint> getSalesPoint() {
            return this.salesPoint;
        }

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public EntityReference<Cash> getCash() {
            return this.cash;
        }

        public EntityReference<CashRegister> getCashRegister() {
            return this.cashRegister;
        }

        public EntityReference<CashRegisterWorkplace> getCashRegisterWorkplace() {
            return this.cashRegisterWorkplace;
        }
    }
}

