/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.gds.sabre.GetThereHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.l10n.Messages;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.GetThereSettings;
import com.gridnine.xtrip.common.model.profile.GetThereSubsiteSettings;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesValidationResult;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProfileValidationUtil {
    public static final String COUNTRY_CODE_LENGTH = "[0-9]{1,5}";

    public static SabreProfilesValidationResult validateOrganizationForSabreProfiles(EntityContainer<Organization> organizationContainer) {
        String number;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (EntityStorageHelper.isEmpty(organizationContainer)) {
            ProfileValidationUtil.addErrorMessage(messages, L10n.get((String)Messages.profileIsEmpty), new Object[0]);
            return ProfileValidationUtil.createValidationResult(messages);
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        String shortName = ProfileValidationUtil.getEnglishValue(organization.getShortName());
        if (!organization.getTypes().contains(OrganizationType.AGENCY) && !organization.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            ProfileValidationUtil.addErrorMessage(messages, L10n.get((String)Messages.onlyOrganizationRoles), OrganizationType.AGENCY + ", " + OrganizationType.CORPORATE_CLIENT);
        }
        for (Card card : organization.getCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationCreditCardNum), shortName);
                continue;
            }
            CardVendor vendor = card.getVendor();
            if (vendor == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationCreditCardType), shortName, number);
                continue;
            }
            if (ProfileSynchronizationConstants.Card2Abbr.containsKey(vendor)) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.notSupportedOrganizationCreditCardType), shortName, number, vendor);
        }
        for (Card card : organization.getCarBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationCarBonusCardNum), shortName);
            }
            if (card.getCarSupplier() != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationCarBonusCardSupplier), shortName, number);
        }
        for (Card card : organization.getHotelBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationHotelBonusCardNum), shortName);
                continue;
            }
            if (card.getHotelBrand() != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationHotelBonusCardBrand), shortName, number);
        }
        for (Card card : organization.getRailwayBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationRailwayBonusCardNum), shortName);
                continue;
            }
            if (card.getRailwayCarrierCode() != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noOrganizationRailwayBonusCardCarrierCode), shortName, number);
        }
        ProfileValidationUtil.validateSymbolsInOrganizationForSabreProfiles(organization, messages);
        SabreProfilesValidationResult validationResult = ProfileValidationUtil.createValidationResult(messages);
        organization.getSabreProfilesMessages().clear();
        organization.getSabreProfilesMessages().addAll(validationResult.getMessages());
        organization.setSabreProfilesLastSyncStatus(validationResult.getStatus());
        return validationResult;
    }

    private static void validateSymbolsInOrganizationForSabreProfiles(Organization org, List<Message> errors) {
        String orgCode;
        if (org == null) {
            return;
        }
        String shortName = ProfileValidationUtil.getEnglishValue(org.getShortName());
        ArrayList<Message> localErrors = new ArrayList<Message>();
        if (org.isNotSynchronizeWithSabreProfile()) {
            ProfileValidationUtil.addErrorMessage(localErrors, L10n.get((String)Messages.organizationNotSupportSync), shortName);
        }
        if (TextUtil.isBlank((String)(orgCode = org.getCode()))) {
            ProfileValidationUtil.addErrorMessage(localErrors, L10n.get((String)Messages.noOrganizationDKNum), shortName);
        }
        ProfileValidationUtil.checkStrict(orgCode, localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationDKNum), true, shortName, orgCode);
        if (TextUtil.isBlank((String)shortName)) {
            ProfileValidationUtil.addErrorMessage(localErrors, L10n.get((String)Messages.noOrganizationShortName), orgCode);
        }
        ProfileValidationUtil.check(shortName, localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationShortName), true, orgCode, shortName);
        for (Communication pc : org.getCommunications()) {
            if (Arrays.asList(CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.HOME_PHONE, CommunicationType.FAX).contains(pc.getType())) {
                ProfileValidationUtil.check(pc.getCountryCode(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationPhoneNum), false, shortName);
                ProfileValidationUtil.check(pc.getCityCode(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationPhoneNum), false, shortName);
                ProfileValidationUtil.check(pc.getSense(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationPhoneNum), false, shortName);
                ProfileValidationUtil.checkNumbers(pc.getInternalNumber(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationPhoneNum), false, shortName);
                ProfileValidationUtil.check(pc.getRemarks(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationPhoneNum), false, shortName);
                continue;
            }
            if (CommunicationType.EMAIL != pc.getType()) continue;
            ProfileValidationUtil.checkEmail(pc.getSense(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationEmail), false, shortName);
            ProfileValidationUtil.check(pc.getRemarks(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationEmail), false, shortName);
        }
        for (Address addr : ProfileHelper.getOrganizationAddresses(org)) {
            if (addr.getAddressType() != AddressType.FACTUAL && addr.getAddressType() != AddressType.DELIVERY) continue;
            ProfileValidationUtil.check(ProfileValidationUtil.getEnglishValue(addr.getAddress()), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationAddress), false, shortName);
            ProfileValidationUtil.check(ProfileValidationUtil.getEnglishValue(addr.getHouse()), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationAddress), false, shortName);
            ProfileValidationUtil.check(addr.getZip(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationAddress), false, shortName);
            ProfileValidationUtil.check(addr.getNotes(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationAddress), false, shortName);
        }
        for (Card cc : org.getCards()) {
            ProfileValidationUtil.check(cc.getNumber(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationCreditCardNum), false, shortName);
            ProfileValidationUtil.check(cc.getNameOnCard(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationCreditCardName), false, shortName);
            ProfileValidationUtil.check(cc.getRemarks(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationCreditCard), false, shortName);
        }
        for (AirlineBonusCard abc : org.getAirlineBonusCards()) {
            ProfileValidationUtil.checkNonOnlyLatinLettersOrNumbers(abc.getNumber(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationAirBonusCard), false, shortName);
            Airline airline = (Airline)DictionaryCache.get().resolveReference(abc.getAirline());
            if (airline == null) continue;
            ProfileValidationUtil.check(DictHelper.getCodeVariant((BaseDictionary)airline, CodeSystem.IATA), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationAirBonusCard), false, shortName);
        }
        for (CarBonusCard cbc : org.getCarBonusCards()) {
            ProfileValidationUtil.check(cbc.getNumber(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationCarBonusCard), false, shortName);
        }
        for (HotelBonusCard hbc : org.getHotelBonusCards()) {
            ProfileValidationUtil.check(hbc.getNumber(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationHotelBonusCard), false, shortName);
        }
        for (RailwayBonusCard rbc : org.getRailwayBonusCards()) {
            ProfileValidationUtil.check(rbc.getNumber(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationRailBonusCard), false, shortName);
        }
        for (CostCode pcc : org.getCostCodes()) {
            ProfileValidationUtil.checkStrict(pcc.getValue(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationCostCode), false, shortName);
        }
        for (ReasonCode rc : org.getReasonCodes()) {
            ProfileValidationUtil.check(rc.getSabreName(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationReasonCode), false, shortName);
            ProfileValidationUtil.check(rc.getName(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationReasonCode), false, shortName);
        }
        for (Object rem : org.getSabreAdditionalProfileLines()) {
            if (rem.getLineType() == SabreProfileLineType.P) continue;
            ProfileValidationUtil.check(rem.getLineBody(), localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationRemark), false, shortName);
        }
        for (Object rem : org.getSabreFreeTextRemarks()) {
            ProfileValidationUtil.check((String)rem, localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationRemark), false, shortName);
        }
        for (PayerDetails payer : ProfileValidationUtil.getPayersDetails(org)) {
            String payerCode = payer.getCode();
            String payerShortName = ProfileValidationUtil.getEnglishValue(payer.getShortName());
            if (TextUtil.isBlank((String)payerCode)) {
                localErrors.add(MessageHelper.createWarningMessage(L10n.get((String)Messages.noPayerDKNum), payerShortName));
            }
            ProfileValidationUtil.check(payerCode, localErrors, L10n.get((String)Messages.illegalSymbolsPayerDKNum), true, payerShortName, payerCode);
            if (TextUtil.isBlank((String)payerShortName)) {
                localErrors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.noPayerEnShortName), payerCode != null ? payerCode : ""));
            }
            ProfileValidationUtil.check(payerShortName, localErrors, L10n.get((String)Messages.illegalSymbolsPayerEnShortName), true, payerShortName, payerShortName);
        }
        String sabreNotes = org.getSabreNotes() != null ? org.getSabreNotes().replace("\n", "") : null;
        ProfileValidationUtil.check(sabreNotes, localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationSabreNotes), false, shortName);
        String sabreNotesOptional = org.getSabreNotesOptional() != null ? org.getSabreNotesOptional().replace("\n", "") : null;
        ProfileValidationUtil.check(sabreNotesOptional, localErrors, L10n.get((String)Messages.illegalSymbolsOrganizationSabreNotesOptional), false, shortName);
        errors.addAll(localErrors);
    }

    public static SabreProfilesValidationResult validatePersonForSabreProfiles(EntityContainer<Person> personContainer) {
        String number;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (EntityStorageHelper.isEmpty(personContainer)) {
            ProfileValidationUtil.addErrorMessage(messages, L10n.get((String)Messages.profileIsEmpty), new Object[0]);
            return ProfileValidationUtil.createValidationResult(messages);
        }
        Person person = (Person)personContainer.getEntity();
        String personName = ProfileValidationUtil.getPersonName(person);
        if (!person.getTypes().contains(PersonType.PASSENGER)) {
            ProfileValidationUtil.addErrorMessage(messages, L10n.get((String)Messages.onlyPassengerRole), new Object[0]);
        }
        ProfileValidationUtil.validateSymbolsInPersonForSabreProfiles(person, messages);
        List<PersonPassportWrapper> passportWrappers = PersonPassportWrapper.wrap(person.getPassports());
        for (PersonPassportWrapper p : passportWrappers) {
            if (!ProfileValidationUtil.isRealPassport(p)) continue;
            if (TextUtil.isBlank((String)p.getNumber())) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportNum), personName, p.getType());
                continue;
            }
            if (TextUtil.isBlank((String)p.getLastNameLatin()) && TextUtil.isBlank((String)p.getLastNameCyrillic())) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportLastName), personName, p.getNumber());
                continue;
            }
            if (TextUtil.isBlank((String)p.getFirstNameLatin()) && TextUtil.isBlank((String)p.getFirstNameCyrillic())) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportFirstName), personName, p.getNumber());
                continue;
            }
            if (p.getBirthday() == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportBirthdate), personName, p.getNumber());
                continue;
            }
            if (p.getType() == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportType), personName, p.getNumber());
                continue;
            }
            if (p.getGender() == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportGender), personName, p.getNumber());
                continue;
            }
            if (p.getOriginCountry() == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportOriginCountry), personName, p.getNumber());
            }
            if (p.getCitizenship() == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportCitizenship), personName, p.getNumber());
            }
            if (ProfileSynchronizationUtil.calculateExpirationDocumentDate(p.getExpired(), p.getType(), p.getBirthday(), p.getCitizenship()) != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noPersonPassportExpirationDate), personName, p.getNumber());
        }
        for (Visa v : person.getVisas()) {
            if (!Objects.isNull(v.getEndDate())) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.visaExpirationDateRequired), new Object[0]);
        }
        String engLastName = ProfileSynchronizationUtil.removeSlashesAndHyphens(ProfileValidationUtil.getEnglishValue(person.getLastName()));
        if (engLastName.length() > 29) {
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.tooManySymbolsLastNameField), engLastName);
        }
        String engFirstName = ProfileValidationUtil.getEnglishValue(person.getFirstName());
        String engMiddleName = ProfileValidationUtil.getEnglishValue(person.getMiddleName());
        String engSecondName = ProfileValidationUtil.getEnglishValue(person.getSecondName());
        String title = person.getTitle() != null ? person.getTitle().toString() : (person.getGender() == Gender.MALE ? "MR" : (person.getGender() == Gender.FEMALE ? "MRS" : " "));
        String engOtherNames = ProfileSynchronizationUtil.removeSlashesAndHyphens(engFirstName + engSecondName + engMiddleName + title.trim());
        if (engOtherNames.length() > 29) {
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.tooManySymbolsFirstNameField), new Object[0]);
        }
        if (person.getSabrePhoneContacts().size() + person.getSabreEmailContacts().size() > 10) {
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.tooManyContacts), new Object[0]);
        }
        for (Card card : person.getCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noCreditCardNum), personName);
                continue;
            }
            CardVendor vendor = card.getVendor();
            if (vendor == null && TextUtil.isBlank((String)card.getSabreVendorCode())) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noCreditCardType), personName, number);
                continue;
            }
            if (ProfileSynchronizationConstants.Card2Abbr.containsKey(vendor) || !TextUtil.isBlank((String)card.getSabreVendorCode())) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.notSupportedCreditCardType), personName, number, vendor);
        }
        for (Card card : person.getAirlineBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noAirBonusCardNum), personName);
                continue;
            }
            Airline airline = (Airline)DictionaryCache.get().resolveReference(card.getAirline());
            if (airline == null) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noAirBonusCardAirline), personName, number);
                continue;
            }
            String airlineCode = DictHelper.getCodeVariant((BaseDictionary)airline, CodeSystem.IATA);
            if (TextUtil.isBlank((String)airlineCode)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noAirBonusCardAirlineCode), personName, number);
                continue;
            }
            if (airlineCode.length() <= 2) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.tooManySymbolsAirBonusCardAirlineCode), personName, airlineCode, number, 2);
        }
        for (Card card : person.getCarBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noCarBonusCardNum), personName);
                continue;
            }
            if (card.getCarSupplier() != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noCarBonusCardSupplier), personName, number);
        }
        for (Card card : person.getHotelBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noHotelBonusCardNum), personName);
                continue;
            }
            if (card.getHotelBrand() != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noHotelBonusCardBrand), personName, number);
        }
        for (Card card : person.getRailwayBonusCards()) {
            number = card.getNumber();
            if (TextUtil.isBlank((String)number)) {
                ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noRailwayBonusCardNum), personName);
                continue;
            }
            if (card.getRailwayCarrierCode() != null) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.noRailwayBonusCardCarrierCode), personName, number);
        }
        List<EntityContainer<Organization>> employments = ProfileHelper.getEmployments(person);
        if (employments.size() == 0) {
            ProfileValidationUtil.addErrorMessage(messages, L10n.get((String)Messages.noPersonEmployment), personName);
        } else {
            boolean hasOrganizationAllowedSynch = employments.stream().filter(Objects::nonNull).map(EntityContainer::getEntity).filter(Objects::nonNull).anyMatch(org -> !org.isNotSynchronizeWithSabreProfile());
            if (!hasOrganizationAllowedSynch) {
                ProfileValidationUtil.addErrorMessage(messages, L10n.get((String)Messages.noPersonJobPosAllowsSync), personName);
            }
        }
        for (SabreProfileCommand4SSR cmd : person.getSabreAdditionalCommand4Lines()) {
            boolean isValid = !TextUtil.isBlank((String)cmd.getSsrCode()) && (cmd.getSsrCode().length() == 4 || cmd.getSsrCode().length() == 6) && ProfileSynchronizationUtil.checkForLatinSymbols(cmd.getSsrCode(), "-\\ \\\\/") && ProfileSynchronizationUtil.checkForLatinSymbols(cmd.getSsrInfo(), "-\\ \\\\/");
            if (isValid) continue;
            ProfileValidationUtil.addWarningMessage(messages, L10n.get((String)Messages.ssrWarningMessage), personName, cmd.getSsrCode());
        }
        SabreProfilesValidationResult validationResult = ProfileValidationUtil.createValidationResult(messages);
        person.getSabreProfilesMessages().clear();
        person.getSabreProfilesMessages().addAll(validationResult.getMessages());
        person.setSabreProfilesLastSyncStatus(validationResult.getStatus());
        return validationResult;
    }

    private static void validateSymbolsInPersonForSabreProfiles(Person per, List<Message> messages) {
        if (per == null) {
            return;
        }
        String perName = ProfileValidationUtil.getPersonName(per);
        ArrayList<Message> localMessages = new ArrayList<Message>();
        if (TextUtil.isBlank((String)ProfileValidationUtil.getEnglishValue(per.getLastName()))) {
            ProfileValidationUtil.addErrorMessage(localMessages, L10n.get((String)Messages.noPersonLastName), perName);
        }
        if (TextUtil.isBlank((String)ProfileValidationUtil.getEnglishValue(per.getFirstName()))) {
            ProfileValidationUtil.addErrorMessage(localMessages, L10n.get((String)Messages.noPersonFirstName), perName);
        }
        ProfileValidationUtil.checkStrict(ProfileValidationUtil.getEnglishValue(per.getLastName()), localMessages, L10n.get((String)Messages.illegalSymbolsPersonLastName), true, perName);
        ProfileValidationUtil.checkStrict(ProfileValidationUtil.getEnglishValue(per.getFirstName()), localMessages, L10n.get((String)Messages.illegalSymbolsPersonFirstName), true, perName);
        ProfileValidationUtil.checkStrict(ProfileValidationUtil.getEnglishValue(per.getMiddleName()), localMessages, L10n.get((String)Messages.illegalSymbolsPersonMiddleName), false, perName);
        ProfileValidationUtil.checkStrict(ProfileValidationUtil.getEnglishValue(per.getSecondName()), localMessages, L10n.get((String)Messages.illegalSymbolsPersonSecondName), false, perName);
        for (PersonCommunication pc : per.getCommunications()) {
            if (Arrays.asList(CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.HOME_PHONE, CommunicationType.FAX).contains(pc.getType())) {
                ProfileValidationUtil.check(pc.getCountryCode(), localMessages, L10n.get((String)Messages.illegalSymbolsPhoneNum), false, perName);
                ProfileValidationUtil.checkCountryCode(pc.getCountryCode(), true, false, localMessages, L10n.get((String)Messages.illegalCountryCodeLength), perName);
                ProfileValidationUtil.check(pc.getCityCode(), localMessages, L10n.get((String)Messages.illegalSymbolsPhoneNum), false, perName);
                ProfileValidationUtil.check(pc.getSense(), localMessages, L10n.get((String)Messages.illegalSymbolsPhoneNum), false, perName);
                ProfileValidationUtil.check(pc.getInternalNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsPhoneNum), false, perName);
                ProfileValidationUtil.check(pc.getRemarks(), localMessages, L10n.get((String)Messages.illegalSymbolsPhoneNum), false, perName);
                continue;
            }
            if (CommunicationType.EMAIL != pc.getType()) continue;
            ProfileValidationUtil.checkEmail(pc.getSense(), localMessages, L10n.get((String)Messages.illegalSymbolsEmail), false, perName);
            ProfileValidationUtil.check(pc.getRemarks(), localMessages, L10n.get((String)Messages.illegalSymbolsEmail), false, perName);
        }
        List<PersonPassportWrapper> passportWrappers = PersonPassportWrapper.wrap(per.getPassports());
        for (PersonPassportWrapper p : passportWrappers) {
            if (PassportType.FOREIGN != p.getType()) continue;
            ProfileValidationUtil.check(p.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsPassport), false, perName);
        }
        for (Address address : per.getAddresses()) {
            if (address.getAddressType() != AddressType.BUSINESS && address.getAddressType() != AddressType.FACTUAL && address.getAddressType() != AddressType.DELIVERY) continue;
            ProfileValidationUtil.check(ProfileValidationUtil.getEnglishValue(address.getAddress()), localMessages, L10n.get((String)Messages.illegalSymbolsAddress), false, perName);
            ProfileValidationUtil.check(ProfileValidationUtil.getEnglishValue(address.getHouse()), localMessages, L10n.get((String)Messages.illegalSymbolsAddress), false, perName);
            ProfileValidationUtil.check(address.getZip(), localMessages, L10n.get((String)Messages.illegalSymbolsAddress), false, perName);
            ProfileValidationUtil.check(address.getNotes(), localMessages, L10n.get((String)Messages.illegalSymbolsAddress), false, perName);
        }
        for (Visa v : per.getVisas()) {
            ProfileValidationUtil.check(v.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsVisa), false, perName);
        }
        for (Card cc : per.getCards()) {
            ProfileValidationUtil.check(cc.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsCreditCardNum), false, perName);
            ProfileValidationUtil.check(cc.getNameOnCard(), localMessages, L10n.get((String)Messages.illegalSymbolsCreditCardName), false, perName);
            ProfileValidationUtil.check(cc.getRemarks(), localMessages, L10n.get((String)Messages.illegalSymbolsCreditCard), false, perName);
        }
        for (AirlineBonusCard abc : per.getAirlineBonusCards()) {
            ProfileValidationUtil.checkNonOnlyLatinLettersOrNumbers(abc.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsAirBonusCard), false, perName);
            Airline airline = (Airline)DictionaryCache.get().resolveReference(abc.getAirline());
            if (airline == null) continue;
            ProfileValidationUtil.check(DictHelper.getCodeVariant((BaseDictionary)airline, CodeSystem.IATA), localMessages, L10n.get((String)Messages.illegalSymbolsAirBonusCard), false, perName);
        }
        for (CarBonusCard cbc : per.getCarBonusCards()) {
            ProfileValidationUtil.check(cbc.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsCarBonusCard), false, perName);
        }
        for (HotelBonusCard hbc : per.getHotelBonusCards()) {
            ProfileValidationUtil.check(hbc.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsHotelBonusCard), false, perName);
        }
        for (RailwayBonusCard rbc : per.getRailwayBonusCards()) {
            ProfileValidationUtil.check(rbc.getNumber(), localMessages, L10n.get((String)Messages.illegalSymbolsRailBonusCard), false, perName);
        }
        for (SabreProfileLine rem : per.getSabreAdditionalProfileLines()) {
            if (rem.getLineType() == SabreProfileLineType.P) continue;
            ProfileValidationUtil.check(rem.getLineBody(), localMessages, L10n.get((String)Messages.illegalSymbolsRemark), false, perName);
        }
        for (SabreContactEmail e : per.getSabreEmailContacts()) {
            ProfileValidationUtil.checkEmail(e.getSense(), localMessages, L10n.get((String)Messages.illegalSymbolsSabreEmail), false, perName);
        }
        for (PersonCostCode pcc : per.getCostCodes()) {
            ProfileValidationUtil.checkStrict(pcc.getValue(), messages, L10n.get((String)Messages.illegalSymbolsCostCode), false, perName);
        }
        messages.addAll(localMessages);
    }

    private static SabreProfilesValidationResult createValidationResult(List<Message> messages) {
        SabreProfilesValidationResult result = new SabreProfilesValidationResult();
        ProfileSynchronizationUtil.sortMessages(messages);
        result.getMessages().addAll(messages);
        return result;
    }

    private static void addErrorMessage(List<Message> messages, String key, Object ... parameters) {
        messages.add(MessageHelper.createErrorMessage(key, null, parameters));
    }

    private static void addWarningMessage(List<Message> messages, String key, Object ... parameters) {
        messages.add(MessageHelper.createWarningMessage(key, null, parameters));
    }

    private static void check(String value, List<Message> errors, String msg, boolean isError, String ... args) {
        if (ProfileValidationUtil.hasIllegalSymbols(value, false)) {
            ProfileValidationUtil.prepareErrors(value, errors, msg, isError, args);
        }
    }

    private static void checkCountryCode(String value, boolean isNullable, boolean isError, List<Message> errors, String msg, String ... args) {
        if (isNullable && TextUtil.isBlank((String)value)) {
            return;
        }
        if (!value.replaceAll("[^0-9]+", "").matches(COUNTRY_CODE_LENGTH)) {
            ProfileValidationUtil.prepareErrors(value, errors, msg, isError, args);
        }
    }

    private static void checkGetThere(String value, List<Message> errors, String msg, boolean isError, String ... args) {
        if (ProfileValidationUtil.hasIllegalSymbolsGetThere(value)) {
            ProfileValidationUtil.prepareErrors(value, errors, msg, isError, args);
        }
    }

    private static void checkStrict(String value, List<Message> errors, String msg, boolean isError, String ... args) {
        if (ProfileValidationUtil.hasIllegalSymbols(value, true)) {
            ProfileValidationUtil.prepareErrors(value, errors, msg, isError, args);
        }
    }

    private static void checkEmail(String value, List<Message> errors, String msg, boolean isError, String ... args) {
        if (TextUtil.isBlank((String)value)) {
            return;
        }
        Matcher matcher = ProfileSynchronizationUtil.SABRE_ILLEGAL_SYMBOLS_EMAIL.matcher(value);
        if (matcher.find()) {
            ProfileValidationUtil.prepareErrors(value, errors, msg, isError, args);
        }
    }

    private static void checkNumbers(String str, List<Message> errors, String msg, boolean isError, String ... args) {
        if (TextUtil.isBlank((String)str)) {
            return;
        }
        Matcher m = Pattern.compile("[0-9]+").matcher(str.trim());
        if (!m.matches()) {
            ProfileValidationUtil.prepareErrors(str, errors, msg, isError, args);
        }
    }

    private static void checkNonOnlyLatinLettersOrNumbers(String value, List<Message> errors, String msg, boolean isError, String ... args) {
        if (TextUtil.isBlank((String)value)) {
            return;
        }
        if (ValidationUtil.containsNonOnlyLatinLettersOrNumbers(value)) {
            ProfileValidationUtil.prepareErrors(value, errors, msg, isError, args);
        }
    }

    private static boolean hasIllegalSymbols(String str, boolean strict) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        Matcher matcher = strict ? ProfileSynchronizationUtil.SABRE_ILLEGAL_SYMBOLS_STRICT.matcher(str) : ProfileSynchronizationUtil.SABRE_ILLEGAL_SYMBOLS_GENERAL.matcher(str);
        return matcher.find();
    }

    private static boolean hasIllegalSymbolsGetThere(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        Matcher matcher = ProfileSynchronizationUtil.CYRILLIC_SYMBOLS.matcher(str);
        return matcher.find();
    }

    private static void prepareErrors(String value, List<Message> errors, String msg, boolean isError, String ... args) {
        Object[] params = new String[args.length + 1];
        System.arraycopy(args, 0, params, 0, args.length);
        params[args.length] = value;
        if (isError) {
            ProfileValidationUtil.addErrorMessage(errors, msg, params);
        } else {
            ProfileValidationUtil.addWarningMessage(errors, msg, params);
        }
    }

    private static boolean isRealPassport(PersonPassportWrapper p) {
        return TextUtil.nonBlank((String)p.getNumber()) || p.getBirthday() != null || p.getCitizenship() != null || p.getExpired() != null;
    }

    private static String getEnglishValue(L10nString str) {
        String res = "";
        if (str == null || str.getValues().isEmpty()) {
            return res;
        }
        if (str.getValues().containsKey(LocaleUtil.LOCALE_EN)) {
            res = (String)str.getValues().get(LocaleUtil.LOCALE_EN);
        } else if (str.getValues().containsKey(null)) {
            res = (String)str.getValues().get(null);
        }
        return res;
    }

    private static String getPersonName(Person per) {
        String res = ProfileValidationUtil.getEnglishValue(per.getFirstName()) + " " + ProfileValidationUtil.getEnglishValue(per.getLastName());
        return res.trim();
    }

    public static List<EntityReference<Organization>> getOrganizationsForPerson(Person per) {
        return ProfileHelper.getOrganizationForPerson(per);
    }

    public static boolean validatePersonForGetThere(EntityContainer<Person> personCont, List<Message> errors) {
        Map<String, Object> details;
        boolean hasNoErrors = true;
        if (personCont == null || personCont.getEntity() == null) {
            errors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.travellerIsEmpty), new Object[0]));
            return false;
        }
        Person per = (Person)personCont.getEntity();
        if (!ProfileValidationUtil.validateSymbolsInOrganizationForGetThere(per, details = GetThereHelper.getOrganizationDetailsForGetThereSync((EntityReference<Person>)personCont.toReference()), errors)) {
            hasNoErrors = false;
        }
        if (!ProfileValidationUtil.validateSymbolsInPersonForGetThere(per, errors)) {
            hasNoErrors = false;
        }
        ProfileSynchronizationUtil.sortMessages(errors);
        return hasNoErrors;
    }

    private static boolean validateSymbolsInPersonForGetThere(Person per, List<Message> errors) {
        boolean hasNoErrors = true;
        String perName = ProfileValidationUtil.getPersonName(per);
        int errorsCount = errors.size();
        if (!per.getTypes().contains(PersonType.PASSENGER)) {
            errors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.noDKNumber), perName));
        }
        if (TextUtil.isBlank((String)per.getResourceIdForGetThere())) {
            errors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.noUserID), perName));
        } else {
            ProfileValidationUtil.checkGetThere(per.getResourceIdForGetThere(), errors, L10n.get((String)Messages.illegalSymbolsUserID), true, perName);
        }
        ProfileValidationUtil.check(L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false), errors, L10n.get((String)Messages.illegalSymbolsPersonFirstName), true, perName);
        ProfileValidationUtil.check(L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false), errors, L10n.get((String)Messages.illegalSymbolsPersonFirstName), true, perName);
        ProfileValidationUtil.check(L10nStringHelper.getValue((L10nString)per.getMiddleName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false), errors, L10n.get((String)Messages.illegalSymbolsPersonFirstName), true, perName);
        ProfileValidationUtil.check(L10nStringHelper.getValue((L10nString)per.getSecondName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false), errors, L10n.get((String)Messages.illegalSymbolsPersonFirstName), true, perName);
        for (PersonCommunication pc : per.getCommunications()) {
            if (Arrays.asList(CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.HOME_PHONE).contains(pc.getType())) {
                ProfileValidationUtil.check(pc.getCountryCode(), errors, L10n.get((String)Messages.illegalSymbolsPhoneNum), true, perName);
                ProfileValidationUtil.check(pc.getCityCode(), errors, L10n.get((String)Messages.illegalSymbolsPhoneNum), true, perName);
                ProfileValidationUtil.check(pc.getSense(), errors, L10n.get((String)Messages.illegalSymbolsPhoneNum), true, perName);
                ProfileValidationUtil.check(pc.getInternalNumber(), errors, L10n.get((String)Messages.illegalSymbolsPhoneNum), true, perName);
                continue;
            }
            if (CommunicationType.EMAIL != pc.getType()) continue;
            ProfileValidationUtil.checkEmail(pc.getSense(), errors, L10n.get((String)Messages.illegalSymbolsEmail), true, perName);
        }
        for (Passport p : per.getPassports()) {
            if (PassportType.FOREIGN != p.getType()) continue;
            ProfileValidationUtil.check(p.getNumber(), errors, L10n.get((String)Messages.illegalSymbolsPassport), true, perName);
        }
        for (Address addr : per.getAddresses()) {
            if (AddressType.BUSINESS != addr.getAddressType()) continue;
            ProfileValidationUtil.check(L10nStringHelper.getValue((L10nString)addr.getAddress(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false), errors, L10n.get((String)Messages.illegalSymbolsAddress), true, perName);
            ProfileValidationUtil.check(L10nStringHelper.getValue((L10nString)addr.getHouse(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false), errors, L10n.get((String)Messages.illegalSymbolsAddress), true, perName);
            ProfileValidationUtil.check(addr.getZip(), errors, L10n.get((String)Messages.illegalSymbolsAddress), true, perName);
        }
        for (Visa v : per.getVisas()) {
            if (!ProfileValidationUtil.hasIllegalSymbols(v.getNumber(), false)) continue;
            ProfileValidationUtil.check(v.getNumber(), errors, L10n.get((String)Messages.illegalSymbolsVisa), true, perName);
        }
        for (Card cc : per.getCards()) {
            ProfileValidationUtil.check(cc.getNumber(), errors, L10n.get((String)Messages.illegalSymbolsCreditCard), true, perName);
            ProfileValidationUtil.check(cc.getNameOnCard(), errors, L10n.get((String)Messages.illegalSymbolsCreditCard), true, perName);
            ProfileValidationUtil.check(cc.getRemarks(), errors, L10n.get((String)Messages.illegalSymbolsCreditCard), true, perName);
        }
        for (AirlineBonusCard abc : per.getAirlineBonusCards()) {
            ProfileValidationUtil.check(abc.getNumber(), errors, L10n.get((String)Messages.illegalSymbolsAirBonusCard), true, perName);
            ProfileValidationUtil.check(abc.getNameOnCard(), errors, L10n.get((String)Messages.illegalSymbolsAirBonusCard), true, perName);
        }
        for (SabreProfileLine rem : per.getSabreAdditionalProfileLines()) {
            if (!Arrays.asList(SabreProfileLineServiceType.H, SabreProfileLineServiceType.C, SabreProfileLineServiceType.R, SabreProfileLineServiceType.M, SabreProfileLineServiceType.S).contains(rem.getLineServiceType())) continue;
            ProfileValidationUtil.check(rem.getLineBody(), errors, L10n.get((String)Messages.illegalSymbolsRemark), true, perName);
        }
        for (SabreContactEmail e : per.getSabreEmailContacts()) {
            ProfileValidationUtil.checkEmail(e.getSense(), errors, L10n.get((String)Messages.illegalSymbolsSabreEmail), true, perName);
        }
        for (PersonCostCode pcc : per.getCostCodes()) {
            ProfileValidationUtil.check(pcc.getValue(), errors, L10n.get((String)Messages.illegalSymbolsCostCode), true, perName);
        }
        String acqCode = ProfileSynchronizationUtil.getPersonGetThereAcquisitionCode(per);
        if (!TextUtil.isBlank((String)acqCode) && !TextUtil.isSame((String)acqCode, (String)per.getResourceIdForGetThere())) {
            ProfileValidationUtil.check(acqCode, errors, L10n.get((String)Messages.illegalSymbolsAcqCode), true, perName);
        }
        if (errors.size() > errorsCount) {
            hasNoErrors = false;
        }
        return hasNoErrors;
    }

    private static boolean validateSymbolsInOrganizationForGetThere(Person per, Map<String, Object> details, List<Message> errors) {
        boolean hasNoErrors = true;
        String perName = ProfileValidationUtil.getPersonName(per);
        if (Boolean.FALSE.equals(details.get("ORGANIZATION_FOUND"))) {
            errors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.hasNoEmployments), perName));
            hasNoErrors = false;
        } else {
            String orgCode = (String)details.get("ORGANIZATION_CODE");
            String orgShortName = (String)details.get("ORGANIZATION_SHORT_NAME");
            if (TextUtil.isBlank((String)orgCode)) {
                errors.add(MessageHelper.createWarningMessage(L10n.get((String)Messages.noDKNumber), new Object[]{perName, orgShortName}));
            } else if (ProfileValidationUtil.hasIllegalSymbols(orgCode, false)) {
                errors.add(MessageHelper.createWarningMessage(L10n.get((String)Messages.illegalSymbolsDKNum), new Object[]{perName, orgShortName, orgCode}));
                hasNoErrors = false;
            }
            if (TextUtil.isBlank((String)orgShortName)) {
                errors.add(MessageHelper.createWarningMessage(L10n.get((String)Messages.noEnglishShortName), new Object[]{perName, orgCode}));
            } else if (ProfileValidationUtil.hasIllegalSymbols(orgShortName, false)) {
                errors.add(MessageHelper.createWarningMessage(L10n.get((String)Messages.illegalSymbolsShortName), new Object[]{perName, orgShortName}));
                hasNoErrors = false;
            }
            GetThereSettings settings = GetThereHelper.getGetThereSettings();
            if (settings == null || settings.getSites().isEmpty() || settings.getSubSites().isEmpty()) {
                errors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.settingNotFound), new Object[0]));
                hasNoErrors = false;
            } else {
                GetThereSubsiteSettings subsiteSettings = (GetThereSubsiteSettings)details.get("ORGANIZATION_GET_THERE_SETTINGS");
                if (subsiteSettings == null) {
                    errors.add(MessageHelper.createErrorMessage(L10n.get((String)Messages.noGTSettings), orgShortName));
                    hasNoErrors = false;
                }
            }
            String orgPosition = (String)details.get("PERSON_POSITION");
            if (ProfileValidationUtil.hasIllegalSymbols(orgPosition, false)) {
                errors.add(MessageHelper.createWarningMessage(L10n.get((String)Messages.illegalSymbolsJobPos), new Object[]{perName, orgShortName, orgPosition}));
                hasNoErrors = false;
            }
        }
        return hasNoErrors;
    }

    private static List<PayerDetails> getPayersDetails(Organization organization) {
        ArrayList<PayerDetails> result = new ArrayList<PayerDetails>();
        for (EntityReference orgRef : organization.getPayers()) {
            EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
            if (EntityStorageHelper.isEmpty((EntityContainer)orgCont)) continue;
            PayerDetails payerDetails = new PayerDetails(((Organization)orgCont.getEntity()).getCode(), ((Organization)orgCont.getEntity()).getShortName());
            result.add(payerDetails);
        }
        return result;
    }

    private static class PayerDetails {
        private final String code;
        private final L10nString shortName;

        PayerDetails(String code, L10nString shortName) {
            this.code = code;
            this.shortName = shortName;
        }

        String getCode() {
            return this.code;
        }

        L10nString getShortName() {
            return this.shortName;
        }
    }
}

