/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionAir;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.CarTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActions;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripartiteContractSynchronizationUtil {
    private static final Logger log = LoggerFactory.getLogger(TripartiteContractSynchronizationUtil.class);
    private static int counter = 1;

    static void addTripartiteContractRemarks(EntityReference<Organization> orgRef, Map<String, List<String>> linesMap, List<Message> messages) {
        counter = 0;
        TreeMap<String, Set<String>> linesMapWithSets = new TreeMap<String, Set<String>>();
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(orgRef, TripartiteContractType.AVIA, linesMapWithSets, messages);
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(orgRef, TripartiteContractType.CAR, linesMapWithSets, messages);
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(orgRef, TripartiteContractType.HOTEL, linesMapWithSets, messages);
        for (Map.Entry entry : linesMapWithSets.entrySet()) {
            if (linesMap.containsKey(entry.getKey())) {
                linesMap.get(entry.getKey()).addAll(TripartiteContractSynchronizationUtil.convertAndReorder((Set)entry.getValue()));
                continue;
            }
            linesMap.put((String)entry.getKey(), TripartiteContractSynchronizationUtil.convertAndReorder((Set)entry.getValue()));
        }
    }

    @Deprecated
    public static void addTripartiteContractRemarks(EntityReference<Organization> orgRef, Map<String, List<String>> linesMap, List<Message> messages, String pccFromEmulator) {
        counter = 0;
        TreeMap<String, Set<String>> linesMapWithSets = new TreeMap<String, Set<String>>();
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(orgRef, TripartiteContractType.AVIA, linesMapWithSets, messages, pccFromEmulator);
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(orgRef, TripartiteContractType.CAR, linesMapWithSets, messages, pccFromEmulator);
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(orgRef, TripartiteContractType.HOTEL, linesMapWithSets, messages, pccFromEmulator);
        for (Map.Entry entry : linesMapWithSets.entrySet()) {
            if (linesMap.containsKey(entry.getKey())) {
                linesMap.get(entry.getKey()).addAll(TripartiteContractSynchronizationUtil.convertAndReorder((Set)entry.getValue()));
                continue;
            }
            linesMap.put((String)entry.getKey(), TripartiteContractSynchronizationUtil.convertAndReorder((Set)entry.getValue()));
        }
    }

    private static void addTripartiteContractRemarks(EntityReference<Organization> orgRef, TripartiteContractType type, Map<String, Set<String>> linesMap, List<Message> messages) {
        try {
            List<TripartiteContract> contracts = TripartiteContractSynchronizationUtil.findTripartiteContracts(orgRef, type, (EntityReference<Organization>)((EntityReference)null));
            TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(contracts, type, linesMap, messages);
        }
        catch (Throwable e) {
            log.error("unable to find tripartite contracts", e);
            messages.add(MessageHelper.createExceptonMessage("unableToFindTripContracts", e, new Object[0]));
        }
    }

    @Deprecated
    private static void addTripartiteContractRemarks(EntityReference<Organization> orgRef, TripartiteContractType type, Map<String, Set<String>> linesMap, List<Message> messages, String pcc) {
        try {
            List<TripartiteContract> contracts = TripartiteContractSynchronizationUtil.findTripartiteContracts(orgRef, type, pcc);
            TripartiteContractSynchronizationUtil.addTripartiteContractRemarks(contracts, type, linesMap, messages);
        }
        catch (Throwable e) {
            log.error("unable to find tripartite contracts", e);
            messages.add(MessageHelper.createExceptonMessage("unableToFindTripContracts", e, new Object[0]));
        }
    }

    private static void addTripartiteContractRemarks(List<TripartiteContract> contracts, TripartiteContractType type, Map<String, Set<String>> linesMap, List<Message> messages) {
        LinkedHashMap<TripartiteContractsLineDescription, Set<String>> remarks = new LinkedHashMap<TripartiteContractsLineDescription, Set<String>>();
        String serviceCode = ProfileSynchronizationUtil.getLineServiceTypeString(TripartiteContractSynchronizationUtil.getSabreProfileLineServiceType(type));
        TripartiteContractsLineDescription corpCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription accCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription tourCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription contractCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription publicFareDiscountKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        for (TripartiteContract contract : contracts) {
            TripartiteContractSynchronizationUtil.updateTripartiteContractRemarks(remarks, contract, serviceCode, corpCodeKey, accCodeKey, tourCodeKey, contractCodeKey, publicFareDiscountKey, messages);
        }
        TripartiteContractSynchronizationUtil.prepareTripartiteContractRemarks(remarks, corpCodeKey, accCodeKey, tourCodeKey, linesMap, messages);
    }

    private static void updateTripartiteContractRemarks(Map<TripartiteContractsLineDescription, Set<String>> remarks, TripartiteContract contract, String serviceCode, TripartiteContractsLineDescription corpCodeKey, TripartiteContractsLineDescription accCodeKey, TripartiteContractsLineDescription tourCodeKey, TripartiteContractsLineDescription contractCodeKey, TripartiteContractsLineDescription publicFareDiscountKey, List<Message> messages) {
        if (contract.getType() == null) {
            messages.add(MessageHelper.createErrorMessage("ContractSynchronizationHelper_contractTypeNoSpecMessageText", null, contract.getName()));
            return;
        }
        if (TextUtil.isBlank((String)serviceCode)) {
            messages.add(MessageHelper.createErrorMessage("ContractSynchronizationHelper_codeTypeDetectingUnsuccessMessageText", null, contract.getName()));
            return;
        }
        ArrayList<String> airlines = new ArrayList<String>();
        String autoRemarkSuppliers = TripartiteContractSynchronizationUtil.createSuppliersRemark(contract, airlines);
        String corporatePrefix = ProfileSynchronizationUtil.getLineServiceTypeStringForRemark(ProfileSynchronizationUtil.getLineServiceTypeFromString(serviceCode)) + " " + SabreProfileLineSubsectionAir.CORPORATE_DEALS.name() + " / ";
        TripartiteContractsLineDescription autoRemarkKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 50);
        if (!remarks.containsKey(autoRemarkKey)) {
            remarks.put(autoRemarkKey, new LinkedHashSet());
        }
        if (contract.getRuleSet() == null) {
            return;
        }
        block0: for (RuleSettings rs : contract.getRuleSet().getRules()) {
            if (rs.getTarget() == null || !MiscUtil.isBetween((Date)rs.getPeriodBegin(), (Date)rs.getPeriodEnd(), (Date)new Date())) continue;
            for (RuleRestriction restr : rs.getRestrictions()) {
                if (restr.getProperty() == null || TripartiteContractSynchronizationUtil.isApplicableForSabre(restr)) continue;
                continue block0;
            }
            List<String> fareBasisLines = TripartiteContractSynchronizationUtil.getFareBasisLines(rs);
            for (RuleResult rr : rs.getResults()) {
                TripartiteContractsLineDescription key;
                TripartitePublicFareDiscount discount;
                int maxLinesPerProfile;
                int maxCodesPerLine;
                String actionCode;
                boolean needCorporateSection = false;
                boolean needTourCodePrefix = false;
                boolean needSlashDelimiterAfterPrefix = false;
                boolean needCalculationIndicator = false;
                boolean isAccCode = false;
                TripartiteContractsLineDescription specialKeyCode = null;
                if (AviaTripartiteContractActions.AVIA_CORPORATE_ID == rr.getAction()) {
                    actionCode = "CORP.ID";
                    maxCodesPerLine = 4;
                    maxLinesPerProfile = 2;
                    isAccCode = true;
                    specialKeyCode = corpCodeKey;
                } else if (AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE == rr.getAction()) {
                    actionCode = "AIR.ACCT.CODE";
                    maxCodesPerLine = 10;
                    maxLinesPerProfile = 4;
                    isAccCode = true;
                    specialKeyCode = accCodeKey;
                } else if (AviaTripartiteContractActions.AVIA_FREE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    needCorporateSection = true;
                } else if (AviaTripartiteContractActions.AVIA_TEMPLATE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 99;
                    needCorporateSection = true;
                } else if (AviaTripartiteContractActions.AVIA_TOUR_CODE == rr.getAction()) {
                    actionCode = "AIR.TOUR.CODE";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    needTourCodePrefix = true;
                    needSlashDelimiterAfterPrefix = true;
                    needCalculationIndicator = true;
                    specialKeyCode = tourCodeKey;
                } else if (AviaTripartiteContractActions.AVIA_PUBLIC_FARE_DISCOUNT == rr.getAction()) {
                    actionCode = "CORP.DISC";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    specialKeyCode = publicFareDiscountKey;
                } else if (HotelTripartiteContractActions.HOTEL_CORPORATE_ID == rr.getAction()) {
                    actionCode = "HOTL.CO";
                    maxCodesPerLine = 4;
                    maxLinesPerProfile = 1;
                    isAccCode = true;
                    specialKeyCode = corpCodeKey;
                } else if (HotelTripartiteContractActions.HOTEL_DISCOUNT_NUMBER == rr.getAction()) {
                    actionCode = "CD.NUMB";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    isAccCode = true;
                    specialKeyCode = accCodeKey;
                } else if (HotelTripartiteContractActions.HOTEL_FREE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 98;
                    needCorporateSection = true;
                } else if (HotelTripartiteContractActions.HOTEL_TEMPLATE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 97;
                    needCorporateSection = true;
                } else if (CarTripartiteContractActions.CAR_DISCOUNT_NUMBER == rr.getAction()) {
                    actionCode = "CAR CD.NUMB";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    isAccCode = true;
                    specialKeyCode = corpCodeKey;
                } else if (CarTripartiteContractActions.CAR_FREE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 96;
                    needCorporateSection = true;
                } else if (CarTripartiteContractActions.CAR_TEMPLATE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 95;
                    needCorporateSection = true;
                } else {
                    if (AviaTripartiteContractActions.CONTRACT_CODE != rr.getAction()) continue;
                    actionCode = "AIR.FOP.CODE";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    needSlashDelimiterAfterPrefix = true;
                    needTourCodePrefix = true;
                    specialKeyCode = contractCodeKey;
                }
                List<Object> values = new ArrayList<String>();
                boolean needPublicFareDiscountPrefix = false;
                if (rr.getValue() instanceof SabreRemarkResult) {
                    values.add(((SabreRemarkResult)rr.getValue()).getTemplate());
                } else if (rr.getValue() instanceof String || rr.getValue() instanceof Iterable) {
                    values = RulesHelper.toStringCollection(rr.getValue());
                } else if (rr.getValue() instanceof TripartitePublicFareDiscount && (discount = (TripartitePublicFareDiscount)rr.getValue()).getValue() != null && !fareBasisLines.isEmpty()) {
                    values.addAll(airlines);
                    needPublicFareDiscountPrefix = true;
                }
                discount = values.iterator();
                while (discount.hasNext()) {
                    String v = (String)discount.next();
                    if (!ProfileSynchronizationUtil.checkIllegalSymbols(v, false)) continue;
                    continue block0;
                }
                if (values.isEmpty()) continue;
                if (isAccCode && TextUtil.nonBlank((String)autoRemarkSuppliers) && !HotelTripartiteContractActions.HOTEL_DISCOUNT_NUMBER.equals(rr.getAction())) {
                    String autoRemark = corporatePrefix + autoRemarkSuppliers + " - " + (String)values.get(0);
                    Set<String> autoList = remarks.get(autoRemarkKey);
                    autoList.add(autoRemark);
                    isAccCode = false;
                }
                if (!TextUtil.isBlank((String)actionCode)) {
                    key = specialKeyCode != null ? specialKeyCode : corpCodeKey;
                    key.setActionCode(actionCode);
                    key.setMaxCodesPerLine(maxCodesPerLine);
                    key.setMaxLinesPerProfile(maxLinesPerProfile);
                    if ("AIR.ACCT.CODE".equals(actionCode)) {
                        key.setDelimiterAfterPrefix("/");
                        key.setDelimiterBetweenCodes("*");
                    }
                } else {
                    key = new TripartiteContractsLineDescription(serviceCode, "", actionCode, maxCodesPerLine, maxLinesPerProfile);
                }
                if (needSlashDelimiterAfterPrefix) {
                    key.setDelimiterAfterPrefix("/");
                }
                Set list = remarks.computeIfAbsent(key, k -> new LinkedHashSet());
                for (String string : values) {
                    List<Object> splittedLines = new ArrayList();
                    if (needCorporateSection) {
                        splittedLines = ProfileSynchronizationUtil.advancedPrepareRemarkForSabre(string, 50, "", ProfileSynchronizationUtil.getLineServiceTypeStringForRemark(ProfileSynchronizationUtil.getLineServiceTypeFromString(serviceCode)), " " + SabreProfileLineSubsectionAir.CORPORATE_DEALS.name() + " /", "", false, true);
                    } else if (needTourCodePrefix) {
                        Object tourCodesStr = new StringBuilder();
                        ArrayList<String> listOfTourCodes = new ArrayList<String>();
                        if (contract.getAviaVendorData().getAlliances() != null && contract.getAviaVendorData().getAlliances().size() > 0) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String a : airlines) {
                                stringBuilder.append(stringBuilder.length() > 0 ? "/" + a : a);
                            }
                            airlines.clear();
                            airlines.add(stringBuilder.toString());
                        }
                        for (String a : airlines) {
                            String s = a + "-";
                            if (needCalculationIndicator) {
                                s = s + ProfileSynchronizationConstants.CalculatiionIndicator2String.get(TripartiteContractSynchronizationUtil.getCalculationIndicator(contract, string));
                            }
                            s = s + string;
                            if (((StringBuilder)tourCodesStr).length() + s.length() < 53 - "AIR.TOUR.CODE".length()) {
                                if (((StringBuilder)tourCodesStr).length() > 0) {
                                    ((StringBuilder)tourCodesStr).append("*");
                                }
                                ((StringBuilder)tourCodesStr).append(s);
                                continue;
                            }
                            listOfTourCodes.add(((StringBuilder)tourCodesStr).toString());
                            tourCodesStr = new StringBuilder(s);
                        }
                        listOfTourCodes.add(((StringBuilder)tourCodesStr).toString());
                        splittedLines.addAll(listOfTourCodes);
                    } else if (needPublicFareDiscountPrefix) {
                        for (String fb : fareBasisLines) {
                            String string2 = ProfileSynchronizationUtil.prepareRemarkForSabre(string + (!TextUtil.isBlank((String)fb) ? Character.valueOf('\u00a5') : "") + fb, "", "", false);
                            splittedLines.add(string2.trim());
                        }
                    } else {
                        splittedLines = ProfileSynchronizationUtil.advancedPrepareRemarkForSabre(string, 50, "", "", "", "", false, true);
                        ArrayList<String> trimLines = new ArrayList<String>();
                        for (String string3 : splittedLines) {
                            trimLines.add(string3.trim());
                        }
                        splittedLines = trimLines;
                    }
                    list.addAll(splittedLines);
                }
            }
        }
    }

    private static List<String> getFareBasisLines(RuleSettings rs) {
        ArrayList<String> result = new ArrayList<String>();
        int fareBasisLimit = 57 - "CORP.DISC".length() - 8;
        StringBuilder sb = new StringBuilder();
        for (RuleRestriction restr : rs.getRestrictions()) {
            String[] codes;
            if (restr.getProperty() == null || !TextUtil.isSame((String)restr.getProperty().getId(), (String)"FARE_BASIS") || !(restr.getValue() instanceof String) || !Conditions.EQUALS.equals(restr.getCondition())) continue;
            for (String code : codes = ((String)restr.getValue()).split(",")) {
                if ((code = code.trim()).startsWith("!")) continue;
                if (sb.length() + code.length() + 1 >= fareBasisLimit) {
                    result.add(sb.toString());
                    sb = new StringBuilder();
                }
                if (sb.length() > 0) {
                    sb.append('\u00a5');
                }
                sb.append(code);
            }
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    private static void prepareTripartiteContractRemarks(LinkedHashMap<TripartiteContractsLineDescription, Set<String>> remarks, TripartiteContractsLineDescription corpCodeKey, TripartiteContractsLineDescription accCodeKey, TripartiteContractsLineDescription tourCodeKey, Map<String, Set<String>> linesMap, List<Message> messages) {
        Set tourCodeValues;
        Set accCodeValues;
        Set corpCodeValues = (Set)remarks.remove(corpCodeKey);
        if (corpCodeValues != null) {
            remarks.put(corpCodeKey, corpCodeValues);
        }
        if ((accCodeValues = (Set)remarks.remove(accCodeKey)) != null) {
            remarks.put(accCodeKey, accCodeValues);
        }
        if ((tourCodeValues = (Set)remarks.remove(tourCodeKey)) != null) {
            remarks.put(tourCodeKey, tourCodeValues);
        }
        for (Map.Entry<TripartiteContractsLineDescription, Set<String>> entry : remarks.entrySet()) {
            TripartiteContractsLineDescription description = entry.getKey();
            ArrayList<String> splittedRemarks = new ArrayList<String>();
            StringBuilder currentString = new StringBuilder();
            int codesCountInLine = 0;
            String prefix = "A5" + description.getServiceCode() + '\u00a5';
            if (TextUtil.nonBlank((String)description.getActionCode())) {
                prefix = prefix + description.getActionCode() + description.getDelimiterAfterPrefix();
            }
            int threshold = 57 - prefix.length() - 2;
            for (String item : entry.getValue()) {
                if (TextUtil.isBlank((String)item)) continue;
                if (codesCountInLine >= description.getMaxCodesPerLine() || currentString.length() + item.length() > threshold) {
                    ArrayList<String> partsOfLongLine = new ArrayList<String>();
                    if (item.length() > threshold) {
                        ProfileSynchronizationUtil.split(item, threshold, partsOfLongLine);
                        item = null;
                    }
                    if (currentString.length() > 0) {
                        splittedRemarks.add(currentString.toString());
                        currentString = new StringBuilder();
                        codesCountInLine = 0;
                    }
                    splittedRemarks.addAll(partsOfLongLine);
                }
                if (currentString.length() > 0) {
                    currentString.append(description.getDelimiterBetweenCodes());
                }
                if (item == null) continue;
                currentString.append(item);
                ++codesCountInLine;
            }
            if (currentString.length() > 0) {
                splittedRemarks.add(currentString.toString());
            }
            if (splittedRemarks.size() > description.getMaxLinesPerProfile()) {
                messages.add(MessageHelper.createWarningMessage("ContractSynchronizationHelper_maxLinesProfileReached", null, description.getMaxLinesPerProfile(), description.getActionCode()));
                continue;
            }
            for (String line : splittedRemarks) {
                String s = prefix + line + (TextUtil.nonBlank((String)description.getActionCode()) && "*".equals(description.getDelimiterAfterPrefix()) ? "*" : "");
                linesMap.computeIfAbsent(description.getServiceCode(), c -> new LinkedHashSet()).add(s.toUpperCase());
            }
        }
    }

    private static String createSuppliersRemark(TripartiteContract contract, List<String> airlines) {
        List<Object> codes = Collections.emptyList();
        switch (contract.getType()) {
            case AVIA: {
                codes = !contract.getAviaVendorData().getAirlines().isEmpty() ? contract.getAviaVendorData().getAirlines().stream().map(DictionaryReference::getCode).collect(Collectors.toList()) : contract.getAviaVendorData().getAlliances().stream().map(DictionaryReference::getCode).collect(Collectors.toList());
                airlines.addAll(codes);
                break;
            }
            case HOTEL: {
                if (!contract.getHotelVendorData().getBrands().isEmpty()) {
                    codes = contract.getHotelVendorData().getBrands().stream().map(DictionaryReference::getCode).collect(Collectors.toList());
                    break;
                }
                codes = Collections.singletonList("GLOBAL RATES");
                break;
            }
            case CAR: {
                codes = contract.getCarVendorData().getSuppliers().stream().map(DictionaryReference::getCode).collect(Collectors.toList());
            }
        }
        return TextUtil.join((String)"/", codes);
    }

    private static boolean isApplicableForSabre(RuleRestriction restr) {
        if (!TextUtil.isSame((String)Properties.GDS_NAME.getId(), (String)restr.getProperty().getId())) {
            return true;
        }
        if (!(restr.getValue() instanceof List)) {
            return true;
        }
        List gdsList = (List)restr.getValue();
        return (!Conditions.EQUALS.getId().equals(restr.getCondition().getId()) || gdsList.contains(GdsName.SABRE)) && (!Conditions.NOT_EQUALS.getId().equals(restr.getCondition().getId()) || !gdsList.contains(GdsName.SABRE));
    }

    @Deprecated
    public static List<TripartiteContract> findTripartiteContracts(EntityReference<Organization> orgRef, TripartiteContractType type, String pcc) throws Exception {
        EntityReference<Organization> mainAgency = ProfileDao.findMainAgency(pcc);
        return mainAgency == null ? Collections.emptyList() : TripartiteContractSynchronizationUtil.findTripartiteContracts(orgRef, type, mainAgency);
    }

    public static List<TripartiteContract> findTripartiteContracts(EntityReference<Organization> orgRef, TripartiteContractType type) {
        return TripartiteContractSynchronizationUtil.findTripartiteContracts(orgRef, type, (EntityReference<Organization>)((EntityReference)null));
    }

    private static List<TripartiteContract> findTripartiteContracts(EntityReference<Organization> orgRef, TripartiteContractType type, EntityReference<Organization> mainAgency) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.contractType.name(), (Object)type));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)orgRef.getUid()));
        if (mainAgency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.agency.name(), (Object)mainAgency.getUid()));
        }
        ArrayList<TripartiteContract> result = new ArrayList<TripartiteContract>();
        List indices = EntityStorage.get().search(TripartiteContractIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        block0: for (TripartiteContractIndex tci : indices) {
            EntityContainer tcCont = EntityStorage.get().resolve(tci.getSource());
            if (tcCont == null) continue;
            TripartiteContract tc = (TripartiteContract)tcCont.getEntity();
            for (TripartiteContractCustomerInfo tcci : tc.getCustomers()) {
                if (!orgRef.equals((Object)tcci.getCustomer()) || !MiscUtil.isBetween((Date)tcci.getStartDate(), (Date)tcci.getEndDate(), (Date)new Date())) continue;
                result.add(tc);
                continue block0;
            }
        }
        return result;
    }

    public static TripartiteContractCalculationIndicatorType getCalculationIndicator(TripartiteContract contract, String tourCode) {
        if (contract == null || contract.getRuleSet() == null) {
            return null;
        }
        for (RuleSettings rs : contract.getRuleSet().getRules()) {
            boolean hasNeededTourCode = false;
            TripartiteContractCalculationIndicatorType indicator = null;
            for (RuleResult rr : rs.getResults()) {
                if (rr.getAction() == AviaTripartiteContractActions.AVIA_TOUR_CODE) {
                    List<String> values = RulesHelper.toStringCollection(rr.getValue());
                    if (values.size() != 1 || !TextUtil.isSame((String)tourCode, (String)values.get(0))) continue;
                    hasNeededTourCode = true;
                    continue;
                }
                if (rr.getAction() != AviaTripartiteContractActions.AVIA_CALCULATION_INDICATOR && rr.getAction() != CarTripartiteContractActions.CAR_CALCULATION_INDICATOR && rr.getAction() != HotelTripartiteContractActions.HOTEL_CALCULATION_INDICATOR) continue;
                indicator = (TripartiteContractCalculationIndicatorType)rr.getValue();
            }
            if (!hasNeededTourCode || indicator == null) continue;
            return indicator;
        }
        return null;
    }

    private static SabreProfileLineServiceType getSabreProfileLineServiceType(TripartiteContractType type) {
        switch (type) {
            case AVIA: {
                return SabreProfileLineServiceType.A;
            }
            case HOTEL: {
                return SabreProfileLineServiceType.H;
            }
            case CAR: {
                return SabreProfileLineServiceType.C;
            }
        }
        return null;
    }

    private static List<String> convertAndReorder(Set<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        String corporateDeals = SabreProfileLineSubsectionAir.CORPORATE_DEALS.name();
        ArrayList<String> corporateDealsLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.contains(corporateDeals)) {
                corporateDealsLines.add(line);
                continue;
            }
            result.add(line);
        }
        result.addAll(corporateDealsLines);
        return result;
    }

    private static final class TripartiteContractsLineDescription {
        private final int num;
        private final String supplierCode;
        private String actionCode;
        private int maxCodesPerLine;
        private int maxLinesPerProfile;
        private final String serviceCode;
        private String delimiterAfterPrefix;
        private String delimiterBetweenCodes;

        TripartiteContractsLineDescription(String service, String supplier, String action, int maxCodes, int maxLines) {
            this.serviceCode = service;
            this.supplierCode = supplier;
            this.actionCode = action;
            this.maxCodesPerLine = maxCodes;
            this.maxLinesPerProfile = maxLines;
            this.delimiterAfterPrefix = "*";
            this.delimiterBetweenCodes = String.valueOf('\u00a5');
            this.num = counter++;
        }

        String getSupplierCode() {
            return this.supplierCode;
        }

        String getActionCode() {
            return this.actionCode;
        }

        void setActionCode(String value) {
            this.actionCode = value;
        }

        int getMaxCodesPerLine() {
            return this.maxCodesPerLine;
        }

        void setMaxCodesPerLine(int value) {
            this.maxCodesPerLine = value;
        }

        int getMaxLinesPerProfile() {
            return this.maxLinesPerProfile;
        }

        void setMaxLinesPerProfile(int value) {
            this.maxLinesPerProfile = value;
        }

        String getServiceCode() {
            return this.serviceCode;
        }

        String getDelimiterAfterPrefix() {
            return this.delimiterAfterPrefix;
        }

        void setDelimiterAfterPrefix(String value) {
            this.delimiterAfterPrefix = value;
        }

        String getDelimiterBetweenCodes() {
            return this.delimiterBetweenCodes;
        }

        void setDelimiterBetweenCodes(String value) {
            this.delimiterBetweenCodes = value;
        }

        int getNum() {
            return this.num;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof TripartiteContractsLineDescription) {
                TripartiteContractsLineDescription descr2 = (TripartiteContractsLineDescription)o2;
                return TextUtil.isSame((String)this.serviceCode, (String)descr2.serviceCode) && TextUtil.isSame((String)this.supplierCode, (String)descr2.supplierCode) && TextUtil.isSame((String)this.actionCode, (String)descr2.actionCode) && this.maxCodesPerLine == descr2.maxCodesPerLine && this.maxLinesPerProfile == descr2.maxLinesPerProfile && this.num == descr2.num;
            }
            return false;
        }

        public int hashCode() {
            return (this.serviceCode != null ? this.serviceCode.hashCode() : 0) + (this.supplierCode != null ? this.supplierCode.hashCode() : 0) + (this.actionCode != null ? this.actionCode.hashCode() : 0) + this.maxCodesPerLine + this.maxLinesPerProfile + this.num;
        }
    }
}

