/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BasePenalty;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.VendorAdditionalService;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.PreferenceHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface ProductHandler<P extends BaseProduct> {
    public static <P extends BaseProduct> ProductHandler<P> of(P product) {
        return HandlersRegistry.get().findProductHandler(product.getClass());
    }

    public VatAmount calculateProductPrice(P var1, ContractType var2);

    public VatAmount calculateProductPrice(GeneralProductContractRelationData var1, P var2);

    default public VatAmount calculateEquivalentProductPrice(GeneralProductContractRelationData relation, P product) {
        return null;
    }

    public String generateShortProductName(P var1);

    public String generateProductName(P var1);

    public Date findFirstTravelDate(P var1);

    public Date findNearestTravelDate(Date var1, P var2);

    public Date findLastTravelDate(P var1);

    public Date findIssueDate(P var1);

    public Date findLocalIssueDate(P var1);

    public void setIssueDate(P var1, Date var2);

    default public String getPassiveSegmentRecordLocator(P product) {
        Reservation reservation = product.getReservation();
        return reservation != null ? CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(reservation) : null;
    }

    default public String getProductNumberForPassiveSegments(P product) {
        List<String> list = this.getProductNumbers(product);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<String> getProductNumbers(P var1);

    public EntityReference<Person> findIssuingAgent(P var1);

    default public String findIssuingAgentCode(P product) {
        return null;
    }

    public TravelSubject findTravelSubject(P var1);

    public boolean includeInFinanceDocuments(P var1);

    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> var1, List<FinanceDocument> var2) throws Exception;

    public Class<P> getProductClass();

    public Collection<BillingItem> getBillingItems(List<BaseProduct> var1, FinanceDocumentsProperties var2, boolean var3) throws Exception;

    public void updateBillingItems(Collection<BillingItem> var1, List<P> var2);

    public String getBillingItemName(P var1, String var2);

    public Collection<Traveller> getTravellers(P var1);

    public String getRfic(P var1);

    public String getRfisc(P var1);

    default public boolean isMultiTraveller() {
        return false;
    }

    default public boolean isNoTraveller() {
        return false;
    }

    public void replaceTraveller(P var1, Traveller var2, Traveller var3);

    default public void setOrReplaceTraveller(P product, Traveller oldTraveller, Traveller newTraveller) {
    }

    default public void setOrReplaceTraveller(P product, Traveller newTraveller) {
    }

    public EntityReference<SalesPoint> findSalesPoint(P var1);

    public ProductStatus getStatus(P var1);

    public ProductStatus getBaseStatus(P var1);

    public void setStatus(P var1, ProductStatus var2);

    public ProductType getProductType(P var1);

    public Set<ProductType> getAllProductTypes();

    public RuleTarget getCommissionRuleTarget();

    public EntityReference<Organization> getBlankOwner(P var1);

    public EntityReference<Branch> getBranch(P var1);

    public List<MCOFeesSource> getMcoFeesSources(P var1);

    public boolean isCompleted(P var1);

    public void setCompleted(P var1, boolean var2);

    public boolean isChecked(P var1);

    public void setChecked(P var1, boolean var2);

    public TransportationType getTransportationType(P var1);

    public ServiceLocationType getServiceLocationType(P var1);

    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(P var1);

    default public List<GeneralProductContractRelationData> getUnmodifiableContractRelationsForTransactions(P product) {
        return this.getUnmodifiableContractRelations(product);
    }

    public void updateContractRelations(P var1, List<GeneralProductContractRelationData> var2);

    public P getPreviousProduct(P var1);

    public void setPreviousProduct(P var1, P var2);

    public P getNextProduct(P var1);

    public void setNextProduct(P var1, P var2);

    public void addRelatedProduct(P var1, BaseProduct var2);

    public List<BaseProduct> getRelatedProducts(P var1);

    @Deprecated
    public ProductCancellationDetails getCancellationDetails(P var1);

    public ProductCategory getProductCategory(P var1);

    public MCOCategory getMCOCategory(P var1);

    public List<GeneralProductTax> getTaxes(P var1);

    public DictionaryReference<BlankType> getBlankType(P var1);

    public BigDecimal getEquivalentFare(P var1);

    default public BigDecimal getOnlyEquivalentFare(P product) {
        return this.getEquivalentFare(product);
    }

    public BigDecimal getServiceFare(P var1);

    default public BigDecimal getAdditionalFeeEquivalentAmount(P product) {
        return BigDecimal.ZERO;
    }

    default public Money getAdditionalFee(P product) {
        return null;
    }

    public BigDecimal getPenalty(P var1);

    default public BigDecimal getDeduction(P product) {
        return null;
    }

    default public BigDecimal getDeductionVat(P product) {
        return null;
    }

    public int getConjunction(P var1);

    public String getRouteLine(P var1);

    public String getLocalizedRouteLine(P var1);

    public String getCodeRouteLine(P var1);

    public SalesChain getSalesChain(P var1);

    public TicketType getTicketType(P var1);

    public void setTicketType(P var1, TicketType var2);

    public String getPCC(P var1);

    public void updateProductFops(P var1);

    public void setContractRulesApplied(P var1, boolean var2);

    public List<ValidationMessage> getValidationMessages(P var1);

    public EntityReference<Organization> getProvider(P var1);

    public PassengerStatus getPassengerStatus(P var1);

    public boolean isHoldable(P var1);

    public Date getUnholdDate(P var1);

    public String getValidatorNumber(P var1);

    @Deprecated
    public DictionaryReference<PassengerType> getPassengerType(P var1);

    default public DictionaryReference<PassengerType> getPassengerType(P product, Traveller traveller) {
        return this.getPassengerType(product);
    }

    public String getCarrierNumber(P var1);

    default public Supplier getFiscalSupplier(P product) {
        EntityContainer vendorContractCtr = null;
        for (GeneralProductContractRelationData relation : this.getUnmodifiableContractRelations(product)) {
            EntityContainer relationDescr = EntityStorage.get().resolve(relation.getDescription());
            EntityContainer supplierDescr = EntityStorage.get().resolve(((ContractRelationDescription)relationDescr.getEntity()).getSupplier());
            boolean isSupplierContractRelation = ((ContractorDescription)supplierDescr.getEntity()).getPredefinedType() == PredefinedContractorType.SUPER_SUPPLIER || ((ContractorDescription)supplierDescr.getEntity()).getPredefinedType() == PredefinedContractorType.SUPPLIER;
            if (!isSupplierContractRelation) continue;
            vendorContractCtr = EntityStorage.get().resolve(relation.getGeneralData().getContractData().getContract());
            break;
        }
        if (vendorContractCtr != null && ((Contract)vendorContractCtr.getEntity()).getAgreementType() == AgreementType.AGENCY_CONTRACT) {
            String supplierRegistrationId;
            String legalForm;
            EntityContainer supplierCtr = Objects.requireNonNull(EntityStorage.get().resolve(((Contract)vendorContractCtr.getEntity()).getSupplier()), "Can't resolve supplier from contract " + vendorContractCtr.getUid());
            String supplierFullName = L10nStringHelper.getValue((L10nString)((Organization)supplierCtr.getEntity()).getFullName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)false);
            LegalForm form = (LegalForm)DictionaryCache.get().resolveReference(((Organization)supplierCtr.getEntity()).getLegalForm());
            if (form != null && (legalForm = (String)form.getAbbreviations().entrySet().stream().filter(entry -> LocaleHelper.RU_LOCALE.getLanguage().equals(((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).findFirst().orElse(null)) != null) {
                String string = supplierFullName = supplierFullName.startsWith(legalForm) ? supplierFullName : legalForm + " " + supplierFullName;
            }
            if (TextUtil.isBlank((String)(supplierRegistrationId = ((Organization)supplierCtr.getEntity()).getRegistrationId()))) {
                supplierRegistrationId = ((Organization)supplierCtr.getEntity()).isForeign() ? "0000000000" : null;
            }
            Supplier supplier = new Supplier();
            supplier.setName(supplierFullName);
            supplier.setINN(supplierRegistrationId);
            return supplier;
        }
        return null;
    }

    public StatisticalData getStatisticalData(P var1);

    public boolean isStatisticalDataAvailable(P var1);

    public void newStatisticalData(P var1);

    public BigDecimal getAddCollect(P var1);

    default public VatDetalization getVendorVatDetalization(P product) {
        return null;
    }

    default public boolean isFareFopsRelevant(P product) {
        return this.getTicketType(product) != TicketType.REFERRAL;
    }

    default public String getGdsName(P product) {
        return null;
    }

    default public String getProviderName(P product) {
        return null;
    }

    default public String getGdsCurrency(P product) {
        return null;
    }

    default public Money getProductEquivalentFare(P product) {
        BigDecimal equivalentFare = this.getEquivalentFare(product);
        if (null == equivalentFare) {
            return null;
        }
        Money fare = new Money();
        fare.setValue(equivalentFare);
        fare.setCurrency((String)MiscUtil.guarded((Object)this.getGdsCurrency(product), (Object)PreferenceHelper.getLocalCurrency()));
        return fare;
    }

    default public void updateProductEquivalentFare(P product, ExchangeRateData rateData) {
    }

    default public Money getProductBaseFare(P product) {
        return this.getProductEquivalentFare(product);
    }

    default public Money getProductEquivalentPenalty(P product) {
        BigDecimal equivalentPenalty = this.getPenalty(product);
        if (null == equivalentPenalty) {
            return null;
        }
        Money penalty = new Money();
        penalty.setValue(equivalentPenalty);
        penalty.setCurrency((String)MiscUtil.guarded((Object)this.getGdsCurrency(product), (Object)PreferenceHelper.getLocalCurrency()));
        return penalty;
    }

    default public Money getProductBasePenalty(P product) {
        return this.getProductEquivalentPenalty(product);
    }

    default public Collection<BasePenalty> getProductBasePenalties(P product) {
        return null;
    }

    default public Collection<BasePenalty> getProductEquivalentPenalties(P product) {
        return null;
    }

    default public Collection<BasePenalty> getProductBaseCancellationPenalties(P product) {
        return null;
    }

    default public Collection<BasePenalty> getProductEquivalentCancellationPenalties(P product) {
        return null;
    }

    default public Collection<VendorAdditionalService> getProductBaseAdditionalServices(P product) {
        return null;
    }

    default public Collection<VendorAdditionalService> getProductEquivalentAdditionalServices(P product) {
        return null;
    }

    default public String getPreferredClientContractNumber(P product) {
        return null;
    }

    default public BigDecimal getObFees(P product) {
        return null;
    }

    public TravelSubject getDefaultTravelSubject();

    public P newInstance();

    default public EntityReference<UniversalProductDescription> getUniversalProductDescription(P product) {
        return null;
    }

    public void setAgent(P var1, EntityReference<Person> var2);

    public void setComments(P var1, String var2);

    public void setAgency(P var1, EntityReference<Organization> var2);

    public void setBlankOwner(P var1, EntityReference<Organization> var2);

    public void setBranch(P var1, EntityReference<Branch> var2);

    public void setSupplier(P var1, EntityReference<Organization> var2);

    public void setSubagency(P var1, EntityReference<Organization> var2);

    default public void setTechnicalProvider(P product, EntityReference<Organization> technicalProvider) {
    }

    public void setSalesPoint(P var1, EntityReference<SalesPoint> var2);

    public void changeFopsPaymentTypes(P var1, PaymentType var2, ContractType var3, boolean var4);

    public void changeFopsAgent(P var1, EntityReference<Person> var2, ContractType var3);

    public List<String> getFopsUids(P var1, ContractType var2);

    default public void setValidatorCode(P product, String code) {
    }

    public void setBlankType(P var1, DictionaryReference<BlankType> var2);

    public Money getBspCommissionValue(P var1);

    public Double getBspCommissionRate(P var1);

    public boolean removeProduct(P var1);

    public boolean removeRelatedProduct(P var1, BaseProduct var2);

    public boolean isAppropriateBillingItem(P var1, FinanceDocumentType var2, UniversalDocumentStatus var3, BillingItemIncludeMode var4, com.gridnine.xtrip.common.model.finance.BillingItem var5, List<com.gridnine.xtrip.common.model.finance.BillingItem> var6, List<com.gridnine.xtrip.common.model.finance.BillingItem> var7);

    default public boolean isVatIncludeBillingItem(P product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET;
    }

    public String getCities(P var1, Locale var2);

    public String getCountries(P var1, Locale var2);

    default public String getAddresses(P product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return null;
    }

    public Date getFirstStartDate(P var1);

    public Date getLastStartDate(P var1);

    public Date getFirstEndDate(P var1);

    public Date getLastEndDate(P var1);

    public String getDescriptionLine(P var1);

    public DictionaryReference<Airline> getCarrier(P var1);

    default public String getTrain(P product) {
        return null;
    }

    default public String getHotel(P product) {
        return null;
    }

    default public String getRoom(P product) {
        return null;
    }

    public boolean isContractRulesApplied(P var1);

    default public Double getGdsCurrencyRate(P product) {
        return null;
    }

    public boolean isSystemNumberDuplicateAllowed(P var1);

    public String getTourCode(P var1);

    public boolean isDuplicate(P var1);

    default public boolean isTripartiteDiscount(P product) {
        return false;
    }

    default public DictionaryReference<Principal> getPrincipal(P product) {
        return null;
    }

    default public boolean isUseShortName() {
        return false;
    }

    default public boolean hasSameSystemNumbers(P product) {
        return ProductHelper.hasSameSystemNumbers(product);
    }

    default public Set<String> getServiceClasses(P product, Locale locale) {
        return Collections.emptySet();
    }

    default public void setClientShipmentsDate(P product, Date date) {
        product.setShipmentsDate(date);
    }

    default public void setSubagentShipmentsDate(P product, Date date) {
        product.setShipmentsDateSubagent(date);
    }
}

