/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.handlers.FinanceDocumentHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;

public class AcceptanceCertificateHandler
implements FinanceDocumentHandler {
    @Override
    public FinanceDocumentType getFinanceDocumentType() {
        return FinanceDocumentType.ACCEPTANCE_CERTIFICATE;
    }

    @Override
    public boolean accept(BillingItem billingItem, Payment payment, FinanceDocumentSettings financeDocumentSettings) throws Exception {
        BillingItemSettings billingItemSettings;
        if (billingItem.getProductUids().isEmpty()) {
            return false;
        }
        if (financeDocumentSettings != null && (billingItemSettings = FinanceDocumentsHelper.getBillingItemSettings(financeDocumentSettings.getBillingItemsSettings(), billingItem.getServiceType())) != null && !billingItemSettings.isUseBillingItem()) {
            return false;
        }
        boolean paymentForRefund = FinanceDocumentsHelper.isPaymentForRefund(payment);
        if (billingItem.getServiceType() == ServiceType.FEE) {
            return paymentForRefund && BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)billingItem.getCommissionType()) || !paymentForRefund && !BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)billingItem.getCommissionType());
        }
        return true;
    }

    @Override
    public String getDocumentGroupId(BillingItem billingItem, Payment payment, FinanceDocumentSettings financeDocumentSettings) {
        return "acceptance_cetrificate";
    }
}

