/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.localization.routeLine.GeoLocationLocalizer;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeroexpressTicketHandler
implements ProductHandler<AeroexpressTicket> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, AeroexpressTicket product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return result;
        }
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
            }
            result.setTotalVat(totalPrice, 0.0);
            return result;
        }
        BigDecimal total = product.getEquivalentFare();
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (product.getPenalty() != null) {
            total = total.subtract(product.getPenalty());
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            total = total.abs().negate();
        }
        result.setTotalVat(total, 0.0);
        return result;
    }

    @Override
    public VatAmount calculateProductPrice(AeroexpressTicket product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(AeroexpressTicket product) {
        return L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_SHORT_PRODUCT_NAME", (Object[])new Object[]{GeneralProductHelper.getNonNullString(product.getSystemNumber()), GeneralProductHelper.getNonNullString(product.getStatus())});
    }

    @Override
    public String generateProductName(AeroexpressTicket product) {
        return L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_PRODUCT_NAME", (Object[])new Object[]{GeneralProductHelper.getNonNullString(product.getStatus()), GeneralProductHelper.getNonNullString(product.getSystemNumber()), AeroexpressTicketHelper.getRouteLine(product), product.getTraveller() != null ? " " + product.getTraveller().getName() : ""});
    }

    @Override
    public Date findFirstTravelDate(AeroexpressTicket product) {
        return product.getDepartureDate();
    }

    @Override
    public Date findLastTravelDate(AeroexpressTicket product) {
        return product.getDepartureDate();
    }

    @Override
    public List<String> getProductNumbers(AeroexpressTicket product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(AeroexpressTicket product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(AeroexpressTicket product) {
        return TravelSubject.AEROEXPRESS;
    }

    @Override
    public Date findIssueDate(AeroexpressTicket product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(AeroexpressTicket product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(AeroexpressTicket product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(AeroexpressTicket product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AeroexpressTicket)) continue;
            prods.add(this.createFinanceCapableProduct((AeroexpressTicket)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AeroexpressTicket)) continue;
            prods.add(this.createFinanceCapableProduct((AeroexpressTicket)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(AeroexpressTicket product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final AeroexpressTicket product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return AeroexpressTicketHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return AeroexpressTicketHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return AeroexpressTicketHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return AeroexpressTicketHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return AeroexpressTicketHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? AeroexpressTicketHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return AeroexpressTicketHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                String ETICKET_STR = L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_PRODUCT_E_TICKET", (Object[])new Object[0]) + " ";
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_PRODUCT_REFUND", (Object[])new Object[]{product.isEticket() ? ETICKET_STR : "", AeroexpressTicketHelper.getRouteLine(product), product.getClassOfService(), this.getDepartureDate(product), this.getExhangeInfo(product)});
                }
                return L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_PRODUCT_TICKET_INFO", (Object[])new Object[]{product.isEticket() ? ETICKET_STR : "", AeroexpressTicketHelper.getRouteLine(product), product.getClassOfService(), this.getDepartureDate(product), this.getExhangeInfo(product)});
            }

            private String getExhangeInfo(AeroexpressTicket prod) {
                if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
                    return "";
                }
                AeroexpressTicket firstSell = prod.getPreviousProduct().getPreviousProduct();
                Payment exchangePayment = null;
                block0: for (Payment payment : firstSell.getReservation().getBookingFile().getPayments()) {
                    for (BillingItem bi : payment.getBillingItems()) {
                        for (String uid : bi.getProductUids()) {
                            if (!firstSell.getUid().equals(uid)) continue;
                            exchangePayment = payment;
                            break block0;
                        }
                    }
                }
                return L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_PRODUCT_EXHANGE_INFO", (Object[])new Object[]{firstSell.getSystemNumber(), exchangePayment != null ? L10nResourcesManager.getStr((String)"AEROEXPRESS_TICKET_PRODUCT_EXHANGE_ACCOUNT", (Object[])new Object[]{TextUtil.buildFullNumber(exchangePayment)}) : ""});
            }

            private String getDepartureDate(AeroexpressTicket prod) {
                return prod.getDepartureDate() == null ? "???" : LocaleManager.get().getCurrentLocaleData().getDateFormat().format(prod.getDepartureDate());
            }

            @Override
            public BigDecimal getPenalty() {
                return product.getPenalty();
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return product.getTraveller();
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(AeroexpressTicket product) {
        return product.getTraveller() == null ? new ArrayList() : Collections.singletonList(product.getTraveller());
    }

    @Override
    public void replaceTraveller(AeroexpressTicket product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller.equals((Object)product.getTraveller())) {
            product.setTraveller(newTraveller);
        }
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(AeroexpressTicket product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.setTraveller(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void setOrReplaceTraveller(AeroexpressTicket product, Traveller newTraveller) {
        this.setOrReplaceTraveller(product, product.getTraveller(), newTraveller);
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<AeroexpressTicket> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(AeroexpressTicket product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(AeroexpressTicket product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(AeroexpressTicket product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(AeroexpressTicket product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(AeroexpressTicket product) {
        return ProductType.AEROEXPRESS;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.AEROEXPRESS).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.AEROEXPRESS_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(AeroexpressTicket product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(AeroexpressTicket product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(AeroexpressTicket product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = product.getEquivalentFare();
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : AeroexpressTicketHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(AeroexpressTicket product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(AeroexpressTicket product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(AeroexpressTicket product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(AeroexpressTicket product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(AeroexpressTicket product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(AeroexpressTicket product) {
        return ServiceLocationType.DOMESTIC;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, AeroexpressTicket product) {
        Date departure = product.getDepartureDate();
        if (momentOfTime.compareTo(departure) > 0) {
            return null;
        }
        return departure;
    }

    @Override
    public AeroexpressTicket getPreviousProduct(AeroexpressTicket product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(AeroexpressTicket product, AeroexpressTicket previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(AeroexpressTicket product, AeroexpressTicket nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public AeroexpressTicket getNextProduct(AeroexpressTicket product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(AeroexpressTicket product, BaseProduct relatedProduct) {
        product.setRelatedProduct((Product)relatedProduct);
    }

    @Override
    public List<BaseProduct> getRelatedProducts(AeroexpressTicket product) {
        return product.getRelatedProduct() != null ? Collections.singletonList(product.getRelatedProduct()) : Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(AeroexpressTicket product) {
        return product.getCancellationDetails();
    }

    @Override
    public ProductCategory getProductCategory(AeroexpressTicket product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(AeroexpressTicket product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(AeroexpressTicket product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(AeroexpressTicket product) {
        return product.getBlankType();
    }

    @Override
    public BigDecimal getEquivalentFare(AeroexpressTicket product) {
        return product.getEquivalentFare();
    }

    @Override
    public BigDecimal getServiceFare(AeroexpressTicket product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(AeroexpressTicket product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(AeroexpressTicket product) {
        return 0;
    }

    @Override
    public String getRouteLine(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getLocalizedRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(AeroexpressTicket product) {
        if (product == null) {
            return null;
        }
        return GeoLocationLocalizer.get().encode(product.getDepartureLocation(), product.getArrivalLocation());
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getContractRelations(product).stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(AeroexpressTicket product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(AeroexpressTicket product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(AeroexpressTicket product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(AeroexpressTicket product) {
        return product.getPcc();
    }

    @Override
    public void updateProductFops(AeroexpressTicket product) {
        AeroexpressTicketHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(AeroexpressTicket product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(AeroexpressTicket product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(AeroexpressTicket product) {
        return product.getProvider();
    }

    @Override
    public PassengerStatus getPassengerStatus(AeroexpressTicket product) {
        return null;
    }

    @Override
    public boolean isHoldable(AeroexpressTicket product) {
        return false;
    }

    @Override
    public Date getUnholdDate(AeroexpressTicket product) {
        return null;
    }

    @Override
    public String getValidatorNumber(AeroexpressTicket product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(AeroexpressTicket product) {
        return product.getPassengerType();
    }

    @Override
    public StatisticalData getStatisticalData(AeroexpressTicket product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(AeroexpressTicket product) {
        return true;
    }

    @Override
    public void newStatisticalData(AeroexpressTicket product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(AeroexpressTicket product) {
        return null;
    }

    @Override
    public VatDetalization getVendorVatDetalization(AeroexpressTicket product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentFare(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        GeneralProductHelper.addVatComponent(vatComponents, product.getPenalty(), product.getPenaltyVatValue(), VatBasisType.PENALTY);
        result.setDetalized(true);
        return result;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.AEROEXPRESS;
    }

    @Override
    public AeroexpressTicket newInstance() {
        return new AeroexpressTicket();
    }

    @Override
    public String getCarrierNumber(AeroexpressTicket product) {
        return null;
    }

    @Override
    public void setAgent(AeroexpressTicket product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(AeroexpressTicket product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(AeroexpressTicket product, EntityReference<Organization> agency) {
        AeroexpressTicketHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(AeroexpressTicket product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(AeroexpressTicket product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(AeroexpressTicket product, EntityReference<Organization> supplier) {
        AeroexpressTicketHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(AeroexpressTicket product, EntityReference<Organization> subagency) {
        AeroexpressTicketHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(AeroexpressTicket product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(AeroexpressTicket product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(AeroexpressTicketHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(AeroexpressTicketHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(AeroexpressTicketHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(AeroexpressTicket product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(AeroexpressTicket product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(AeroexpressTicket product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return AeroexpressTicketHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return AeroexpressTicketHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return AeroexpressTicketHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(AeroexpressTicket product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    @Override
    public Money getBspCommissionValue(AeroexpressTicket product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(AeroexpressTicket product) {
        return null;
    }

    @Override
    public boolean removeProduct(AeroexpressTicket product) {
        return AeroexpressTicketHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(AeroexpressTicket product, BaseProduct relatedProduct) {
        return AeroexpressTicketHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(AeroexpressTicket product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if (type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) {
            if (Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
                return false;
            }
            if (billingItem.getServiceType() != ServiceType.FEE) {
                return false;
            }
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return billingItem.getServiceType() == ServiceType.TICKET || billingItem.getServiceType() == ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && mode == BillingItemIncludeMode.ALL_EXCEPT_TICKET) {
            return billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public boolean isVatIncludeBillingItem(AeroexpressTicket product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    @Override
    public String getCities(AeroexpressTicket product, Locale locale) {
        return AeroexpressTicketHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(AeroexpressTicket product, Locale locale) {
        return AeroexpressTicketHelper.getCountries(product, locale);
    }

    @Override
    public Date getFirstStartDate(AeroexpressTicket product) {
        return product.getDepartureDate();
    }

    @Override
    public Date getLastStartDate(AeroexpressTicket product) {
        return product.getDepartureDate();
    }

    @Override
    public Date getFirstEndDate(AeroexpressTicket product) {
        return null;
    }

    @Override
    public Date getLastEndDate(AeroexpressTicket product) {
        return null;
    }

    @Override
    public String getDescriptionLine(AeroexpressTicket product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(AeroexpressTicket product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(AeroexpressTicket product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(AeroexpressTicket product) {
        return false;
    }

    @Override
    public String getRfic(AeroexpressTicket product) {
        return null;
    }

    @Override
    public String getRfisc(AeroexpressTicket product) {
        return null;
    }

    @Override
    public String getTourCode(AeroexpressTicket product) {
        return null;
    }

    @Override
    public boolean isDuplicate(AeroexpressTicket product) {
        return false;
    }

    @Override
    public String getGdsCurrency(AeroexpressTicket product) {
        return "RUB";
    }
}

