/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.standard.AgentTouchProductHelper;
import com.gridnine.xtrip.common.model.helpers.AgentTouchHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AgentTouchProductHandler
implements ProductHandler<AgentTouch> {
    @Override
    public Class<AgentTouch> getProductClass() {
        return AgentTouch.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, AgentTouch product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    @Override
    public VatAmount calculateProductPrice(AgentTouch product, ContractType ctype) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    @Override
    public String generateShortProductName(AgentTouch product) {
        return L10nResourcesManager.getStr((String)"AGENTTOUCH_SHORT_PRODUCT_NAME", (Object[])new Object[0]);
    }

    @Override
    public String generateProductName(AgentTouch product) {
        return this.generateShortProductName(product);
    }

    @Override
    public Date findFirstTravelDate(AgentTouch product) {
        return null;
    }

    @Override
    public Date findLastTravelDate(AgentTouch product) {
        return null;
    }

    @Override
    public List<String> getProductNumbers(AgentTouch product) {
        return Collections.emptyList();
    }

    @Override
    public EntityReference<Person> findIssuingAgent(AgentTouch product) {
        return null;
    }

    @Override
    public TravelSubject findTravelSubject(AgentTouch product) {
        return null;
    }

    @Override
    public Date findIssueDate(AgentTouch product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(AgentTouch product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(AgentTouch product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(AgentTouch product) {
        return true;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AgentTouch)) continue;
            prods.add(this.createFinanceCapableProduct((AgentTouch)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AgentTouch)) continue;
            prods.add(this.createFinanceCapableProduct((AgentTouch)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(AgentTouch product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final AgentTouch product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return AgentTouchProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return AgentTouchProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return AgentTouchProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return AgentTouchProductHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return ProductStatus.SELL;
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return AgentTouchProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return AgentTouchProductHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                return AgentTouchProductHandler.this.generateShortProductName(product);
            }

            @Override
            public BigDecimal getPenalty() {
                return BigDecimal.ZERO;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return null;
            }

            @Override
            public Traveller getTraveller() {
                return null;
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(AgentTouch product) {
        return Collections.emptyList();
    }

    @Override
    public void replaceTraveller(AgentTouch product, Traveller oldTraveller, Traveller newTraveller) {
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
    }

    @Override
    public void setOrReplaceTraveller(AgentTouch product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller != null) {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<AgentTouch> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(AgentTouch product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(AgentTouch product) {
        return ProductStatus.SELL;
    }

    @Override
    public ProductStatus getBaseStatus(AgentTouch product) {
        return ProductStatus.SELL;
    }

    @Override
    public void setStatus(AgentTouch product, ProductStatus productStatus) {
    }

    @Override
    public ProductType getProductType(AgentTouch product) {
        return ProductType.AGENT_TOUCH;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.AGENT_TOUCH).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.AGENT_TOUCH_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(AgentTouch product) {
        return null;
    }

    @Override
    public EntityReference<Branch> getBranch(AgentTouch product) {
        return null;
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(AgentTouch product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        for (GeneralProductCommission comm : AgentTouchProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber((String)this.getProductNumbers(product).stream().findFirst().orElse(null));
            Money fareComm = new Money();
            fareComm.setValue(comm.getEquivalentAmount());
            fareComm.setCurrency(DictHelper.getEquivCurrency());
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(AgentTouch product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(AgentTouch product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(AgentTouch product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(AgentTouch product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(AgentTouch product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(AgentTouch product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, AgentTouch product) {
        return null;
    }

    @Override
    public AgentTouch getPreviousProduct(AgentTouch product) {
        return null;
    }

    @Override
    public void setPreviousProduct(AgentTouch product, AgentTouch previousProduct) {
    }

    @Override
    public void setNextProduct(AgentTouch product, AgentTouch nextProduct) {
    }

    @Override
    public AgentTouch getNextProduct(AgentTouch product) {
        return null;
    }

    @Override
    public void addRelatedProduct(AgentTouch product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(AgentTouch product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(AgentTouch product) {
        return null;
    }

    @Override
    public ProductCategory getProductCategory(AgentTouch product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(AgentTouch product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(AgentTouch product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(AgentTouch product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(AgentTouch product) {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getServiceFare(AgentTouch product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(AgentTouch product) {
        return BigDecimal.ZERO;
    }

    @Override
    public int getConjunction(AgentTouch product) {
        return 0;
    }

    @Override
    public String getRouteLine(AgentTouch product) {
        return null;
    }

    @Override
    public String getLocalizedRouteLine(AgentTouch product) {
        return null;
    }

    @Override
    public String getCodeRouteLine(AgentTouch product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(AgentTouch product) {
        return AgentTouchProductHelper.getContractRelations(product).stream().map(this::cloneRelationData).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public SalesChain getSalesChain(AgentTouch product) {
        return AgentTouchProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(AgentTouch product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelations(product.getContractRelations(), relations);
    }

    @Override
    public TicketType getTicketType(AgentTouch product) {
        return TicketType.OWN;
    }

    @Override
    public void setTicketType(AgentTouch product, TicketType ticketType) {
    }

    @Override
    public String getPCC(AgentTouch product) {
        return null;
    }

    @Override
    public void updateProductFops(AgentTouch product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(AgentTouch product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(AgentTouch product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(AgentTouch product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(AgentTouch product) {
        return null;
    }

    @Override
    public boolean isHoldable(AgentTouch product) {
        return false;
    }

    @Override
    public Date getUnholdDate(AgentTouch product) {
        return null;
    }

    @Override
    public String getValidatorNumber(AgentTouch product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(AgentTouch product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(AgentTouch product) {
        return null;
    }

    @Override
    public boolean isStatisticalDataAvailable(AgentTouch product) {
        return false;
    }

    @Override
    public void newStatisticalData(AgentTouch product) {
    }

    @Override
    public BigDecimal getAddCollect(AgentTouch product) {
        return BigDecimal.ZERO;
    }

    private GeneralProductContractRelationData cloneRelationData(GeneralProductContractRelationData source) {
        GeneralProductContractRelationData dest = new GeneralProductContractRelationData();
        dest.setUid(source.getUid());
        dest.setDescription(source.getDescription());
        try {
            XCloneModelHelper.copy((BaseEntity)source.getServiceData(), (BaseEntity)dest.getServiceData());
            XCloneModelHelper.copy((BaseEntity)source.getGeneralData(), (BaseEntity)dest.getGeneralData());
            dest.getCommissions().addAll(source.getCommissions());
            this.cloneFops(source, dest);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone entity ", e);
        }
        return dest;
    }

    private void cloneFops(GeneralProductContractRelationData item, GeneralProductContractRelationData generalData) throws Exception {
        for (GeneralProductFop fop : item.getFops()) {
            GeneralProductFop clonedFop = new GeneralProductFop();
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)clonedFop);
            generalData.getFops().add(clonedFop);
        }
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    @Override
    public AgentTouch newInstance() {
        return new AgentTouch();
    }

    @Override
    public String getCarrierNumber(AgentTouch product) {
        return null;
    }

    @Override
    public void setAgent(AgentTouch product, EntityReference<Person> agent) {
    }

    @Override
    public void setComments(AgentTouch product, String comments) {
    }

    @Override
    public void setAgency(AgentTouch product, EntityReference<Organization> agency) {
    }

    @Override
    public void setBlankOwner(AgentTouch product, EntityReference<Organization> blankOwner) {
    }

    @Override
    public void setBranch(AgentTouch product, EntityReference<Branch> branch) {
    }

    @Override
    public void setSupplier(AgentTouch product, EntityReference<Organization> supplier) {
    }

    @Override
    public void setSubagency(AgentTouch product, EntityReference<Organization> subagency) {
    }

    @Override
    public void setSalesPoint(AgentTouch product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(AgentTouch product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(AgentTouchProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(AgentTouchProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(AgentTouchProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(AgentTouch product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(AgentTouch product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(AgentTouch product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return AgentTouchProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return AgentTouchProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return AgentTouchProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(AgentTouch product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(AgentTouch product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(AgentTouch product) {
        return null;
    }

    @Override
    public boolean removeProduct(AgentTouch product) {
        return AgentTouchHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(AgentTouch product, BaseProduct relatedProduct) {
        return AgentTouchHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(AgentTouch product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(AgentTouch product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(AgentTouch product, Locale locale) {
        return null;
    }

    @Override
    public Date getFirstStartDate(AgentTouch product) {
        return null;
    }

    @Override
    public Date getLastStartDate(AgentTouch product) {
        return null;
    }

    @Override
    public Date getFirstEndDate(AgentTouch product) {
        return null;
    }

    @Override
    public Date getLastEndDate(AgentTouch product) {
        return null;
    }

    @Override
    public String getDescriptionLine(AgentTouch product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(AgentTouch product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(AgentTouch product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(AgentTouch product) {
        return false;
    }

    @Override
    public String getRfic(AgentTouch product) {
        return null;
    }

    @Override
    public String getRfisc(AgentTouch product) {
        return null;
    }

    @Override
    public String getTourCode(AgentTouch product) {
        return null;
    }

    @Override
    public boolean isDuplicate(AgentTouch product) {
        return false;
    }
}

