/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescriptionIndex;
import java.util.Collections;
import java.util.List;

public class AgentTouchProductHelper {
    public static List<GeneralProductFop> getVendorFops(AgentTouch product) {
        GeneralProductContractRelationData relation = AgentTouchProductHelper.getVendorContractRelation(product);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static GeneralProductContractRelationData getVendorContractRelation(AgentTouch prod) {
        return (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(prod.getContractRelations(), ContractType.VENDOR);
    }

    public static List<GeneralProductFop> getSubagentFops(AgentTouch product, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)product, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(AgentTouch product) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)product).getFops();
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(AgentTouch product, ContractType ctype) {
        List<GeneralProductCommission> commissions = GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
        return commissions == null ? Collections.emptyList() : commissions;
    }

    public static SalesChain getSalesChain(AgentTouch product) {
        if (product.getSalesChain() == null) {
            product.setSalesChain(AgentTouchProductHelper.createSalesChain());
        }
        return product.getSalesChain();
    }

    public static EntityReference<Organization> getSupplier(AgentTouch prod) {
        return GeneralProductHelper.getContractor(AgentTouchProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(AgentTouch prod, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor(AgentTouchProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getSubagency(AgentTouch prod) {
        return GeneralProductHelper.getContractor(AgentTouchProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(AgentTouch prod, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor(AgentTouchProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static EntityReference<Organization> getAgency(AgentTouch prod) {
        return GeneralProductHelper.getContractor(AgentTouchProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(AgentTouch prod, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor(AgentTouchProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(AgentTouch product) {
        if (AgentTouchProductHelper.getSalesChain(product) != null) {
            return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)product);
        }
        return Collections.emptyList();
    }

    private static SalesChain createSalesChain() {
        SalesChain salesChain = new SalesChain();
        EntityContainer ctr = EntityStorage.get().find(SalesChainDescriptionIndex.class, SalesChainDescriptionIndex.Property.predefinedType.name(), (Object)PredefinedSalesChainType.OWN);
        if (ctr != null) {
            salesChain.setDescription(ctr.toReference());
        }
        return salesChain;
    }
}

