/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CarRentalProductHandler
implements ProductHandler<CarRentalProduct> {
    @Override
    public Class<CarRentalProduct> getProductClass() {
        return CarRentalProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, CarRentalProduct product) {
        return GeneralProductHelper.calculateProductPrice(relation, this, product);
    }

    @Override
    public VatAmount calculateProductPrice(CarRentalProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(CarRentalProduct product) {
        return L10nResourcesManager.getStr((String)"CAR_RENTAL_SHORT_PRODUCT_NAME", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", product.getStatus() != null ? product.getStatus() : ""});
    }

    @Override
    public String generateProductName(CarRentalProduct product) {
        return L10nResourcesManager.getStr((String)"CAR_RENTAL_PRODUCT_NAME", (Object[])new Object[]{TextUtil.nonBlank((String)product.getSystemNumber()) ? " " + product.getSystemNumber().trim() : "", product.getStatus() != null ? " \u2014 " + product.getStatus() : ""});
    }

    @Override
    public List<String> getProductNumbers(CarRentalProduct product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(CarRentalProduct product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(CarRentalProduct product) {
        return TravelSubject.CAR_RENTAL;
    }

    @Override
    public Date findIssueDate(CarRentalProduct product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(CarRentalProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(CarRentalProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(CarRentalProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        Set<GeneralProductHelper.FinanceCapableProduct> prods = products.stream().filter(bp -> bp instanceof CarRentalProduct).map(bp -> this.createFinanceCapableProduct((CarRentalProduct)bp)).collect(Collectors.toSet());
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        List prods = products.stream().filter(bp -> bp instanceof CarRentalProduct).map(bp -> this.createFinanceCapableProduct((CarRentalProduct)bp)).collect(Collectors.toCollection(ArrayList::new));
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(CarRentalProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    @Override
    public Collection<Traveller> getTravellers(CarRentalProduct product) {
        return product.getTravellers();
    }

    @Override
    public void replaceTraveller(CarRentalProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(CarRentalProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<CarRentalProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(CarRentalProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public Date findLastTravelDate(CarRentalProduct product) {
        return product.getEndDate();
    }

    @Override
    public ProductStatus getStatus(CarRentalProduct product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(CarRentalProduct product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(CarRentalProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(CarRentalProduct product) {
        return ProductType.CAR_RENTAL;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.CAR_RENTAL).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.CAR;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(CarRentalProduct product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(CarRentalProduct product) {
        return null;
    }

    @Override
    public boolean isCompleted(CarRentalProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(CarRentalProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(CarRentalProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(CarRentalProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(CarRentalProduct product) {
        return new ArrayList<MCOFeesSource>();
    }

    @Override
    public TransportationType getTransportationType(CarRentalProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(CarRentalProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, CarRentalProduct product) {
        return product.getStartDate();
    }

    @Override
    public CarRentalProduct getPreviousProduct(CarRentalProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(CarRentalProduct product, CarRentalProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(CarRentalProduct product, CarRentalProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public CarRentalProduct getNextProduct(CarRentalProduct product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(CarRentalProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(CarRentalProduct product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCategory getProductCategory(CarRentalProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(CarRentalProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(CarRentalProduct product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(CarRentalProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(CarRentalProduct product) {
        return product.getEquivalentFare() != null ? product.getEquivalentFare().getValue() : null;
    }

    @Override
    public BigDecimal getServiceFare(CarRentalProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(CarRentalProduct product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(CarRentalProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(CarRentalProduct product) {
        return CarRentalProductHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(CarRentalProduct product) {
        return CarRentalProductHelper.getRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(CarRentalProduct product) {
        if (product == null) {
            return null;
        }
        return CarRentalProductHelper.getRouteLine(product);
    }

    @Override
    public Date findFirstTravelDate(CarRentalProduct product) {
        return product.getStartDate();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(CarRentalProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(CarRentalProduct product) {
        return CarRentalProductHelper.getContractRelations(product).stream().map(this::cloneRelationData).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public SalesChain getSalesChain(CarRentalProduct product) {
        return CarRentalProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(CarRentalProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(CarRentalProduct product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(CarRentalProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(CarRentalProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(CarRentalProduct product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(CarRentalProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(CarRentalProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(CarRentalProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(CarRentalProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(CarRentalProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(CarRentalProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(CarRentalProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(CarRentalProduct product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(CarRentalProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(CarRentalProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(CarRentalProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(CarRentalProduct product) {
        return null;
    }

    private VatAmount calculateProductPriceBasic(CarRentalProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    private GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final CarRentalProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return CarRentalProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return CarRentalProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return CarRentalProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return CarRentalProductHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return CarRentalProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? CarRentalProductHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return CarRentalProductHandler.this.calculateProductPriceBasic(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"CAR_RENTAL_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"CAR_RENTAL_PRODUCT_INFO", (Object[])new Object[0]);
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return (Traveller)product.getTravellers().get(0);
            }
        };
    }

    private GeneralProductContractRelationData cloneRelationData(GeneralProductContractRelationData source) {
        GeneralProductContractRelationData dest = new GeneralProductContractRelationData();
        dest.setUid(source.getUid());
        dest.setDescription(source.getDescription());
        try {
            XCloneModelHelper.copy((BaseEntity)source.getServiceData(), (BaseEntity)dest.getServiceData());
            XCloneModelHelper.copy((BaseEntity)source.getGeneralData(), (BaseEntity)dest.getGeneralData());
            dest.getCommissions().addAll(source.getCommissions());
            this.cloneFops(source, dest);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone entity ", e);
        }
        return dest;
    }

    private void cloneFops(GeneralProductContractRelationData item, GeneralProductContractRelationData generalData) throws Exception {
        for (GeneralProductFop fop : item.getFops()) {
            GeneralProductFop clonedFop = new GeneralProductFop();
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)clonedFop);
            generalData.getFops().add(clonedFop);
        }
    }

    @Override
    public VatDetalization getVendorVatDetalization(CarRentalProduct product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        if (product.getEquivalentFare() != null) {
            GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentFare().getValue(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        }
        GeneralProductHelper.addVatComponent(vatComponents, product.getPenalty(), product.getPenaltyVatValue(), VatBasisType.PENALTY);
        result.setDetalized(true);
        return result;
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.CAR_RENTAL;
    }

    @Override
    public CarRentalProduct newInstance() {
        return new CarRentalProduct();
    }

    @Override
    public String getCarrierNumber(CarRentalProduct product) {
        return null;
    }

    @Override
    public void setAgent(CarRentalProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(CarRentalProduct product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(CarRentalProduct product, EntityReference<Organization> agency) {
        CarRentalProductHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(CarRentalProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(CarRentalProduct product, EntityReference<Branch> branch) {
    }

    @Override
    public void setSupplier(CarRentalProduct product, EntityReference<Organization> supplier) {
        CarRentalProductHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(CarRentalProduct product, EntityReference<Organization> subagency) {
        CarRentalProductHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(CarRentalProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(CarRentalProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(CarRentalProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(CarRentalProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(CarRentalProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(CarRentalProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(CarRentalProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(CarRentalProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return CarRentalProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return CarRentalProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return CarRentalProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(CarRentalProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(CarRentalProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(CarRentalProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(CarRentalProduct product) {
        return CarRentalProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(CarRentalProduct product, BaseProduct relatedProduct) {
        return CarRentalProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(CarRentalProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(CarRentalProduct product, Locale locale) {
        return CarRentalProductHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(CarRentalProduct product, Locale locale) {
        return CarRentalProductHelper.getCountries(product, locale);
    }

    @Override
    public Date getFirstStartDate(CarRentalProduct product) {
        return product.getStartDate();
    }

    @Override
    public Date getLastStartDate(CarRentalProduct product) {
        return product.getStartDate();
    }

    @Override
    public Date getFirstEndDate(CarRentalProduct product) {
        return product.getEndDate();
    }

    @Override
    public Date getLastEndDate(CarRentalProduct product) {
        return product.getEndDate();
    }

    @Override
    public String getDescriptionLine(CarRentalProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(CarRentalProduct product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(CarRentalProduct product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(CarRentalProduct product) {
        return false;
    }

    @Override
    public String getRfic(CarRentalProduct product) {
        return null;
    }

    @Override
    public String getRfisc(CarRentalProduct product) {
        return null;
    }

    @Override
    public String getTourCode(CarRentalProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(CarRentalProduct product) {
        return false;
    }

    @Override
    public String getGdsCurrency(CarRentalProduct product) {
        return Optional.ofNullable(product.getEquivalentFare()).map(Money::getCurrency).orElse(null);
    }
}

