/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.FinanceDocumentHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import java.math.BigDecimal;

public class CashOrderHandler
implements FinanceDocumentHandler {
    @Override
    public FinanceDocumentType getFinanceDocumentType() {
        return FinanceDocumentType.CASH_ORDER;
    }

    @Override
    public boolean accept(BillingItem billingItem, Payment payment, FinanceDocumentSettings financeDocumentSettings) {
        boolean paymentForRefund;
        BillingItemSettings billingItemSettings;
        if (billingItem.getProductUids().isEmpty()) {
            return false;
        }
        if (financeDocumentSettings != null && (billingItemSettings = FinanceDocumentsHelper.getBillingItemSettings(financeDocumentSettings.getBillingItemsSettings(), billingItem.getServiceType())) != null) {
            if (billingItem.getServiceType() == ServiceType.FEE) {
                BigDecimal amount;
                BigDecimal bigDecimal = amount = billingItem.getAmount() != null ? billingItem.getAmount().getTotal() : null;
                if (amount != null && amount.compareTo(BigDecimal.ZERO) >= 0 && !billingItemSettings.isUseBillingItem()) {
                    return false;
                }
            } else if (!billingItemSettings.isUseBillingItem()) {
                return false;
            }
        }
        if (!(paymentForRefund = FinanceDocumentsHelper.isPaymentForRefund(payment))) {
            return false;
        }
        if (billingItem.getServiceType() == ServiceType.FEE) {
            EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(billingItem.getCommissionType());
            if (commissionPropertiesContainer == null) {
                return false;
            }
            BaseCommissionProperties commissionProperties = (BaseCommissionProperties)commissionPropertiesContainer.getEntity();
            if (commissionProperties instanceof FeeProperties) {
                FeeProperties fee = (FeeProperties)commissionProperties;
                return fee.getOperation() != Operation.REFUND && fee.getOperation() != Operation.EXCHANGE;
            }
            return commissionProperties instanceof PaymentFeeProperties;
        }
        return true;
    }

    @Override
    public String getDocumentGroupId(BillingItem billingItem, Payment payment, FinanceDocumentSettings financeDocumentSettings) {
        return "cash_order";
    }
}

