/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;

public class CountryHandler
extends DictionaryHandler<Country> {
    @Override
    protected void registerProperties() {
        this.registerCodeVariants();
        this.registerTranslations();
        this.registerSpellVariants();
        this.registerProperty(new DictionaryHandler.Property<Country>(){

            @Override
            public boolean match(Country dictTo, Country dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return dictTo.isRuPassportAllowed() || !dictFrom.isRuPassportAllowed();
            }

            @Override
            public void merge(Country dictTo, Country dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setRuPassportAllowed(dictFrom.isRuPassportAllowed());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"RU_PASSPORT_ALLOWED", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Country.Property.ruPassportAllowed;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Country>(){

            @Override
            public boolean match(Country dictTo, Country dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return TextUtil.isBlank((String)dictFrom.getPhoneCode()) || TextUtil.isSame((String)dictFrom.getPhoneCode(), (String)dictTo.getPhoneCode());
            }

            @Override
            public void merge(Country dictTo, Country dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setPhoneCode(dictFrom.getPhoneCode());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"PHONE_CODE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Country.Property.phoneCode;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Country>(){

            @Override
            public boolean match(Country dictTo, Country dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictTo.getRegions().containsAll(dictFrom.getRegions())) {
                    return true;
                }
                for (DictionaryReference regionRef : dictFrom.getRegions()) {
                    GeoRegion region;
                    if (dictTo.getRegions().contains(regionRef) || (region = DictSyncHelper.search(regionRef, relatedDictionaries, GeoRegion.class)) == null || dictTo.getRegions().contains(region.toReference())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void merge(Country dictTo, Country dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                for (DictionaryReference regionRef : dictFrom.getRegions()) {
                    GeoRegion region;
                    if (dictTo.getRegions().contains(regionRef) || (region = DictSyncHelper.search(regionRef, relatedDictionaries, GeoRegion.class)) == null) continue;
                    GeoRegionReference regionReference = region.toReference();
                    if (dictTo.getRegions().contains(regionReference)) continue;
                    dictTo.getRegions().add(regionReference);
                }
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"REGIONS", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Country.Property.regions;
            }
        });
    }

    @Override
    public Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(Country dict) {
        return Collections.unmodifiableCollection(dict.getRegions());
    }

    @Override
    public Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses() {
        return Collections.singletonList(GeoRegion.class);
    }

    @Override
    public Class<Country> getDictionaryClass() {
        return Country.class;
    }
}

