/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.localization.routeLine.CountryLocalizer;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InsuranceTouristicHandler
implements ProductHandler<InsuranceTouristic> {
    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, InsuranceTouristic product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return result;
        }
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
            }
            result.setTotalVat(totalPrice, 0.0);
            return result;
        }
        BigDecimal total = product.getEquivalentSum();
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            total = total.negate();
        }
        result.setTotalVat(total, 0.0);
        return result;
    }

    @Override
    public VatAmount calculateProductPrice(InsuranceTouristic product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(InsuranceTouristic product) {
        return L10nResourcesManager.getStr((String)"INSURANCE_TOURISTIC_SHORT_PRODUCT_NAME", (Object[])new Object[]{GeneralProductHelper.getNonNullString(product.getSystemNumber()), GeneralProductHelper.getNonNullString(product.getStatus())});
    }

    @Override
    public String generateProductName(InsuranceTouristic product) {
        return this.composeProductName(product, this.getInsured(product));
    }

    @Override
    public Date findFirstTravelDate(InsuranceTouristic product) {
        return product.getStartDate();
    }

    @Override
    public List<String> getProductNumbers(InsuranceTouristic product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(InsuranceTouristic product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(InsuranceTouristic product) {
        return TravelSubject.INSURANCE_TOURISTIC;
    }

    @Override
    public Date findIssueDate(InsuranceTouristic product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(InsuranceTouristic product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(InsuranceTouristic product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(InsuranceTouristic product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof InsuranceTouristic)) continue;
            prods.add(this.createFinanceCapableProduct((InsuranceTouristic)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof InsuranceTouristic)) continue;
            prods.add(this.createFinanceCapableProduct((InsuranceTouristic)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(InsuranceTouristic product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    @Override
    public Collection<Traveller> getTravellers(InsuranceTouristic product) {
        LinkedHashSet<Traveller> lst = new LinkedHashSet<Traveller>();
        Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getPolicyHolderUid());
        if (traveller != null) {
            lst.add(traveller);
        }
        for (String travellerUid : product.getTravellersUids()) {
            traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), travellerUid);
            if (traveller == null) continue;
            lst.add(traveller);
        }
        return lst;
    }

    @Override
    public void replaceTraveller(InsuranceTouristic product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller.getUid().equals(product.getPolicyHolderUid())) {
            product.setPolicyHolderUid(newTraveller.getUid());
        }
        Collections.replaceAll(product.getTravellersUids(), oldTraveller.getUid(), newTraveller.getUid());
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(InsuranceTouristic product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellersUids().add(newTraveller.getUid());
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<InsuranceTouristic> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(InsuranceTouristic product) {
        return product.getSalesPoint();
    }

    @Override
    public Date findLastTravelDate(InsuranceTouristic product) {
        return product.getEndDate();
    }

    @Override
    public ProductStatus getStatus(InsuranceTouristic product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(InsuranceTouristic product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(InsuranceTouristic product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(InsuranceTouristic product) {
        return ProductType.INSURANCE_TOURISTIC;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.INSURANCE_TOURISTIC).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.INSURANCE_TOURISTIC_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(InsuranceTouristic product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(InsuranceTouristic product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(InsuranceTouristic product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = product.getEquivalentSum();
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : InsuranceTouristicHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(InsuranceTouristic product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(InsuranceTouristic product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(InsuranceTouristic product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(InsuranceTouristic product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(InsuranceTouristic product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(InsuranceTouristic product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, InsuranceTouristic product) {
        if (momentOfTime.compareTo(product.getStartDate()) > 0) {
            return null;
        }
        return product.getStartDate();
    }

    @Override
    public InsuranceTouristic getPreviousProduct(InsuranceTouristic product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(InsuranceTouristic product, InsuranceTouristic previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(InsuranceTouristic product, InsuranceTouristic nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public InsuranceTouristic getNextProduct(InsuranceTouristic product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(InsuranceTouristic product, BaseProduct relatedProduct) {
        product.setRelatedProductUid(relatedProduct.getUid());
    }

    @Override
    public List<BaseProduct> getRelatedProducts(InsuranceTouristic product) {
        Object relatedProduct = product.getRelatedProductUid() != null ? (Object)BookingHelper.findProductByUid(product.getRelatedProductUid(), product.getReservation().getBookingFile()) : null;
        return relatedProduct != null ? Collections.singletonList(relatedProduct) : Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(InsuranceTouristic product) {
        return product.getCancellationDetails();
    }

    @Override
    public ProductCategory getProductCategory(InsuranceTouristic product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(InsuranceTouristic product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(InsuranceTouristic product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(InsuranceTouristic product) {
        return product.getBlankType();
    }

    @Override
    public BigDecimal getEquivalentFare(InsuranceTouristic product) {
        return product.getEquivalentSum();
    }

    @Override
    public BigDecimal getServiceFare(InsuranceTouristic product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(InsuranceTouristic product) {
        return null;
    }

    @Override
    public int getConjunction(InsuranceTouristic product) {
        return 0;
    }

    @Override
    public String getRouteLine(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getLocalizedRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(InsuranceTouristic product) {
        if (product == null) {
            return null;
        }
        return CountryLocalizer.get().encode(new CountryReference(product.getCountryName()));
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getContractRelations(product).stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(InsuranceTouristic product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(InsuranceTouristic product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(InsuranceTouristic product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(InsuranceTouristic product) {
        return null;
    }

    @Override
    public void updateProductFops(InsuranceTouristic product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(InsuranceTouristic product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(InsuranceTouristic product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(InsuranceTouristic product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(InsuranceTouristic product) {
        return null;
    }

    @Override
    public boolean isHoldable(InsuranceTouristic product) {
        return false;
    }

    @Override
    public Date getUnholdDate(InsuranceTouristic product) {
        return null;
    }

    @Override
    public String getValidatorNumber(InsuranceTouristic product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(InsuranceTouristic product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(InsuranceTouristic product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(InsuranceTouristic product) {
        return true;
    }

    @Override
    public void newStatisticalData(InsuranceTouristic product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(InsuranceTouristic product) {
        return null;
    }

    @Override
    public VatDetalization getVendorVatDetalization(InsuranceTouristic product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentSum(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        result.setDetalized(true);
        return result;
    }

    public String composeProductName(InsuranceTouristic product, Traveller insured) {
        return L10nResourcesManager.getStr((String)"INSURANCE_TOURISTIC_PRODUCT_NAME", (Object[])new Object[]{GeneralProductHelper.getNonNullString(product.getStatus()), GeneralProductHelper.getNonNullString(product.getSystemNumber()), GeneralProductHelper.getNonNullString(insured != null ? insured.getName() : null), GeneralProductHelper.getNonNullString(product.getCountryName())});
    }

    private Traveller getInsured(InsuranceTouristic product) {
        if (product.getTravellersUids().isEmpty()) {
            return null;
        }
        return BookingHelper.findTraveller(product.getReservation().getBookingFile(), (String)product.getTravellersUids().get(0));
    }

    private GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final InsuranceTouristic product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return InsuranceTouristicHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return InsuranceTouristicHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return InsuranceTouristicHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return InsuranceTouristicHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return InsuranceTouristicHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? InsuranceTouristicHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return InsuranceTouristicHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return false;
            }

            @Override
            public String getCommonPart() {
                Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getPolicyHolderUid());
                if (product.getStatus() == ProductStatus.REFUND) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0422\u0443\u0440\u0438\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0438 %s (\u0441\u0442\u0440\u0430\u0445\u043e\u0432\u0430\u0442\u0435\u043b\u044c: %s, \u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0435\u0431\u044b\u0432\u0430\u043d\u0438\u044f: %s)", product.getSystemNumber(), traveller != null ? traveller.getName() : "", product.getCountryName());
                }
                return String.format("\u0422\u0443\u0440\u0438\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0430 %s (\u0441\u0442\u0440\u0430\u0445\u043e\u0432\u0430\u0442\u0435\u043b\u044c: %s, \u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0435\u0431\u044b\u0432\u0430\u043d\u0438\u044f: %s)", product.getSystemNumber(), traveller != null ? traveller.getName() : "", product.getCountryName());
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getPolicyHolderUid());
            }
        };
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.INSURANCE_TOURISTIC;
    }

    @Override
    public InsuranceTouristic newInstance() {
        return new InsuranceTouristic();
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public String getCarrierNumber(InsuranceTouristic product) {
        return null;
    }

    @Override
    public void setAgent(InsuranceTouristic product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(InsuranceTouristic product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(InsuranceTouristic product, EntityReference<Organization> agency) {
        InsuranceTouristicHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(InsuranceTouristic product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(InsuranceTouristic product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(InsuranceTouristic product, EntityReference<Organization> supplier) {
        InsuranceTouristicHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(InsuranceTouristic product, EntityReference<Organization> subagency) {
        InsuranceTouristicHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(InsuranceTouristic product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(InsuranceTouristic product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(InsuranceTouristicHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(InsuranceTouristicHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(InsuranceTouristicHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(InsuranceTouristic product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(InsuranceTouristic product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(InsuranceTouristic product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return InsuranceTouristicHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return InsuranceTouristicHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return InsuranceTouristicHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(InsuranceTouristic product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    @Override
    public Money getBspCommissionValue(InsuranceTouristic product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(InsuranceTouristic product) {
        return null;
    }

    @Override
    public boolean removeProduct(InsuranceTouristic product) {
        return InsuranceTouristicHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(InsuranceTouristic product, BaseProduct relatedProduct) {
        return InsuranceTouristicHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(InsuranceTouristic product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(InsuranceTouristic product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(InsuranceTouristic product, Locale locale) {
        return InsuranceTouristicHelper.getCountries(product, locale);
    }

    @Override
    public Date getFirstStartDate(InsuranceTouristic product) {
        return product.getStartDate();
    }

    @Override
    public Date getLastStartDate(InsuranceTouristic product) {
        return product.getStartDate();
    }

    @Override
    public Date getFirstEndDate(InsuranceTouristic product) {
        return product.getEndDate();
    }

    @Override
    public Date getLastEndDate(InsuranceTouristic product) {
        return product.getEndDate();
    }

    @Override
    public String getDescriptionLine(InsuranceTouristic product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(InsuranceTouristic product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(InsuranceTouristic product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(InsuranceTouristic product) {
        return false;
    }

    @Override
    public String getRfic(InsuranceTouristic product) {
        return null;
    }

    @Override
    public String getRfisc(InsuranceTouristic product) {
        return null;
    }

    @Override
    public String getTourCode(InsuranceTouristic product) {
        return null;
    }

    @Override
    public boolean isDuplicate(InsuranceTouristic product) {
        return false;
    }
}

