/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.MiscProduct;
import com.gridnine.xtrip.common.model.booking.MiscProductItem;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OldMiscProductHandler
implements ProductHandler<MiscProduct> {
    @Override
    public Class<MiscProduct> getProductClass() {
        return MiscProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, MiscProduct product) {
        return this.calculateProductPrice(product, (ContractType)null);
    }

    @Override
    public VatAmount calculateProductPrice(MiscProduct product, ContractType ctype) {
        VatAmount result = new VatAmount();
        BigDecimal total = BigDecimal.ZERO;
        for (MiscProductItem item : product.getItems()) {
            if (item.getAmount() == null) continue;
            total = total.add(item.getAmount());
        }
        result.setTotalVat(total, MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        return result;
    }

    @Override
    public String generateShortProductName(MiscProduct product) {
        return this.generateProductName(product);
    }

    @Override
    public String generateProductName(MiscProduct product) {
        return TextUtil.isBlank((String)product.getName()) ? "Other" : product.getName();
    }

    @Override
    public Date findFirstTravelDate(MiscProduct product) {
        return null;
    }

    @Override
    public Date findLastTravelDate(MiscProduct product) {
        return null;
    }

    @Override
    public List<String> getProductNumbers(MiscProduct product) {
        return Collections.emptyList();
    }

    @Override
    public EntityReference<Person> findIssuingAgent(MiscProduct product) {
        return null;
    }

    @Override
    public TravelSubject findTravelSubject(MiscProduct product) {
        return null;
    }

    @Override
    public Date findIssueDate(MiscProduct product) {
        return null;
    }

    @Override
    public Date findLocalIssueDate(MiscProduct product) {
        return null;
    }

    @Override
    public void setIssueDate(MiscProduct product, Date issueDate) {
    }

    @Override
    public boolean includeInFinanceDocuments(MiscProduct product) {
        return true;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) {
        LinkedHashSet<FinanceDocument> result = new LinkedHashSet<FinanceDocument>();
        for (FinanceDocument finDoc : availableDocuments) {
            if (finDoc.getType() != FinanceDocumentType.INVOICE) continue;
            result.add(finDoc);
        }
        return result;
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) {
        HashMap map = new HashMap();
        for (BaseProduct prod : products) {
            if (!(prod instanceof MiscProduct)) continue;
            MiscProduct misc = (MiscProduct)prod;
            FinanceDocumentsHelper.updateMap(map, FinanceDocumentsHelper.getDescription(this.generateProductName(misc), this.calculateProductPrice(misc, ContractType.CLIENT)), misc);
        }
        ArrayList<BillingItem> result = new ArrayList<BillingItem>();
        for (List list : map.values()) {
            if (list.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (MiscProduct product : list) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.TICKET);
            item.setName(this.generateProductName((MiscProduct)list.get(0)));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (MiscProduct product : list) {
                VatAmount price = this.calculateProductPrice(product, ContractType.CLIENT);
                total = total.add(price.getTotal());
                vat = vat.add(price.getVatAmount());
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            result.add(item);
        }
        return result;
    }

    @Override
    public String getBillingItemName(MiscProduct product, String relatedInvoiceNumber) {
        return this.generateProductName(product);
    }

    @Override
    public Collection<Traveller> getTravellers(MiscProduct product) {
        return new ArrayList<Traveller>();
    }

    @Override
    public void replaceTraveller(MiscProduct product, Traveller oldTraveller, Traveller newTraveller) {
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(MiscProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller != null) {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<MiscProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(MiscProduct product) {
        return null;
    }

    @Override
    public ProductStatus getStatus(MiscProduct product) {
        return null;
    }

    @Override
    public ProductStatus getBaseStatus(MiscProduct product) {
        return null;
    }

    @Override
    public void setStatus(MiscProduct product, ProductStatus productStatus) {
    }

    @Override
    public ProductType getProductType(MiscProduct product) {
        return ProductType.OLD_MISC_PRODUCT;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.OLD_MISC_PRODUCT).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return null;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(MiscProduct product) {
        return null;
    }

    @Override
    public EntityReference<Branch> getBranch(MiscProduct product) {
        return null;
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(MiscProduct product) {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompleted(MiscProduct product) {
        return false;
    }

    @Override
    public void setCompleted(MiscProduct product, boolean completed) {
    }

    @Override
    public boolean isChecked(MiscProduct product) {
        return false;
    }

    @Override
    public void setChecked(MiscProduct product, boolean checked) {
    }

    @Override
    public TransportationType getTransportationType(MiscProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(MiscProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, MiscProduct product) {
        return null;
    }

    @Override
    public MiscProduct getPreviousProduct(MiscProduct product) {
        return null;
    }

    @Override
    public void setPreviousProduct(MiscProduct product, MiscProduct previousProduct) {
    }

    @Override
    public void setNextProduct(MiscProduct product, MiscProduct nextProduct) {
    }

    @Override
    public MiscProduct getNextProduct(MiscProduct product) {
        return null;
    }

    @Override
    public void addRelatedProduct(MiscProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(MiscProduct product) {
        ArrayList<BaseProduct> relatedProducts = new ArrayList<BaseProduct>();
        for (MiscProductItem item : product.getItems()) {
            Object relatedProduct;
            if (item.getProductUid() == null || (relatedProduct = BookingHelper.findProductByUid(item.getProductUid(), product.getReservation().getBookingFile())) == null) continue;
            relatedProducts.add((BaseProduct)relatedProduct);
        }
        return relatedProducts;
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(MiscProduct product) {
        return null;
    }

    @Override
    public ProductCategory getProductCategory(MiscProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(MiscProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(MiscProduct product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(MiscProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(MiscProduct product) {
        return null;
    }

    @Override
    public BigDecimal getServiceFare(MiscProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(MiscProduct product) {
        return null;
    }

    @Override
    public int getConjunction(MiscProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(MiscProduct product) {
        return null;
    }

    @Override
    public String getLocalizedRouteLine(MiscProduct product) {
        return null;
    }

    @Override
    public String getCodeRouteLine(MiscProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(MiscProduct product) {
        return Collections.emptyList();
    }

    @Override
    public SalesChain getSalesChain(MiscProduct product) {
        SalesChain result = new SalesChain();
        result.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.OWN, null));
        return result;
    }

    @Override
    public void updateContractRelations(MiscProduct product, List<GeneralProductContractRelationData> relations) {
    }

    @Override
    public TicketType getTicketType(MiscProduct product) {
        return null;
    }

    @Override
    public void setTicketType(MiscProduct product, TicketType ticketType) {
    }

    @Override
    public String getPCC(MiscProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(MiscProduct product) {
    }

    @Override
    public void setContractRulesApplied(MiscProduct product, boolean value) {
    }

    @Override
    public List<ValidationMessage> getValidationMessages(MiscProduct product) {
        return Collections.emptyList();
    }

    @Override
    public EntityReference<Organization> getProvider(MiscProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(MiscProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(MiscProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(MiscProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(MiscProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(MiscProduct product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(MiscProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(MiscProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(MiscProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(MiscProduct product) {
        return null;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    @Override
    public MiscProduct newInstance() {
        return new MiscProduct();
    }

    @Override
    public String getCarrierNumber(MiscProduct product) {
        return null;
    }

    @Override
    public void setAgent(MiscProduct product, EntityReference<Person> agent) {
    }

    @Override
    public void setComments(MiscProduct product, String comments) {
    }

    @Override
    public void setAgency(MiscProduct product, EntityReference<Organization> agency) {
    }

    @Override
    public void setBlankOwner(MiscProduct product, EntityReference<Organization> blankOwner) {
    }

    @Override
    public void setBranch(MiscProduct product, EntityReference<Branch> branch) {
    }

    @Override
    public void setSupplier(MiscProduct product, EntityReference<Organization> supplier) {
    }

    @Override
    public void setSubagency(MiscProduct product, EntityReference<Organization> subagency) {
    }

    @Override
    public void setSalesPoint(MiscProduct product, EntityReference<SalesPoint> salesPoint) {
    }

    @Override
    public void changeFopsPaymentTypes(MiscProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
    }

    @Override
    public void changeFopsAgent(MiscProduct product, EntityReference<Person> agent, ContractType contractType) {
    }

    @Override
    public List<String> getFopsUids(MiscProduct product, ContractType contractType) {
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(MiscProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(MiscProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(MiscProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(MiscProduct product) {
        return true;
    }

    @Override
    public boolean removeRelatedProduct(MiscProduct product, BaseProduct relatedProduct) {
        return true;
    }

    @Override
    public boolean isAppropriateBillingItem(MiscProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        return false;
    }

    @Override
    public boolean isVatIncludeBillingItem(MiscProduct product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        return false;
    }

    @Override
    public String getCities(MiscProduct product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(MiscProduct product, Locale locale) {
        return null;
    }

    @Override
    public Date getFirstStartDate(MiscProduct product) {
        return null;
    }

    @Override
    public Date getLastStartDate(MiscProduct product) {
        return null;
    }

    @Override
    public Date getFirstEndDate(MiscProduct product) {
        return null;
    }

    @Override
    public Date getLastEndDate(MiscProduct product) {
        return null;
    }

    @Override
    public String getDescriptionLine(MiscProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(MiscProduct product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(MiscProduct product) {
        return false;
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(MiscProduct product) {
        return false;
    }

    @Override
    public String getRfic(MiscProduct product) {
        return null;
    }

    @Override
    public String getRfisc(MiscProduct product) {
        return null;
    }

    @Override
    public String getTourCode(MiscProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(MiscProduct product) {
        return false;
    }
}

