/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaxiProductHandler
implements ProductHandler<TaxiProduct> {
    @Override
    public Class<TaxiProduct> getProductClass() {
        return TaxiProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, TaxiProduct product) {
        return GeneralProductHelper.calculateProductPrice(relation, this, product);
    }

    @Override
    public VatAmount calculateProductPrice(TaxiProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(TaxiProduct product) {
        return L10nResourcesManager.getStr((String)"TAXI_SHORT_PRODUCT_NAME", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", product.getStatus() != null ? product.getStatus() : ""});
    }

    @Override
    public String generateProductName(TaxiProduct product) {
        return L10nResourcesManager.getStr((String)"TAXI_PRODUCT_NAME", (Object[])new Object[]{TextUtil.nonBlank((String)product.getSystemNumber()) ? " " + product.getSystemNumber().trim() : "", product.getStatus() != null ? " \u2014 " + product.getStatus() : ""});
    }

    @Override
    public List<String> getProductNumbers(TaxiProduct product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(TaxiProduct product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(TaxiProduct product) {
        return TravelSubject.TAXI;
    }

    @Override
    public Date findIssueDate(TaxiProduct product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(TaxiProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(TaxiProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(TaxiProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        Set<GeneralProductHelper.FinanceCapableProduct> prods = products.stream().filter(TaxiProduct.class::isInstance).map(TaxiProduct.class::cast).map(this::createFinanceCapableProduct).collect(Collectors.toSet());
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        List prods = products.stream().filter(bp -> bp instanceof TaxiProduct).map(bp -> this.createFinanceCapableProduct((TaxiProduct)bp)).collect(Collectors.toCollection(ArrayList::new));
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(TaxiProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    @Override
    public Collection<Traveller> getTravellers(TaxiProduct product) {
        return product.getTravellers();
    }

    @Override
    public void replaceTraveller(TaxiProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(TaxiProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<TaxiProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(TaxiProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public Date findLastTravelDate(TaxiProduct product) {
        return product.getFinishDate();
    }

    @Override
    public ProductStatus getStatus(TaxiProduct product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(TaxiProduct product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(TaxiProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(TaxiProduct product) {
        return ProductType.TAXI;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.TAXI).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.TAXI;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(TaxiProduct product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(TaxiProduct product) {
        return product.getBranch();
    }

    @Override
    public boolean isCompleted(TaxiProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(TaxiProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(TaxiProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(TaxiProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(TaxiProduct product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = null;
        if (product.getEquivalentFare() != null) {
            fareValue = product.getEquivalentFare().getValue();
        }
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : GeneralProductHelper.getUnmodifiableCommissions(product, null)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public TransportationType getTransportationType(TaxiProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(TaxiProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, TaxiProduct product) {
        return product.getDateStart();
    }

    @Override
    public TaxiProduct getPreviousProduct(TaxiProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(TaxiProduct product, TaxiProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(TaxiProduct product, TaxiProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public TaxiProduct getNextProduct(TaxiProduct product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(TaxiProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(TaxiProduct product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCategory getProductCategory(TaxiProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(TaxiProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(TaxiProduct product) {
        return product.getTaxes().stream().map(GeneralProductHelper::toGeneralProductTax).collect(Collectors.toList());
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(TaxiProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(TaxiProduct product) {
        return product.getEquivalentFare() != null ? product.getEquivalentFare().getValue() : null;
    }

    @Override
    public BigDecimal getServiceFare(TaxiProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(TaxiProduct product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(TaxiProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(TaxiProduct product) {
        return TaxiHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(TaxiProduct product) {
        return TaxiHelper.getRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(TaxiProduct product) {
        if (product == null) {
            return null;
        }
        return TaxiHelper.getRouteLine(product);
    }

    @Override
    public Date findFirstTravelDate(TaxiProduct product) {
        return product.getDateStart();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(TaxiProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(TaxiProduct product) {
        return TaxiHelper.getContractRelations(product).stream().map(this::cloneRelationData).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public SalesChain getSalesChain(TaxiProduct product) {
        return TaxiHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(TaxiProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(TaxiProduct product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(TaxiProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(TaxiProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(TaxiProduct product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(TaxiProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(TaxiProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(TaxiProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(TaxiProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(TaxiProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(TaxiProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(TaxiProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(TaxiProduct product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(TaxiProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(TaxiProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(TaxiProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(TaxiProduct product) {
        return null;
    }

    private VatAmount calculateProductPriceBasic(TaxiProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    private GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final TaxiProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return TaxiProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return TaxiHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return TaxiHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return TaxiHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return TaxiHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? TaxiProductHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return TaxiProductHandler.this.calculateProductPriceBasic(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"TAXI_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"TAXI_PRODUCT_INFO", (Object[])new Object[0]);
            }

            @Override
            public BigDecimal getPenalty() {
                return product.getPenalty();
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                if (product.getTravellers().isEmpty()) {
                    return null;
                }
                return (Traveller)product.getTravellers().get(0);
            }
        };
    }

    private GeneralProductContractRelationData cloneRelationData(GeneralProductContractRelationData source) {
        GeneralProductContractRelationData dest = new GeneralProductContractRelationData();
        dest.setUid(source.getUid());
        dest.setDescription(source.getDescription());
        try {
            XCloneModelHelper.copy((BaseEntity)source.getServiceData(), (BaseEntity)dest.getServiceData());
            XCloneModelHelper.copy((BaseEntity)source.getGeneralData(), (BaseEntity)dest.getGeneralData());
            dest.getCommissions().addAll(source.getCommissions());
            this.cloneFops(source, dest);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone entity ", e);
        }
        return dest;
    }

    private void cloneFops(GeneralProductContractRelationData item, GeneralProductContractRelationData generalData) throws Exception {
        for (GeneralProductFop fop : item.getFops()) {
            GeneralProductFop clonedFop = new GeneralProductFop();
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)clonedFop);
            generalData.getFops().add(clonedFop);
        }
    }

    @Override
    public VatDetalization getVendorVatDetalization(TaxiProduct product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        if (product.getEquivalentFare() != null) {
            GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentFare().getValue(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        }
        GeneralProductHelper.addVatComponent(vatComponents, product.getPenalty(), product.getPenaltyVatValue(), VatBasisType.PENALTY);
        result.setDetalized(true);
        return result;
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.TAXI;
    }

    @Override
    public TaxiProduct newInstance() {
        return new TaxiProduct();
    }

    @Override
    public String getCarrierNumber(TaxiProduct product) {
        return null;
    }

    @Override
    public void setAgent(TaxiProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(TaxiProduct product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(TaxiProduct product, EntityReference<Organization> agency) {
        TaxiHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(TaxiProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(TaxiProduct product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(TaxiProduct product, EntityReference<Organization> supplier) {
        TaxiHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(TaxiProduct product, EntityReference<Organization> subagency) {
        TaxiHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(TaxiProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(TaxiProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(TaxiHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(TaxiHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(TaxiHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(TaxiProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(TaxiProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(TaxiProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return TaxiHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return TaxiHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return TaxiHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(TaxiProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(TaxiProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(TaxiProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(TaxiProduct product) {
        return TaxiHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(TaxiProduct product, BaseProduct relatedProduct) {
        return TaxiHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(TaxiProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(TaxiProduct product, Locale locale) {
        return TaxiHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(TaxiProduct product, Locale locale) {
        return TaxiHelper.getCountries(product, locale);
    }

    @Override
    public String getAddresses(TaxiProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return TaxiHelper.getAddresses(product, locale, translitRules);
    }

    @Override
    public Date getFirstStartDate(TaxiProduct product) {
        return product.getDateStart();
    }

    @Override
    public Date getLastStartDate(TaxiProduct product) {
        return product.getDateStart();
    }

    @Override
    public Date getFirstEndDate(TaxiProduct product) {
        return product.getFinishDate();
    }

    @Override
    public Date getLastEndDate(TaxiProduct product) {
        return product.getFinishDate();
    }

    @Override
    public String getDescriptionLine(TaxiProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(TaxiProduct product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(TaxiProduct product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(TaxiProduct product) {
        return true;
    }

    @Override
    public String getRfic(TaxiProduct product) {
        return null;
    }

    @Override
    public String getRfisc(TaxiProduct product) {
        return null;
    }

    @Override
    public String getTourCode(TaxiProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(TaxiProduct product) {
        return false;
    }

    @Override
    public String getGdsCurrency(TaxiProduct product) {
        return Optional.ofNullable(product.getEquivalentFare()).map(Money::getCurrency).orElse(null);
    }
}

