/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.VendorAdditionalService;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TransferHandler
implements ProductHandler<Transfer> {
    @Override
    public Class<Transfer> getProductClass() {
        return Transfer.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, Transfer product) {
        return GeneralProductHelper.calculateProductPrice(relation, this, product);
    }

    @Override
    public VatAmount calculateProductPrice(Transfer product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(Transfer product) {
        return L10nResourcesManager.getStr((String)"TRANSFER_SHORT_PRODUCT_NAME", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", product.getStatus() != null ? product.getStatus() : ""});
    }

    @Override
    public String generateProductName(Transfer product) {
        return L10nResourcesManager.getStr((String)"TRANSFER_PRODUCT_NAME", (Object[])new Object[]{TextUtil.nonBlank((String)product.getSystemNumber()) ? " " + product.getSystemNumber().trim() : "", product.getStatus() != null ? " \u2014 " + product.getStatus() : ""}) + (product.getTravellers().size() > 0 ? " " + ((Traveller)product.getTravellers().get(0)).getName() : "");
    }

    @Override
    public List<String> getProductNumbers(Transfer product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(Transfer product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(Transfer product) {
        return TravelSubject.TRANSFER;
    }

    @Override
    public Date findIssueDate(Transfer product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(Transfer product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(Transfer product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(Transfer product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        Set<GeneralProductHelper.FinanceCapableProduct> prods = products.stream().filter(Transfer.class::isInstance).map(Transfer.class::cast).map(this::createFinanceCapableProduct).collect(Collectors.toSet());
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        List prods = products.stream().filter(bp -> bp instanceof Transfer).map(bp -> this.createFinanceCapableProduct((Transfer)bp)).collect(Collectors.toCollection(ArrayList::new));
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(Transfer product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    @Override
    public Collection<Traveller> getTravellers(Transfer product) {
        return product.getTravellers();
    }

    @Override
    public void replaceTraveller(Transfer product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(Transfer product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<Transfer> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(Transfer product) {
        return product.getSalesPoint();
    }

    @Override
    public Date findLastTravelDate(Transfer product) {
        return product.getEndDate();
    }

    @Override
    public ProductStatus getStatus(Transfer product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(Transfer product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(Transfer product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(Transfer product) {
        return ProductType.TRANSFER;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.TRANSFER).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.TRANSFER;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(Transfer product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(Transfer product) {
        return product.getBranch();
    }

    @Override
    public boolean isCompleted(Transfer product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(Transfer product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(Transfer product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(Transfer product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(Transfer product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = null;
        if (product.getEquivalentFare() != null) {
            fareValue = product.getEquivalentFare().getValue();
        }
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : GeneralProductHelper.getUnmodifiableCommissions(product, null)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public TransportationType getTransportationType(Transfer product) {
        return TransferHelper.getTransportationType(product);
    }

    @Override
    public ServiceLocationType getServiceLocationType(Transfer product) {
        TransportationType transportationType = this.getTransportationType(product);
        return transportationType == TransportationType.DOMESTIC || transportationType == TransportationType.NONE ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, Transfer product) {
        return product.getStartDate();
    }

    @Override
    public Transfer getPreviousProduct(Transfer product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(Transfer product, Transfer previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(Transfer product, Transfer nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public Transfer getNextProduct(Transfer product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(Transfer product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(Transfer product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCategory getProductCategory(Transfer product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(Transfer product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(Transfer product) {
        return product.getTaxes().stream().map(GeneralProductHelper::toGeneralProductTax).collect(Collectors.toList());
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(Transfer product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(Transfer product) {
        return product.getEquivalentFare() != null ? product.getEquivalentFare().getValue() : null;
    }

    @Override
    public BigDecimal getServiceFare(Transfer product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(Transfer product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(Transfer product) {
        return 0;
    }

    @Override
    public String getRouteLine(Transfer product) {
        return TransferHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(Transfer product) {
        return TransferHelper.getRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(Transfer product) {
        if (product == null) {
            return null;
        }
        return TransferHelper.getRouteLine(product);
    }

    @Override
    public Date findFirstTravelDate(Transfer product) {
        return product.getStartDate();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(Transfer product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(Transfer product) {
        return TransferHelper.getContractRelations(product).stream().map(this::cloneRelationData).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public SalesChain getSalesChain(Transfer product) {
        return TransferHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(Transfer product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(Transfer product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(Transfer product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(Transfer product) {
        return null;
    }

    @Override
    public void updateProductFops(Transfer product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(Transfer product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(Transfer product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(Transfer product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(Transfer product) {
        return null;
    }

    @Override
    public boolean isHoldable(Transfer product) {
        return false;
    }

    @Override
    public Date getUnholdDate(Transfer product) {
        return null;
    }

    @Override
    public String getValidatorNumber(Transfer product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(Transfer product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(Transfer product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(Transfer product) {
        return true;
    }

    @Override
    public void newStatisticalData(Transfer product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(Transfer product) {
        return null;
    }

    private VatAmount calculateProductPriceBasic(Transfer product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    private GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final Transfer product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return TransferHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return TransferHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return TransferHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return TransferHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return TransferHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? TransferHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return TransferHandler.this.calculateProductPriceBasic(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"TRANSFER_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"TRANSFER_PRODUCT_INFO", (Object[])new Object[0]);
            }

            @Override
            public BigDecimal getPenalty() {
                return product.getPenalty();
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                if (product.getTravellers().isEmpty()) {
                    return null;
                }
                return (Traveller)product.getTravellers().get(0);
            }
        };
    }

    private GeneralProductContractRelationData cloneRelationData(GeneralProductContractRelationData source) {
        GeneralProductContractRelationData dest = new GeneralProductContractRelationData();
        dest.setUid(source.getUid());
        dest.setDescription(source.getDescription());
        try {
            XCloneModelHelper.copy((BaseEntity)source.getServiceData(), (BaseEntity)dest.getServiceData());
            XCloneModelHelper.copy((BaseEntity)source.getGeneralData(), (BaseEntity)dest.getGeneralData());
            dest.getCommissions().addAll(source.getCommissions());
            this.cloneFops(source, dest);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone entity ", e);
        }
        return dest;
    }

    private void cloneFops(GeneralProductContractRelationData item, GeneralProductContractRelationData generalData) throws Exception {
        for (GeneralProductFop fop : item.getFops()) {
            GeneralProductFop clonedFop = new GeneralProductFop();
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)clonedFop);
            generalData.getFops().add(clonedFop);
        }
    }

    @Override
    public VatDetalization getVendorVatDetalization(Transfer product) {
        Collection<VendorAdditionalService> additionalServices;
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        if (product.getEquivalentFare() != null) {
            GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentFare().getValue(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        }
        if ((additionalServices = this.getProductEquivalentAdditionalServices(product)) != null) {
            Map<Double, VatComponent> serviceVatComponents = additionalServices.stream().filter(service -> service.getAmount() != null).collect(Collectors.toMap(VendorAdditionalService::getVatRate, this::createVatComponent, this::mergeVatComponents));
            vatComponents.addAll(serviceVatComponents.values());
        }
        GeneralProductHelper.addVatComponent(vatComponents, product.getPenalty(), product.getPenaltyVatValue(), VatBasisType.PENALTY);
        result.setDetalized(true);
        return result;
    }

    private VatComponent createVatComponent(VendorAdditionalService service) {
        VatComponent component = new VatComponent();
        component.setBasis(service.getAmount().getValue());
        component.setRate(service.getVatRate());
        component.setSum(service.getVatAmount());
        component.getBasisTypes().add(VatBasisType.SERVICE);
        return component;
    }

    private VatComponent mergeVatComponents(VatComponent vc1, VatComponent vc2) {
        vc1.setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vc1.getBasis(), vc2.getBasis()}));
        vc1.setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vc1.getSum(), vc2.getSum()}));
        return vc1;
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.TRANSFER;
    }

    @Override
    public Transfer newInstance() {
        return new Transfer();
    }

    @Override
    public String getCarrierNumber(Transfer product) {
        return null;
    }

    @Override
    public void setAgent(Transfer product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(Transfer product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(Transfer product, EntityReference<Organization> agency) {
        TransferHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(Transfer product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(Transfer product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(Transfer product, EntityReference<Organization> supplier) {
        TransferHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(Transfer product, EntityReference<Organization> subagency) {
        TransferHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(Transfer product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(Transfer product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(TransferHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(TransferHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(TransferHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(Transfer product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(Transfer product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(Transfer product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return TransferHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return TransferHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return TransferHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(Transfer product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(Transfer product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(Transfer product) {
        return null;
    }

    @Override
    public boolean removeProduct(Transfer product) {
        return TransferHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(Transfer product, BaseProduct relatedProduct) {
        return TransferHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(Transfer product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(Transfer product, Locale locale) {
        return TransferHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(Transfer product, Locale locale) {
        return TransferHelper.getCountries(product, locale);
    }

    @Override
    public String getAddresses(Transfer product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return TransferHelper.getAddresses(product, locale, translitRules);
    }

    @Override
    public Date getFirstStartDate(Transfer product) {
        return product.getStartDate();
    }

    @Override
    public Date getLastStartDate(Transfer product) {
        return product.getStartDate();
    }

    @Override
    public Date getFirstEndDate(Transfer product) {
        return product.getEndDate();
    }

    @Override
    public Date getLastEndDate(Transfer product) {
        return product.getEndDate();
    }

    @Override
    public String getDescriptionLine(Transfer product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(Transfer product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(Transfer product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(Transfer product) {
        return false;
    }

    @Override
    public String getRfic(Transfer product) {
        return null;
    }

    @Override
    public String getRfisc(Transfer product) {
        return null;
    }

    @Override
    public String getTourCode(Transfer product) {
        return null;
    }

    @Override
    public boolean isDuplicate(Transfer product) {
        return false;
    }

    @Override
    public String getGdsCurrency(Transfer product) {
        return Optional.ofNullable(product.getEquivalentFare()).map(Money::getCurrency).orElse(null);
    }

    @Override
    public boolean hasSameSystemNumbers(Transfer product) {
        return TransferHelper.hasSameSystemNumbers(product);
    }
}

