/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterRole;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductFinanceDocumentBillingItemsParameters;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.localization.routeLine.GeoLocationLocalizer;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductHandler
implements ProductHandler<UniversalProduct> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, UniversalProduct product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (status == ProductStatus.VOID) {
            return result;
        }
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
            }
            result.setTotalVat(totalPrice, UniversalProductHandler.isHasVat(product) ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue() : 0.0);
            return result;
        }
        BigDecimal total = UniversalProductHelper.calculateTotalCost(product);
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            total = total.negate();
        }
        result.setTotalVat(total, UniversalProductHandler.isHasVat(product) ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue() : 0.0);
        return result;
    }

    @Override
    public String getGdsCurrency(UniversalProduct product) {
        return product.getEquivalentCurrency();
    }

    private static boolean isHasVat(UniversalProduct product) {
        EntityContainer supplierCtr;
        if (!product.isHasVat()) {
            return false;
        }
        EntityReference<Organization> supplier = UniversalProductHelper.getSupplier(product);
        EntityContainer descr = EntityStorage.get().resolve(product.getDescription());
        if (descr != null && ((UniversalProductDescription)descr.getEntity()).isBlankOwnerAndSupplierAreAgency()) {
            supplier = GeneralProductHelper.getAgency((BaseProduct)product);
        }
        return (supplierCtr = EntityStorage.get().resolve(supplier)) == null || !((Organization)supplierCtr.getEntity()).isSimpleTaxed();
    }

    @Override
    public VatAmount calculateProductPrice(UniversalProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(UniversalProduct product) {
        String productName = L10nResourcesManager.getStr((String)"UNIVERSAL_PRODUCT_NAME", (Object[])new Object[0]);
        return String.format("%s %s %s", product.getDescription() == null ? productName : product.getDescription().getCaption(), GeneralProductHelper.getNonNullString(product.getSystemNumber()), GeneralProductHelper.getNonNullString(product.getStatus()));
    }

    @Override
    public String generateProductName(UniversalProduct product) {
        return UniversalProductHelper.generateProductName(product);
    }

    @Override
    public Date findFirstTravelDate(UniversalProduct product) {
        return UniversalProductHelper.getFirstTravelDate(product);
    }

    @Override
    public Date findLastTravelDate(UniversalProduct product) {
        return UniversalProductHelper.getLastTravelDate(product);
    }

    @Override
    public List<String> getProductNumbers(UniversalProduct product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(UniversalProduct product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(UniversalProduct product) {
        return TravelSubject.OTHER;
    }

    @Override
    public Date findIssueDate(UniversalProduct product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(UniversalProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(UniversalProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(UniversalProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof UniversalProduct)) continue;
            prods.add(this.createFinanceCapableProduct((UniversalProduct)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof UniversalProduct)) continue;
            prods.add(this.createFinanceCapableProduct((UniversalProduct)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(UniversalProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final UniversalProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return UniversalProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return UniversalProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return UniversalProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return UniversalProductHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return UniversalProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? UniversalProductHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return UniversalProductHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return UniversalProductHandler.isHasVat(product);
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 %s %s", product.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", UniversalProductHelper.generateProductName(product));
                }
                return String.format("%s %s, ($group_info)%s", product.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", UniversalProductHelper.generateProductName(product), this.getExhangeInfo(product));
            }

            private String getExhangeInfo(UniversalProduct prod) {
                if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
                    return "";
                }
                UniversalProduct firstSell = prod.getPreviousProduct().getPreviousProduct();
                Payment exchangePayment = null;
                block0: for (Payment payment : firstSell.getReservation().getBookingFile().getPayments()) {
                    for (BillingItem bi : payment.getBillingItems()) {
                        for (String uid : bi.getProductUids()) {
                            if (!firstSell.getUid().equals(uid)) continue;
                            exchangePayment = payment;
                            break block0;
                        }
                    }
                }
                return String.format("(\u0421 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0433\u043e \u0432 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s%s)", firstSell.getSystemNumber(), exchangePayment != null ? String.format(", \u0441\u0447\u0435\u0442 \u2116 %s", TextUtil.buildFullNumber(exchangePayment)) : "");
            }

            @Override
            public BigDecimal getPenalty() {
                return product.getPenalty();
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return product.getTravellersUids().isEmpty() ? null : BookingHelper.findTraveller(product.getReservation().getBookingFile(), (String)product.getTravellersUids().get(0));
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(UniversalProduct product) {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        for (String travellerUid : product.getTravellersUids()) {
            Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), travellerUid);
            if (traveller == null) continue;
            result.add(traveller);
        }
        return result;
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public void replaceTraveller(UniversalProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellersUids(), oldTraveller.getUid(), newTraveller.getUid());
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(UniversalProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellersUids().add(newTraveller.getUid());
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<UniversalProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(UniversalProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(UniversalProduct product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(UniversalProduct product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(UniversalProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(UniversalProduct product) {
        return ProductType.MISC_PRODUCT;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.MISC_PRODUCT).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityReference<Organization> getBlankOwner(UniversalProduct product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(UniversalProduct product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(UniversalProduct product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal taxesSum = BigDecimal.ZERO;
        for (GeneralProductTax t : product.getTaxes()) {
            if (t == null || t.getEquivalentAmount() == null) continue;
            taxesSum = taxesSum.add(t.getEquivalentAmount());
        }
        BigDecimal fareValue = product.getEquivalentFare();
        if (fareValue != null) {
            fareValue = fareValue.add(taxesSum);
        }
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : UniversalProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(UniversalProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(UniversalProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(UniversalProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(UniversalProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(UniversalProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(UniversalProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, UniversalProduct product) {
        if (momentOfTime.compareTo(this.findFirstTravelDate(product)) > 0) {
            return null;
        }
        return this.findFirstTravelDate(product);
    }

    @Override
    public UniversalProduct getPreviousProduct(UniversalProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(UniversalProduct product, UniversalProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(UniversalProduct product, UniversalProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public UniversalProduct getNextProduct(UniversalProduct product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(UniversalProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(UniversalProduct product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(UniversalProduct product) {
        return product.getCancellationDetails();
    }

    @Override
    public ProductCategory getProductCategory(UniversalProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(UniversalProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(UniversalProduct product) {
        ArrayList<GeneralProductTax> taxes = new ArrayList<GeneralProductTax>();
        for (GeneralProductTax tax : product.getTaxes()) {
            taxes.add(GeneralProductHelper.toGeneralProductTax(tax));
        }
        return taxes;
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(UniversalProduct product) {
        return product.getBlankType();
    }

    @Override
    public BigDecimal getEquivalentFare(UniversalProduct product) {
        return product.getEquivalentFare();
    }

    @Override
    public BigDecimal getServiceFare(UniversalProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(UniversalProduct product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(UniversalProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(UniversalProduct product) {
        return UniversalProductHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(UniversalProduct product) {
        return UniversalProductHelper.getRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(UniversalProduct product) {
        if (product == null) {
            return null;
        }
        List<GeoLocationReference> customValues = UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, GeoLocationReference.class);
        return GeoLocationLocalizer.get().encode(customValues.stream());
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(UniversalProduct product) {
        return UniversalProductHelper.getContractRelations(product).stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(UniversalProduct product) {
        return UniversalProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(UniversalProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(UniversalProduct product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(UniversalProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(UniversalProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(UniversalProduct product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(UniversalProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(UniversalProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(UniversalProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(UniversalProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(UniversalProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(UniversalProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(UniversalProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(UniversalProduct product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(UniversalProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(UniversalProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(UniversalProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(UniversalProduct product) {
        return null;
    }

    @Override
    public Money getProductBaseFare(UniversalProduct product) {
        return product.getBaseFare();
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    @Override
    public UniversalProduct newInstance() {
        return new UniversalProduct();
    }

    @Override
    public EntityReference<UniversalProductDescription> getUniversalProductDescription(UniversalProduct product) {
        return product.getDescription();
    }

    @Override
    public String getCarrierNumber(UniversalProduct product) {
        return null;
    }

    @Override
    public void setAgent(UniversalProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(UniversalProduct product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(UniversalProduct product, EntityReference<Organization> agency) {
        UniversalProductHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(UniversalProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(UniversalProduct product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(UniversalProduct product, EntityReference<Organization> supplier) {
        UniversalProductHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(UniversalProduct product, EntityReference<Organization> subagency) {
        UniversalProductHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(UniversalProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(UniversalProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(UniversalProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(UniversalProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(UniversalProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(UniversalProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(UniversalProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(UniversalProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return UniversalProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return UniversalProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return UniversalProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(UniversalProduct product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    @Override
    public Money getBspCommissionValue(UniversalProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(UniversalProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(UniversalProduct product) {
        return UniversalProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(UniversalProduct product, BaseProduct relatedProduct) {
        return UniversalProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public BigDecimal getAdditionalFeeEquivalentAmount(UniversalProduct product) {
        BigDecimal result = BigDecimal.ZERO;
        for (Object param : UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.PRICE_COMPONENT)) {
            if (!(param instanceof BigDecimal)) continue;
            result = result.add((BigDecimal)param);
        }
        return result;
    }

    @Override
    public Money getAdditionalFee(UniversalProduct product) {
        BigDecimal equivValue = this.getAdditionalFeeEquivalentAmount(product);
        Money money = new Money();
        money.setValue(equivValue);
        money.setCurrency(DictHelper.getEquivCurrency());
        return money;
    }

    @Override
    public boolean isAppropriateBillingItem(UniversalProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        Optional<Boolean> includeInFinDoc;
        EntityContainer descr = EntityStorage.get().resolve(product.getDescription());
        if (descr != null && CollectionUtil.isNotEmpty((Collection)((UniversalProductDescription)descr.getEntity()).getFinDocBillingItemsParameters()) && (includeInFinDoc = ((UniversalProductDescription)descr.getEntity()).getFinDocBillingItemsParameters().stream().filter(parameters -> type == parameters.getFinDocType() && billingItem.getServiceType() == parameters.getServiceType()).map(UniversalProductFinanceDocumentBillingItemsParameters::isIncludeInFinDoc).findFirst()).isPresent()) {
            return includeInFinDoc.get();
        }
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(UniversalProduct product, Locale locale) {
        return UniversalProductHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(UniversalProduct product, Locale locale) {
        return UniversalProductHelper.getCountries(product, locale);
    }

    @Override
    public String getAddresses(UniversalProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return UniversalProductHelper.getAddresses(product, locale, translitRules);
    }

    @Override
    public Date getFirstStartDate(UniversalProduct product) {
        return UniversalProductHelper.getFirstStartDate(product);
    }

    @Override
    public Date getLastStartDate(UniversalProduct product) {
        return UniversalProductHelper.getLastStartDate(product);
    }

    @Override
    public Date getFirstEndDate(UniversalProduct product) {
        return UniversalProductHelper.getFirstEndDate(product);
    }

    @Override
    public Date getLastEndDate(UniversalProduct product) {
        return UniversalProductHelper.getLastEndDate(product);
    }

    @Override
    public DictionaryReference<Airline> getCarrier(UniversalProduct product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(UniversalProduct product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(UniversalProduct product) {
        return false;
    }

    @Override
    public String getRfic(UniversalProduct product) {
        return null;
    }

    @Override
    public String getRfisc(UniversalProduct product) {
        return null;
    }

    @Override
    public String getTourCode(UniversalProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(UniversalProduct product) {
        return false;
    }

    @Override
    public VatDetalization getVendorVatDetalization(UniversalProduct product) {
        if (product.getVendorVatDetalization() != null) {
            return product.getVendorVatDetalization();
        }
        return UniversalProductHelper.createVatDetalization(product);
    }

    @Override
    public String getDescriptionLine(UniversalProduct product) {
        return UniversalProductHelper.getDescription(product);
    }

    @Override
    public boolean hasSameSystemNumbers(UniversalProduct product) {
        return UniversalProductHelper.hasSameSystemNumbers(product);
    }
}

