/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BasePenalty;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.VendorAdditionalService;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.handlers.standard.HotelProductFinanceHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class XtripHotelProductHandler
implements ProductHandler<HotelProduct> {
    private static final String UNKNOWN_NAME = "";
    private static final String NAME_SEPARATOR = " ";
    private static final String NAME_PASSENGER_SEPARATOR = ", ";

    @Override
    public VatAmount calculateProductPrice(HotelProduct product, ContractType ctype) {
        GeneralProductContractRelationData relation = null;
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            relation = data;
            break;
        }
        return this.calculateProductPrice(relation, product);
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, HotelProduct product) {
        VatAmount result;
        BigDecimal totalPrice;
        ProductStatus status = product.getStatus();
        if (XtripHotelProductHandler.isVoid(status)) {
            return VatAmount.newZeroVatAmount();
        }
        BigDecimal bigDecimal = totalPrice = relation != null ? relation.getServiceData().getTotalPrice() : null;
        if (totalPrice != null) {
            if (ProductStatusHelper.get().negatesPrice(status)) {
                totalPrice = totalPrice.negate();
            }
            result = new VatAmount();
            if (relation.getServiceData().getDetalization().getVat() != null) {
                BigDecimal vatAmount = relation.getServiceData().getDetalization().getVat().getComponents().stream().map(VatComponent::getSum).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
                result.setTotalVatAmount(totalPrice, vatAmount);
            } else {
                result.setTotalNoVat(totalPrice);
            }
        } else {
            result = this.calculateEquivalentProductPrice(relation, product);
        }
        return result;
    }

    @Override
    public VatAmount calculateEquivalentProductPrice(GeneralProductContractRelationData relation, HotelProduct product) {
        ProductStatus status = product.getStatus();
        if (XtripHotelProductHandler.isVoid(status)) {
            return VatAmount.newZeroVatAmount();
        }
        BigDecimal price = HotelProductHelper.getEquivalentFare(product);
        price = price == null ? BigDecimal.ZERO : price;
        BigDecimal taxes = HotelProductHelper.calculateTaxesEquivalentAmount(product);
        BigDecimal additionalFee = this.getAdditionalFeeEquivalentAmount(product);
        BigDecimal penalty = HotelProductHelper.calculatePenaltyEquivalentAmount(product, true);
        price = price.add(taxes).add(additionalFee).add(penalty);
        BigDecimal vatAmount = HotelProductHelper.calculateTotalVatAmount(product);
        if (ProductStatusHelper.get().negatesPrice(status)) {
            price = MiscUtil.negate((BigDecimal)price);
            vatAmount = MiscUtil.negate((BigDecimal)vatAmount);
        }
        VatAmount result = new VatAmount();
        result.setTotalVatAmount(price, vatAmount);
        return result;
    }

    private static boolean isVoid(ProductStatus status) {
        return ProductStatusHandler.getAllVoidStatuses().contains(status);
    }

    @Override
    public BigDecimal getAdditionalFeeEquivalentAmount(HotelProduct product) {
        return HotelProductHelper.calculateAddServicesEquivalentAmount(product);
    }

    @Override
    public Money getAdditionalFee(HotelProduct product) {
        return HotelProductHelper.calcAddServicesBasePrice(product);
    }

    @Override
    public String generateShortProductName(HotelProduct product) {
        StringBuilder sb = new StringBuilder();
        sb.append(L10nResourcesManager.getStr((String)"HOTEL_PRODUCT_SHORT_PRODUCT_NAME", (Object[])new Object[]{TextUtil.isBlank((String)product.getSystemNumber()) ? UNKNOWN_NAME : product.getSystemNumber()}));
        if (product.getStatus() != null) {
            sb.append(NAME_SEPARATOR);
            sb.append(product.getStatus());
        }
        return sb.toString();
    }

    @Override
    public String generateProductName(HotelProduct product) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generateShortProductName(product));
        sb.append(NAME_SEPARATOR);
        for (int i = 0; i < product.getTravellers().size(); ++i) {
            sb.append(((Traveller)product.getTravellers().get(i)).getName());
            if (i == product.getTravellers().size() - 1) continue;
            sb.append(NAME_PASSENGER_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public Date findFirstTravelDate(HotelProduct product) {
        if (product.getRooms().isEmpty()) {
            return null;
        }
        return ((Room)product.getRooms().get(0)).getCheckInDate();
    }

    @Override
    public Date findLastTravelDate(HotelProduct product) {
        if (product.getRooms().isEmpty()) {
            return null;
        }
        return ((Room)product.getRooms().get(0)).getCheckOutDate();
    }

    @Override
    public Date findIssueDate(HotelProduct product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(HotelProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(HotelProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public List<String> getProductNumbers(HotelProduct product) {
        return TextUtil.isBlank((String)product.getSystemNumber()) ? Collections.emptyList() : Collections.singletonList(product.getSystemNumber());
    }

    @Override
    public EntityReference<Person> findIssuingAgent(HotelProduct product) {
        return product.getCashier();
    }

    @Override
    public TravelSubject findTravelSubject(HotelProduct product) {
        return TravelSubject.HOTEL_RESERVATION;
    }

    @Override
    public boolean includeInFinanceDocuments(HotelProduct product) {
        return HotelProductFinanceHelper.includeInFinanceDocuments(product);
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<HotelProduct> prods = new HashSet<HotelProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof HotelProduct)) continue;
            prods.add((HotelProduct)bp);
        }
        return HotelProductFinanceHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public Collection<com.gridnine.xtrip.common.model.booking.BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<HotelProduct> prods = new ArrayList<HotelProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof HotelProduct)) continue;
            prods.add((HotelProduct)bp);
        }
        return HotelProductFinanceHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(HotelProduct product, String relatedInvoiceNumber) {
        return HotelProductFinanceHelper.getCommonPart(product, relatedInvoiceNumber);
    }

    @Override
    public void updateBillingItems(Collection<com.gridnine.xtrip.common.model.booking.BillingItem> items, List<HotelProduct> products) {
    }

    @Override
    public Collection<Traveller> getTravellers(HotelProduct product) {
        return product.getTravellers();
    }

    @Override
    public void replaceTraveller(HotelProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellers(), oldTraveller, newTraveller);
        product.getTravellersPassengerTypes().forEach(type -> {
            if (oldTraveller.getUid().equals(type.getTravellerUid())) {
                type.setTravellerUid(newTraveller.getUid());
            }
        });
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(HotelProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(HotelProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(HotelProduct product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(HotelProduct product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(HotelProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(HotelProduct product) {
        return ProductType.HOTEL_RESERVATION;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.HOTEL_RESERVATION).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.HOTELS_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(HotelProduct product) {
        return product.getBlankOwnerRef();
    }

    @Override
    public EntityReference<Branch> getBranch(HotelProduct product) {
        return null;
    }

    @Override
    public boolean isCompleted(HotelProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(HotelProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(HotelProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(HotelProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(HotelProduct product) {
        return Collections.emptyList();
    }

    @Override
    public TransportationType getTransportationType(HotelProduct product) {
        return HotelProductHelper.getTransportationType(product);
    }

    @Override
    public ServiceLocationType getServiceLocationType(HotelProduct product) {
        return this.getTransportationType(product) == TransportationType.DOMESTIC ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, HotelProduct product) {
        for (Room room : product.getRooms()) {
            if (momentOfTime.compareTo(room.getCheckInDate()) > 0) continue;
            return room.getCheckInDate();
        }
        return null;
    }

    @Override
    public HotelProduct getPreviousProduct(HotelProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(HotelProduct product, HotelProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(HotelProduct product, HotelProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public HotelProduct getNextProduct(HotelProduct product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(HotelProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(HotelProduct product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(HotelProduct product) {
        return null;
    }

    @Override
    public ProductCategory getProductCategory(HotelProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(HotelProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(HotelProduct product) {
        ArrayList<GeneralProductTax> taxes = new ArrayList<GeneralProductTax>();
        for (HotelProductTax tax : product.getTaxes()) {
            taxes.add(HotelProductHelper.toGeneralProductTax(tax));
        }
        return taxes;
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(HotelProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(HotelProduct product) {
        return HotelProductHelper.getEquivalentFare(product);
    }

    @Override
    public BigDecimal getServiceFare(HotelProduct product) {
        return null;
    }

    @Override
    public Money getProductBasePenalty(HotelProduct product) {
        if (product.getPenalties().isEmpty()) {
            return null;
        }
        Money result = null;
        String currency = null;
        for (Penalty penalty : product.getPenalties()) {
            Money baseAmount = penalty.getBaseAmount();
            if (baseAmount == null) continue;
            if (result == null) {
                currency = baseAmount.getCurrency();
                result = MoneyHelper.buildMoney(baseAmount.getValue(), currency);
                continue;
            }
            if (currency.equals(baseAmount.getCurrency())) {
                result.setValue(result.getValue().add(baseAmount.getValue()));
                continue;
            }
            throw new RuntimeException(String.format("different currencies in penalties (%s, %s) of the hotel product %s in the order %s", currency, baseAmount.getCurrency(), product.getSystemNumber(), HotelProductHelper.getBookingFileNumber(product)));
        }
        return result;
    }

    @Override
    public Money getProductEquivalentPenalty(HotelProduct product) {
        BigDecimal equivalentPenalty = this.getPenalty(product);
        if (null == equivalentPenalty) {
            return null;
        }
        Money penalty = new Money();
        penalty.setValue(equivalentPenalty);
        String currency = product.getGdsCurrency();
        if (StringUtils.isBlank((String)currency)) {
            throw new RuntimeException("empty gdsCurrency in the hotel product " + product.getSystemNumber() + " in the order " + HotelProductHelper.getBookingFileNumber(product));
        }
        penalty.setCurrency(currency);
        return penalty;
    }

    @Override
    public BigDecimal getPenalty(HotelProduct product) {
        if (product.getPenalties().isEmpty()) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (Penalty penalty : product.getPenalties()) {
            if (penalty.getEquivalentAmount() == null) continue;
            result = result.add(penalty.getEquivalentAmount());
        }
        return result;
    }

    @Override
    public int getConjunction(HotelProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(HotelProduct product) {
        return this.getRouteLine(product, true);
    }

    private String getRouteLineSeparator(boolean onlyCodes) {
        return onlyCodes ? "-" : " - ";
    }

    public String getRouteLine(HotelProduct product, boolean onlyCodes) {
        DictionaryReference hotelLocation = product.getHotelLocation();
        return DictHelper.findCity((DictionaryReference<GeoLocation>)hotelLocation) + this.getRouteLineSeparator(onlyCodes) + product.getHotelName();
    }

    @Override
    public String getLocalizedRouteLine(HotelProduct product) {
        return MiscUtil.toString((Object)DictHelper.findCity((DictionaryReference<GeoLocation>)product.getHotelLocation()));
    }

    @Override
    public String getCodeRouteLine(HotelProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(HotelProduct product) {
        ArrayList<GeneralProductContractRelationData> result = new ArrayList<GeneralProductContractRelationData>();
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations(product)) {
            GeneralProductContractRelationData generalData = new GeneralProductContractRelationData();
            generalData.setDescription(item.getDescription());
            generalData.setUid(item.getUid());
            try {
                XCloneModelHelper.copy((BaseEntity)item.getServiceData(), (BaseEntity)generalData.getServiceData());
                XCloneModelHelper.copy((BaseEntity)item.getGeneralData(), (BaseEntity)generalData.getGeneralData());
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
            generalData.getCommissions().addAll(item.getCommissions());
            for (HotelProductFop fop : item.getFops()) {
                generalData.getFops().add(HotelProductHelper.toGeneralProductFop(fop));
            }
            result.add(generalData);
        }
        return result;
    }

    @Override
    public SalesChain getSalesChain(HotelProduct product) {
        return HotelProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(HotelProduct product, List<GeneralProductContractRelationData> relations) {
        ArrayList<HotelProductContractRelationData> result = new ArrayList<HotelProductContractRelationData>();
        List<HotelProductContractRelationData> originalRelations = HotelProductHelper.getContractRelations(product);
        boolean updateRelations = originalRelations.size() != relations.size();
        for (GeneralProductContractRelationData generalProductRelation : relations) {
            HotelProductContractRelationData relation = (HotelProductContractRelationData)CollectionUtil.find(originalRelations, (String)generalProductRelation.getUid());
            if (relation == null) {
                relation = new HotelProductContractRelationData();
                relation.setUid(generalProductRelation.getUid());
                relation.setDescription(generalProductRelation.getDescription());
                updateRelations = true;
            }
            result.add(relation);
            try {
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getGeneralData(), (BaseEntity)relation.getGeneralData());
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getServiceData(), (BaseEntity)relation.getServiceData());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"unable to xcopy object", (Throwable)e, (Object[])new Object[0]);
            }
            GeneralProductHelper.updateCommissions(generalProductRelation.getCommissions(), relation.getCommissions());
            ArrayList<HotelProductFop> fops = new ArrayList<HotelProductFop>();
            boolean updateFops = generalProductRelation.getFops().size() != relation.getFops().size();
            for (GeneralProductFop generalProductFop : generalProductRelation.getFops()) {
                HotelProductFop fop = (HotelProductFop)CollectionUtil.find((Iterable)relation.getFops(), (String)generalProductFop.getUid());
                if (fop == null) {
                    fop = new HotelProductFop();
                    fop.setUid(generalProductFop.getUid());
                    updateFops = true;
                }
                fops.add(fop);
                fop.setType(generalProductFop.getType());
                fop.setCard(generalProductFop.getCard());
                fop.setRelatedTicketNumber(generalProductFop.getRelatedTicketNumber());
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(DictHelper.getLocalCurrency());
                    fop.setAmount(money);
                }
                fop.getAmount().setValue(generalProductFop.getEquivalentAmount());
                fop.getAmount().setCurrency(generalProductRelation.getGeneralData().getCurrency() != null ? generalProductRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency());
                fop.setOperationDate(generalProductFop.getOperationDate());
                fop.setAgent(generalProductFop.getAgent());
                fop.setRefused(generalProductFop.isRefused());
                fop.setPayer(generalProductFop.getPayer());
                fop.getCommissions().clear();
                for (GeneralProductCommission generalProductCommission : generalProductFop.getCommissions()) {
                    GeneralProductCommission commission = (GeneralProductCommission)BookingHelper.findEntityByUid(relation.getCommissions(), generalProductCommission.getUid());
                    if (commission == null) continue;
                    fop.getCommissions().add(commission);
                }
            }
            if (!updateFops) continue;
            relation.getFops().clear();
            relation.getFops().addAll(fops);
        }
        if (updateRelations) {
            originalRelations.clear();
            originalRelations.addAll(result);
        }
    }

    @Override
    public TicketType getTicketType(HotelProduct product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(HotelProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(HotelProduct product) {
        return product.getPcc();
    }

    @Override
    public void updateProductFops(HotelProduct product) {
        HotelProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(HotelProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(HotelProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(HotelProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(HotelProduct product) {
        for (HotelProductFop fop : HotelProductHelper.getClientFops(product)) {
            if (fop.getType() != PaymentType.MTD || fop.getPassengerStatus() == null) continue;
            return fop.getPassengerStatus();
        }
        return null;
    }

    @Override
    public boolean isHoldable(HotelProduct product) {
        return true;
    }

    @Override
    public Date getUnholdDate(HotelProduct product) {
        return product.getUnholdDate();
    }

    @Override
    public String getValidatorNumber(HotelProduct product) {
        return product.getValidatorCode();
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(HotelProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(HotelProduct product, Traveller traveller) {
        if (traveller == null) {
            return null;
        }
        PassengerTypeReference passengerTypeReference = product.getTravellersPassengerTypes().stream().filter(p -> p.getTravellerUid().equals(traveller.getUid())).findFirst().orElse(null);
        if (passengerTypeReference == null) {
            return null;
        }
        return passengerTypeReference.getPassengerType();
    }

    @Override
    public StatisticalData getStatisticalData(HotelProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(HotelProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(HotelProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(HotelProduct product) {
        return null;
    }

    @Override
    public String getGdsName(HotelProduct product) {
        Reservation reservation = product.getReservation();
        GdsName gdsName = CommonReservationGdsNameInfoHelper.getRulesGdsName(reservation);
        if (gdsName != null) {
            return SabrePassiveSegmentsUtil.convertGDS2String(gdsName);
        }
        return null;
    }

    @Override
    public String getProviderName(HotelProduct product) {
        HotelProvider provider = product.getProvider();
        return provider != null ? provider.name() : null;
    }

    @Override
    public String getGdsCurrency(HotelProduct product) {
        return product.getGdsCurrency();
    }

    @Override
    public Money getProductBaseFare(HotelProduct product) {
        return HotelProductHelper.calcBasePrice(product);
    }

    @Override
    public Collection<BasePenalty> getProductBasePenalties(HotelProduct product) {
        return product.getPenalties().stream().map(p -> {
            BasePenalty info = new BasePenalty();
            info.setAmount(p.getBaseAmount());
            info.setVatAmount(p.getBaseVatAmount() != null ? p.getBaseVatAmount().getValue() : null);
            info.setVatRate(info.getVatAmount() != null ? Double.valueOf(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue()) : null);
            info.setSource(p.getUid());
            return info;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<BasePenalty> getProductEquivalentPenalties(HotelProduct product) {
        String currency = this.getGdsCurrency(product);
        return product.getPenalties().stream().map(p -> {
            BasePenalty info = new BasePenalty();
            info.setAmount(MoneyHelper.buildMoney(p.getEquivalentAmount(), currency));
            info.setVatAmount(p.getEquivalentVatAmount());
            info.setVatRate(p.getEquivalentVatRate());
            info.setSource(p.getUid());
            return info;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<BasePenalty> getProductBaseCancellationPenalties(HotelProduct product) {
        return product.getCancellationCharges().stream().map(cc -> {
            RateMoney p = cc.getPenalty();
            if (null == p || p.getRate() != null) {
                return null;
            }
            BasePenalty info = new BasePenalty();
            info.setAmount(p.getMoney());
            info.setVatAmount(cc.getPenaltyVatAmount());
            info.setVatRate(info.getVatAmount() != null ? Double.valueOf(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue()) : null);
            info.setSource(p.getUid());
            return info;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Collection<BasePenalty> getProductEquivalentCancellationPenalties(HotelProduct product) {
        String currency = this.getGdsCurrency(product);
        return product.getCancellationCharges().stream().map(cc -> {
            RateMoney p = cc.getPenalty();
            if (null == p || p.getRate() != null) {
                return null;
            }
            BasePenalty info = new BasePenalty();
            info.setAmount(MoneyHelper.buildMoney(cc.getPenaltyEquivalentAmount(), currency));
            info.setVatAmount(cc.getPenaltyEquivalentVatAmount());
            info.setVatRate(cc.getPenaltyEquivalentVatRate());
            info.setSource(cc.getUid());
            return info;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Collection<VendorAdditionalService> getProductBaseAdditionalServices(HotelProduct product) {
        return product.getAdditionalServices().stream().map(as -> {
            VendorAdditionalService info = new VendorAdditionalService();
            info.setAmount(as.getBaseAmount());
            info.setVatAmount(as.getEquivalentVatAmount());
            info.setVatRate(as.getEquivalentVatRate());
            info.setSource(as.getUid());
            info.setTypeCaption(EnumUtil.stringValueOf((Enum)as.getType()));
            return info;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<VendorAdditionalService> getProductEquivalentAdditionalServices(HotelProduct product) {
        String currency = this.getGdsCurrency(product);
        return product.getAdditionalServices().stream().map(as -> {
            VendorAdditionalService info = new VendorAdditionalService();
            info.setAmount(MoneyHelper.buildMoney(as.getEquivalentAmount(), currency));
            info.setVatAmount(as.getEquivalentVatAmount());
            info.setVatRate(as.getEquivalentVatRate());
            info.setSource(as.getUid());
            return info;
        }).collect(Collectors.toList());
    }

    @Override
    public VatDetalization getVendorVatDetalization(HotelProduct product) {
        return HotelProductVatFiller.getVendorVatDetalization(product);
    }

    @Override
    public String getPreferredClientContractNumber(HotelProduct product) {
        return product.getClientContractNumber();
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.HOTEL_RESERVATION;
    }

    @Override
    public HotelProduct newInstance() {
        return new HotelProduct();
    }

    @Override
    public String getCarrierNumber(HotelProduct product) {
        return null;
    }

    @Override
    public void setAgent(HotelProduct product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    @Override
    public void setComments(HotelProduct product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(HotelProduct product, EntityReference<Organization> agency) {
        HotelProductHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(HotelProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwnerRef(blankOwner);
    }

    @Override
    public void setBranch(HotelProduct product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(HotelProduct product, EntityReference<Organization> supplier) {
        HotelProductHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(HotelProduct product, EntityReference<Organization> subagency) {
        HotelProductHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(HotelProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(HotelProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<HotelProductFop> fops = new ArrayList<HotelProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(HotelProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(HotelProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(HotelProductHelper.getClientFops(product));
            }
        }
        HotelProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(HotelProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<HotelProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(HotelProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<HotelProductFop> getFops(HotelProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return HotelProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return HotelProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return HotelProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(HotelProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(HotelProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(HotelProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(HotelProduct product) {
        return HotelProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(HotelProduct product, BaseProduct relatedProduct) {
        return HotelProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(HotelProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, BillingItem billingItem, List<BillingItem> billingItems, List<BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<BillingItem> remainingList = new ArrayList<BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(HotelProduct product, Locale locale) {
        return HotelProductHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(HotelProduct product, Locale locale) {
        return HotelProductHelper.getCountries(product, locale);
    }

    @Override
    public String getAddresses(HotelProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return HotelProductHelper.getAddresses(product, locale, translitRules);
    }

    @Override
    public Date getFirstStartDate(HotelProduct product) {
        return product.getRooms().size() > 0 && ((Room)product.getRooms().get(0)).getCheckInDate() != null ? MiscUtil.addToDate((Date)((Room)product.getRooms().get(0)).getCheckInDate(), (int)(((Room)product.getRooms().get(0)).getCheckInTime() != null ? ((Room)product.getRooms().get(0)).getCheckInTime() : 0), (int)12) : null;
    }

    @Override
    public Date getLastStartDate(HotelProduct product) {
        return product.getRooms().size() > 0 && ((Room)product.getRooms().get(0)).getCheckInDate() != null && ((Room)product.getRooms().get(0)).getCheckInTime() != null ? MiscUtil.addToDate((Date)((Room)product.getRooms().get(0)).getCheckInDate(), (int)((Room)product.getRooms().get(0)).getCheckInTime(), (int)12) : null;
    }

    @Override
    public Date getFirstEndDate(HotelProduct product) {
        return product.getRooms().size() > 0 && ((Room)product.getRooms().get(0)).getCheckOutDate() != null && ((Room)product.getRooms().get(0)).getCheckOutTime() != null ? MiscUtil.addToDate((Date)((Room)product.getRooms().get(0)).getCheckOutDate(), (int)((Room)product.getRooms().get(0)).getCheckOutTime(), (int)12) : null;
    }

    @Override
    public Date getLastEndDate(HotelProduct product) {
        return product.getRooms().size() > 0 && ((Room)product.getRooms().get(0)).getCheckOutDate() != null ? MiscUtil.addToDate((Date)((Room)product.getRooms().get(0)).getCheckOutDate(), (int)(((Room)product.getRooms().get(0)).getCheckOutTime() != null ? ((Room)product.getRooms().get(0)).getCheckOutTime() : 0), (int)12) : null;
    }

    @Override
    public String getDescriptionLine(HotelProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(HotelProduct product) {
        return null;
    }

    @Override
    public String getHotel(HotelProduct product) {
        return product.getHotelName();
    }

    @Override
    public String getRoom(HotelProduct product) {
        return product.getRooms().size() > 0 ? ((Room)product.getRooms().get(0)).getRoomName() : null;
    }

    @Override
    public boolean isContractRulesApplied(HotelProduct product) {
        return product.isContractRulesApplied();
    }

    @Override
    public Double getGdsCurrencyRate(HotelProduct product) {
        return product.getGdsCurrencyRate();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(HotelProduct product) {
        return false;
    }

    @Override
    public String getRfic(HotelProduct product) {
        return null;
    }

    @Override
    public String getRfisc(HotelProduct product) {
        return null;
    }

    @Override
    public String getTourCode(HotelProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(HotelProduct product) {
        return false;
    }

    @Override
    public boolean hasSameSystemNumbers(HotelProduct product) {
        return HotelProductHelper.hasSameSystemNumbers(product);
    }
}

