/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProductIndex;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class AdditionalServiceProductHelper {
    private AdditionalServiceProductHelper() {
    }

    public static SalesChain getSalesChain(AdditionalServiceProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(AdditionalServiceProduct item) {
        List<GeneralProductContractRelationData> contractRelations = GeneralProductHelper.getContractRelationsByReflection((BaseProduct)item);
        return contractRelations.stream().filter(relation -> GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.VENDOR).collect(Collectors.toList());
    }

    public static GeneralProductContractRelationData getClientContractRelation(AdditionalServiceProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(AdditionalServiceProduct product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static EntityReference<Organization> getSupplier(AdditionalServiceProduct prod) {
        return GeneralProductHelper.getContractor(AdditionalServiceProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(AdditionalServiceProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(AdditionalServiceProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(AdditionalServiceProduct prod) {
        return GeneralProductHelper.getContractor(AdditionalServiceProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(AdditionalServiceProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(AdditionalServiceProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(AdditionalServiceProduct prod) {
        return GeneralProductHelper.getContractor(AdditionalServiceProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(AdditionalServiceProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(AdditionalServiceProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(AdditionalServiceProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(AdditionalServiceProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static List<GeneralProductFop> getVendorFops(AdditionalServiceProduct prod) {
        return AdditionalServiceProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(AdditionalServiceProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = AdditionalServiceProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(AdditionalServiceProduct prod) {
        return AdditionalServiceProductHelper.getClientContractRelation(prod).getFops();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(AdditionalServiceProduct source, AdditionalServiceProduct target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            target.setReservation(targetRes);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static void removeProduct(AdditionalServiceProduct product, boolean removeEmptyReservations) {
        Iterator iterator = product.getReservation().getBookingFile().getReservations().iterator();
        while (iterator.hasNext()) {
            Reservation res = (Reservation)iterator.next();
            res.getProducts().remove(product);
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            iterator.remove();
        }
    }

    public static boolean removeProduct(AdditionalServiceProduct product) {
        product.getReservation().getProducts().remove(product);
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(AdditionalServiceProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static AdditionalServiceProduct createCertificateOfCompletedFlight(Product product, List<String> usedSegments) {
        AdditionalServiceProduct certificate = new AdditionalServiceProduct();
        BookingHelper.addProduct(product.getReservation(), (BaseProduct)certificate);
        certificate.setCategory(AdditionalServiceCategory.CERTIFICATE_OF_COMPLETED_FLIGHT);
        certificate.setStatus(ProductStatus.SELL);
        certificate.setIssueDate(new Date());
        certificate.setAgency(AirProductHelper.getAgency(product));
        certificate.setSubagency(AirProductHelper.getSubagency(product));
        certificate.setBranch(product.getBranch());
        certificate.setAgent(product.getCashier());
        certificate.setSalesPoint(product.getSalesPoint());
        certificate.getTravellers().add(product.getTraveller());
        try {
            certificate.setStatisticalData(AdditionalServiceProductHelper.createStatisticalData(product));
        }
        catch (Exception e) {
            certificate.setStatisticalData(new StatisticalData());
        }
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            List segments = segmentTariff.getSegments().stream().filter(segment -> usedSegments.contains(segment.getUid())).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            SegmentTariff st = new SegmentTariff();
            st.getSegments().addAll(segments);
            certificate.getSegments().add(st);
        }
        certificate.getRelatedProducts().add(product);
        return certificate;
    }

    private static StatisticalData createStatisticalData(Product product) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(product.getTraveller().getUid());
        StatisticalData sourceStatisticalData = product.getStatisticalData();
        if (sourceStatisticalData != null) {
            sourceStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        return (StatisticalData)XCloneHelper.clone((XCloneable)product.getStatisticalData(), (boolean)true, excludedUids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdditionalServiceProduct createRefund(AdditionalServiceProduct model) throws Exception {
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            AdditionalServiceProduct refund = (AdditionalServiceProduct)XCloneHelper.clone((XCloneable)model, (boolean)true);
            refund.setReservation(res);
            res.getProducts().add(refund);
            refund.setPreviousProduct(model);
            model.setNextProduct(refund);
            refund.setContractRulesApplied(false);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            refund.getShipments().clear();
            refund.getPrepaymentDocuments().clear();
            refund.getFopDetalizations().clear();
            AdditionalServiceProduct additionalServiceProduct = refund;
            return additionalServiceProduct;
        }
        finally {
            model.setReservation(res);
        }
    }

    public static boolean hasSameSystemNumbers(AdditionalServiceProduct product) {
        ProductHandler<AdditionalServiceProduct> handler = ProductHandler.of(product);
        List<String> systemNumbers = handler.getProductNumbers(product);
        if (CollectionUtil.isEmpty(systemNumbers)) {
            return false;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"navigationKey", (Object)product.getUid()));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)AdditionalServiceProductIndex.Property.systemNumber.name(), systemNumbers));
        ProductStatus status = handler.getStatus(product);
        if (status == ProductStatus.SELL || status == ProductStatus.VOID) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)AdditionalServiceProductIndex.Property.status.name(), EnumSet.of(ProductStatus.SELL, ProductStatus.VOID)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AdditionalServiceProductIndex.Property.status.name(), (Object)status));
        }
        TicketType ticketType = handler.getTicketType(product);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)AdditionalServiceProductIndex.Property.ticketType.name(), Arrays.asList(ticketType, null)));
        Date issueDate = handler.findIssueDate(product);
        if (issueDate != null) {
            Date issueDateStart = MiscUtil.addYearsToDate((Date)issueDate, (int)-1);
            Date issueDateEnd = MiscUtil.addYearsToDate((Date)issueDate, (int)1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AdditionalServiceProductIndex.Property.issueDate.name(), (Object)issueDateStart));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)AdditionalServiceProductIndex.Property.issueDate.name(), (Object)issueDateEnd));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AdditionalServiceProductIndex.Property.category.name(), (Object)product.getCategory()));
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(AdditionalServiceProductIndex.class, query).getTotalCount() > 0;
    }

    public static Date getFirstDepartureDate(AdditionalServiceProduct product) {
        Segment firstSegment = AdditionalServiceProductHelper.getFirstSegment(product);
        return firstSegment != null ? firstSegment.getStartDate() : null;
    }

    public static Segment getFirstSegment(AdditionalServiceProduct product) {
        Segment firstSegment = null;
        Date departureDate = null;
        for (SegmentTariff segmentTariff : product.getSegments()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment.getStartDate() == null || departureDate != null && !segment.getStartDate().before(departureDate)) continue;
                firstSegment = segment;
                departureDate = segment.getStartDate();
            }
        }
        return firstSegment;
    }

    public static Date getLastArrivalDate(AdditionalServiceProduct product) {
        Segment lastSegment = AdditionalServiceProductHelper.getLastSegment(product);
        return lastSegment != null ? lastSegment.getEndDate() : null;
    }

    public static Segment getLastSegment(AdditionalServiceProduct product) {
        Segment lastSegment = null;
        Date departureDate = null;
        for (SegmentTariff segmentTariff : product.getSegments()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment.getStartDate() == null || departureDate != null && !segment.getStartDate().after(departureDate)) continue;
                lastSegment = segment;
                departureDate = segment.getStartDate();
            }
        }
        return lastSegment;
    }
}

