/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import java.math.BigDecimal;

public final class AeroExpressHelper {
    public static EntityReference<Organization> getSupplier(AeroexpressTicket product) {
        return GeneralProductHelper.getContractor(AeroExpressHelper.getSalesChain(product), PredefinedContractorType.SUPPLIER);
    }

    private static SalesChain getSalesChain(AeroexpressTicket product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static void setAgency(AeroexpressTicket product, EntityReference<Organization> agency) {
        product.setValue("agency", agency);
        GeneralProductHelper.setContractor(AeroExpressHelper.getSalesChain(product), PredefinedContractorType.AGENCY, agency);
    }

    public static void setSubagency(AeroexpressTicket product, EntityReference<Organization> subagency) {
        product.setValue("subagency", subagency);
        GeneralProductHelper.setContractor(AeroExpressHelper.getSalesChain(product), PredefinedContractorType.SUBAGENCY, subagency);
    }

    public static void setSupplier(AeroexpressTicket product, EntityReference<Organization> supplier) {
        product.setValue("supplier", supplier);
        GeneralProductHelper.setContractor(AeroExpressHelper.getSalesChain(product), PredefinedContractorType.SUPPLIER, supplier);
    }

    public static EntityReference<Organization> getAgency(AeroexpressTicket product) {
        return GeneralProductHelper.getContractor(AeroExpressHelper.getSalesChain(product), PredefinedContractorType.AGENCY);
    }

    public static EntityReference<Organization> getSubagency(AeroexpressTicket product) {
        return GeneralProductHelper.getContractor(AeroExpressHelper.getSalesChain(product), PredefinedContractorType.SUBAGENCY);
    }

    public static BigDecimal calculateTotalEquivalentFare(AeroexpressTicket product) {
        BigDecimal total = BigDecimal.ZERO;
        if (product.getEquivalentFare() != null) {
            total = total.add(product.getEquivalentFare());
        }
        if (product.getPenalty() != null) {
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                total = total.subtract(product.getPenalty());
            } else if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                total = total.add(product.getPenalty());
            }
        }
        return total;
    }
}

