/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageCommonParameters;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ProjectionQueryHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BalanceHelper {
    protected static final transient Logger log = LoggerFactory.getLogger(BalanceHelper.class);

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions) {
        return BalanceHelper.calculateBalance(organization, startOperationDate, endOperationDate, calculationDate, chartOfAccountsElementType, currency, dimensions, null);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, EntityStorageCommonParameters parameters) {
        EntityContainer chartOfAccountsSettingsContainer;
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null) {
            return null;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, parameters);
        if (chartOfAccountsElement == null) {
            return null;
        }
        EntityContainer entityContainer = chartOfAccountsSettingsContainer = parameters != null && parameters.getLoadParamaters() != null ? EntityStorage.get().resolve(chartOfAccountsSettings, parameters.getLoadParamaters()) : EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return null;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return null;
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, true, actualDimensions, null, parameters);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, boolean credit) {
        return BalanceHelper.calculateBalance(organization, startOperationDate, endOperationDate, calculationDate, chartOfAccountsElementType, currency, dimensions, credit, null);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, boolean credit, EntityStorageCommonParameters parameters) {
        EntityContainer chartOfAccountsSettingsContainer;
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null) {
            return null;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, parameters);
        if (chartOfAccountsElement == null) {
            return null;
        }
        EntityContainer entityContainer = chartOfAccountsSettingsContainer = parameters != null && parameters.getLoadParamaters() != null ? EntityStorage.get().resolve(chartOfAccountsSettings, parameters.getLoadParamaters()) : EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return null;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return null;
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, true, actualDimensions, credit, parameters);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date operationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions) {
        return BalanceHelper.calculateBalance(organization, operationDate, calculationDate, chartOfAccountsElementType, currency, dimensions, null);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date operationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, EntityStorageCommonParameters parameters) {
        EntityContainer chartOfAccountsSettingsContainer;
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null) {
            return null;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, parameters);
        if (chartOfAccountsElement == null) {
            return null;
        }
        EntityContainer entityContainer = chartOfAccountsSettingsContainer = parameters != null && parameters.getLoadParamaters() != null ? EntityStorage.get().resolve(chartOfAccountsSettings, parameters.getLoadParamaters()) : EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return null;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return null;
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.calculateBalance(chartOfAccountsElement, operationDate, calculationDate, actualDimensions, parameters);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date operationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, boolean credit) {
        return BalanceHelper.calculateBalance(organization, operationDate, calculationDate, chartOfAccountsElementType, currency, dimensions, credit, null);
    }

    public static BigDecimal calculateBalance(EntityReference<Organization> organization, Date operationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, boolean credit, EntityStorageCommonParameters parameters) {
        EntityContainer chartOfAccountsSettingsContainer;
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null) {
            return null;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, parameters);
        if (chartOfAccountsElement == null) {
            return null;
        }
        EntityContainer entityContainer = chartOfAccountsSettingsContainer = parameters != null && parameters.getLoadParamaters() != null ? EntityStorage.get().resolve(chartOfAccountsSettings, parameters.getLoadParamaters()) : EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return null;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return null;
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.calculateBalance(chartOfAccountsElement, operationDate, calculationDate, true, actualDimensions, credit, parameters);
    }

    public static BigDecimal calculateTransactions(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, List<SearchCriterion> criterions) {
        return BalanceHelper.calculateTransactions(organization, startOperationDate, endOperationDate, calculationDate, chartOfAccountsElementType, currency, dimensions, criterions, null);
    }

    public static BigDecimal calculateTransactions(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, List<SearchCriterion> criterions, EntityStorageCommonParameters parameters) {
        EntityContainer chartOfAccountsSettingsContainer;
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null || criterions == null) {
            return null;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, parameters);
        if (chartOfAccountsElement == null) {
            return null;
        }
        EntityContainer entityContainer = chartOfAccountsSettingsContainer = parameters != null && parameters.getLoadParamaters() != null ? EntityStorage.get().resolve(chartOfAccountsSettings, parameters.getLoadParamaters()) : EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return null;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return null;
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.calculateTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, actualDimensions, criterions, parameters);
    }

    public static BigDecimal calculateTransactions(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, List<SearchCriterion> criterions, boolean credit) {
        return BalanceHelper.calculateTransactions(organization, startOperationDate, endOperationDate, calculationDate, chartOfAccountsElementType, currency, dimensions, criterions, credit, null);
    }

    public static BigDecimal calculateTransactions(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, List<SearchCriterion> criterions, boolean credit, EntityStorageCommonParameters parameters) {
        EntityContainer chartOfAccountsSettingsContainer;
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null || criterions == null) {
            return null;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, parameters);
        if (chartOfAccountsElement == null) {
            return null;
        }
        EntityContainer entityContainer = chartOfAccountsSettingsContainer = parameters != null && parameters.getLoadParamaters() != null ? EntityStorage.get().resolve(chartOfAccountsSettings, parameters.getLoadParamaters()) : EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return null;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return null;
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.calculateTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, actualDimensions, criterions, credit, parameters);
    }

    public static List<Transaction> getTransactions(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, boolean credit) {
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null) {
            return Collections.emptyList();
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return Collections.emptyList();
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency);
        if (chartOfAccountsElement == null) {
            return Collections.emptyList();
        }
        EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return Collections.emptyList();
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return Collections.emptyList();
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.getTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, actualDimensions, credit);
    }

    public static List<TransactionSplitIndex> getTransactionIndexes(EntityReference<Organization> organization, Date startOperationDate, Date endOperationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, Boolean credit, String description, TransactionSplitIndex.Property orderBy, SortOrder sortOrder) {
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null) {
            return Collections.emptyList();
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return Collections.emptyList();
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency);
        if (chartOfAccountsElement == null) {
            return Collections.emptyList();
        }
        EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return Collections.emptyList();
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return Collections.emptyList();
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        return FinanceHelper.getTransactionIndexes(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, actualDimensions, credit, description, orderBy, sortOrder);
    }

    public static boolean isSettingsEnabled(EntityReference<Organization> organization, ChartOfAccountsElementType chartOfAccountsElementType) {
        if (organization == null || chartOfAccountsElementType == null) {
            return false;
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return false;
        }
        EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return false;
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        return chartOfAccountsElementSettings != null && chartOfAccountsElementSettings.isEnabled();
    }

    public static ProjectionQueryHelper.GroupValues<DimensionType> getDimensionsValues(EntityReference<Organization> organization, Date operationDate, Date calculationDate, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, Map<DimensionType, Object> dimensions, List<DimensionType> groups) {
        if (organization == null || chartOfAccountsElementType == null || currency == null || dimensions == null || groups == null) {
            return ProjectionQueryHelper.GroupValues.empty();
        }
        EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(organization, false);
        if (chartOfAccountsSettings == null) {
            return ProjectionQueryHelper.GroupValues.empty();
        }
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency);
        if (chartOfAccountsElement == null) {
            return ProjectionQueryHelper.GroupValues.empty();
        }
        EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(chartOfAccountsSettings);
        if (chartOfAccountsSettingsContainer == null) {
            return ProjectionQueryHelper.GroupValues.empty();
        }
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity(), chartOfAccountsElementType);
        if (chartOfAccountsElementSettings == null) {
            return ProjectionQueryHelper.GroupValues.empty();
        }
        HashMap<FinanceHelper.Dimension, String> actualDimensions = new HashMap<FinanceHelper.Dimension, String>();
        for (Map.Entry<DimensionType, Object> entry : dimensions.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            FinanceHelper.Dimension dimension = FinanceHelper.getDimension(chartOfAccountsElementSettings, entry.getKey());
            String value = FinanceHelper.getDimensionValue(entry.getKey(), entry.getValue());
            if (dimension == null || value == null) continue;
            actualDimensions.put(dimension, value);
        }
        List<FinanceHelper.Dimension> actualGroups = groups.stream().map(item -> FinanceHelper.getDimension(chartOfAccountsElementSettings, item)).collect(Collectors.toList());
        return ProjectionQueryHelper.GroupValues.of(dimensionType -> Optional.ofNullable(FinanceHelper.getDimension(chartOfAccountsElementSettings, dimensionType)).map(value -> value.name()).orElse(null), FinanceHelper.getDimensionsValues(chartOfAccountsElement, operationDate, calculationDate, actualDimensions, actualGroups).getData());
    }

    public static Date getFinanceInitializationDate(EntityReference<Organization> organizationRef) {
        return FinanceHelper.getFinanceInitializationDate(organizationRef);
    }
}

