/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.RelatedDocumentDescriptor;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;

public class BookingFileHelper {
    private static final String UTF8 = "UTF-8";

    public static List<RelatedDocumentDescriptor> getRelatedDocuments(EntityContainer<BookingFile> bookingFileCtr) {
        ArrayList<RelatedDocumentDescriptor> relatedDocuments = new ArrayList<RelatedDocumentDescriptor>();
        String uid = bookingFileCtr.getUid();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)new EntityReference(uid, BookingFile.class, null)), SearchCriterion.contains((String)BasicDocumentIndex.Property.ownersUids.name(), (Object)new EntityReference(uid, BookingFile.class, null).getUid())}));
        query.getCriteria().getOrders().put(BasicDocumentIndex.Property.created.name(), SortOrder.ASC);
        for (BasicDocumentIndex idx : EntityStorage.get().search(BasicDocumentIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData()) {
            relatedDocuments.add(new RelatedDocumentDescriptor(idx));
        }
        return relatedDocuments;
    }

    public static BaseFileDocument getBaseFileDocument(RelatedDocumentDescriptor rdd) {
        EntityContainer ctr = EntityStorage.get().resolve(rdd.getRef());
        BaseEntity be = ctr.getEntity();
        return be instanceof BaseFileDocument ? (BaseFileDocument)be : null;
    }

    public static List<BasicDocumentIndex> findBookingDocumentIndexes(EntityReference<BookingFile> bookingRef, List<DocumentType> documentTypes) {
        if (CollectionUtil.isEmpty(documentTypes)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bookingRef), SearchCriterion.contains((String)BasicDocumentIndex.Property.ownersUids.name(), (Object)bookingRef.getUid())}));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)BasicDocumentIndex.Property.type.name(), (Object[])documentTypes.toArray()));
        query.getPreferredProperties().add(BasicDocumentIndex.Property.name.name());
        List result = EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
        return result;
    }

    public static BufferedReader getBufferedReader(BaseFileDocument bfd) throws Exception {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bfd.getContent()), UTF8));
    }

    public static Document getXmlDocument(BaseFileDocument bfd) throws Exception {
        byte[] bytes = bfd.getContent();
        return DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(bytes));
    }

    public static Date getMaxIssueDate(BookingFile booking) {
        Date lastModifiedDate = null;
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                Date issueDate = GeneralProductHelper.getHandler(prod).findIssueDate(prod);
                if (issueDate == null || lastModifiedDate != null && !lastModifiedDate.before(issueDate)) continue;
                lastModifiedDate = issueDate;
            }
        }
        return lastModifiedDate;
    }

    public static int getProductsCount(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().mapToInt(reservation -> reservation.getProducts().size()).sum();
    }
}

