/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class BookingStreamHelper {
    public static Function<Reservation, Stream<BaseProduct>> BASE_PRODUCT_STREAM_EXTRACTOR = reservation -> reservation.getProducts().stream();

    public static Stream<BaseProduct> getBaseProductsStream(BookingFile bookingFile) {
        Objects.requireNonNull(bookingFile);
        return bookingFile.getReservations().stream().flatMap(BASE_PRODUCT_STREAM_EXTRACTOR);
    }

    public static Stream<BaseProduct> getBaseProductsStream(Collection<Reservation> reservations) {
        Objects.requireNonNull(reservations);
        return reservations.stream().flatMap(BASE_PRODUCT_STREAM_EXTRACTOR);
    }

    public static Stream<BaseProduct> getBaseProductsStream(Reservation reservation) {
        Objects.requireNonNull(reservation);
        return BASE_PRODUCT_STREAM_EXTRACTOR.apply(reservation);
    }

    public static Stream<TravelSubject> getTravelSubjects(Stream<BaseProduct> productStream) {
        return productStream.map(baseProduct -> BookingStreamHelper.productHandlerMapper(baseProduct, ProductHandler::findTravelSubject)).filter(Objects::nonNull);
    }

    public static Stream<TravelSubject> getTravelSubjects(BookingFile bookingFile) {
        return BookingStreamHelper.getTravelSubjects(BookingStreamHelper.getBaseProductsStream(bookingFile));
    }

    public static <P extends BaseProduct, R> R productHandlerMapper(P baseProduct, BiFunction<ProductHandler<P>, P, R> getter) {
        Objects.requireNonNull(baseProduct);
        ProductHandler<P> handler = ProductHandler.of(baseProduct);
        return getter.apply(handler, baseProduct);
    }

    public static <E extends BaseProduct> Stream<E> getProductsStream(BookingFile bookingFile, Class<E> clazz) {
        return BookingStreamHelper.getProductsStream(BookingStreamHelper.getBaseProductsStream(bookingFile), clazz);
    }

    public static <E extends BaseProduct> Stream<E> getProductsStream(Collection<Reservation> reservations, Class<E> clazz) {
        return BookingStreamHelper.getProductsStream(BookingStreamHelper.getBaseProductsStream(reservations), clazz);
    }

    public static <E extends BaseProduct> Stream<E> getProductsStream(Reservation reservation, Class<E> clazz) {
        return BookingStreamHelper.getProductsStream(BookingStreamHelper.getBaseProductsStream(reservation), clazz);
    }

    public static <E extends BaseProduct> Stream<E> getProductsStream(Stream<BaseProduct> baseProductStream, Class<E> clazz) {
        Objects.requireNonNull(baseProductStream);
        Objects.requireNonNull(clazz);
        return baseProductStream.filter(clazz::isInstance).map(clazz::cast);
    }

    public static Stream<BaseProduct> baseProductStreamSafe(BookingFile bookingFile) {
        Objects.requireNonNull(bookingFile);
        return BookingStreamHelper.reservationStreamSafe(bookingFile).flatMap(BASE_PRODUCT_STREAM_EXTRACTOR).filter(Objects::nonNull);
    }

    public static Stream<Reservation> reservationStreamSafe(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().filter(Objects::nonNull);
    }

    public static <P extends BaseProduct> Consumer<P> productHandlerConsumerStrict(BiConsumer<P, ProductHandler<P>> biConsumer) throws RuntimeException {
        Objects.requireNonNull(biConsumer);
        return baseProduct -> {
            Objects.requireNonNull(baseProduct);
            ProductHandler<BaseProduct> productHandler = ProductHandler.of(baseProduct);
            if (Objects.nonNull(productHandler)) {
                biConsumer.accept(baseProduct, productHandler);
            }
        };
    }
}

