/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryDataModification;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.util.LogUtil;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyRateSuperCache
implements DictionaryCache.ModificationListener {
    private final Logger log = LoggerFactory.getLogger(CurrencyRateSuperCache.class);
    private final ConcurrentHashMap<String, Set<CurrencyRateData>> cache = new ConcurrentHashMap();
    static Comparator<CurrencyRateData> comparator = new Comparator<CurrencyRateData>(){

        @Override
        public int compare(CurrencyRateData o1, CurrencyRateData o2) {
            int result = -MiscUtil.compare((Date)o1.date, (Date)o2.date);
            if (result == 0) {
                result = -MiscUtil.compare((Date)o1.issueDate, (Date)o2.issueDate);
            }
            return result;
        }
    };

    static CurrencyRateSuperCache get() {
        return (CurrencyRateSuperCache)Environment.getPublished(CurrencyRateSuperCache.class);
    }

    public CurrencyRateSuperCache(DictionaryCache cache) {
        cache.addListener((DictionaryCache.ModificationListener)this);
    }

    private static String calculateKey(String baseCurrencyCode, String currencyCode, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOnwer, EntityReference<Organization> supplier) {
        return String.join((CharSequence)"_", baseCurrencyCode, currencyCode, rateType == null ? null : rateType.name(), tariffType == null ? null : tariffType.name(), blankOnwer == null ? null : blankOnwer.getUid(), supplier == null ? null : supplier.getUid());
    }

    CurrencyRate findCurrencyRate(String baseCurrencyCode, String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        String queryBaseCurrencyCode;
        if (currencyCode == null) {
            return null;
        }
        String string = queryBaseCurrencyCode = baseCurrencyCode != null ? baseCurrencyCode : DictHelper.getEquivCurrency();
        if (queryBaseCurrencyCode == null) {
            return null;
        }
        EntityReference<Organization> requiredSupplier = null;
        if (CurrencyRateType.VENDOR == rateType) {
            requiredSupplier = supplier;
        }
        Date correctedIssueDate = issueDate == null ? new Date() : issueDate;
        String key = CurrencyRateSuperCache.calculateKey(queryBaseCurrencyCode, currencyCode, rateType, tariffType, blankOwner, requiredSupplier);
        CurrencyRateData cached = this.findInCache(key, correctedIssueDate);
        CurrencyRate result = cached != null ? cached.rate : this.findRateAndUpdateCache(queryBaseCurrencyCode, currencyCode, correctedIssueDate, rateType, tariffType, blankOwner, requiredSupplier, key);
        return result;
    }

    private CurrencyRate findRateAndUpdateCache(String baseCurrencyCode, String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, String cacheKey) {
        String issueDateString = this.yyyymmdd(issueDate);
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("findRateAndUpdateCache(%s,%s,%s,%s,%s,%s,%s,%s)", baseCurrencyCode, currencyCode, issueDateString, rateType, tariffType, blankOwner != null ? blankOwner.getUid() : null, supplier != null ? supplier.getUid() : null, cacheKey));
        }
        try {
            CurrencyRate result = null;
            CurrencyRateData cached = this.findInCache(cacheKey, issueDate);
            if (cached != null) {
                result = cached.rate;
            } else {
                result = this.findInDictionaryCache(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
                this.cacheIt(result, cacheKey, issueDate);
            }
            return result;
        }
        catch (Exception e) {
            String msg = String.format("failed to compute findRateAndUpdateCache(%s,%s,%s,%s,%s,%s,%s,%s)", baseCurrencyCode, currencyCode, issueDateString, rateType, tariffType, blankOwner != null ? blankOwner.getUid() : null, supplier != null ? supplier.getUid() : null, cacheKey);
            IncidentsLog.reportException((String)msg, (Throwable)e);
            this.log.error(msg, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private CurrencyRate findInDictionaryCache(String baseCurrencyCode, String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        CurrencyRate result = null;
        String equivCurrencyCode = DictHelper.getEquivCurrency();
        long issueDateTime = issueDate.getTime();
        for (CurrencyRate rate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            String dictBaseCurrencyCode;
            Date date = rate.getDate();
            if (date == null || rate.getCurrency() == null || !rate.getCurrency().equalsIgnoreCase(currencyCode) || !Objects.equals(dictBaseCurrencyCode = (dictBaseCurrencyCode = rate.getBaseCurrency()) == null ? equivCurrencyCode : dictBaseCurrencyCode, baseCurrencyCode) || rateType != null && rate.getType() != rateType || tariffType != null && rate.getTariffType() != tariffType || blankOwner != null && !blankOwner.equals((Object)rate.getBlankOwner()) || supplier != null && !supplier.equals((Object)rate.getSupplier()) || CurrencyRateType.VENDOR == rateType && supplier == null && rate.getSupplier() != null || issueDateTime != -1L && MiscUtil.clearTime((Date)date).getTime() > issueDateTime || result != null && date.getTime() <= result.getDate().getTime()) continue;
            result = rate;
        }
        return result;
    }

    private CurrencyRateData findInCache(String key, Date issueDate) {
        CurrencyRateData result = null;
        Set<CurrencyRateData> cacheValues = this.cache.get(key);
        if (cacheValues != null) {
            for (CurrencyRateData rate : cacheValues) {
                if (issueDate.before(rate.date) || issueDate.after(rate.issueDate)) continue;
                result = rate;
                break;
            }
        }
        return result;
    }

    private String yyyymmdd(Date date) {
        LocalDate localDate = date != null ? MiscUtil.toLocalDate((Date)date) : null;
        return localDate != null ? localDate.toString() : null;
    }

    private void cacheIt(CurrencyRate rate, String key, Date issueDate) {
        ConcurrentSkipListSet<CurrencyRateData> values2;
        ConcurrentSkipListSet<CurrencyRateData> values;
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("adding to currency rate supercache: key=%s, issueDate=%s, rate=%s", key, this.yyyymmdd(issueDate), this.info(rate)));
        }
        if ((values = this.cache.get(key)) == null && (values = (ConcurrentSkipListSet<CurrencyRateData>)this.cache.putIfAbsent(key, values2 = new ConcurrentSkipListSet<CurrencyRateData>(comparator))) == null) {
            values = values2;
        }
        CurrencyRateData rateData = rate != null ? new CurrencyRateData(rate, issueDate) : new CurrencyRateData(issueDate);
        values.add(rateData);
    }

    private String info(CurrencyRate obj) {
        return obj != null ? obj.getUid() : null;
    }

    public void dictionaryCacheChanged(Map<String, DictionaryDataModification> reloadedDictionaries, DictionaryDataModification dataModification) {
        for (String dictId : reloadedDictionaries.keySet()) {
            if (!CurrencyRate.class.getName().equals(dictId)) continue;
            this.invalidateAll();
            return;
        }
        for (DictionaryReference item : dataModification.getDeleted()) {
            if (!item.getType().equals(CurrencyRate.class)) continue;
            this.invalidateAll();
            return;
        }
        for (DictionaryReference item : dataModification.getModified()) {
            if (!(item instanceof CurrencyRate)) continue;
            this.invalidateAll();
            return;
        }
    }

    public void onPut(BaseDictionary dict) {
        if (dict instanceof CurrencyRate) {
            this.invalidateAll();
        }
    }

    public void onEvict(BaseDictionary dict) {
        if (dict instanceof CurrencyRate) {
            this.invalidateAll();
        }
    }

    void invalidateAll() {
        this.cache.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug(LogUtil.getStackTrace("currency rate supercache was invalidated"));
        }
    }

    class ShaperKey {
        private final String cacheKey;
        private final String issueDate;

        public ShaperKey(String cacheKey, Date issueDate) {
            this.cacheKey = cacheKey;
            this.issueDate = issueDate != null ? CurrencyRateSuperCache.this.yyyymmdd(issueDate) : null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ShaperKey)) {
                return false;
            }
            ShaperKey t = (ShaperKey)obj;
            return Objects.equals(this.cacheKey, t.cacheKey) && Objects.equals(this.issueDate, t.issueDate);
        }

        public int hashCode() {
            return this.cacheKey != null ? this.cacheKey.hashCode() : 0;
        }
    }

    static class CurrencyRateData {
        final CurrencyRate rate;
        final Date issueDate;
        final Date date;
        final int hashCode;

        CurrencyRateData(CurrencyRate rate, Date issueDate) {
            this.rate = rate;
            this.issueDate = MiscUtil.setDayEndTime((Date)issueDate);
            this.date = MiscUtil.clearTime((Date)rate.getDate());
            this.hashCode = CurrencyRateData.calculateHash(issueDate, this.date);
        }

        CurrencyRateData(Date issueDate) {
            this.rate = null;
            this.issueDate = MiscUtil.setDayEndTime((Date)issueDate);
            this.date = MiscUtil.clearTime((Date)new Date(0L));
            this.hashCode = CurrencyRateData.calculateHash(issueDate, this.date);
        }

        private static int calculateHash(Date issueDate, Date date) {
            return String.format("%s_%s", Long.toString(issueDate.getTime()), Long.toString(date.getTime())).hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CurrencyRateData)) {
                return false;
            }
            CurrencyRateData other = (CurrencyRateData)obj;
            if (!MiscUtil.equals((Object)this.date, (Object)other.date)) {
                return false;
            }
            if (!MiscUtil.equals((Object)this.issueDate, (Object)other.issueDate)) {
                return false;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

