/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductPeriodType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.FinanceDocumentHandler;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinanceDocumentsHelper {
    private static Logger log = LoggerFactory.getLogger(FinanceDocumentsHelper.class);
    public static final String MESSAGES_KEY = "messages";
    public static final List<FinanceDocumentType> types = Arrays.asList(FinanceDocumentType.STANDARD_BILL, FinanceDocumentType.INVOICE, FinanceDocumentType.INVOICE_CONSOLIDATED, FinanceDocumentType.INVOICE_PREPAYMENT, FinanceDocumentType.CORRECTION_DOCUMENT, FinanceDocumentType.INVOICE_FACTURA, FinanceDocumentType.ACCEPTANCE_CERTIFICATE, FinanceDocumentType.UNIVERSAL_DOCUMENT);
    public static final Collection<ProductStatus> allowedProductStatusesShipment = Arrays.asList(ProductStatus.SELL, ProductStatus.REFUND);
    public static final Collection<ProductStatus> allowedProductStatusesPrepayment = Arrays.asList(ProductStatus.SELL, ProductStatus.REFUND, ProductStatus.BOOKING);
    public static final Comparator<Shipment> shipmentComparator = new Comparator<Shipment>(){

        @Override
        public int compare(Shipment o1, Shipment o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return o1 == null ? 0 : 1;
            }
            return MiscUtil.compare((Comparable)((Object)o1.getNumber()), (Comparable)((Object)o2.getNumber()));
        }
    };
    public static final Comparator<BaseProduct> productComparator = new Comparator<BaseProduct>(){

        @Override
        public int compare(BaseProduct o1, BaseProduct o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return o1 == null ? 0 : 1;
            }
            return MiscUtil.compare((Comparable)((Object)this.getSortingTicketNumber(o1, new HashSet<BaseProduct>())), (Comparable)((Object)this.getSortingTicketNumber(o2, new HashSet<BaseProduct>())));
        }

        private String getSortingTicketNumber(BaseProduct product, Set<BaseProduct> checkedProducts) {
            BaseProduct relatedProduct;
            StringBuilder number = new StringBuilder();
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(product);
            ProductCategory productCategory = handler.getProductCategory(product);
            ProductStatus status = handler.getStatus(product);
            List<String> productNumbers = handler.getProductNumbers(product);
            String systemNumber = productNumbers.size() > 0 ? productNumbers.get(0) : null;
            BaseProduct previousProduct = handler.getPreviousProduct(product);
            List<BaseProduct> relatedProducts = handler.getRelatedProducts(product);
            BaseProduct baseProduct = relatedProduct = relatedProducts.size() > 0 ? relatedProducts.get(0) : null;
            if (previousProduct != null && !checkedProducts.contains(previousProduct)) {
                checkedProducts.add(previousProduct);
                String previousNumber = this.getSortingTicketNumber(previousProduct, checkedProducts);
                number.append(previousNumber).append(" -> ");
            } else if (relatedProduct != null && !checkedProducts.contains(relatedProduct)) {
                checkedProducts.add(relatedProduct);
                String relatedNumber = this.getSortingTicketNumber(relatedProduct, checkedProducts);
                number.append(relatedNumber).append(" -> ");
            }
            String prefix = productCategory == ProductCategory.MCO ? "A" : (productCategory == ProductCategory.AIR ? "B" : "C");
            String suffix = status == ProductStatus.SELL ? "1" : (status == ProductStatus.REFUND ? "2" : (status == ProductStatus.EXCHANGE ? "3" : "4"));
            number.append(String.format("%s_%s_%s_%s", prefix, systemNumber, suffix, product.getUid()));
            return number.length() > 0 ? number.toString() : null;
        }
    };
    public static final Comparator<ServiceType> serviceTypeComparator = new Comparator<ServiceType>(){
        private final List<ServiceType> weights = Arrays.asList(ServiceType.TICKET, ServiceType.PENALTY, ServiceType.FEE, ServiceType.DISCOUNT);

        @Override
        public int compare(ServiceType o1, ServiceType o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return o1 == null ? 0 : 1;
            }
            return this.weights.indexOf(o1) - this.weights.indexOf(o2);
        }
    };
    public static final Comparator<FopComponent> fopComponentComparator = new Comparator<FopComponent>(){

        @Override
        public int compare(FopComponent o1, FopComponent o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return o1 == null ? 0 : 1;
            }
            return MiscUtil.compare((Comparable)((Object)this.getComponentSortingNumber(o1)), (Comparable)((Object)this.getComponentSortingNumber(o2)));
        }

        private String getComponentSortingNumber(FopComponent component) {
            StringBuilder componentSortingNumber = new StringBuilder();
            FopComponentType type = component.getType();
            String typeSortingNumber = type == FopComponentType.PRODUCT ? "1" : (type == FopComponentType.TAXES ? "2" : (type == FopComponentType.SERVICE ? "3" : (type == FopComponentType.PENALTY ? "4" : (type == FopComponentType.DEDUCTION ? "5" : (type == FopComponentType.VENDOR_FEES ? "6" : (type == FopComponentType.TECHNICAL_PROVIDER_FEES ? "7" : (type == FopComponentType.OWN_FEES ? "8" : (type == FopComponentType.DISCOUNTS ? "9" : "10"))))))));
            componentSortingNumber.append(String.format("%s_%s", typeSortingNumber, component.getUid()));
            return componentSortingNumber.length() > 0 ? componentSortingNumber.toString() : null;
        }
    };

    public static MiscUtil.PeriodType toPeriodType(ProductPeriodType productPeriodType) {
        if (productPeriodType == ProductPeriodType.MONTH) {
            return MiscUtil.PeriodType.MONTH;
        }
        if (productPeriodType == ProductPeriodType.MONTH_HALF) {
            return MiscUtil.PeriodType.MONTH_HALF;
        }
        if (productPeriodType == ProductPeriodType.DECADE) {
            return MiscUtil.PeriodType.DECADE;
        }
        if (productPeriodType == ProductPeriodType.WEEK) {
            return MiscUtil.PeriodType.WEEK;
        }
        if (productPeriodType == ProductPeriodType.DAY) {
            return MiscUtil.PeriodType.DAY;
        }
        if (productPeriodType == ProductPeriodType.BSP_PERIOD) {
            return MiscUtil.PeriodType.BSP_PERIOD;
        }
        if (productPeriodType == ProductPeriodType.EVERY_N_DAYS_OF_MONTH) {
            return MiscUtil.PeriodType.EVERY_N_DAYS_OF_MONTH;
        }
        return null;
    }

    public static DayOfWeek toDayOfWeek(WeekDay weekDay) {
        if (weekDay == WeekDay.MONDAY) {
            return DayOfWeek.MONDAY;
        }
        if (weekDay == WeekDay.TUESDAY) {
            return DayOfWeek.TUESDAY;
        }
        if (weekDay == WeekDay.WEDNESDAY) {
            return DayOfWeek.WEDNESDAY;
        }
        if (weekDay == WeekDay.THURSDAY) {
            return DayOfWeek.THURSDAY;
        }
        if (weekDay == WeekDay.FRIDAY) {
            return DayOfWeek.FRIDAY;
        }
        if (weekDay == WeekDay.SATURDAY) {
            return DayOfWeek.SATURDAY;
        }
        if (weekDay == WeekDay.SUNDAY) {
            return DayOfWeek.SUNDAY;
        }
        return null;
    }

    public static Set<BaseProduct> getProductsForPayment(BookingFile booking, boolean onlyUnpaid) {
        if (booking == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<BaseProduct> result = new LinkedHashSet<BaseProduct>();
        HashSet uids = new HashSet();
        for (Payment payment : booking.getPayments()) {
            if (payment.isCanceled()) continue;
            for (BillingItem bi : payment.getBillingItems()) {
                uids.addAll(bi.getProductUids());
            }
        }
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(prod.getClass());
                if (handler == null) {
                    log.error("no product handler is registered for product class " + prod.getClass().getName());
                    continue;
                }
                if (!handler.includeInFinanceDocuments(prod) || onlyUnpaid && uids.contains(prod.getUid())) continue;
                result.add(prod);
            }
        }
        return result;
    }

    public static List<FinanceDocument> getAvailableFinanceDocuments(BookingFile bookingFile) throws Exception {
        ArrayList<FinanceDocument> documents = new ArrayList<FinanceDocument>();
        List<FinanceDocumentType> types = FinanceDocumentsHelper.getFinanceDocumentTypes(bookingFile);
        for (FinanceDocumentType type : types) {
            FinanceDocumentSettings settings = FinanceDocumentsHelper.getFinanceDocumentSettings(bookingFile, type);
            if (settings == null || settings.getTemplate() == null) continue;
            FinanceDocument document = new FinanceDocument();
            document.setType(settings.getType());
            document.setTemplate(settings.getTemplate());
            document.setIncludeStamp(true);
            documents.add(document);
        }
        return documents;
    }

    public static List<FinanceDocument> getAllFinanceDocuments(Set<Message> messages) throws Exception {
        ArrayList<FinanceDocument> documents = new ArrayList<FinanceDocument>();
        for (TemplateDocumentIndex index : EntityStorage.get().search(TemplateDocumentIndex.class, new SearchQuery()).getData()) {
            FinanceDocumentType financeDocumentType;
            EntityContainer templateDocumentContainer = EntityStorage.get().resolve(index.getSource());
            if (templateDocumentContainer == null) {
                messages.add(SystemHelper.createMessage(MessageType.WARNING, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d", index.getSource()));
                continue;
            }
            TemplateDocument templateDocument = (TemplateDocument)templateDocumentContainer.getEntity();
            String financeDocumentTypeCode = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_FINANCE_DOCUMENT_TYPE);
            if (TextUtil.isBlank((String)financeDocumentTypeCode)) continue;
            FinanceDocument financeDocument = new FinanceDocument();
            try {
                financeDocumentType = FinanceDocumentType.valueOf((String)financeDocumentTypeCode);
            }
            catch (Exception e) {
                log.error("unknown finance document type " + financeDocumentTypeCode, (Throwable)e);
                continue;
            }
            financeDocument.setType(financeDocumentType);
            financeDocument.setTemplate(templateDocumentContainer.toReference());
            documents.add(financeDocument);
        }
        return documents;
    }

    public static List<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        if (products.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Class, Set> map = new HashMap<Class, Set>();
        for (BaseProduct bp : products) {
            Set set = map.computeIfAbsent(bp.getClass(), k -> new HashSet());
            set.add(bp);
        }
        ArrayList<FinanceDocument> result = new ArrayList<FinanceDocument>(availableDocuments);
        for (Map.Entry entry : map.entrySet()) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler((Class)entry.getKey());
            if (handler == null) {
                log.error("no product handler is registered for product class " + ((Class)entry.getKey()).getName());
                continue;
            }
            Set<FinanceDocument> docs = handler.getAppropriateFinanceDocuments((Collection)entry.getValue(), availableDocuments);
            result.removeIf(financeDocument -> !docs.contains(financeDocument));
        }
        result.sort((o1, o2) -> TextUtil.compare((String)o1.getTemplate().toString(), (String)o2.getTemplate().toString(), (boolean)false, (boolean)true));
        return result;
    }

    public static Payment addPayment(Collection<BaseProduct> products, List<FinanceDocument> documents, Set<Message> messages) throws Exception {
        EntityContainer subagencyContainer;
        if (products.isEmpty()) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043d\u0435\u0442 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", new Object[0]));
            return null;
        }
        BookingFile bf = products.iterator().next().getReservation().getBookingFile();
        EntityContainer agencyCtr = EntityStorage.get().resolve(bf.getAgency());
        if (agencyCtr == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430", new Object[0]));
            return null;
        }
        EntityReference<Organization> supplier = null;
        EntityReference<Organization> subagency = null;
        for (BaseProduct prod : products) {
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(prod.getClass());
            if (handler == null) {
                log.error("no product handler is registered for product class " + prod.getClass().getName());
                continue;
            }
            if (supplier == null) {
                supplier = GeneralProductHelper.getSupplier(prod);
            }
            if (subagency == null) {
                subagency = GeneralProductHelper.getSubagency(prod);
            }
            if (supplier == null || subagency == null) continue;
            break;
        }
        if (supplier == null) {
            messages.add(SystemHelper.createMessage(MessageType.WARNING, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0443\u0441\u043b\u0443\u0433", new Object[0]));
        }
        if (subagency == null) {
            messages.add(SystemHelper.createMessage(MessageType.WARNING, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0430", new Object[0]));
        }
        EntityReference agent = null;
        String userLogin = UserData.get().getCurrentUser();
        if (userLogin != null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)userLogin));
            List personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
            if (personIndexes.size() > 0) {
                agent = ((PersonIndex)personIndexes.get(0)).getSource();
            }
        }
        FinanceDocumentsProperties fdp = null;
        if (subagency != null && (subagencyContainer = EntityStorage.get().resolve(subagency)) != null && subagencyContainer.getEntity() != null) {
            fdp = ((Organization)subagencyContainer.getEntity()).getFinanceDocumentProperties();
        }
        Fop existingFop = null;
        for (BaseProduct prod : products) {
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(prod.getClass());
            if (handler == null) {
                log.error("no product handler is registered for product class " + prod.getClass().getName());
                continue;
            }
            Fop fop2 = GeneralProductHelper.findFop(prod);
            if (fop2 == null) continue;
            existingFop = fop2;
            break;
        }
        Payment result = new Payment();
        result.setDate(new Date());
        result.setBookingFile(bf);
        result.setSupplier(supplier);
        result.setAgent(agent);
        Date date = new Date();
        result.setDate(date);
        Fop fop = new Fop();
        result.setSupplierFop(new Fop());
        if (existingFop != null) {
            fop.setCard(existingFop.getCard());
            fop.setType(existingFop.getType());
            result.getSupplierFop().setType(existingFop.getType());
        }
        result.setFop(fop);
        FinanceDocumentsHelper.updatePayment(result, products, fdp, ((Organization)agencyCtr.getEntity()).isSimpleTaxed());
        FinanceDocumentsHelper.updatePaymentFinanceDocuments(result, documents, fdp, ((Organization)agencyCtr.getEntity()).isSimpleTaxed());
        bf.getPayments().add(result);
        return result;
    }

    public static void updatePaymentFinanceDocuments(Payment payment, Collection<FinanceDocument> originalFinanceDocuments, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap<String, FinanceDocument> financeDocuments = new HashMap<String, FinanceDocument>();
        for (FinanceDocument originalFinanceDocument : originalFinanceDocuments) {
            FinanceDocumentHandler handler = HandlersRegistry.get().findFinanceDocumentHandler(originalFinanceDocument.getType());
            if (handler == null) continue;
            FinanceDocumentSettings settings = FinanceDocumentsHelper.getFinanceDocumentSettings(payment.getBookingFile(), originalFinanceDocument.getType());
            for (BillingItem billingItem : payment.getBillingItems()) {
                if (!handler.accept(billingItem, payment, settings)) continue;
                String documentGroupId = handler.getDocumentGroupId(billingItem, payment, settings);
                FinanceDocument financeDocument = (FinanceDocument)financeDocuments.get(documentGroupId);
                if (financeDocument == null) {
                    financeDocument = (FinanceDocument)XCloneHelper.clone((XCloneable)originalFinanceDocument, (boolean)true);
                    financeDocument.setPayment(payment);
                    financeDocument.setDate(payment.getDate());
                    financeDocuments.put(documentGroupId, financeDocument);
                }
                financeDocument.getBillingItems().add(billingItem);
            }
        }
        payment.getFinanceDocuments().addAll(financeDocuments.values());
    }

    public static boolean isPaymentForRefund(Payment payment) {
        for (BillingItem billingItem : payment.getBillingItems()) {
            for (String productUid : billingItem.getProductUids()) {
                ProductHandler<?> productHandler;
                BaseProduct baseProduct = BookingHelper.findProduct(payment.getBookingFile(), productUid);
                if (baseProduct == null || (productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass())) == null || productHandler.getStatus(baseProduct) != ProductStatus.REFUND && !ProductStatusHandler.getAllVoidStatuses().contains(productHandler.getStatus(baseProduct)) && !MCOCategory.RETURN_FARE_DIFFERENCE.equals((Object)productHandler.getMCOCategory(baseProduct))) continue;
                return true;
            }
        }
        return false;
    }

    public static void updatePayment(Payment payment, Collection<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ProductHandler handler;
        HashMap<Class, List> map = new HashMap<Class, List>();
        for (BaseProduct bp : products) {
            List list = map.computeIfAbsent(bp.getClass(), k -> new ArrayList());
            list.add(bp);
        }
        ArrayList<BillingItem> billingItems = new ArrayList<BillingItem>();
        for (Map.Entry entry : map.entrySet()) {
            handler = HandlersRegistry.get().findProductHandler((Class)entry.getKey());
            if (handler == null) {
                log.error("no product handler is registered for product class " + ((Class)entry.getKey()).getName());
                continue;
            }
            billingItems.addAll(handler.getBillingItems((List)entry.getValue(), fdp, noVat));
        }
        for (Map.Entry entry : map.entrySet()) {
            handler = HandlersRegistry.get().findProductHandler((Class)entry.getKey());
            if (handler == null) {
                log.error("no product handler is registered for product class " + ((Class)entry.getKey()).getName());
                continue;
            }
            handler.updateBillingItems(billingItems, (List)entry.getValue());
        }
        billingItems.sort(new Comparator<BillingItem>(){

            @Override
            public int compare(BillingItem o1, BillingItem o2) {
                int type2;
                int type1 = this.getServiceTypeIndex(o1.getServiceType());
                if (type1 != (type2 = this.getServiceTypeIndex(o2.getServiceType()))) {
                    return type1 > type2 ? 1 : -1;
                }
                return TextUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)false, (boolean)true);
            }

            private int getServiceTypeIndex(ServiceType serviceType) {
                if (serviceType == null) {
                    return 5;
                }
                switch (serviceType) {
                    case TICKET: {
                        return 0;
                    }
                    case PENALTY: {
                        return 1;
                    }
                    case FEE: {
                        return 2;
                    }
                    case DISCOUNT: {
                        return 3;
                    }
                }
                return 4;
            }
        });
        payment.getBillingItems().addAll(billingItems);
    }

    public static <T> void updateMap(Map<String, List<T>> map, String description, T object) {
        String key = description != null ? description : "";
        List lst = map.computeIfAbsent(key, k -> new ArrayList());
        lst.add(object);
    }

    public static String getDescription(String commonPart, VatAmount money) {
        String result = commonPart;
        DecimalFormat pf = LocaleManager.get().getCurrentLocaleData().getPriceFormat();
        result = result + "_";
        result = result + pf.format(money.getTotal().doubleValue());
        if (money.getVatAmount() != null) {
            result = result + "_";
            result = result + pf.format(money.getVatAmount().doubleValue());
        }
        return result;
    }

    public static EntityContainer<Organization> getAgency(BookingFile bookingFile, Payment payment) throws Exception {
        for (BillingItem billingItem : payment.getBillingItems()) {
            EntityReference<Organization> subagencyReference;
            BaseProduct baseProduct = BookingHelper.findProduct(bookingFile, !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler == null || (subagencyReference = GeneralProductHelper.getSubagency(baseProduct)) == null) continue;
            return EntityStorage.get().resolve(subagencyReference);
        }
        return null;
    }

    public static EntityContainer<Branch> getBranch(BookingFile bookingFile, Payment payment) throws Exception {
        for (BillingItem billingItem : payment.getBillingItems()) {
            EntityReference<Branch> branchReference;
            BaseProduct prod = BookingHelper.findProduct(bookingFile, !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(prod.getClass());
            if (handler == null || (branchReference = handler.getBranch(prod)) == null) continue;
            return EntityStorage.get().resolve(branchReference);
        }
        return null;
    }

    public static EntityContainer<Person> getAgent(BookingFile bookingFile, Payment payment) throws Exception {
        for (BillingItem billingItem : payment.getBillingItems()) {
            EntityReference<Person> agentReference;
            BaseProduct prod = BookingHelper.findProduct(bookingFile, !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(prod.getClass());
            if (handler == null || (agentReference = GeneralProductHelper.findFOPAgent(prod)) == null) continue;
            return EntityStorage.get().resolve(agentReference);
        }
        return null;
    }

    public static FinanceDocumentsProperties getFinanceDocumentProperties(BookingFile bookingFile, Payment payment) throws Exception {
        EntityContainer<Organization> agencyContainer = FinanceDocumentsHelper.getAgency(bookingFile, payment);
        if (agencyContainer != null) {
            return ((Organization)agencyContainer.getEntity()).getFinanceDocumentProperties();
        }
        return null;
    }

    public static List<FinanceDocumentType> getFinanceDocumentTypes(BookingFile bookingFile) {
        ArrayList<FinanceDocumentType> types = new ArrayList<FinanceDocumentType>();
        EntityContainer clientContainer = EntityStorage.get().resolve(bookingFile.getCustomerProfile());
        if (clientContainer != null) {
            for (Object settings : ((Organization)clientContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                if (!settings.isUseDocument() || settings.getType() == null) continue;
                types.add(settings.getType());
            }
        }
        if (!types.isEmpty()) {
            return types;
        }
        EntityContainer branchContainer = EntityStorage.get().resolve(BookingHelper.getBranch(bookingFile));
        if (branchContainer != null) {
            for (FinanceDocumentSettings settings : ((Branch)branchContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                if (!settings.isUseDocument() || settings.getType() == null) continue;
                types.add(settings.getType());
            }
        }
        if (!types.isEmpty()) {
            return types;
        }
        EntityContainer subagencyContainer = EntityStorage.get().resolve(BookingHelper.getSubagency(bookingFile));
        if (subagencyContainer != null) {
            for (FinanceDocumentSettings settings : ((Organization)subagencyContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                if (!settings.isUseDocument() || settings.getType() == null) continue;
                types.add(settings.getType());
            }
        }
        if (!types.isEmpty()) {
            return types;
        }
        return Collections.emptyList();
    }

    public static FinanceDocumentSettings getFinanceDocumentSettings(BookingFile bookingFile, FinanceDocumentType type) throws Exception {
        EntityContainer subagencyContainer;
        EntityContainer branchContainer;
        EntityContainer clientContainer = EntityStorage.get().resolve(bookingFile.getCustomerProfile());
        if (clientContainer != null) {
            for (Object settings : ((Organization)clientContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                if (settings.getType() == null || !settings.getType().equals((Object)type)) continue;
                if (!settings.isUseSettings()) break;
                return settings;
            }
        }
        if ((branchContainer = EntityStorage.get().resolve(BookingHelper.getBranch(bookingFile))) != null) {
            for (FinanceDocumentSettings settings : ((Branch)branchContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                if (settings.getType() == null || !settings.getType().equals((Object)type)) continue;
                if (!settings.isUseSettings()) break;
                return settings;
            }
        }
        if ((subagencyContainer = EntityStorage.get().resolve(BookingHelper.getSubagency(bookingFile))) != null) {
            for (FinanceDocumentSettings settings : ((Organization)subagencyContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                if (settings.getType() == null || !settings.getType().equals((Object)type)) continue;
                if (!settings.isUseSettings()) break;
                return settings;
            }
        }
        return null;
    }

    public static FinanceDocumentSettings getFinanceDocumentSettings(List<FinanceDocumentSettings> financeDocumentsSettings, FinanceDocumentType type) {
        for (FinanceDocumentSettings financeDocumentSettings : financeDocumentsSettings) {
            if (financeDocumentSettings.getType() != type) continue;
            return financeDocumentSettings;
        }
        return null;
    }

    public static BillingItemSettings getBillingItemSettings(List<BillingItemSettings> billingItemsSettings, ServiceType type) {
        for (BillingItemSettings billingItemSettings : billingItemsSettings) {
            if (billingItemSettings.getType() != type) continue;
            return billingItemSettings;
        }
        return null;
    }

    public static String getMoneyStr(BigDecimal price, Locale locale, String currency) {
        Number2WordsConverter number2WordsConverter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(locale, currency);
        if (number2WordsConverter != null) {
            try {
                return TextUtil.capitalize((String)number2WordsConverter.toCurrencyWords(price, currency, false, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isValidProductForFinanceDocument(BaseProduct bp) {
        ProductHandler<BaseProduct> ph = GeneralProductHelper.getHandler(bp);
        return MessageHelper.filterValidMessages(ph.getValidationMessages(bp), ValidationMessageSeverity.WARNING, ValidationMessageCategory.FOP_DETALIZATION).isEmpty();
    }

    public static boolean isConsolidated(FinanceDocumentType type) {
        return type == FinanceDocumentType.INVOICE_CONSOLIDATED;
    }

    public static boolean isPrepayment(FinanceDocumentType type) {
        return type == FinanceDocumentType.INVOICE_PREPAYMENT;
    }

    public static boolean isCorrection(FinanceDocumentType type) {
        return type == FinanceDocumentType.CORRECTION_DOCUMENT;
    }

    public static String getFinanceDocumentDataKey(FinanceDocumentData data) {
        FinanceDocumentType type = data.getType();
        EntityReference template = data.getTemplate();
        BillingItemIncludeMode billingItemIncludeMode = data.getBillingItemIncludeMode();
        VatViewMode vatViewMode = data.getVatViewMode();
        boolean groupByTraveller = data.isGroupByTraveller();
        boolean notGroupByProduct = data.isNotGroupByProduct();
        Boolean mergeBillingItems = data.getMergeBillingItems();
        boolean useDelegate = data.isUseDelegate();
        boolean useFacsimile = data.isUseFacsimile();
        boolean disableCustomerQuotes = data.isDisableCustomerQuotes();
        boolean displayContract = data.isDisplayContract();
        boolean notDisplayTitleContractNumber = data.isNotDisplayTitleContractNumber();
        boolean notGroupByServiceType = data.isNotGroupByServiceType();
        boolean invertSign = data.isInvertSign();
        String captionTemplate = data.getCaptionTemplate();
        UniversalDocumentStatus status = data.getUniversalDocumentStatus();
        Map customParameters = data.getCustomParameters();
        return String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", type != null ? type.name().toLowerCase() : "?", template != null ? template.getUid() : "?", billingItemIncludeMode != null ? billingItemIncludeMode.name().toLowerCase() : "?", vatViewMode != null ? vatViewMode.name().toLowerCase() : "?", groupByTraveller, notGroupByProduct, disableCustomerQuotes, displayContract, notDisplayTitleContractNumber, notGroupByServiceType, invertSign, mergeBillingItems != null ? mergeBillingItems : "?", useDelegate, useFacsimile, TextUtil.nonBlank((String)captionTemplate) ? captionTemplate : "?", status != null ? status.name().toLowerCase() : "?", customParameters.isEmpty() ? "?-?" : customParameters.entrySet().stream().map(entry -> (String)entry.getKey() + "-" + (String)entry.getValue()).collect(Collectors.joining(";")));
    }

    public static boolean isSameBillingItems(com.gridnine.xtrip.common.model.finance.BillingItem bi1, com.gridnine.xtrip.common.model.finance.BillingItem bi2) {
        return MiscUtil.equals((Object)bi1.getAmount(), (Object)bi2.getAmount()) && MiscUtil.equals((Object)bi1.getServiceType(), (Object)bi2.getServiceType()) && MiscUtil.equals((Object)bi1.getPaymentType(), (Object)bi2.getPaymentType()) && MiscUtil.equals((Object)bi1.getNomenclature(), (Object)bi2.getNomenclature()) && MiscUtil.equals((Object)bi1.getSupplier(), (Object)bi2.getSupplier()) && MiscUtil.equals((Object)bi1.getTraveller(), (Object)bi2.getTraveller()) && MiscUtil.equals((Object)bi1.getProduct(), (Object)bi2.getProduct());
    }

    public static class FinanceDocumentProductData
    implements Serializable {
        private static final long serialVersionUID = -4583612367341962451L;
        private ContractType contractType;
        private BaseProduct product;
        private EntityReference<Organization> agency;
        private EntityReference<Organization> subagency;
        private BigDecimal total;
        private BigDecimal remain;

        public BaseProduct getProduct() {
            return this.product;
        }

        public void setProduct(BaseProduct product) {
            this.product = product;
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public void setTotal(BigDecimal total) {
            this.total = total;
        }

        public BigDecimal getRemain() {
            return this.remain;
        }

        public void setRemain(BigDecimal remain) {
            this.remain = remain;
        }

        public ContractType getContractType() {
            return this.contractType;
        }

        public void setContractType(ContractType contractType) {
            this.contractType = contractType;
        }

        public EntityReference<Organization> getAgency() {
            return this.agency;
        }

        public void setAgency(EntityReference<Organization> agency) {
            this.agency = agency;
        }

        public EntityReference<Organization> getSubagency() {
            return this.subagency;
        }

        public void setSubagency(EntityReference<Organization> subagency) {
            this.subagency = subagency;
        }
    }

    public static class FinanceConsolidatedDocumentsShipmentsData
    implements Serializable {
        private static final long serialVersionUID = 446480575886572835L;
        private Map<MiscUtil.Pair<EntityReference<Shipment>, Boolean>, MiscUtil.Pair<Shipment, BigDecimal>> shipmentAmountDatas;
        private BigDecimal totalAmount;

        public Map<MiscUtil.Pair<EntityReference<Shipment>, Boolean>, MiscUtil.Pair<Shipment, BigDecimal>> getShipmentAmountDatas() {
            return this.shipmentAmountDatas;
        }

        public void setShipmentAmountDatas(Map<MiscUtil.Pair<EntityReference<Shipment>, Boolean>, MiscUtil.Pair<Shipment, BigDecimal>> shipmentAmountDatas) {
            this.shipmentAmountDatas = shipmentAmountDatas;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
        }
    }
}

