/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.IbusManager;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageCommonParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationDataIndex;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.ProjectionQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.vip.NewFinanceModuleSettings;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class FinanceHelper {
    private static final EntityReference<NewFinanceModuleSettings> newFinanceModuleSettingsRef = SystemHelper.createSystemSettingsRererence(NewFinanceModuleSettings.class);

    public static DictionaryReference<CurrencyInfo> getDefaultCurrency() {
        return new CurrencyInfoReference(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB"));
    }

    public static DictionaryReference<CurrencyInfo> getCurrency(String currency) {
        return new CurrencyInfoReference(currency);
    }

    public static void save(EntityContainer<Transaction> transaction) throws Exception {
        HashMap<String, EntityContainer<Transaction>> data = new HashMap<String, EntityContainer<Transaction>>();
        data.put(IBusFinanceContextKeys.TRANSACTION_CONTAINER.name(), transaction);
        IbusManager.get().processSync("finance:save-transaction", data);
    }

    public static void delete(EntityContainer<Transaction> transaction) throws Exception {
        HashMap<String, EntityContainer<Transaction>> data = new HashMap<String, EntityContainer<Transaction>>();
        data.put(IBusFinanceContextKeys.TRANSACTION_CONTAINER.name(), transaction);
        IbusManager.get().processSync("finance:delete-transaction", data);
    }

    public static CurrencyRateType getCurrencyRateType(String currencyCode) {
        if (TextUtil.isSame((String)"RUB", (String)currencyCode)) {
            return CurrencyRateType.IATA;
        }
        if (TextUtil.isSame((String)"UAH", (String)currencyCode)) {
            return CurrencyRateType.NBU;
        }
        return CurrencyRateType.IATA;
    }

    public static BigDecimal exchange(BigDecimal amount, String sourceCurrencyCode, TariffType tariffType, Date date) {
        return FinanceHelper.exchange(amount, sourceCurrencyCode, tariffType, date, false);
    }

    public static BigDecimal exchange(BigDecimal amount, String sourceCurrencyCode, TariffType tariffType, Date date, boolean allowReverseRate) {
        String exchangeCurrencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
        return FinanceHelper.exchange(amount, sourceCurrencyCode, exchangeCurrencyCode, tariffType, date, allowReverseRate);
    }

    public static BigDecimal exchange(BigDecimal amount, String sourceCurrencyCode, String exchangeCurrencyCode, TariffType tariffType, Date date) {
        return FinanceHelper.exchange(amount, sourceCurrencyCode, exchangeCurrencyCode, tariffType, date, false);
    }

    public static BigDecimal exchange(BigDecimal amount, String sourceCurrencyCode, String exchangeCurrencyCode, TariffType tariffType, Date date, boolean allowReverseRate) {
        CurrencyRateType currencyRateType = FinanceHelper.getCurrencyRateType(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        return FinanceHelper.exchange(amount, sourceCurrencyCode, exchangeCurrencyCode, currencyRateType, tariffType, date, null, allowReverseRate);
    }

    public static BigDecimal exchange(BigDecimal amount, String sourceCurrencyCode, String exchangeCurrencyCode, CurrencyRateType currencyRateType, TariffType tariffType, Date date, EntityReference<Organization> supplier, boolean allowReverseRate) {
        if (amount == null) {
            return null;
        }
        Double rate = null;
        boolean reverseRate = false;
        if (!TextUtil.isBlank((String)sourceCurrencyCode) && !TextUtil.isBlank((String)exchangeCurrencyCode)) {
            if (!TextUtil.isSame((String)sourceCurrencyCode, (String)exchangeCurrencyCode)) {
                if (currencyRateType != null) {
                    CurrencyRate currencyRate = DictHelper.findExactCurrencyRate(sourceCurrencyCode, exchangeCurrencyCode, date, currencyRateType, tariffType, supplier);
                    if (currencyRate != null) {
                        rate = currencyRate.getRate();
                    } else if (allowReverseRate && (currencyRate = DictHelper.findExactCurrencyRate(exchangeCurrencyCode, sourceCurrencyCode, date, currencyRateType, tariffType, supplier)) != null) {
                        rate = currencyRate.getRate();
                        reverseRate = true;
                    }
                }
            } else {
                rate = 1.0;
            }
        }
        if (rate != null) {
            if (reverseRate) {
                if (BigDecimal.valueOf(rate).compareTo(BigDecimal.ZERO) != 0) {
                    return amount.divide(BigDecimal.valueOf(rate), 3, RoundingMode.HALF_UP);
                }
            } else {
                return amount.multiply(BigDecimal.valueOf(rate));
            }
        }
        return null;
    }

    public static BigDecimal exchange(BigDecimal amount, CurrencyRate currencyRate) {
        return FinanceHelper.exchange(amount, currencyRate, false);
    }

    public static BigDecimal exchange(BigDecimal amount, CurrencyRate currencyRate, boolean reverseRate) {
        if (amount == null || currencyRate == null) {
            return null;
        }
        double rate = currencyRate.getRate();
        if (reverseRate) {
            if (BigDecimal.valueOf(rate).compareTo(BigDecimal.ZERO) != 0) {
                return amount.divide(BigDecimal.valueOf(rate), 3, RoundingMode.HALF_UP);
            }
        } else {
            return amount.multiply(BigDecimal.valueOf(rate));
        }
        return null;
    }

    public static BigDecimal calculateExchangePrice(BigDecimal amount, String sourceCurrencyCode, String exchangeCurrencyCode, CurrencyRateType currencyRateType, TariffType tariffType, Date date, EntityReference<Organization> supplier, boolean reverseRate) {
        CurrencyRate currencyRate = DictHelper.findExactCurrencyRate(exchangeCurrencyCode, sourceCurrencyCode, date, currencyRateType, tariffType, supplier);
        if (currencyRate != null) {
            double rate = currencyRate.getRate();
            if (reverseRate) {
                if (BigDecimal.valueOf(rate).compareTo(BigDecimal.ZERO) != 0) {
                    return amount.divide(BigDecimal.valueOf(rate), 3, RoundingMode.HALF_UP);
                }
            } else {
                return amount.multiply(BigDecimal.valueOf(rate));
            }
        }
        return null;
    }

    public static FinanceInitializationDataIndex getFinanceInitializationDataIndex(EntityReference<Organization> organization, boolean isTolerant, String ... preferredProperties) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceInitializationDataIndex.Property.organization.name(), organization));
        for (String preferredProperty : preferredProperties) {
            query.getPreferredProperties().add(preferredProperty);
        }
        query.setLimit(1);
        SearchResult searchResult = isTolerant ? EntityStorage.get().search(FinanceInitializationDataIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS) : EntityStorage.get().search(FinanceInitializationDataIndex.class, query);
        List indexes = searchResult.getData();
        return indexes.size() > 0 ? (FinanceInitializationDataIndex)indexes.get(0) : null;
    }

    public static EntityReference<FinanceInitializationData> getFinanceInitializationData(EntityReference<Organization> organization) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceInitializationDataIndex.Property.organization.name(), organization));
        List indexes = EntityStorage.get().search(FinanceInitializationDataIndex.class, query).getData();
        return indexes.size() > 0 ? ((FinanceInitializationDataIndex)indexes.get(0)).getSource() : null;
    }

    public static Date getFinanceInitializationDate(EntityReference<Organization> organization) {
        FinanceInitializationDataIndex index = FinanceHelper.getFinanceInitializationDataIndex(organization, true, FinanceInitializationDataIndex.Property.date.name());
        return index != null ? index.getDate() : null;
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, boolean calculateHistorical, Map<Dimension, String> dimensions, RoundingParameters roundingParameters) {
        return FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, calculateHistorical, dimensions, roundingParameters, null);
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, boolean calculateHistorical, Map<Dimension, String> dimensions, RoundingParameters roundingParameters, EntityStorageCommonParameters parameters) {
        BigDecimal debitAmount = FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, calculateHistorical, dimensions, false, parameters);
        BigDecimal creditAmount = FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, calculateHistorical, dimensions, true, parameters);
        if (roundingParameters != null) {
            debitAmount = FinanceHelper.round(debitAmount);
            creditAmount = FinanceHelper.round(creditAmount);
        }
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{debitAmount, MiscUtil.negate((BigDecimal)creditAmount)});
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, boolean calculateHistorical, Map<Dimension, String> dimensions, boolean credit) {
        return FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, calculateHistorical, dimensions, credit, null);
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, boolean calculateHistorical, Map<Dimension, String> dimensions, boolean credit, EntityStorageCommonParameters parameters) {
        BigDecimal startOperationDateAmount = null;
        if (startOperationDate != null) {
            startOperationDateAmount = FinanceHelper.calculateBalance(chartOfAccountsElement, startOperationDate, calculationDate, calculateHistorical, dimensions, credit, parameters);
        }
        BigDecimal endOperationDateAmount = FinanceHelper.calculateBalance(chartOfAccountsElement, endOperationDate, calculationDate, calculateHistorical, dimensions, credit, parameters);
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{endOperationDateAmount, MiscUtil.negate((BigDecimal)startOperationDateAmount)});
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, Map<Dimension, String> dimensions) {
        return FinanceHelper.calculateBalance(chartOfAccountsElement, operationDate, calculationDate, dimensions, null);
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, Map<Dimension, String> dimensions, EntityStorageCommonParameters parameters) {
        BigDecimal debitAmount = FinanceHelper.calculateBalance(chartOfAccountsElement, operationDate, calculationDate, true, dimensions, false, parameters);
        BigDecimal creditAmount = FinanceHelper.calculateBalance(chartOfAccountsElement, operationDate, calculationDate, true, dimensions, true, parameters);
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{debitAmount, MiscUtil.negate((BigDecimal)creditAmount)});
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, Map<Dimension, String> dimensions, boolean credit) {
        return FinanceHelper.calculateBalance(chartOfAccountsElement, operationDate, calculationDate, true, dimensions, credit, null);
    }

    public static BigDecimal calculateBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, boolean calculateHistorical, Map<Dimension, String> dimensions, boolean credit, EntityStorageCommonParameters parameters) {
        ArrayList<SearchCriterion> andCriterions;
        if (chartOfAccountsElement == null) {
            throw new IllegalArgumentException("chart of accounts element can't be null");
        }
        long amount = 0L;
        OpeningBalance balance = FinanceHelper.getBalance(chartOfAccountsElement, operationDate, calculationDate, dimensions);
        if (balance != null) {
            amount += credit ? balance.getCredit() : balance.getDebit();
        }
        ProjectionQuery query = new ProjectionQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        ArrayList<SearchCriterion> orCriterions = new ArrayList<SearchCriterion>();
        if (balance != null) {
            andCriterions = new ArrayList<SearchCriterion>();
            andCriterions.add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)balance.getOperationDate()));
            andCriterions.add(SearchCriterion.gt((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)balance.getCalculationDate()));
            if (calculationDate != null) {
                andCriterions.add(SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate));
            }
            orCriterions.add(SearchCriterion.and((SearchCriterion[])andCriterions.toArray(new SearchCriterion[0])));
        }
        andCriterions = new ArrayList();
        if (balance != null) {
            andCriterions.add(SearchCriterion.gt((String)TransactionSplitIndex.Property.operationDate.name(), (Object)balance.getOperationDate()));
        }
        if (operationDate != null) {
            andCriterions.add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)operationDate));
        }
        if (calculationDate != null) {
            andCriterions.add(SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate));
        }
        if (!calculateHistorical) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        }
        orCriterions.add(SearchCriterion.and((SearchCriterion[])andCriterions.toArray(new SearchCriterion[0])));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])orCriterions.toArray(new SearchCriterion[0])));
        if (dimensions.get((Object)Dimension.DIMENSION_1) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_1)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_2) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_2)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_3) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_3)));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.credit.name(), (Object)credit));
        query.getProjections().add(Projection.sum((String)TransactionSplitIndex.Property.amount.name(), (String)"amount"));
        ProjectionResult result = parameters != null && parameters.getSearchParamaters() != null ? EntityStorage.get().search(TransactionSplitIndex.class, query, parameters.getSearchParamaters()) : EntityStorage.get().search(TransactionSplitIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(false));
        return ModelHelper.long2BigDecimal(amount += result.uniqueBigDecimal().longValue());
    }

    public static BigDecimal calculateTransactions(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, Map<Dimension, String> dimensions, List<SearchCriterion> criterions) {
        return FinanceHelper.calculateTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, dimensions, criterions, null);
    }

    public static BigDecimal calculateTransactions(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, Map<Dimension, String> dimensions, List<SearchCriterion> criterions, EntityStorageCommonParameters parameters) {
        BigDecimal debitAmount = FinanceHelper.calculateTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, dimensions, criterions, false, parameters);
        BigDecimal creditAmount = FinanceHelper.calculateTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, dimensions, criterions, true, parameters);
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{debitAmount, MiscUtil.negate((BigDecimal)creditAmount)});
    }

    public static BigDecimal calculateTransactions(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, Map<Dimension, String> dimensions, List<SearchCriterion> criterions, boolean credit) {
        return FinanceHelper.calculateTransactions(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, dimensions, criterions, credit, null);
    }

    public static BigDecimal calculateTransactions(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, Map<Dimension, String> dimensions, List<SearchCriterion> criterions, boolean credit, EntityStorageCommonParameters parameters) {
        if (chartOfAccountsElement == null) {
            throw new IllegalArgumentException("chart of accounts element can't be null");
        }
        ProjectionQuery query = new ProjectionQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        if (startOperationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)TransactionSplitIndex.Property.operationDate.name(), (Object)startOperationDate));
        }
        if (endOperationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)endOperationDate));
        }
        if (calculationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_1) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_1)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_2) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_2)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_3) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_3)));
        }
        query.getCriteria().getCriterions().addAll(criterions);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.credit.name(), (Object)credit));
        query.getProjections().add(Projection.sum((String)TransactionSplitIndex.Property.amount.name(), (String)"amount"));
        ProjectionResult result = parameters != null && parameters.getSearchParamaters() != null ? EntityStorage.get().search(TransactionSplitIndex.class, query, parameters.getSearchParamaters()) : EntityStorage.get().search(TransactionSplitIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(false));
        return ModelHelper.long2BigDecimal(result.uniqueBigDecimal().longValue());
    }

    public static OpeningBalance getBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, Map<Dimension, String> dimensions) {
        if (chartOfAccountsElement == null) {
            throw new IllegalArgumentException("chart of accounts element can't be null");
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        if (operationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)OpeningBalance.Property.operationDate.name(), (Object)operationDate));
        }
        if (calculationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)OpeningBalance.Property.calculationDate.name(), (Object)calculationDate));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_1) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension1.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_1)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension1.name(), null));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_2) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension2.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_2)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension2.name(), null));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_3) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension3.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_3)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension3.name(), null));
        }
        query.getCriteria().getOrders().put(OpeningBalance.Property.operationDate.name(), SortOrder.DESC);
        query.getCriteria().getOrders().put(OpeningBalance.Property.calculationDate.name(), SortOrder.DESC);
        query.setLimit(1);
        List balances = AssetsStorage.get().search(OpeningBalance.class, query).getData();
        if (balances.size() > 0) {
            return (OpeningBalance)((Object)balances.get(0));
        }
        return null;
    }

    public static String getChartOfAccountsSettingsCompoundKey(EntityReference<Organization> organization) {
        return String.format("CHART_OF_ACCOUNTS_SETTINGS_FOR_%s", organization.getUid());
    }

    public static String getChartOfAccountsElementCompoundUid(EntityReference<Organization> organization, EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency) {
        return String.format("%s_%s_%s_%s", organization.getUid(), chartOfAccountsSettings.getUid(), chartOfAccountsElementType.name(), currency.getCode());
    }

    public static boolean isChartOfAccountsSettingsDisabled(ChartOfAccountsSettings settings) {
        return !settings.getSupplierSettings().isEnabled() && !settings.getCustomerSettings().isEnabled() && !settings.getAgentSettings().isEnabled() && !settings.getCashRemainsSettings().isEnabled();
    }

    public static EntityReference<ChartOfAccountsSettings> getChartOfAccountsSettings(EntityReference<Organization> organization) {
        return FinanceHelper.getChartOfAccountsSettings(organization, false);
    }

    public static EntityReference<ChartOfAccountsSettings> getChartOfAccountsSettings(EntityReference<Organization> organization, boolean strict) {
        return FinanceHelper.getChartOfAccountsSettings((EntityContainer<Organization>)EntityStorage.get().resolve(organization), strict);
    }

    public static EntityReference<ChartOfAccountsSettings> getChartOfAccountsSettings(EntityContainer<Organization> organization, boolean strict) {
        EntityContainer chartOfAccountsSettingsContainer = null;
        if (organization != null && (chartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference<Organization>)organization.toReference()))) == null && !strict) {
            EntityReference<Organization> defaultOrganization = null;
            if (ProfileHelper.isOrganizationType((Organization)organization.getEntity(), OrganizationType.AGENCY)) {
                defaultOrganization = ProfileDao.findAllAgenciesProfile();
            } else if (ProfileHelper.isOrganizationType((Organization)organization.getEntity(), OrganizationType.CORPORATE_CLIENT)) {
                defaultOrganization = ProfileDao.findAllClientsProfile();
            }
            if (defaultOrganization != null) {
                chartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey(defaultOrganization));
            }
        }
        return chartOfAccountsSettingsContainer != null ? ((EntityContainer)chartOfAccountsSettingsContainer).toReference() : null;
    }

    public static boolean isSpecialChartOfAccountsElementType(ChartOfAccountsElementType type) {
        return type == ChartOfAccountsElementType.BANK || type == ChartOfAccountsElementType.INCOME || type == ChartOfAccountsElementType.INCOME_COMMISSION || type == ChartOfAccountsElementType.INCOME_FEE || type == ChartOfAccountsElementType.EXPENSE || type == ChartOfAccountsElementType.EXPENSE_COMMISSION || type == ChartOfAccountsElementType.EXPENSE_FEE;
    }

    public static BasicChartOfAccountsElementSettings getChartOfAccountsElementSettings(ChartOfAccountsSettings settings, ChartOfAccountsElementType type) {
        if (settings == null || type == null) {
            return null;
        }
        if (type == ChartOfAccountsElementType.SUPPLIER || type == ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE || type == ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT || type == ChartOfAccountsElementType.SUPPLIER_COMMISSION) {
            return settings.getSupplierSettings();
        }
        if (type == ChartOfAccountsElementType.CUSTOMER || type == ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE || type == ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT || type == ChartOfAccountsElementType.CUSTOMER_COMMISSION) {
            return settings.getCustomerSettings();
        }
        if (type == ChartOfAccountsElementType.AGENT || type == ChartOfAccountsElementType.AGENT_CORRECTION || type == ChartOfAccountsElementType.CASH_REGISTER || type == ChartOfAccountsElementType.CASH || type == ChartOfAccountsElementType.CASH_STASH || type == ChartOfAccountsElementType.CASH_CORRECTION || type == ChartOfAccountsElementType.TRANSFER) {
            return settings.getAgentSettings();
        }
        if (type == ChartOfAccountsElementType.CASH_REMAINS_CUSTOMER || type == ChartOfAccountsElementType.CASH_REMAINS_AGENT || type == ChartOfAccountsElementType.CASH_REMAINS_CASH || type == ChartOfAccountsElementType.CASH_REMAINS_STASH || type == ChartOfAccountsElementType.CASH_REMAINS_CORRECTION) {
            return settings.getCashRemainsSettings();
        }
        return null;
    }

    public static EntityReference<ChartOfAccountsElement> getChartOfAccountsElement(EntityReference<Organization> organization, EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency) {
        return FinanceHelper.getChartOfAccountsElement(organization, chartOfAccountsSettings, chartOfAccountsElementType, currency, null);
    }

    public static EntityReference<ChartOfAccountsElement> getChartOfAccountsElement(EntityReference<Organization> organization, EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency, EntityStorageCommonParameters parameters) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.settings.name(), chartOfAccountsSettings));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)chartOfAccountsElementType));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        List chartOfAccountsElementIndexes = parameters != null && parameters.getSearchParamaters() != null ? EntityStorage.get().search(ChartOfAccountsElementIndex.class, query, parameters.getSearchParamaters()).getData() : EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        return chartOfAccountsElementIndexes.size() > 0 ? ((ChartOfAccountsElementIndex)chartOfAccountsElementIndexes.get(0)).getSource() : null;
    }

    public static Set<DictionaryReference<CurrencyInfo>> getChartOfAccountsElementCurrencies(EntityReference<Organization> organization, EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings, ChartOfAccountsElementType chartOfAccountsElementType) {
        return FinanceHelper.getChartOfAccountsElementCurrencies(organization, chartOfAccountsSettings, chartOfAccountsElementType, null);
    }

    public static Set<DictionaryReference<CurrencyInfo>> getChartOfAccountsElementCurrencies(EntityReference<Organization> organization, EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings, ChartOfAccountsElementType chartOfAccountsElementType, EntityStorageCommonParameters parameters) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.settings.name(), chartOfAccountsSettings));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)chartOfAccountsElementType));
        return (parameters != null && parameters.getSearchParamaters() != null ? EntityStorage.get().search(ChartOfAccountsElementIndex.class, query, parameters.getSearchParamaters()).getData() : EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData()).stream().map(ChartOfAccountsElementIndex::getCurrency).collect(Collectors.toSet());
    }

    public static Dimension getDimension(BasicChartOfAccountsElementSettings settings, DimensionType type) {
        if (settings.getDimension1() != null && settings.getDimension1().getType() == type) {
            return Dimension.DIMENSION_1;
        }
        if (settings.getDimension2() != null && settings.getDimension2().getType() == type) {
            return Dimension.DIMENSION_2;
        }
        if (settings.getDimension3() != null && settings.getDimension3().getType() == type) {
            return Dimension.DIMENSION_3;
        }
        return null;
    }

    public static String getDimensionValue(DimensionType dimensionType, Object object) {
        if (object != null) {
            if (dimensionType == DimensionType.PAYMENT_TYPE) {
                return ((PaymentType)object).name();
            }
            if (dimensionType == DimensionType.CONTRACT_TYPE) {
                return ((ContractType)object).name();
            }
            if (dimensionType == DimensionType.ORGANIZATION) {
                return ((EntityReference)object).getUid();
            }
            if (dimensionType == DimensionType.AGENT) {
                return ((EntityReference)object).getUid();
            }
            if (dimensionType == DimensionType.CASH) {
                return ((EntityReference)object).getUid();
            }
            if (dimensionType == DimensionType.CASH_REGISTER) {
                return ((EntityReference)object).getUid();
            }
            if (dimensionType == DimensionType.CASH_REGISTER_WORKPLACE) {
                return ((EntityReference)object).getUid();
            }
            if (dimensionType == DimensionType.SALES_POINT) {
                return ((EntityReference)object).getUid();
            }
        }
        return null;
    }

    public static Object getDimensionObject(DimensionType dimensionType, String value) {
        if (dimensionType == DimensionType.PAYMENT_TYPE) {
            return PaymentType.valueOf((String)value);
        }
        if (dimensionType == DimensionType.CONTRACT_TYPE) {
            return ContractType.valueOf((String)value);
        }
        if (dimensionType == DimensionType.ORGANIZATION) {
            EntityReference organization = new EntityReference(value, Organization.class, null);
            EntityStorage.get().actualize(organization, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            return organization;
        }
        if (dimensionType == DimensionType.AGENT) {
            EntityReference person = new EntityReference(value, Person.class, null);
            EntityStorage.get().actualize(person, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            return person;
        }
        if (dimensionType == DimensionType.CASH) {
            EntityReference cash = new EntityReference(value, Cash.class, null);
            EntityStorage.get().actualize(cash, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            return cash;
        }
        if (dimensionType == DimensionType.CASH_REGISTER) {
            EntityReference cashRegister = new EntityReference(value, CashRegister.class, null);
            EntityStorage.get().actualize(cashRegister, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            return cashRegister;
        }
        if (dimensionType == DimensionType.CASH_REGISTER_WORKPLACE) {
            EntityReference cashRegisterWorkplace = new EntityReference(value, CashRegisterWorkplace.class, null);
            EntityStorage.get().actualize(cashRegisterWorkplace, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            return cashRegisterWorkplace;
        }
        if (dimensionType == DimensionType.SALES_POINT) {
            EntityReference salesPoint = new EntityReference(value, SalesPoint.class, null);
            EntityStorage.get().actualize(salesPoint, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            return salesPoint;
        }
        return null;
    }

    public static EntityContainer<ChartOfAccountsSettings> loadChartOfAccountsSettings(EntityReference<Organization> organization, boolean strict) {
        if (organization != null) {
            EntityContainer organizationChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey(organization));
            if (organizationChartOfAccountsSettingsContainer != null) {
                return organizationChartOfAccountsSettingsContainer;
            }
            if (!strict) {
                EntityReference<Organization> allClientsProfileReference;
                if (ProfileHelper.isOrganizationType(organization, OrganizationType.AGENCY)) {
                    EntityReference<Organization> allAgenciesProfileReference = ProfileDao.findAllAgenciesProfile();
                    if (allAgenciesProfileReference != null) {
                        organizationChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey(allAgenciesProfileReference));
                    }
                } else if (ProfileHelper.isOrganizationType(organization, OrganizationType.CORPORATE_CLIENT) && (allClientsProfileReference = ProfileDao.findAllClientsProfile()) != null) {
                    organizationChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey(allClientsProfileReference));
                }
                if (organizationChartOfAccountsSettingsContainer != null) {
                    return organizationChartOfAccountsSettingsContainer;
                }
            }
        }
        return null;
    }

    public static NewFinanceModuleSettings getGlobalFinanceModuleSettings() {
        EntityContainer ctr = EntityStorage.get().resolve(newFinanceModuleSettingsRef);
        if (ctr == null) {
            ctr = new EntityContainer(NewFinanceModuleSettings.class, newFinanceModuleSettingsRef.getUid());
            ((NewFinanceModuleSettings)ctr.getEntity()).setName(newFinanceModuleSettingsRef.getCaption());
            ((NewFinanceModuleSettings)ctr.getEntity()).setType(SystemSettingsType.OTHER);
            ((NewFinanceModuleSettings)ctr.getEntity()).setUseNewTransactionRulesSettngs(true);
            ctr = EntityStorage.get().save(ctr, false);
        }
        return (NewFinanceModuleSettings)ctr.getEntity();
    }

    public static FopPaymentInfo getFopPaymentInfo(EntityReference<Organization> organization, PaymentType paymentType, boolean strict) {
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        if (organizationContainer != null) {
            for (FopPaymentInfo fopPaymentInfo : ((Organization)organizationContainer.getEntity()).getFopPaymentInfos()) {
                if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                return fopPaymentInfo;
            }
        }
        if (!strict) {
            EntityReference<Organization> defaultOrganization = null;
            if (ProfileHelper.isOrganizationType(organization, OrganizationType.AGENCY)) {
                defaultOrganization = ProfileDao.findAllAgenciesProfile();
            } else if (ProfileHelper.isOrganizationType(organization, OrganizationType.CORPORATE_CLIENT)) {
                defaultOrganization = ProfileDao.findAllClientsProfile();
            }
            EntityContainer defaultOrganizationContainer = EntityStorage.get().resolve(defaultOrganization);
            if (defaultOrganizationContainer != null) {
                for (FopPaymentInfo fopPaymentInfo : ((Organization)defaultOrganizationContainer.getEntity()).getFopPaymentInfos()) {
                    if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                    return fopPaymentInfo;
                }
            }
        }
        return null;
    }

    public static List<Transaction> getTransactions(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, Map<Dimension, String> dimensions, boolean credit) {
        List<TransactionSplitIndex> transactionSplitIndexes = FinanceHelper.getTransactionIndexes(chartOfAccountsElement, startOperationDate, endOperationDate, calculationDate, dimensions, credit, null, null, null);
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (TransactionSplitIndex index : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(index.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    public static List<TransactionSplitIndex> getTransactionIndexes(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date startOperationDate, Date endOperationDate, Date calculationDate, Map<Dimension, String> dimensions, Boolean credit, String description, TransactionSplitIndex.Property orderBy, SortOrder sortOrder) {
        if (chartOfAccountsElement == null) {
            throw new IllegalArgumentException("chart of accounts element can't be null");
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        if (startOperationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)TransactionSplitIndex.Property.operationDate.name(), (Object)startOperationDate));
        }
        if (endOperationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)endOperationDate));
        }
        if (calculationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_1) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_1)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_2) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_2)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_3) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_3)));
        }
        if (credit != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.credit.name(), (Object)credit));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        if (description != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)TransactionSplitIndex.Property.description.name(), (String)description));
        }
        if (orderBy != null && sortOrder != null) {
            query.getCriteria().getOrders().put(orderBy.name(), sortOrder);
        }
        return EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
    }

    public static ProjectionQueryHelper.GroupValues<Dimension> getDimensionsValues(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, Map<Dimension, String> dimensions, List<Dimension> groups) {
        ProjectionQuery query = new ProjectionQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)TransactionSplitIndex.Property.operationDate.name(), null), SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)operationDate)}));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)TransactionSplitIndex.Property.calculationDate.name(), null), SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate)}));
        if (dimensions.get((Object)Dimension.DIMENSION_1) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_1)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_2) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_2)));
        }
        if (dimensions.get((Object)Dimension.DIMENSION_3) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), (Object)dimensions.get((Object)Dimension.DIMENSION_3)));
        }
        for (Dimension group : groups) {
            String property = null;
            if (group == Dimension.DIMENSION_1) {
                property = TransactionSplitIndex.Property.dimension1.name();
            } else if (group == Dimension.DIMENSION_2) {
                property = TransactionSplitIndex.Property.dimension2.name();
            } else if (group == Dimension.DIMENSION_3) {
                property = TransactionSplitIndex.Property.dimension3.name();
            }
            if (property == null) continue;
            query.getProjections().add(Projection.group((String)property, (String)group.name()));
        }
        return ProjectionQueryHelper.GroupValues.of(Enum::name, EntityStorage.get().search(TransactionSplitIndex.class, query).getData());
    }

    public static BigDecimal round(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(RoundingParameters.HALF_UP_2.getScale(), RoundingParameters.HALF_UP_2.getRoundingMode());
    }

    public static enum RoundingParameters {
        HALF_UP_2(RoundingMode.HALF_UP, 2);

        private final RoundingMode roundingMode;
        private final int scale;

        private RoundingParameters(RoundingMode roundingMode, int scale) {
            this.roundingMode = roundingMode;
            this.scale = scale;
        }

        public RoundingMode getRoundingMode() {
            return this.roundingMode;
        }

        public int getScale() {
            return this.scale;
        }
    }

    public static enum Dimension {
        DIMENSION_1,
        DIMENSION_2,
        DIMENSION_3;

    }
}

