/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MathUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.ZoneId;
import java.util.Set;
import java.util.TimeZone;

public class GeoLocationHelper {
    public static GeoLocation getCity(GeoLocation location) {
        if (location.getType() == LocationType.CITY) {
            return location;
        }
        if (location.getType() != LocationType.AIRPORT) {
            throw Xeption.forDeveloper((String)"location with code '{0}' is not an airport", (Object[])new Object[]{location.getCode()});
        }
        DictionaryReference parentRef = location.getParent();
        if (parentRef == null) {
            throw Xeption.forDeveloper((String)"airport with code '{0}' doesn't have a parent", (Object[])new Object[]{location.getCode()});
        }
        GeoLocation parent = (GeoLocation)DictionaryCache.get().resolveReference(parentRef);
        if (parent == null) {
            throw Xeption.forDeveloper((String)"airport with code '{0}' has invalid parent reference '{1}'", (Object[])new Object[]{location.getCode(), parentRef});
        }
        if (parent.getType() != LocationType.CITY) {
            throw Xeption.forDeveloper((String)"airport with code '{0}' has parent location with code '{1}' which is not a city", (Object[])new Object[]{location.getCode(), parent.getCode()});
        }
        return parent;
    }

    public static GeoLocation getCity(DictionaryReference<GeoLocation> locationRef) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
        if (location == null) {
            throw Xeption.forDeveloper((String)"invalid location reference '{0}'", (Object[])new Object[]{locationRef});
        }
        return GeoLocationHelper.getCity(location);
    }

    public static boolean isDomestic(GeoLocation loc) {
        if (loc == null) {
            return false;
        }
        DictionaryReference countryRef = loc.getCountry();
        if (countryRef == null) {
            return false;
        }
        Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
        if (country == null) {
            return false;
        }
        return country.isDomestic();
    }

    public static boolean isDomestic(DictionaryReference<GeoLocation> locRef) {
        if (locRef == null) {
            return false;
        }
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        return GeoLocationHelper.isDomestic(loc);
    }

    public static String getTimeZoneId(GeoLocation geoLocation, Set<GeoLocation> history) {
        if (geoLocation == null) {
            return null;
        }
        String timeZoneId = geoLocation.getTimeZoneId();
        if (!TextUtil.isBlank((String)timeZoneId)) {
            return timeZoneId;
        }
        DictionaryReference parent = geoLocation.getParent();
        if (parent == null || history.contains(geoLocation)) {
            return null;
        }
        history.add(geoLocation);
        GeoLocation parentGeoLocation = (GeoLocation)DictionaryCache.get().resolveReference(parent);
        return parentGeoLocation != null ? GeoLocationHelper.getTimeZoneId(parentGeoLocation, history) : null;
    }

    public static double getDistance(GeoLocation locStart, GeoLocation locEnd) {
        if (locStart == null || locEnd == null || locStart.getLatitude() == 0.0 && locStart.getLongitude() == 0.0 || locEnd.getLatitude() == 0.0 && locEnd.getLongitude() == 0.0) {
            return -1.0;
        }
        return MathUtil.calculateDistance((double)locStart.getLatitude(), (double)locStart.getLongitude(), (double)locEnd.getLatitude(), (double)locEnd.getLongitude());
    }

    public static TimeZone timeZone(DictionaryReference<GeoLocation> locationRef) {
        if (locationRef == null) {
            return null;
        }
        ZoneId zoneId = DictHelper.getZoneId(locationRef);
        if (zoneId != null) {
            return TimeZone.getTimeZone(zoneId);
        }
        return null;
    }
}

