/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.l10n.RussianLuggageInfo2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LuggageInfo2WordsConverter;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.LuggageDimensionUnit;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ItineraryReceiptHelper {
    private static final Map<Locale, Map<PaymentType, String>> localizedPaymentTypeNames = new HashMap<Locale, Map<PaymentType, String>>();
    private static final Map<Locale, Map<String, LuggageInfo2WordsConverter>> luggageConverters = new HashMap<Locale, Map<String, LuggageInfo2WordsConverter>>();

    public static String getLocalizedPaymentType(PaymentType paymentType, Locale locale) {
        PaymentType paymentTypeLocal = Objects.requireNonNull(paymentType);
        Map paymentTypeNameMap = (Map)MiscUtil.findByLocale(localizedPaymentTypeNames, (Locale)locale);
        if (paymentTypeNameMap != null) {
            if (paymentType.name().contains("CREDIT_CARD")) {
                paymentTypeLocal = PaymentType.CREDIT_CARD;
            }
            return (String)paymentTypeNameMap.get(paymentTypeLocal);
        }
        return null;
    }

    public static String luggageInfoToString(Segment segment, Locale locale) {
        ExtendedLuggageInfo extendedLuggageInfo = Optional.ofNullable(segment.getFareDetails()).map(FareDetails::getLuggageInfo).orElse(null);
        if (extendedLuggageInfo != null) {
            return ItineraryReceiptHelper.extendedLuggageInfoToString(extendedLuggageInfo, locale);
        }
        return ItineraryReceiptHelper.luggageInfoToString(segment.getLuggageInfo(), locale);
    }

    public static String luggageInfoToString(LuggageInfo info, Locale locale) {
        LuggageInfo2WordsConverter converter;
        Map converterMap;
        if (info == null) {
            return null;
        }
        if (info.isNil()) {
            return (String)MiscUtil.findByLocale((Map)DictHelper.getNilLuggageUnit().getTranslations(), (Locale)locale);
        }
        if (info.getUnit() != null && (converterMap = (Map)MiscUtil.findByLocale(luggageConverters, (Locale)locale)) != null && (converter = (LuggageInfo2WordsConverter)converterMap.get(info.getUnit().getCode())) != null) {
            StringBuilder sb = new StringBuilder();
            String units = converter.toLuggageUnitWords(info.getQuantity(), info.getUnit().getCode());
            if (units != null) {
                sb.append(Optional.ofNullable(info.getQuantity()).map(Object::toString).orElse(""));
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(units);
            }
            if (sb.length() != 0) {
                return sb.toString();
            }
        }
        return AirProductHelper.luggageInfoToSring(info, locale);
    }

    public static String extendedLuggageInfoToString(ExtendedLuggageInfo info, Locale locale) {
        LuggageInfo2WordsConverter converter;
        String units;
        Map converterMap = (Map)MiscUtil.findByLocale(luggageConverters, (Locale)locale);
        StringBuilder sb = new StringBuilder();
        if (info.getPieces() != null) {
            sb.append(info.getPieces().toString());
            units = null;
            if (converterMap != null && (converter = (LuggageInfo2WordsConverter)converterMap.get("PC")) != null) {
                units = converter.toLuggageUnitWords(info.getPieces(), "PC");
            }
            if (units == null) {
                units = Optional.ofNullable(DictionaryCache.get().findByCode(LuggageUnit.class, "PC")).map(item -> (String)MiscUtil.findByLocale((Map)item.getTranslations(), (Locale)locale)).orElse("pc");
            }
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(units);
        }
        if (info.getWeight() != null && info.getWeightUnit() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(info.getWeight());
            units = null;
            if (converterMap != null && (converter = (LuggageInfo2WordsConverter)converterMap.get(info.getWeightUnit().getCode())) != null) {
                units = converter.toLuggageUnitWords(info.getWeight(), info.getWeightUnit().getCode());
            }
            if (units == null) {
                units = Optional.ofNullable(DictionaryCache.get().resolveReference(info.getWeightUnit())).map(lu -> (String)MiscUtil.findByLocale((Map)lu.getTranslations(), (Locale)locale)).orElse(info.getWeightUnit().getCode());
            }
            sb.append(' ').append(units);
        }
        String dimensionUnit = null;
        if (info.getDimensionUnit() != null) {
            dimensionUnit = LuggageDimensionUnit.INCH == info.getDimensionUnit() ? (MiscUtil.guarded((Integer)info.getDimensionsSum()) == 1 ? "inch" : "inches") : info.getDimensionUnit().toString(locale);
        }
        if (info.getDimensionsSum() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(info.getDimensionsSum());
            if (dimensionUnit != null) {
                sb.append(' ').append(dimensionUnit);
            }
            sb.append(LocaleHelper.RU_LOCALE.getLanguage().equals(locale.getLanguage()) ? " \u0432 \u0441\u0443\u043c\u043c\u0435 3 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439" : " in the sum of three dimensions");
        }
        if (info.getHeight() != null && info.getLength() != null && info.getWidth() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(info.getLength()).append("x").append(info.getWidth()).append("x").append(info.getHeight());
            if (dimensionUnit != null) {
                sb.append(' ').append(dimensionUnit);
            }
        }
        return sb.toString();
    }

    static {
        Locale enLocale = LocaleHelper.getLocale((String)"EN");
        HashMap<PaymentType, String> enPaymentTypeNames = new HashMap<PaymentType, String>();
        localizedPaymentTypeNames.put(enLocale, enPaymentTypeNames);
        enPaymentTypeNames.put(PaymentType.CASH, "Cash");
        enPaymentTypeNames.put(PaymentType.INVOICE, "Invoice");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD, "Credit card");
        Locale ruLocale = LocaleHelper.getLocale((String)"RU");
        HashMap<PaymentType, String> ruPaymentTypeNames = new HashMap<PaymentType, String>();
        localizedPaymentTypeNames.put(ruLocale, ruPaymentTypeNames);
        ruPaymentTypeNames.put(PaymentType.CASH, "\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435");
        ruPaymentTypeNames.put(PaymentType.INVOICE, "\u0411\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0439 \u0440\u0430\u0441\u0447\u0435\u0442");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD, "\u041a\u0440\u0435\u0434\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        HashMap<String, RussianLuggageInfo2WordsConverter> ruUnits = new HashMap<String, RussianLuggageInfo2WordsConverter>();
        ruUnits.put("PC", new RussianLuggageInfo2WordsConverter());
        luggageConverters.put(ruLocale, ruUnits);
        Locale kzLocale = LocaleHelper.getLocale((String)"KZ");
        HashMap<PaymentType, String> kzPaymentTypeNames = new HashMap<PaymentType, String>();
        localizedPaymentTypeNames.put(kzLocale, kzPaymentTypeNames);
        kzPaymentTypeNames.put(PaymentType.CASH, "\u049a/\u049b \u0430\u049b\u0448\u0430\u043c\u0435\u043d / \u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0439 (\u041d)");
        kzPaymentTypeNames.put(PaymentType.INVOICE, "\u049a/\u049b \u0430\u049b\u0448\u0430\u0441\u044b\u0437 / \u0411\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0439 (W)");
    }
}

